/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.queue;

import java.io.Serializable;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class StorageId
implements Serializable {
    private final transient String prefix;
    private final transient String postfix;
    private transient String strippedId;
    private final String id;

    public StorageId(String prefix, String postfix) {
        this.prefix = prefix;
        this.postfix = postfix;
        this.id = this.prefix + ":" + this.postfix;
    }

    public StorageId(Global glob, String id) throws XmlBlasterException {
        this.id = id;
        int pos = this.id.indexOf(":");
        if (pos < 0) {
            throw new XmlBlasterException(glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "StorageId", "Separator ':' not found in the queueId '" + id + "' please change it to a correct id");
        }
        this.prefix = this.id.substring(0, pos);
        this.postfix = this.id.substring(pos + 1);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public String getId() {
        return this.id;
    }

    public String getStrippedId() {
        if (this.strippedId == null) {
            this.strippedId = Global.getStrippedString(this.id);
        }
        return this.strippedId;
    }

    public String toString() {
        return this.id;
    }
}

