/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.queue.cache;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Properties;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.I_QueuePutListener;
import org.xmlBlaster.util.queue.I_QueueSizeListener;
import org.xmlBlaster.util.queue.I_StoragePlugin;
import org.xmlBlaster.util.queue.I_StorageProblemListener;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queue.cache.CacheControlParam;
import org.xmlBlaster.util.queue.ram.RamQueuePlugin;

public class CacheQueueInterceptorPlugin
implements I_Queue,
I_StoragePlugin,
I_StorageProblemListener {
    private String ME;
    private LogChannel log;
    private QueuePropertyBase property;
    private boolean notifiedAboutAddOrRemove = false;
    boolean isDown = true;
    private StorageId queueId;
    private I_QueuePutListener putListener;
    private I_Queue transientQueue;
    private I_Queue persistentQueue;
    private Global glob;
    private boolean isConnected = false;
    private CacheControlParam controlParam;
    private PluginInfo pluginInfo;
    private I_QueueEntry referenceEntry;
    private ArrayList queueSizeListeners;
    private Object queueSizeListenersSync = new Object();
    private Object peekSync = new Object();

    public boolean isTransient() {
        return this.transientQueue.isTransient() && this.persistentQueue.isTransient();
    }

    private final long checkSpaceAvailable(I_Queue queue, long valueToCheckAgainst, boolean ifFullThrowException, String extraTxt) throws XmlBlasterException {
        long spaceLeft = queue.getMaxNumOfBytes() - queue.getNumOfBytes() - valueToCheckAgainst;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "checkSpaceAvailable : maxNumOfBytes=" + queue.getMaxNumOfBytes() + "' numOfBytes='" + queue.getNumOfBytes() + "'. Occured at " + extraTxt);
        }
        if (spaceLeft < 0L && (this.log.TRACE || ifFullThrowException)) {
            String maxBytes = "maxBytes";
            String queueName = "Cache";
            if (queue == this.transientQueue) {
                maxBytes = "maxBytesCache";
                queueName = "Transient";
            } else if (queue == this.persistentQueue) {
                queueName = "Persistent";
            }
            String reason = queueName + " queue overflow, " + queue.getNumOfBytes() + " bytes are in queue, try increasing '" + this.property.getPropName(maxBytes) + "' on client login.";
            if (this.log.TRACE) {
                this.log.trace(this.ME, reason + this.toXml(""));
            }
            if (ifFullThrowException) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, reason);
            }
        }
        return spaceLeft;
    }

    private final long checkEntriesAvailable(I_Queue queue, long valueToCheckAgainst, boolean ifFullThrowException, String extraTxt) throws XmlBlasterException {
        long entriesLeft = queue.getMaxNumOfEntries() - queue.getNumOfEntries() - valueToCheckAgainst;
        if (entriesLeft < 0L && (this.log.TRACE || ifFullThrowException)) {
            String maxEntries = "maxEntries";
            String queueName = "Cache";
            if (queue == this.transientQueue) {
                maxEntries = "maxEntriesCache";
                queueName = "Transient";
            } else if (queue == this.persistentQueue) {
                queueName = "Persistent";
            }
            String reason = queueName + " queue overflow, " + queue.getNumOfEntries() + " entries are in queue, try increasing '" + this.property.getPropName(maxEntries) + "' on client login.";
            if (this.log.TRACE) {
                this.log.trace(this.ME, reason + this.toXml(""));
            }
            if (ifFullThrowException) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, reason);
            }
        }
        return entriesLeft;
    }

    public synchronized void storageUnavailable(int oldStatus) {
        if (this.log.CALL) {
            this.log.call(this.ME, "storageUnavailable");
        }
        this.isConnected = false;
        try {
            ArrayList lst = this.transientQueue.peek(-1, -1L);
            this.referenceEntry = lst.size() < 1 ? null : (I_QueueEntry)lst.get(lst.size() - 1);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "storageUnavailable: exception occured when peeking the transient queue: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void storageAvailable(int oldStatus) {
        block24: {
            if (oldStatus == -1) {
                return;
            }
            if (this.log.CALL) {
                this.log.call(this.ME, "storageAvailable");
            }
            if (this.persistentQueue == null) {
                return;
            }
            boolean isInclusive = true;
            I_QueueEntry limitEntry = this.referenceEntry;
            if (this.log.TRACE) {
                if (limitEntry == null) {
                    this.log.trace(this.ME, "storageAvailable: the reference entry is null");
                } else {
                    this.log.trace(this.ME, "storageAvailable: the reference entry is '" + limitEntry.getUniqueId() + "' and its flag 'stored' is '" + limitEntry.isStored() + "'");
                }
            }
            ArrayList list = null;
            this.referenceEntry = null;
            if (limitEntry == null || limitEntry.isStored()) {
                isInclusive = false;
                limitEntry = this.transientQueue.peek();
                if (this.log.TRACE) {
                    if (limitEntry == null) {
                        this.log.trace(this.ME, "storageAvailable: the new reference entry is null");
                    } else {
                        this.log.trace(this.ME, "storageAvailable: the new reference entry is '" + limitEntry.getUniqueId() + "'");
                    }
                }
            }
            if (limitEntry == null) {
                isInclusive = false;
                this.persistentQueue.clear();
            } else {
                this.persistentQueue.removeWithLimitEntry(limitEntry, isInclusive);
            }
            limitEntry = this.persistentQueue.peek();
            if (limitEntry != null && (list = this.transientQueue.peekWithLimitEntry(limitEntry)).size() > 0) {
                ArrayList<I_Entry> list2 = new ArrayList<I_Entry>();
                int i = 0;
                while (i < list.size()) {
                    I_Entry entry = (I_Entry)list.get(i);
                    if (entry.isPersistent()) {
                        list2.add(entry);
                    }
                    ++i;
                }
                if (list2.size() > 0) {
                    this.persistentQueue.put(list2.toArray(new I_QueueEntry[list2.size()]), false);
                }
            }
            this.isConnected = true;
            Object var9_9 = null;
            try {
                this.loadFromPersistence();
            }
            catch (XmlBlasterException ex2) {
                this.log.error(this.ME, "storageAvailable: exception when loading from persistence: " + ex2.getMessage());
                ex2.printStackTrace();
            }
            break block24;
            {
                catch (XmlBlasterException ex) {
                    this.log.error(this.ME, "exception occured when reconnecting. " + ex.getMessage());
                    ex.printStackTrace();
                    Object var9_10 = null;
                    try {
                        this.loadFromPersistence();
                    }
                    catch (XmlBlasterException ex2) {
                        this.log.error(this.ME, "storageAvailable: exception when loading from persistence: " + ex2.getMessage());
                        ex2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    this.loadFromPersistence();
                }
                catch (XmlBlasterException ex2) {
                    this.log.error(this.ME, "storageAvailable: exception when loading from persistence: " + ex2.getMessage());
                    ex2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public synchronized void initialize(StorageId uniqueQueueId, Object userData) throws XmlBlasterException {
        if (this.isDown) {
            Properties pluginProperties = null;
            if (this.pluginInfo != null) {
                pluginProperties = this.pluginInfo.getParameters();
            }
            if (pluginProperties == null) {
                pluginProperties = new Properties();
            }
            this.property = null;
            this.glob = ((QueuePropertyBase)userData).getGlobal();
            this.log = this.glob.getLog("queue");
            this.ME = this.getClass().getName() + "-" + uniqueQueueId;
            if (this.log.CALL) {
                this.log.call(this.ME, "initialized");
            }
            this.queueId = uniqueQueueId;
            QueuePluginManager pluginManager = this.glob.getQueuePluginManager();
            QueuePropertyBase queuePropertyBase = (QueuePropertyBase)userData;
            String defaultTransient = pluginProperties.getProperty("transientQueue", "RAM,1.0").trim();
            if (defaultTransient.startsWith(this.getType())) {
                this.log.error(this.ME, "Cache queue configured with transientQueue=CACHE, to prevent recursion we set it to 'RAM,1.0'");
                defaultTransient = "RAM,1.0";
            }
            this.transientQueue = pluginManager.getPlugin(defaultTransient, uniqueQueueId, this.createRamCopy(queuePropertyBase));
            try {
                String defaultPersistent = pluginProperties.getProperty("persistentQueue", "JDBC,1.0").trim();
                if (defaultPersistent.startsWith(this.getType())) {
                    this.log.error(this.ME, "Cache queue configured with persistentQueue=CACHE, to prevent recursion we set it to 'JDBC,1.0'");
                    defaultPersistent = "JDBC,1.0";
                }
                this.persistentQueue = pluginManager.getPlugin(defaultPersistent, uniqueQueueId, queuePropertyBase);
                this.isConnected = true;
                this.persistentQueue.registerStorageProblemListener(this);
            }
            catch (XmlBlasterException ex) {
                this.log.error(this.ME, "Could not initialize the persistent queue '" + uniqueQueueId + "'. Is the JDBC Driver jar file in the CLASSPATH ?" + " Is the DB up and running ? We continue RAM based ..." + ex.getMessage() + " The propery settings are:" + queuePropertyBase.toXml());
                ex.printStackTrace();
            }
            if (this.isPersistenceAvailable()) {
                try {
                    this.persistentQueue.removeTransient();
                }
                catch (XmlBlasterException ex) {
                    this.log.error(this.ME, "could not remove transient entries (swapped entries) probably due to no connection to the DB, or the DB is down");
                    ex.printStackTrace();
                }
                this.setProperties(userData);
                this.controlParam = new CacheControlParam((QueuePropertyBase)this.getProperties());
                this.loadFromPersistence();
            }
            this.isDown = false;
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Successful initialized");
            }
        }
    }

    private QueuePropertyBase createRamCopy(QueuePropertyBase queuePropertyBase) {
        QueuePropertyBase ramCopy = (QueuePropertyBase)queuePropertyBase.clone();
        ramCopy.setMaxEntries(queuePropertyBase.getMaxEntriesCache());
        ramCopy.setMaxBytes(queuePropertyBase.getMaxBytesCache());
        return ramCopy;
    }

    public synchronized void setProperties(Object userData) throws XmlBlasterException {
        QueuePropertyBase newProp;
        if (userData == null) {
            return;
        }
        try {
            newProp = (QueuePropertyBase)userData;
        }
        catch (Throwable e) {
            this.log.error(this.ME, "Can't configure queue, your properties are invalid: " + e.toString());
            e.printStackTrace();
            return;
        }
        this.property = newProp;
        this.transientQueue.setProperties(this.createRamCopy((QueuePropertyBase)userData));
        if (this.persistentQueue != null) {
            this.persistentQueue.setProperties(userData);
        }
    }

    public Object getProperties() {
        return this.property;
    }

    public void setNotifiedAboutAddOrRemove(boolean notify) {
        this.notifiedAboutAddOrRemove = notify;
    }

    public boolean isNotifiedAboutAddOrRemove() {
        return this.notifiedAboutAddOrRemove;
    }

    public synchronized void addPutListener(I_QueuePutListener l) {
        if (l == null) {
            throw new IllegalArgumentException(this.ME + ": addPustListener(null) is not allowed");
        }
        if (this.putListener != null) {
            throw new IllegalArgumentException(this.ME + ": addPustListener() failed, there is a listener registered already");
        }
        this.putListener = l;
    }

    public synchronized void removePutListener(I_QueuePutListener l) {
        this.putListener = null;
    }

    public I_Queue getPersistentQueue() {
        return this.persistentQueue;
    }

    public I_Queue getTransientQueue() {
        return this.transientQueue;
    }

    public long[] getEntryReferences() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "getEntryReferences not implemented");
    }

    public ArrayList getEntries() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "getEntries not implemented");
    }

    public void put(I_QueueEntry queueEntry, boolean ignorePutInterceptor) throws XmlBlasterException {
        I_QueueEntry[] entries = new I_QueueEntry[]{queueEntry};
        this.put(entries, ignorePutInterceptor);
    }

    public void put(I_QueueEntry[] queueEntries, boolean ignorePutInterceptor) throws XmlBlasterException {
        if (queueEntries == null || queueEntries.length < 1) {
            return;
        }
        if (this.putListener != null && !ignorePutInterceptor && !this.putListener.putPre(queueEntries)) {
            return;
        }
        CacheQueueInterceptorPlugin cacheQueueInterceptorPlugin = this;
        synchronized (cacheQueueInterceptorPlugin) {
            this.checkEntriesAvailable(this, 0L, true, "first check in put");
            this.checkSpaceAvailable(this, 0L, true, "first check in put");
            long sizeOfEntries = 0L;
            if (this.isPersistenceAvailable()) {
                ArrayList<I_QueueEntry> persistentsFromEntries = new ArrayList<I_QueueEntry>();
                long sizeOfPersistents = 0L;
                long numOfPersistents = 0L;
                int i = 0;
                while (i < queueEntries.length) {
                    if (queueEntries[i].isPersistent()) {
                        persistentsFromEntries.add(queueEntries[i]);
                        sizeOfPersistents += queueEntries[i].getSizeInBytes();
                        ++numOfPersistents;
                    } else {
                        sizeOfEntries += queueEntries[i].getSizeInBytes();
                    }
                    ++i;
                }
                sizeOfEntries += sizeOfPersistents;
                if (persistentsFromEntries.size() > 0) {
                    try {
                        this.persistentQueue.put(persistentsFromEntries.toArray(new I_QueueEntry[persistentsFromEntries.size()]), ignorePutInterceptor);
                    }
                    catch (XmlBlasterException ex) {
                        this.log.error(this.ME, "put: an error occured when writing to the persistent queue: " + persistentsFromEntries.size() + " persistent entries will temporarly be handled as transient. Is the DB up and running ? " + ex.getMessage() + "state " + this.toXml(""));
                    }
                    catch (Throwable ex) {
                        this.log.error(this.ME, "put: an error occured when writing to the persistent queue: " + persistentsFromEntries.size() + " persistent entries will temporarly be handled as transient. Is the DB up and running ? " + ex.toString() + "state " + this.toXml(""));
                        ex.printStackTrace();
                    }
                }
            }
            Object object = this.peekSync;
            synchronized (object) {
                this.transientQueue.put(queueEntries, ignorePutInterceptor);
                if (this.isPersistenceAvailable()) {
                    long exceedingSize = -this.checkSpaceAvailable(this.transientQueue, 0L, false, "");
                    long exceedingEntries = -this.checkEntriesAvailable(this.transientQueue, 0L, false, "");
                    if (exceedingSize >= 0L && this.persistentQueue.getMaxNumOfBytes() > this.transientQueue.getMaxNumOfBytes() || exceedingEntries >= 0L && this.persistentQueue.getMaxNumOfEntries() > this.transientQueue.getMaxNumOfEntries()) {
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "put: swapping. Exceeding size (in bytes): " + exceedingSize + " exceeding entries: " + exceedingEntries + " state: " + this.toXml(""));
                        }
                        ArrayList<I_QueueEntry> transients = null;
                        try {
                            ArrayList swaps = null;
                            boolean needsLoading = false;
                            if (this.transientQueue.getNumOfEntries() == 0L) {
                                swaps = this.transientQueue.takeLowest((int)exceedingEntries, exceedingSize, null, true);
                            } else {
                                swaps = this.transientQueue.takeLowest(queueEntries.length, sizeOfEntries, null, true);
                                needsLoading = true;
                            }
                            if (this.log.TRACE) {
                                this.log.trace(this.ME, "put: swapping: moving '" + swaps.size() + "' entries from transient queue to persistent queue: exceedingEntries='" + exceedingEntries + "' and exceedingSize='" + exceedingSize + "'");
                            }
                            transients = new ArrayList<I_QueueEntry>();
                            int i = 0;
                            while (i < swaps.size()) {
                                I_QueueEntry entry = (I_QueueEntry)swaps.get(i);
                                if (!entry.isPersistent()) {
                                    transients.add(entry);
                                }
                                ++i;
                            }
                            if (transients.size() > 0) {
                                this.persistentQueue.put(transients.toArray(new I_QueueEntry[transients.size()]), ignorePutInterceptor);
                            }
                            if (needsLoading) {
                                this.loadFromPersistence();
                            }
                        }
                        catch (XmlBlasterException ex) {
                            this.log.error(this.ME, "put: an error occured when swapping: " + transients.size() + ". Is the DB up and running ? " + ex.getMessage() + " state: " + this.toXml(""));
                            ex.printStackTrace();
                        }
                        catch (Throwable ex) {
                            this.log.error(this.ME, "put: an error occured when swapping: " + transients.size() + ". Is the DB up and running ? " + ex.toString());
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
        if (this.notifiedAboutAddOrRemove) {
            int i = 0;
            while (i < queueEntries.length) {
                try {
                    queueEntries[i].added(this.queueId);
                }
                catch (Throwable ex) {
                    this.log.error(this.ME, "put: an error occured when notifying : " + ex.toString());
                    ex.printStackTrace();
                }
                ++i;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        if (this.putListener != null && !ignorePutInterceptor) {
            this.putListener.putPost(queueEntries);
        }
    }

    public StorageId getStorageId() {
        return this.queueId;
    }

    public ArrayList takeWithPriority(int numOfEntries, long numOfBytes, int minPriority, int maxPriority) throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "takeWithPriority not implemented");
    }

    private final boolean hasTransientsSwapped() {
        return this.persistentQueue.getNumOfPersistentEntries() != this.persistentQueue.getNumOfEntries();
    }

    private final boolean isPersistenceAvailable() {
        return this.persistentQueue != null && this.isConnected;
    }

    private final boolean hasUncachedEntries() {
        return this.hasTransientsSwapped() || this.persistentQueue.getNumOfPersistentEntries() != this.transientQueue.getNumOfPersistentEntries();
    }

    public ArrayList peekLowest(int numOfEntries, long numOfBytes, I_QueueEntry limitEntry, boolean leaveOne) throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "peekLowest is not implemented");
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList takeLowest(int numOfEntries, long numOfBytes, I_QueueEntry limitEntry, boolean leaveOne) throws XmlBlasterException {
        block24: {
            block23: {
                block22: {
                    list = null;
                    doNotify = false;
                    try {
                        var8_7 = this;
                        synchronized (var8_7) {
                            v0 = handlePersistents = this.isPersistenceAvailable() != false && this.hasUncachedEntries() != false;
                            if (handlePersistents) {
                                try {
                                    list = this.persistentQueue.takeLowest(numOfEntries, numOfBytes, limitEntry, leaveOne);
                                    doNotify = true;
                                }
                                catch (Throwable ex) {
                                    handlePersistents = false;
                                    this.log.error(this.ME, "takeLowest: exception occured when taking the lowest entry from the persistent queue: " + ex.toString());
                                    ex.printStackTrace();
                                }
                                if (handlePersistents) {
                                    if (list.size() > 1) {
                                        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "takeLowest for more than one entry is not implemented");
                                    }
                                    num = 0L;
                                    hlp = this.transientQueue.removeRandom(list.toArray(new I_Entry[list.size()]));
                                    i = 0;
                                    while (i < hlp.length) {
                                        if (hlp[i]) {
                                            ++num;
                                        }
                                        ++i;
                                    }
                                    if (num > 0L) {
                                        this.log.error(this.ME, "Didn't expect message " + ((I_Entry)list.get(0)).getLogId() + " in transient store " + this.toXml(""));
                                    }
                                }
                            }
                            if (!handlePersistents) {
                                list = this.transientQueue.takeLowest(numOfEntries, numOfBytes, limitEntry, leaveOne);
                                doNotify = true;
                                if (this.isPersistenceAvailable() && list.size() > 0 && this.persistentQueue.getNumOfEntries() > 0L) {
                                    durableFound = false;
                                    i = 0;
                                    while (i < list.size()) {
                                        if (((I_Entry)list.get(i)).isPersistent()) {
                                            durableFound = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (durableFound) {
                                        this.persistentQueue.removeRandom(list.toArray(new I_Entry[list.size()]));
                                    }
                                }
                            }
                        }
                        var16_16 = null;
                        if (!doNotify || !this.notifiedAboutAddOrRemove) break block22;
                        i = 0;
                        ** while (i < list.size())
                    }
                    catch (Throwable var15_20) {
                        var16_17 = null;
                        if (!doNotify || !this.notifiedAboutAddOrRemove) break block23;
                        i = 0;
                        ** while (i < list.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        ((I_Entry)list.get(i)).removed(this.queueId);
                        ++i;
                        continue;
                    }
                }
                if (this.queueSizeListeners != null) {
                    this.invokeQueueSizeListener();
                }
                break block24;
lbl-1000:
                // 1 sources

                {
                    ((I_Entry)list.get(i)).removed(this.queueId);
                    ++i;
                    continue;
                }
            }
            if (this.queueSizeListeners != null) {
                this.invokeQueueSizeListener();
            }
            throw var15_20;
        }
        return list;
    }

    public I_QueueEntry peek() throws XmlBlasterException {
        Object object = this.peekSync;
        synchronized (object) {
            I_QueueEntry i_QueueEntry = this.transientQueue.peek();
            return i_QueueEntry;
        }
    }

    public ArrayList peek(int numOfEntries, long numOfBytes) throws XmlBlasterException {
        Object object = this.peekSync;
        synchronized (object) {
            ArrayList arrayList = this.transientQueue.peek(numOfEntries, numOfBytes);
            return arrayList;
        }
    }

    public ArrayList peekSamePriority(int numOfEntries, long numOfBytes) throws XmlBlasterException {
        Object object = this.peekSync;
        synchronized (object) {
            ArrayList arrayList = this.transientQueue.peekSamePriority(numOfEntries, numOfBytes);
            return arrayList;
        }
    }

    public ArrayList peekWithPriority(int numOfEntries, long numOfBytes, int minPriority, int maxPriority) throws XmlBlasterException {
        Object object = this.peekSync;
        synchronized (object) {
            ArrayList arrayList = this.transientQueue.peekWithPriority(numOfEntries, numOfBytes, minPriority, maxPriority);
            return arrayList;
        }
    }

    public ArrayList peekWithLimitEntry(I_QueueEntry limitEntry) throws XmlBlasterException {
        Object object = this.peekSync;
        synchronized (object) {
            ArrayList arrayList = this.transientQueue.peekWithLimitEntry(limitEntry);
            return arrayList;
        }
    }

    public synchronized long removeWithLimitEntry(I_QueueEntry limitEntry, boolean inclusive) throws XmlBlasterException {
        long ret = this.transientQueue.removeWithLimitEntry(limitEntry, inclusive);
        if (this.isPersistenceAvailable()) {
            try {
                ret = this.persistentQueue.removeWithLimitEntry(limitEntry, inclusive);
            }
            catch (XmlBlasterException ex) {
                this.log.error(this.ME, "removeWithLimitEntry: exception occured when removing from persistence. reason: " + ex.getMessage());
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                this.log.error(this.ME, "removeWithLimitEntry: exception occured when removing from persistence. reason: " + ex.toString());
                ex.printStackTrace();
            }
        }
        return ret;
    }

    public int remove() throws XmlBlasterException {
        return (int)this.remove(1L, -1L);
    }

    public long remove(long numOfEntries, long numOfBytes) throws XmlBlasterException {
        long ret = 0L;
        int removedEntries = 0;
        if (numOfEntries > Integer.MAX_VALUE) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "remove: too many entries to remove " + numOfEntries);
        }
        int nmax = (int)numOfEntries;
        if (nmax < 0) {
            nmax = Integer.MAX_VALUE;
        }
        if (numOfBytes < 0L) {
            numOfBytes = Long.MAX_VALUE;
        }
        I_Entry[] entries = null;
        ArrayList list = null;
        boolean[] tmp = null;
        CacheQueueInterceptorPlugin cacheQueueInterceptorPlugin = this;
        synchronized (cacheQueueInterceptorPlugin) {
            while (nmax > 0 && numOfBytes > 0L) {
                list = this.peek(nmax, numOfBytes);
                if (list == null || list.size() < 1) break;
                long delta = this.transientQueue.getNumOfBytes();
                removedEntries = 0;
                entries = list.toArray(new I_Entry[list.size()]);
                tmp = this.removeRandomNoNotify(entries);
                int i = 0;
                while (i < tmp.length) {
                    if (tmp[i]) {
                        ++removedEntries;
                    }
                    ++i;
                }
                nmax -= removedEntries;
                ret += (long)removedEntries;
                numOfBytes -= (delta -= this.transientQueue.getNumOfBytes());
            }
        }
        if (this.notifiedAboutAddOrRemove) {
            int i = 0;
            while (i < tmp.length) {
                if (tmp[i] != false) {
                    entries[i].removed(this.queueId);
                }
                ++i;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    public int removeRandom(long dataId) throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeRandom(long) not implemented");
    }

    public long removeRandom(long[] dataIdArray) throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeRandom(long[]) not implemented");
    }

    public int removeRandom(I_Entry entry) throws XmlBlasterException {
        I_Entry[] entries = new I_Entry[]{entry};
        if (this.removeRandom(entries)[0]) {
            return 1;
        }
        return 0;
    }

    private final boolean[] removePossibleSwappedEntries(boolean[] ret, I_Entry[] queueEntries) {
        if (this.log.CALL) {
            this.log.call(this.ME, "removePossibleSwappedEntries");
        }
        if (!this.isPersistenceAvailable()) {
            return ret;
        }
        int numUnremoved = 0;
        int i = 0;
        while (i < ret.length) {
            if (!ret[i]) {
                ++numUnremoved;
            }
            ++i;
        }
        if (numUnremoved == 0) {
            return ret;
        }
        if (!this.hasTransientsSwapped()) {
            return ret;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "removePossibleSwappedEntries, there were entries '" + numUnremoved + "' to delete on persistence");
        }
        if (queueEntries == null || queueEntries.length < 1) {
            return ret;
        }
        I_Entry[] unremovedEntries = new I_Entry[numUnremoved];
        int count = 0;
        int i2 = 0;
        while (i2 < ret.length) {
            if (!ret[i2]) {
                unremovedEntries[count] = queueEntries[i2];
                ++count;
            }
            ++i2;
        }
        try {
            boolean[] ret1 = this.persistentQueue.removeRandom(unremovedEntries);
            count = 0;
            int i3 = 0;
            while (i3 < ret.length) {
                if (!ret[i3]) {
                    ret[i3] = ret1[count];
                    ++count;
                    if (this.log.DUMP) {
                        this.log.dump(this.ME, "removePossibleSwappedEntries entry '" + unremovedEntries[count].getUniqueId() + "' has been deleted ? : " + ret1[count]);
                    }
                }
                ++i3;
            }
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "exception occured when trying to remove entries which have supposely been swapped since the last peek. reason: " + ex.getMessage());
            ex.printStackTrace();
            return ret;
        }
        return ret;
    }

    private final boolean[] removeRandomNoNotify(I_Entry[] queueEntries) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "removeRandom(I_QueueEntry[])");
        }
        if (queueEntries == null || queueEntries.length < 1) {
            return new boolean[0];
        }
        boolean[] ret = null;
        CacheQueueInterceptorPlugin cacheQueueInterceptorPlugin = this;
        synchronized (cacheQueueInterceptorPlugin) {
            try {
                if (this.isPersistenceAvailable()) {
                    ArrayList<I_Entry> persistents = new ArrayList<I_Entry>();
                    int i = 0;
                    while (i < queueEntries.length) {
                        if (queueEntries[i].isPersistent()) {
                            persistents.add(queueEntries[i]);
                        }
                        ++i;
                    }
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "removeRandom: remove " + persistents.size() + " persistent entries from persistent storage");
                    }
                    try {
                        this.persistentQueue.removeRandom(persistents.toArray(new I_Entry[persistents.size()]));
                    }
                    catch (XmlBlasterException ex) {
                        this.log.error(this.ME, "could not remove " + persistents.size() + " entries from the persistent queue. Probably due to failed connection to the DB exception: " + ex.getMessage());
                        ex.printStackTrace();
                    }
                }
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "removeRandom: removing from transient queue " + queueEntries.length + " entries");
                }
                try {
                    ret = this.transientQueue.removeRandom(queueEntries);
                    ret = this.removePossibleSwappedEntries(ret, queueEntries);
                }
                catch (XmlBlasterException ex) {
                    this.log.error(this.ME, "could not remove " + queueEntries.length + " entries from the transient queue.: " + ex.getMessage());
                    ex.printStackTrace();
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    this.loadFromPersistence();
                }
                catch (XmlBlasterException ex1) {
                    this.log.error(this.ME, "removeRandom exception occured when loading from persistence: " + ex1.getMessage());
                    ex1.printStackTrace();
                }
                throw throwable;
            }
            try {
                this.loadFromPersistence();
            }
            catch (XmlBlasterException ex1) {
                this.log.error(this.ME, "removeRandom exception occured when loading from persistence: " + ex1.getMessage());
                ex1.printStackTrace();
            }
        }
        return ret;
    }

    public final boolean[] removeRandom(I_Entry[] queueEntries) throws XmlBlasterException {
        boolean[] ret = this.removeRandomNoNotify(queueEntries);
        if (this.notifiedAboutAddOrRemove) {
            int i = 0;
            while (i < ret.length) {
                if (ret[i]) {
                    try {
                        queueEntries[i].removed(this.queueId);
                    }
                    catch (Throwable ex) {
                        this.log.error(this.ME, "removeRandom: exception when notifying about removal: " + ex.toString());
                        ex.printStackTrace();
                    }
                }
                ++i;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    private final synchronized int loadFromPersistence() throws XmlBlasterException {
        if (!this.isPersistenceAvailable()) {
            return 0;
        }
        if (this.hasUncachedEntries()) {
            long freeEntries = this.transientQueue.getMaxNumOfEntries() - this.transientQueue.getNumOfEntries();
            long freeBytes = this.transientQueue.getMaxNumOfBytes() - this.transientQueue.getNumOfBytes();
            if (freeEntries <= 0L || freeBytes <= 0L) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "loadFromPersistence: the transient queue is already full. numOfBytes=" + this.transientQueue.getNumOfBytes() + " maxNumOfBytes=" + this.transientQueue.getMaxNumOfBytes() + " numOfEntries=" + this.transientQueue.getNumOfEntries() + " maxNumOfEntries=" + this.transientQueue.getMaxNumOfBytes());
                }
                if (this.log.DUMP) {
                    this.log.dump(this.ME, "loadFromPersistence: the real current size in bytes of transient queue is: " + ((RamQueuePlugin)this.transientQueue).getSynchronizedNumOfBytes());
                }
                return 0;
            }
            if (this.log.TRACE) {
                this.log.trace(this.ME, "removeRandom: swapping: reloading from persistence for a length of " + freeBytes);
            }
            ArrayList list = null;
            try {
                list = this.persistentQueue.peek((int)freeEntries, freeBytes);
            }
            catch (XmlBlasterException ex) {
                this.log.error(this.ME, "could not read back data from persistence: " + ex.getMessage());
                ex.printStackTrace();
            }
            if (list == null || list.size() < 1) {
                return 0;
            }
            try {
                this.transientQueue.put(list.toArray(new I_QueueEntry[list.size()]), false);
            }
            catch (XmlBlasterException ex) {
                this.log.error(this.ME, "loadFromPeristence: no space left on transient queue: " + ex.getMessage());
                ex.printStackTrace();
                return 0;
            }
            ArrayList transients = new ArrayList();
            int n = list.size();
            int i = 0;
            while (i < n) {
                if (!((I_Entry)list.get(i)).isPersistent()) {
                    transients.add(list.get(i));
                }
                ++i;
            }
            try {
                if (transients.size() > 0) {
                    this.persistentQueue.removeRandom(transients.toArray(new I_Entry[transients.size()]));
                }
            }
            catch (XmlBlasterException ex) {
                this.log.error(this.ME, "loadFromPeristence: Memory leak: problems removing " + transients.size() + " swapped transient entries form persistent store: " + ex.getMessage());
                return list.size();
            }
            return transients.size();
        }
        return 0;
    }

    public long removeWithPriority(long numOfEntries, long numOfBytes, int minPriority, int maxPriority) throws XmlBlasterException {
        ArrayList list = null;
        boolean[] tmp = null;
        CacheQueueInterceptorPlugin cacheQueueInterceptorPlugin = this;
        synchronized (cacheQueueInterceptorPlugin) {
            if (numOfEntries > Integer.MAX_VALUE) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "remove: too many entries to remove " + numOfEntries);
            }
            list = this.peekWithPriority((int)numOfEntries, numOfBytes, minPriority, maxPriority);
            if (list == null || list.size() < 1) {
                long l = 0L;
                return l;
            }
            tmp = this.removeRandomNoNotify(list.toArray(new I_QueueEntry[list.size()]));
        }
        if (this.notifiedAboutAddOrRemove) {
            int i = 0;
            while (i < tmp.length) {
                if (tmp[i]) {
                    try {
                        ((I_Entry)list.get(i)).removed(this.queueId);
                    }
                    catch (Throwable ex) {
                        this.log.error(this.ME, "removeWithPriority exception occured when notifying about removal. Reason: " + ex.toString());
                        ex.printStackTrace();
                    }
                }
                ++i;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        long ret = 0L;
        int i = 0;
        while (i < tmp.length) {
            if (tmp[i]) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public int removeTransient() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeTransient not implemented");
    }

    public synchronized long getNumOfEntries() {
        long ret = 0L;
        if (this.isPersistenceAvailable()) {
            ret = this.persistentQueue.getNumOfEntries();
            if (ret < 0L) {
                return this.transientQueue.getNumOfEntries();
            }
            return ret += this.transientQueue.getNumOfEntries() - this.transientQueue.getNumOfPersistentEntries();
        }
        return this.transientQueue.getNumOfEntries();
    }

    public synchronized long getNumOfPersistentEntries() {
        long ret = 0L;
        if (this.isPersistenceAvailable()) {
            ret = this.persistentQueue.getNumOfPersistentEntries();
            if (ret < 0L) {
                return this.transientQueue.getNumOfEntries();
            }
            return this.persistentQueue.getNumOfPersistentEntries();
        }
        return this.transientQueue.getNumOfPersistentEntries();
    }

    public long getMaxNumOfEntries() {
        long ret = 0L;
        if (this.isPersistenceAvailable()) {
            return this.persistentQueue.getMaxNumOfEntries();
        }
        return this.transientQueue.getMaxNumOfEntries();
    }

    public synchronized long getNumOfBytes() {
        long ret = 0L;
        if (this.isPersistenceAvailable()) {
            ret = this.persistentQueue.getNumOfBytes();
            if (ret < 0L) {
                return this.transientQueue.getNumOfBytes();
            }
            return ret += this.transientQueue.getNumOfBytes() - this.transientQueue.getNumOfPersistentBytes();
        }
        return this.transientQueue.getNumOfBytes();
    }

    public synchronized long getNumOfPersistentBytes() {
        long ret = 0L;
        if (this.isPersistenceAvailable()) {
            ret = this.persistentQueue.getNumOfPersistentBytes();
            if (ret < 0L) {
                return this.transientQueue.getNumOfPersistentBytes();
            }
            return ret;
        }
        return this.transientQueue.getNumOfPersistentBytes();
    }

    public synchronized long getMaxNumOfBytes() {
        long ret = 0L;
        if (this.isPersistenceAvailable()) {
            return this.persistentQueue.getMaxNumOfBytes();
        }
        return this.transientQueue.getMaxNumOfBytes();
    }

    public int update(I_QueueEntry queueEntry) throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "update not implemented");
    }

    public long clear() {
        long ret = 0L;
        CacheQueueInterceptorPlugin cacheQueueInterceptorPlugin = this;
        synchronized (cacheQueueInterceptorPlugin) {
            if (this.notifiedAboutAddOrRemove) {
                this.transientQueue.setNotifiedAboutAddOrRemove(true);
            }
            try {
                ret = this.transientQueue.clear();
            }
            catch (Throwable ex) {
                this.log.error(this.ME, "clear: exception when processing transient queue. Reason: " + ex.toString());
                ex.printStackTrace();
            }
            if (this.notifiedAboutAddOrRemove) {
                this.transientQueue.setNotifiedAboutAddOrRemove(false);
            }
            if (this.isPersistenceAvailable()) {
                try {
                    ret += this.persistentQueue.clear();
                }
                catch (Throwable ex) {
                    this.log.error(this.ME, "clear: exception when processing persistent queue. Reason: " + ex.toString());
                    ex.printStackTrace();
                }
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    public long removeHead(I_QueueEntry toEntry) throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeHead not implemented");
    }

    public synchronized void shutdown() {
        if (this.log.CALL) {
            this.log.call(this.ME, "shutdown()");
        }
        this.isDown = true;
        long numTransients = this.getNumOfEntries() - this.getNumOfPersistentEntries();
        if (numTransients > 0L) {
            this.log.warn(this.ME, "Shutting down cache queue which contains " + numTransients + " transient messages");
        }
        try {
            this.transientQueue.shutdown();
        }
        catch (Throwable ex) {
            this.log.error(this.ME, "shutdown: exception when processing transient queue. Reason: " + ex.toString());
            ex.printStackTrace();
        }
        try {
            if (this.persistentQueue != null) {
                this.persistentQueue.shutdown();
            }
        }
        catch (Throwable ex) {
            this.log.error(this.ME, "shutdown: exception when processing transient queue. Reason: " + ex.toString());
            ex.printStackTrace();
        }
        try {
            if (this.persistentQueue != null) {
                this.persistentQueue.unRegisterStorageProblemListener(this);
            }
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not unregister listener. Cause: " + ex.getMessage());
            ex.printStackTrace();
        }
        this.removeQueueSizeListener(null);
    }

    public boolean isShutdown() {
        return this.isDown;
    }

    public String usage() {
        return "no usage";
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<CacheQueueInterceptorPlugin id='").append(this.getStorageId().getId());
        sb.append("' type='").append(this.getType());
        sb.append("' version='").append(this.getVersion());
        sb.append("' maxEntriesCache='").append(this.transientQueue.getMaxNumOfEntries());
        sb.append("' maxBytesCache='").append(this.transientQueue.getMaxNumOfBytes());
        sb.append("' maxEntries='").append(this.getMaxNumOfEntries());
        sb.append("' maxBytes='").append(this.getMaxNumOfBytes());
        sb.append("' numOfEntries='").append(this.getNumOfEntries());
        sb.append("' numOfBytes='").append(this.getNumOfBytes());
        sb.append("'>");
        sb.append(this.transientQueue.toXml(extraOffset + " "));
        if (this.persistentQueue != null) {
            sb.append(this.persistentQueue.toXml(extraOffset + " "));
        }
        sb.append(offset).append("</CacheQueueInterceptorPlugin>");
        return sb.toString();
    }

    public void init(Global glob, PluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
    }

    public String getType() {
        return "CACHE";
    }

    public String getVersion() {
        return "1.0";
    }

    public PluginInfo getInfo() {
        return this.pluginInfo;
    }

    public synchronized boolean registerStorageProblemListener(I_StorageProblemListener listener) {
        if (this.persistentQueue == null) {
            return false;
        }
        return this.persistentQueue.registerStorageProblemListener(listener);
    }

    public synchronized boolean unRegisterStorageProblemListener(I_StorageProblemListener listener) {
        if (this.persistentQueue == null) {
            return false;
        }
        return this.persistentQueue.unRegisterStorageProblemListener(listener);
    }

    public void addQueueSizeListener(I_QueueSizeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(this.ME + ": addQueueSizeListener(null) is not allowed");
        }
        Object object = this.queueSizeListenersSync;
        synchronized (object) {
            if (this.queueSizeListeners == null) {
                this.queueSizeListeners = new ArrayList();
            }
            this.queueSizeListeners.add(listener);
        }
    }

    public void removeQueueSizeListener(I_QueueSizeListener listener) {
        Object object = this.queueSizeListenersSync;
        synchronized (object) {
            if (listener == null) {
                this.queueSizeListeners = null;
            } else {
                if (!((AbstractCollection)this.queueSizeListeners).remove(listener)) {
                    this.log.warn(this.ME, "removeQueueSizeListener: could not remove listener '" + listener.toString() + "' since not registered");
                }
                if (this.queueSizeListeners.size() == 0) {
                    this.queueSizeListeners = null;
                }
            }
        }
    }

    private final void invokeQueueSizeListener() {
        if (this.queueSizeListeners != null) {
            I_QueueSizeListener[] listeners = null;
            Object object = this.queueSizeListenersSync;
            synchronized (object) {
                listeners = this.queueSizeListeners.toArray(new I_QueueSizeListener[this.queueSizeListeners.size()]);
            }
            int i = 0;
            while (i < listeners.length) {
                block7: {
                    try {
                        listeners[i].changed(this, this.getNumOfEntries(), this.getNumOfBytes());
                    }
                    catch (NullPointerException e) {
                        if (!this.log.TRACE) break block7;
                        this.log.trace(this.ME, "invokeQueueSizeListener() call is not possible as another thread has removed queueSizeListeners, this is OK to prevent a synchronize.");
                    }
                }
                ++i;
            }
        }
    }

    public boolean hasQueueSizeListener(I_QueueSizeListener listener) {
        if (listener == null) {
            return this.queueSizeListeners != null;
        }
        return this.queueSizeListeners.contains(listener);
    }
}

