/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.queue.jdbc;

import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.lang.Tokenizer;
import org.jutils.init.Property;
import org.jutils.log.LogChannel;
import org.jutils.text.StringHelper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.queue.I_StorageProblemListener;
import org.xmlBlaster.util.queue.I_StorageProblemNotifier;
import org.xmlBlaster.util.queue.jdbc.JdbcManagerCommonTable;

public class JdbcConnectionPool
implements I_Timeout,
I_StorageProblemNotifier {
    private static String ME = "JdbcConnectionPool";
    private LogChannel log = null;
    private Global glob = null;
    private BoundedLinkedQueue connections;
    private int capacity;
    private int waitingCalls = 0;
    private long connectionBusyTimeout = 60000L;
    private int maxWaitingThreads = 200;
    private Hashtable mapping = null;
    private boolean initialized = false;
    private String tableNamePrefix = "XB";
    private String colNamePrefix = "";
    private int tableAllocationIncrement = 2;
    private int status = -1;
    private boolean waitingForReentrantConnections = false;
    private String url;
    private String user;
    private String password;
    private long reconnectionTimeout = 10000L;
    private I_StorageProblemListener storageProblemListener = null;
    private static boolean firstConnectError = true;
    private Properties pluginProp = null;
    private boolean dbAdmin = true;
    private int queryTimeout = 0;
    private int managerCount = 0;
    private boolean isShutdown = false;
    private boolean enableBatchMode;
    private String configurationIdentifier;
    private boolean cascadeDeleteSupported;
    private boolean nestedBracketsSupported;
    private final int MIN_POOL_SIZE = 1;

    public Properties getPluginProperties() {
        return this.pluginProp;
    }

    public void timeout(Object userData) {
        this.log.warn(ME, "timeout, current index: " + this.connections.size() + ", waiting for reentrant connections: " + this.waitingForReentrantConnections);
        JdbcConnectionPool jdbcConnectionPool = this;
        synchronized (jdbcConnectionPool) {
            if (this.waitingForReentrantConnections) {
                if (this.connections.size() == this.capacity) {
                    this.waitingForReentrantConnections = false;
                } else {
                    this.glob.getJdbcConnectionPoolTimer().addTimeoutListener(this, this.reconnectionTimeout, null);
                    return;
                }
            }
            try {
                this.log.warn(ME, "timeout:retrying to establish connections");
                this.connect(true);
            }
            catch (Throwable ex) {
                this.disconnect(-1L);
                this.glob.getJdbcConnectionPoolTimer().addTimeoutListener(this, this.reconnectionTimeout, null);
            }
        }
    }

    public synchronized boolean registerStorageProblemListener(I_StorageProblemListener storageProblemListener) {
        this.storageProblemListener = storageProblemListener;
        return true;
    }

    public synchronized boolean unRegisterStorageProblemListener(I_StorageProblemListener storageProblemListener) {
        if (this.storageProblemListener == null || this.storageProblemListener != storageProblemListener) {
            return false;
        }
        this.storageProblemListener = null;
        return true;
    }

    private Connection get(long delay) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "get invoked");
        }
        Connection ret = null;
        if (this.connections.size() > this.capacity) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "get: Inconsistency in connection index: a negative one is not possible: '" + this.connections.size() + "'");
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "going to retreive a connection");
        }
        try {
            ret = (Connection)this.connections.poll(delay);
        }
        catch (InterruptedException ex) {
            this.log.warn(ME, "the waiting for a connection was interrupted: " + ex.getMessage());
        }
        if (this.log.TRACE) {
            this.log.trace(ME, "retreived the connection");
        }
        if (ret == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, ME, "get: a timeout occured when waiting for a free DB connection. Either the timeout is too short or other connections are blocking");
        }
        return ret;
    }

    private boolean put(Connection conn) {
        if (this.log.CALL) {
            this.log.call(ME, "put invoked");
        }
        if (conn == null) {
            return false;
        }
        if (this.log.TRACE) {
            try {
                if (!conn.getAutoCommit()) {
                    this.log.error(ME, "put: error: the connection has not properly been reset: autocommit is 'false'");
                }
            }
            catch (Throwable ex) {
                this.log.error(ME, "put:  checking for autocommit. reason: " + ex.toString());
                ex.printStackTrace();
            }
        }
        try {
            return this.connections.offer((Object)conn, 5L);
        }
        catch (InterruptedException ex) {
            this.log.warn(ME, "put: an interruption occured: " + ex.getMessage());
            return false;
        }
    }

    public Global getGlobal() {
        return this.glob;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void connect(boolean disconnectFirst) throws SQLException {
        int oldStatus;
        I_StorageProblemListener lst = null;
        JdbcConnectionPool jdbcConnectionPool = this;
        synchronized (jdbcConnectionPool) {
            if (disconnectFirst) {
                this.disconnect();
            }
            int i = 0;
            while (i < this.capacity) {
                if (this.log.TRACE) {
                    this.log.trace(ME, "initializing DB connection " + i + " url=" + this.url + " user=" + this.user);
                }
                try {
                    this.connections.put((Object)DriverManager.getConnection(this.url, this.user, this.password));
                }
                catch (InterruptedException e) {
                    this.log.error(ME, "connect: an interrupted exception occured " + e.getMessage());
                }
                if (this.log.TRACE) {
                    this.log.trace(ME, "initialized DB connection " + i + " success");
                }
                ++i;
            }
            oldStatus = this.status;
            this.status = 1;
            lst = this.storageProblemListener;
        }
        this.isShutdown = false;
        if (lst != null) {
            lst.storageAvailable(oldStatus);
        }
        this.log.info(ME, "Successfully reconnected to database");
    }

    public synchronized void initialize(Global glob, Properties pluginProperties) throws ClassNotFoundException, SQLException, XmlBlasterException {
        if (this.initialized) {
            return;
        }
        this.glob = glob;
        this.pluginProp = pluginProperties;
        this.log = this.glob.getLog("jdbc");
        if (this.log.TRACE) {
            this.log.trace(ME, "initialize");
        }
        Property prop = glob.getProperty();
        String xmlBlasterJdbc = prop.get("JdbcDriver.drivers", "org.postgresql.Driver:sun.jdbc.odbc.JdbcOdbcDriver:ORG.as220.tinySQL.dbfFileDriver:oracle.jdbc.driver.OracleDriver");
        System.setProperty("jdbc.drivers", xmlBlasterJdbc);
        this.url = prop.get("queue.persistent.url", "jdbc:postgresql://localhost/test");
        this.user = prop.get("queue.persistent.user", "postgres");
        this.password = prop.get("queue.persistent.password", "");
        this.capacity = prop.get("queue.persistent.connectionPoolSize", 1);
        if (this.capacity < 1) {
            this.log.warn(ME, "queue.persistent.connectionPoolSize=" + this.capacity + " is too small, setting it to " + 1);
            this.capacity = 1;
        }
        this.connectionBusyTimeout = prop.get("queue.persistent.connectionBusyTimeout", 60000L);
        this.maxWaitingThreads = prop.get("queue.persistent.maxWaitingThreads", 200);
        this.tableAllocationIncrement = prop.get("queue.persistent.tableAllocationIncrement", 10);
        this.tableNamePrefix = prop.get("queue.persistent.tableNamePrefix", "XB").toUpperCase();
        this.colNamePrefix = prop.get("queue.persistent.colNamePrefix", "").toUpperCase();
        this.url = this.pluginProp.getProperty("url", this.url);
        String dbInstanceName = glob.getStrippedId();
        this.url = StringHelper.replaceFirst(this.url, "$_{xmlBlaster_uniqueId}", dbInstanceName);
        ME = "JdbcConnectionPool-" + this.url;
        this.user = this.pluginProp.getProperty("user", this.user);
        this.password = this.pluginProp.getProperty("password", this.password);
        String help = this.pluginProp.getProperty("connectionPoolSize", "" + this.capacity);
        try {
            this.capacity = Integer.parseInt(help);
        }
        catch (Exception ex) {
            this.log.warn(ME, "the 'connectionPoolSize' plugin-property is not parseable: '" + help + "' will be using the default '" + this.capacity + "'");
        }
        if (this.capacity < 1) {
            this.log.warn(ME, "connectionPoolSize=" + this.capacity + " is too small, setting it to " + 1);
            this.capacity = 1;
        }
        help = this.pluginProp.getProperty("connectionBusyTimeout", "" + this.connectionBusyTimeout);
        try {
            this.connectionBusyTimeout = Long.parseLong(help);
        }
        catch (Exception ex) {
            this.log.warn(ME, "the 'connectionBusyTimeout' plugin-property is not parseable: '" + help + "' will be using the default '" + this.connectionBusyTimeout + "'");
        }
        help = this.pluginProp.getProperty("maxWaitingThreads", "" + this.maxWaitingThreads);
        try {
            this.maxWaitingThreads = Integer.parseInt(help);
        }
        catch (Exception ex) {
            this.log.warn(ME, "the 'maxWaitingThreads' plugin-property is not parseable: '" + help + "' will be using the default '" + this.maxWaitingThreads + "'");
        }
        help = this.pluginProp.getProperty("enableBatchMode", "true");
        try {
            this.enableBatchMode = Boolean.getBoolean(help);
        }
        catch (Exception ex) {
            this.log.warn(ME, "the 'enableBatchMode' plugin-property is not parseable: '" + help + "' will be using the default '" + this.enableBatchMode + "'");
        }
        help = this.pluginProp.getProperty("tableAllocationIncrement", "" + this.tableAllocationIncrement);
        try {
            this.tableAllocationIncrement = Integer.parseInt(help);
        }
        catch (Exception ex) {
            this.log.warn(ME, "the 'tableAllocationIncrement' plugin-property is not parseable: '" + help + "' will be using the default '" + this.tableAllocationIncrement + "'");
        }
        this.tableNamePrefix = this.pluginProp.getProperty("tableNamePrefix", this.tableNamePrefix).trim().toUpperCase();
        this.colNamePrefix = this.pluginProp.getProperty("colNamePrefix", this.colNamePrefix).trim().toUpperCase();
        String tmp = this.pluginProp.getProperty("dbAdmin", "true").trim();
        this.dbAdmin = true;
        if ("false".equalsIgnoreCase(tmp)) {
            this.dbAdmin = false;
        }
        this.configurationIdentifier = this.pluginProp.getProperty("configurationIdentifier", null);
        if (this.configurationIdentifier != null) {
            this.configurationIdentifier = this.configurationIdentifier.trim();
        }
        help = this.pluginProp.getProperty("cascadeDeleteSupported", "true");
        try {
            this.cascadeDeleteSupported = Boolean.getBoolean(help);
        }
        catch (Exception ex) {
            this.log.warn(ME, "the 'cascadeDeleteSupported' plugin-property is not parseable: '" + help + "' will be using the default '" + this.cascadeDeleteSupported + "'");
        }
        help = this.pluginProp.getProperty("nestedBracketsSupported", "true");
        try {
            this.nestedBracketsSupported = Boolean.getBoolean(help);
        }
        catch (Exception ex) {
            this.log.warn(ME, "the 'nestedBracketsSupported' plugin-property is not parseable: '" + help + "' will be using the default '" + this.nestedBracketsSupported + "'");
        }
        if (this.log.DUMP) {
            this.log.dump(ME, "initialize -url                    : " + this.url);
            this.log.dump(ME, "initialize -user                   : " + this.user);
            this.log.dump(ME, "initialize -password               : " + this.password);
            this.log.dump(ME, "initialize -max number of conn     : " + this.capacity);
            this.log.dump(ME, "initialize -conn busy timeout      : " + this.connectionBusyTimeout);
            this.log.dump(ME, "initialize -driver list            : " + xmlBlasterJdbc);
            this.log.dump(ME, "initialize -max. waiting Threads   :" + this.maxWaitingThreads);
            this.log.dump(ME, "initialize -tableNamePrefix        :" + this.tableNamePrefix);
            this.log.dump(ME, "initialize -colNamePrefix          :" + this.colNamePrefix);
            this.log.dump(ME, "initialize -dbAdmin                :" + this.dbAdmin);
            this.log.dump(ME, "initialize -cascadeDeleteSupported :" + this.cascadeDeleteSupported);
            this.log.dump(ME, "initialize -nestedBracketsSupported:" + this.nestedBracketsSupported);
            if (this.configurationIdentifier != null) {
                this.log.dump(ME, "initialize -configurationIdentifier:" + this.configurationIdentifier);
            }
        }
        this.connections = new BoundedLinkedQueue();
        this.connections.setCapacity(this.capacity);
        try {
            this.connect(true);
            this.parseMapping(prop);
            if (this.log.DUMP) {
                this.dumpMetaData();
            }
            this.initialized = true;
        }
        catch (SQLException ex) {
            if (firstConnectError) {
                firstConnectError = false;
                this.log.error(ME, " connecting to DB, error code : '" + ex.getErrorCode() + " : " + ex.getMessage() + "' DB configuration details follow (check if the DB is running)");
                this.log.info(ME, "diagnostics: initialize -url                 : '" + this.url + "'");
                this.log.info(ME, "diagnostics: initialize -user                : '" + this.user + "'");
                this.log.info(ME, "diagnostics: initialize -password            : '" + this.password + "'");
                this.log.info(ME, "diagnostics: initialize -max number of conn  : '" + this.capacity + "'");
                this.log.info(ME, "diagnostics: initialize -conn busy timeout   : '" + this.connectionBusyTimeout + "'");
                this.log.info(ME, "diagnostics: initialize -driver list         : '" + xmlBlasterJdbc + "'");
                this.log.info(ME, "diagnostics: initialize -max. waiting Threads: '" + this.maxWaitingThreads + "'");
                this.log.dump(ME, "diagnostics: initialize -tableNamePrefix     :" + this.tableNamePrefix);
                this.log.dump(ME, "diagnostics: initialize -colNamePrefix       :" + this.colNamePrefix);
                ex.printStackTrace();
            } else if (this.log.TRACE) {
                this.log.trace(ME, " connecting to DB, error code: '" + ex.getErrorCode() + " : " + ex.getMessage() + "' DB configuration details follow (check if the DB is running)");
            }
            this.disconnect(-1L);
            throw ex;
        }
        this.log.info(ME, "Connections to DB '" + this.url + "' successfully established.");
    }

    public String getTableNamePrefix() {
        return this.tableNamePrefix;
    }

    public String getColNamePrefix() {
        return this.colNamePrefix;
    }

    public int getTableAllocationIncrement() {
        return this.tableAllocationIncrement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Hashtable parseMapping(Property prop) throws XmlBlasterException, SQLException {
        String mappingKey;
        block16: {
            if (this.log.CALL) {
                this.log.call(ME, "parseMapping");
            }
            if (this.isShutdown) {
                this.connect(false);
            }
            mappingKey = null;
            if (this.configurationIdentifier == null) {
                Connection conn = null;
                try {
                    conn = this.getConnection();
                    mappingKey = conn.getMetaData().getDatabaseProductName();
                    mappingKey = StringHelper.replaceAll(mappingKey, " ", "");
                    if (this.log.TRACE) {
                        this.log.trace(ME, "parseMapping: the mapping will be done for the keyword (which is here is the DB product name)'" + mappingKey + "'");
                    }
                    Object var5_4 = null;
                    if (conn == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (conn != null) {
                        this.releaseConnection(conn);
                    }
                    throw throwable;
                }
                this.releaseConnection(conn);
            } else {
                mappingKey = this.configurationIdentifier;
                if (this.log.TRACE) {
                    this.log.trace(ME, "parseMapping: the mapping will be done for the keyword (name given in the plugin)'" + mappingKey + "'");
                }
            }
        }
        String mappingText = prop.get("JdbcDriver.mapping[" + mappingKey + "]", "");
        if (this.log.TRACE) {
            this.log.trace(ME, "parseMapping: the string to be mapped is '" + mappingText + "'");
        }
        this.mapping = new Hashtable();
        Tokenizer tokenizer = new Tokenizer(mappingText, ',', '\"');
        XmlBlasterException ex = null;
        while (true) {
            if (!tokenizer.hasNext()) {
                if (ex == null) {
                    return this.mapping;
                }
                if (this.log.TRACE) {
                    this.log.trace(ME, "parseMapping: Exception occured: " + ex.getMessage());
                }
                throw ex;
            }
            String singleMapping = tokenizer.nextToken();
            int pos = singleMapping.indexOf("=");
            if (pos < 0) {
                ex = new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, ME, "syntax in xmlBlaster.properties for " + singleMapping + " is wrong: no equality sign between key and value");
            }
            String key = singleMapping.substring(0, pos);
            String value = singleMapping.substring(pos + 1, singleMapping.length());
            if (this.log.TRACE) {
                this.log.trace(ME, "parseMapping: mapping " + key + " to " + value);
            }
            this.mapping.put(key, value);
        }
    }

    public Hashtable getMapping() {
        return this.mapping;
    }

    private final synchronized void disconnect(long waitTime) {
        if (waitTime < 5L) {
            waitTime = 5L;
        }
        Connection conn = null;
        int i = 0;
        while (i < this.connections.size()) {
            try {
                conn = this.get(waitTime);
                if (conn == null) break;
                conn.close();
                if (this.log.TRACE) {
                    this.log.trace(ME, "connection " + conn + " disconnected ( object address: " + conn + ")");
                }
            }
            catch (Throwable ex) {
                this.log.error(ME, "could not close connection " + conn + " correctly but resource is set to null. reason " + ex.toString());
                ex.printStackTrace();
            }
            ++i;
        }
    }

    public synchronized void disconnect() {
        if (this.log.CALL) {
            this.log.call(ME, "disconnect invoked");
        }
        this.disconnect(-1L);
    }

    public void finalize() {
        this.shutdown();
    }

    public final int getStatus() {
        return this.status;
    }

    public final void setConnectionLost() {
        if (this.status != 0) {
            int oldStatus = this.status;
            JdbcConnectionPool jdbcConnectionPool = this;
            synchronized (jdbcConnectionPool) {
                if (this.status == 0) {
                    return;
                }
                oldStatus = this.status;
                if (this.status != 0) {
                    this.status = 0;
                    this.waitingForReentrantConnections = true;
                }
            }
            this.glob.getJdbcConnectionPoolTimer().addTimeoutListener(this, this.reconnectionTimeout, null);
            I_StorageProblemListener lst = this.storageProblemListener;
            lst.storageUnavailable(oldStatus);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Connection getConnection() throws XmlBlasterException {
        if (this.status != 1) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, ME, "getConnection: Connection Lost. Going in polling modus");
        }
        if (this.waitingCalls >= this.maxWaitingThreads) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_TOO_MANY_THREADS, ME, "Too many threads waiting for a connection to the DB. Increase the property 'queue.persistent.maxWaitingThreads'");
        }
        JdbcConnectionPool jdbcConnectionPool2 = this;
        // MONITORENTER : jdbcConnectionPool2
        ++this.waitingCalls;
        // MONITOREXIT : jdbcConnectionPool2
        if (this.log.CALL) {
            this.log.call(ME, "getConnection " + this.connections.size() + " waiting calls: " + this.waitingCalls);
        }
        try {
            try {
                if (this.isShutdown) {
                    this.connect(false);
                }
                Connection connection = this.get(this.connectionBusyTimeout);
                Object var5_4 = null;
                JdbcConnectionPool jdbcConnectionPool = this;
                // MONITORENTER : jdbcConnectionPool
                --this.waitingCalls;
                // MONITOREXIT : jdbcConnectionPool
                return connection;
            }
            catch (SQLException ex) {
                String additionalMsg = "check system classpath and 'jdbc.drivers' system property\n";
                additionalMsg = additionalMsg + "'classpath' is: '" + System.getProperty("classpath", "") + "'\n";
                additionalMsg = additionalMsg + "'jdbc.drivers' is: '" + System.getProperty("jdbc.drivers", "") + "'\n";
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, ME + ".getConnection()", ex.getMessage() + " " + additionalMsg);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            JdbcConnectionPool jdbcConnectionPool = this;
            // MONITORENTER : jdbcConnectionPool
            --this.waitingCalls;
            // MONITOREXIT : jdbcConnectionPool
            throw throwable;
        }
    }

    public void releaseConnection(Connection conn) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "releaseConnection " + this.connections.size() + " waiting calls: " + this.waitingCalls);
        }
        try {
            SQLWarning warns = conn.getWarnings();
            if (this.log.TRACE) {
                while (warns != null) {
                    this.log.trace(ME, "errorCode=" + warns.getErrorCode() + " state=" + warns.getSQLState() + ": " + warns.toString().trim());
                    warns = warns.getNextWarning();
                }
            }
            conn.clearWarnings();
        }
        catch (Throwable e) {
            this.log.warn(ME, "clearWarnings() failed: " + e.toString());
        }
        boolean isOk = this.put(conn);
        if (!isOk) {
            this.log.error(ME, "the connection pool is already full");
        }
    }

    /*
     * Loose catch block
     */
    public void dumpMetaData() {
        block15: {
            Connection conn = null;
            if (this.isShutdown) {
                this.connect(false);
            }
            conn = this.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            this.log.info(ME, "--------------- DUMP OF METADATA FOR THE DB START---------------------");
            String driverName = metaData.getDriverName();
            String productName = metaData.getDatabaseProductName();
            this.log.info(ME, "Driver name          :'" + driverName + "', product name: '" + productName + "'");
            this.log.info(ME, "max binary length    : " + metaData.getMaxBinaryLiteralLength());
            this.log.info(ME, "max char lit. length : " + metaData.getMaxCharLiteralLength());
            this.log.info(ME, "max column length    : " + metaData.getMaxColumnNameLength());
            this.log.info(ME, "max cols. in table   : " + metaData.getMaxColumnsInTable());
            this.log.info(ME, "max connections      : " + metaData.getMaxConnections());
            this.log.info(ME, "max statement length : " + metaData.getMaxStatementLength());
            this.log.info(ME, "max nr. of statements: " + metaData.getMaxStatements());
            this.log.info(ME, "max tablename length : " + metaData.getMaxTableNameLength());
            this.log.info(ME, "url                  : " + metaData.getURL());
            this.log.info(ME, "support for trans.   : " + metaData.supportsTransactions());
            this.log.info(ME, "--------------- DUMP OF METADATA FOR THE DB END  ---------------------");
            Object var6_7 = null;
            try {
                if (conn != null) {
                    this.releaseConnection(conn);
                }
                break block15;
            }
            catch (XmlBlasterException ex2) {
                this.log.error(ME, "dumpMetaData:  releasing the connection: " + ex2.getMessage());
                ex2.printStackTrace();
            }
            break block15;
            {
                catch (XmlBlasterException ex) {
                    this.log.error(ME, "dumpMetaData: exception: " + ex.getMessage());
                    ex.printStackTrace();
                    Object var6_8 = null;
                    try {
                        if (conn != null) {
                            this.releaseConnection(conn);
                        }
                        break block15;
                    }
                    catch (XmlBlasterException ex2) {
                        this.log.error(ME, "dumpMetaData:  releasing the connection: " + ex2.getMessage());
                        ex2.printStackTrace();
                    }
                    break block15;
                }
                catch (SQLException ex) {
                    this.log.error(ME, "dumpMetaData: SQL exception: " + ex.getMessage());
                    ex.printStackTrace();
                    Object var6_9 = null;
                    try {
                        if (conn != null) {
                            this.releaseConnection(conn);
                        }
                        break block15;
                    }
                    catch (XmlBlasterException ex2) {
                        this.log.error(ME, "dumpMetaData:  releasing the connection: " + ex2.getMessage());
                        ex2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (conn != null) {
                        this.releaseConnection(conn);
                    }
                }
                catch (XmlBlasterException ex2) {
                    this.log.error(ME, "dumpMetaData:  releasing the connection: " + ex2.getMessage());
                    ex2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public boolean isDbAdmin() {
        return this.dbAdmin;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    /*
     * Loose catch block
     */
    public static void main(String[] args) {
        block19: {
            LogChannel log = null;
            Connection conn = null;
            Global glob = Global.instance();
            glob.init(args);
            log = glob.getLog("queue");
            log.info(ME, "starting the application: The Tests start here ");
            String prefix = "cb.queue.persistent";
            Property prop = glob.getProperty();
            String xmlBlasterJdbc = prop.get("JdbcDriver.drivers", "org.postgresql.Driver");
            System.setProperty("jdbc.drivers", xmlBlasterJdbc);
            String url = prop.get(prefix + ".url", "");
            String user = prop.get(prefix + ".user", "postgres");
            String password = prop.get(prefix + ".password", "");
            if (log.DUMP) {
                log.dump(ME, "initialize -prefix is           : " + prefix);
                log.dump(ME, "initialize -url                 : " + url);
                log.dump(ME, "initialize -user                : " + user);
                log.dump(ME, "initialize -password            : " + password);
                log.dump(ME, "initialize -driver list         : " + xmlBlasterJdbc);
            }
            log.info(ME, "establishing the connection");
            conn = DriverManager.getConnection(url, user, password);
            log.info(ME, "connection established. Sleeping 1 second");
            Thread.sleep(1000L);
            log.info(ME, "finished");
            Object var11_11 = null;
            try {
                if (log != null) {
                    log.info(ME, "closing the connection");
                }
                if (conn != null) {
                    conn.close();
                }
                if (log != null) {
                    log.info(ME, "connection closed");
                }
                break block19;
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
            break block19;
            {
                catch (Exception ex) {
                    if (log != null) {
                        log.error(ME, " connecting to DB, error code:  : " + ex.getMessage());
                    }
                    ex.printStackTrace();
                    Object var11_12 = null;
                    try {
                        if (log != null) {
                            log.info(ME, "closing the connection");
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        if (log != null) {
                            log.info(ME, "connection closed");
                        }
                        break block19;
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (log != null) {
                        log.info(ME, "closing the connection");
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    if (log != null) {
                        log.info(ME, "connection closed");
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public synchronized void shutdown() {
        if (this.log.CALL) {
            this.log.call(ME, "shutdown");
        }
        this.disconnect();
        this.isShutdown = true;
    }

    public synchronized void registerManager(JdbcManagerCommonTable manager) {
        if (this.log.CALL) {
            this.log.call(ME, "registerManager, number of managers registered (before registering this one): '" + this.managerCount + "'");
        }
        if (manager == null) {
            return;
        }
        ++this.managerCount;
    }

    public synchronized void unregisterManager(JdbcManagerCommonTable manager) {
        if (this.log.CALL) {
            this.log.call(ME, "unregisterManager, number of managers registered (still including this one): '" + this.managerCount + "'");
        }
        if (manager == null) {
            return;
        }
        --this.managerCount;
        if (this.managerCount == 0) {
            this.shutdown();
        }
    }

    public boolean isBatchModeEnabled() {
        return this.enableBatchMode;
    }

    public boolean isCascadeDeleteSuppported() {
        return this.cascadeDeleteSupported;
    }

    public boolean isNestedBracketsSuppported() {
        return this.nestedBracketsSupported;
    }
}

