/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.queue.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_EntryFactory;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_StorageProblemListener;
import org.xmlBlaster.util.queue.I_StorageProblemNotifier;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.queue.ReturnDataHolder;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queue.jdbc.JdbcConnectionPool;
import org.xmlBlaster.util.queue.jdbc.PreparedQuery;

public class JdbcManagerCommonTable
implements I_StorageProblemListener,
I_StorageProblemNotifier {
    private static final String ME = "JdbcManagerCommonTable";
    private final Global glob;
    private final LogChannel log;
    private final JdbcConnectionPool pool;
    private final I_EntryFactory factory;
    private final WeakHashMap listener;
    private static final String DUMMY_VALUE = "A";
    private final TreeSet queues;
    private final String tableNamePrefix;
    private final String colNamePrefix;
    private String stringTxt;
    private String longintTxt;
    private String intTxt;
    private String blobTxt;
    private String booleanTxt;
    private boolean dbInitialized;
    private int maxStatementLength;
    private boolean isConnected;
    private static boolean first = true;
    private String nodesTableName;
    private String queuesTableName;
    private String entriesTableName;
    private HashSet nodesCache;
    private String blobVarName;
    private String byteSizeColName;
    private String dataIdColName;
    private String keyAttr;
    private final boolean AUTO_COMMIT = true;
    private final String managerName;
    PreparedStatement pingPrepared;
    private int queueCounter;
    private boolean supportsBatch;
    private boolean enableBatchMode;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JdbcManagerCommonTable(JdbcConnectionPool pool, I_EntryFactory factory, String managerName) throws XmlBlasterException {
        block19: {
            this.stringTxt = null;
            this.longintTxt = null;
            this.intTxt = null;
            this.blobTxt = null;
            this.booleanTxt = null;
            this.dbInitialized = false;
            this.maxStatementLength = 0;
            this.isConnected = true;
            this.nodesTableName = null;
            this.queuesTableName = null;
            this.entriesTableName = null;
            this.AUTO_COMMIT = true;
            this.pingPrepared = null;
            this.queueCounter = 0;
            this.supportsBatch = true;
            this.enableBatchMode = true;
            this.managerName = managerName;
            this.pool = pool;
            this.glob = this.pool.getGlobal();
            this.log = this.glob.getLog("jdbc");
            if (this.log.CALL) {
                this.log.call(ME, "Constructor called");
            }
            this.factory = factory;
            if (!this.pool.isInitialized()) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, ME, "constructor: the Connection pool is not properly initialized");
            }
            Connection conn = null;
            try {
                try {
                    String dbName;
                    conn = this.pool.getConnection();
                    this.maxStatementLength = conn.getMetaData().getMaxStatementLength();
                    if (this.maxStatementLength < 1) {
                        this.maxStatementLength = this.glob.getProperty().get("queue.persistent.maxStatementLength", 2048);
                        if (first) {
                            this.log.info(ME, "The maximum SQL statement length is not defined in JDBC meta data, we set it to " + this.maxStatementLength);
                            first = false;
                        }
                    }
                    if (!conn.getMetaData().supportsTransactions()) {
                        dbName = conn.getMetaData().getDatabaseProductName();
                        this.log.error(ME, "the database '" + dbName + "' does not support transactions, unpredicted results may happen");
                    }
                    if (!conn.getMetaData().supportsBatchUpdates()) {
                        dbName = conn.getMetaData().getDatabaseProductName();
                        this.supportsBatch = false;
                        this.log.trace(ME, "the database '" + dbName + "' does not support batch mode. No problem I will work whitout it");
                    }
                }
                catch (XmlBlasterException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, ME, "constructor: failed to get the metadata", ex);
                }
                Object var8_7 = null;
                if (conn == null) break block19;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (conn != null) {
                    this.pool.releaseConnection(conn);
                }
                throw throwable;
            }
            this.pool.releaseConnection(conn);
        }
        Hashtable names = pool.getMapping();
        this.queues = new TreeSet();
        this.listener = new WeakHashMap();
        this.stringTxt = (String)names.get("string");
        if (this.stringTxt == null) {
            this.stringTxt = "text";
        }
        this.longintTxt = (String)names.get("longint");
        if (this.longintTxt == null) {
            this.longintTxt = "bigint";
        }
        this.intTxt = (String)names.get("int");
        if (this.intTxt == null) {
            this.intTxt = "integer";
        }
        this.booleanTxt = (String)names.get("boolean");
        if (this.booleanTxt == null) {
            this.booleanTxt = "char(1)";
        }
        this.blobTxt = (String)names.get("blob");
        if (this.blobTxt == null) {
            this.blobTxt = "bytea";
        }
        this.blobVarName = (String)names.get("blobVarName");
        if (this.blobVarName == null) {
            this.blobVarName = "blob";
        }
        this.keyAttr = (String)names.get("keyAttr");
        if (this.keyAttr == null) {
            this.keyAttr = "";
        }
        this.tableNamePrefix = this.pool.getTableNamePrefix();
        this.colNamePrefix = this.pool.getColNamePrefix();
        this.nodesTableName = this.tableNamePrefix + pool.getPluginProperties().getProperty("nodesTableName", "NODES");
        this.nodesTableName = this.nodesTableName.toUpperCase();
        this.queuesTableName = this.tableNamePrefix + pool.getPluginProperties().getProperty("queuesTableName", "QUEUES");
        this.queuesTableName = this.queuesTableName.toUpperCase();
        this.entriesTableName = this.tableNamePrefix + pool.getPluginProperties().getProperty("entriesTableName", "ENTRIES");
        this.entriesTableName = this.entriesTableName.toUpperCase();
        this.byteSizeColName = this.colNamePrefix + "byteSize";
        this.dataIdColName = this.colNamePrefix + "dataId";
        this.enableBatchMode = this.pool.isBatchModeEnabled();
        this.nodesCache = new HashSet();
        this.pool.registerManager(this);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ping() {
        conn = null;
        try {
            try {
                conn = this.pool.getConnection();
                var3_4 = ret = this.ping(conn);
                var5_6 = null;
            }
            catch (XmlBlasterException ex) {
                this.log.warn("JdbcManagerCommonTable", "ping failed due to problems with the pool. Check the jdbc pool size in 'xmlBlaster.properties'. Reason :" + ex.getMessage());
                var3_5 = false;
                var5_7 = null;
                try {
                    if (conn == null) return var3_5;
                    this.pool.releaseConnection(conn);
                    return var3_5;
                }
                catch (XmlBlasterException e) {
                    this.log.error("JdbcManagerCommonTable", "ping: releaseConnection failed: " + e.getMessage());
                }
                return var3_5;
            }
        }
        catch (Throwable var4_12) {
            var5_8 = null;
            try {}
            catch (XmlBlasterException e) {
                this.log.error("JdbcManagerCommonTable", "ping: releaseConnection failed: " + e.getMessage());
                throw var4_12;
            }
            if (conn == null) throw var4_12;
            this.pool.releaseConnection(conn);
            throw var4_12;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 72->87)] { 
lbl33:
        // 1 sources

        if (conn == null) return var3_4;
        this.pool.releaseConnection(conn);
        return var3_4;
lbl36:
        // 1 sources

        catch (XmlBlasterException e) {
            this.log.error("JdbcManagerCommonTable", "ping: releaseConnection failed: " + e.getMessage());
        }
        return var3_4;
    }

    private boolean ping(Connection conn) {
        if (this.log.CALL) {
            this.log.call(ME, "ping");
        }
        if (conn == null) {
            return false;
        }
        try {
            if (this.log.TRACE) {
                this.log.trace(ME, "Trying ping ...");
            }
            conn.getMetaData().getTables("xyx", "xyz", "xyz", null);
            if (this.log.TRACE) {
                this.log.trace(ME, "ping successful");
            }
            return true;
        }
        catch (Throwable ex) {
            this.log.warn(ME, "ping to DB failed. DB may be down. Reason " + ex.toString());
            return false;
        }
    }

    public boolean registerStorageProblemListener(I_StorageProblemListener entry) {
        WeakHashMap weakHashMap = this.listener;
        synchronized (weakHashMap) {
            this.listener.put(entry, DUMMY_VALUE);
        }
        return true;
    }

    public boolean unRegisterStorageProblemListener(I_StorageProblemListener entry) {
        if (entry == null) {
            return false;
        }
        WeakHashMap weakHashMap = this.listener;
        synchronized (weakHashMap) {
            boolean bl = this.listener.remove(entry) != null;
            return bl;
        }
    }

    public void storageUnavailable(int oldStatus) {
        if (this.log.CALL) {
            this.log.call(ME, "storageUnavailable (old status '" + oldStatus + "')");
        }
        this.isConnected = false;
        I_StorageProblemListener[] listenerArr = this.getStorageProblemListenerArr();
        int i = 0;
        while (i < listenerArr.length) {
            if (this.isConnected) break;
            I_StorageProblemListener singleListener = listenerArr[i];
            singleListener.storageUnavailable(oldStatus);
            ++i;
        }
    }

    public void storageAvailable(int oldStatus) {
        if (this.log.CALL) {
            this.log.call(ME, "storageAvailable (old status '" + oldStatus + "')");
        }
        this.isConnected = true;
        if (oldStatus == -1) {
            return;
        }
        I_StorageProblemListener[] listenerArr = this.getStorageProblemListenerArr();
        int i = 0;
        while (i < listenerArr.length) {
            if (!this.isConnected) break;
            I_StorageProblemListener singleListener = listenerArr[i];
            singleListener.storageAvailable(oldStatus);
            ++i;
        }
    }

    public I_StorageProblemListener[] getStorageProblemListenerArr() {
        WeakHashMap weakHashMap = this.listener;
        synchronized (weakHashMap) {
            I_StorageProblemListener[] i_StorageProblemListenerArray = ((AbstractMap)this.listener).keySet().toArray(new I_StorageProblemListener[this.listener.size()]);
            return i_StorageProblemListenerArray;
        }
    }

    protected final boolean checkIfDBLoss(Connection conn, String location, Throwable ex) {
        return this.checkIfDBLoss(conn, location, ex, null);
    }

    protected final boolean checkIfDBLoss(Connection conn, String location, Throwable ex, String trace) {
        boolean ret = false;
        if (conn != null) {
            ret = !this.ping(conn);
        } else {
            boolean bl = ret = !this.ping();
        }
        if (ret) {
            this.log.error(ME, location + ": the connection to the DB has been lost. Going in polling modus");
            this.pool.setConnectionLost();
        }
        return ret;
    }

    private synchronized HashSet getXbTableNames(Connection conn) throws SQLException {
        String[] types = new String[]{"TABLE"};
        ResultSet rs = conn.getMetaData().getTables(null, null, null, types);
        HashSet<String> ret = new HashSet<String>();
        while (rs.next()) {
            String table = rs.getString(3).toUpperCase();
            if (this.log.TRACE) {
                this.log.trace(ME, "getXbTableNames found table '" + table + "': adding to the set of found tables");
            }
            ret.add(table);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean tablesCheckAndSetup(boolean createTables) throws XmlBlasterException {
        block34: {
            block31: {
                block33: {
                    block30: {
                        if (this.log.CALL) {
                            this.log.call("JdbcManagerCommonTable", "tablesCheckAndSetup");
                        }
                        if (!this.isConnected) {
                            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable", "tablesCheckAndSetup: the DB disconnected. Handling is currently not possible");
                        }
                        nodesTableExists = false;
                        queuesTableExists = false;
                        entriesTableExists = false;
                        conn = null;
                        req = "retrieving metadata";
                        try {
                            try {
                                conn = this.pool.getConnection();
                                conn.setAutoCommit(false);
                                set = this.getXbTableNames(conn);
                                if (set.contains(this.nodesTableName.toUpperCase())) {
                                    nodesTableExists = true;
                                }
                                if (this.log.TRACE) {
                                    this.log.trace(this.getLogId(null, null, "tablesCheckAndSetup"), "nodes table exists : " + nodesTableExists);
                                }
                                if (set.contains(this.queuesTableName.toUpperCase())) {
                                    queuesTableExists = true;
                                }
                                if (this.log.TRACE) {
                                    this.log.trace(this.getLogId(null, null, "tablesCheckAndSetup"), "queues table exists : " + queuesTableExists);
                                }
                                if (set.contains(this.entriesTableName.toUpperCase())) {
                                    entriesTableExists = true;
                                }
                                if (this.log.TRACE) {
                                    this.log.trace(this.getLogId(null, null, "tablesCheckAndSetup"), "entries table exists : " + entriesTableExists);
                                }
                                if (!createTables) {
                                    var8_9 = nodesTableExists != false && queuesTableExists != false && entriesTableExists != false;
                                    var11_12 = null;
                                    if (conn == null) return var8_9;
                                    break block30;
                                }
                                if (!nodesTableExists) {
                                    this.log.info(this.getLogId(null, null, "tablesCheckAndSetup"), "adding table '" + this.nodesTableName + "' as the 'nodes' table");
                                    req = "CREATE TABLE " + this.nodesTableName.toUpperCase() + " (nodeId " + this.stringTxt + " " + this.keyAttr + ", PRIMARY KEY (nodeId))";
                                    if (this.log.TRACE) {
                                        this.log.trace(this.getLogId(null, null, "tablesCheckAndSetup"), "Request: '" + req + "'");
                                    }
                                    this.update(req, conn);
                                }
                                if (!queuesTableExists) {
                                    this.log.info(this.getLogId(null, null, "tablesCheckAndSetup"), "adding table '" + this.queuesTableName + "' as the 'queues' table");
                                    req = "CREATE TABLE " + this.queuesTableName.toUpperCase() + " (queueName " + this.stringTxt + " " + this.keyAttr + ", nodeId " + this.stringTxt + " " + this.keyAttr + ", numOfBytes " + this.longintTxt + ", numOfEntries " + this.longintTxt + ", PRIMARY KEY (queueName, nodeId)" + ", FOREIGN KEY (nodeId) REFERENCES " + this.nodesTableName + " (nodeId)";
                                    req = this.pool.isCascadeDeleteSuppported() != false ? req + " ON DELETE CASCADE)" : req + ")";
                                    if (this.log.TRACE) {
                                        this.log.trace(this.getLogId(null, null, "tablesCheckAndSetup"), "Request: '" + req + "'");
                                    }
                                    this.update(req, conn);
                                }
                                if (!entriesTableExists) {
                                    this.log.info(this.getLogId(null, null, "tablesCheckAndSetup"), "adding table '" + this.entriesTableName + "' as the 'entries' table");
                                    req = "CREATE TABLE " + this.entriesTableName.toUpperCase() + " (" + this.dataIdColName + " " + this.longintTxt + " " + this.keyAttr + ", nodeId " + this.stringTxt + " " + this.keyAttr + ", queueName " + this.stringTxt + " " + this.keyAttr + ", prio " + this.intTxt + ", flag " + this.stringTxt + ", durable " + this.booleanTxt + ", " + this.byteSizeColName + " " + this.longintTxt + ", " + this.blobVarName + " " + this.blobTxt + ", PRIMARY KEY (" + this.dataIdColName + ", queueName)" + ", FOREIGN KEY (queueName, nodeId) REFERENCES " + this.queuesTableName + " (queueName , nodeId)";
                                    req = this.pool.isCascadeDeleteSuppported() != false ? req + " ON DELETE CASCADE)" : req + ")";
                                    if (this.log.TRACE) {
                                        this.log.trace(this.getLogId(null, null, "tablesCheckAndSetup"), "Request: '" + req + "'");
                                    }
                                    this.update(req, conn);
                                }
                                if (!conn.getAutoCommit()) {
                                    conn.commit();
                                }
                                var9_18 = true;
                                break block31;
                            }
                            catch (XmlBlasterException ex) {
                                try {
                                    if (conn.getAutoCommit() != false) throw ex;
                                    conn.rollback();
                                    throw ex;
                                }
                                catch (Throwable e) {
                                    this.log.error("JdbcManagerCommonTable", "tablesCheckAndSetup: exception occured when rolling back: " + e.toString());
                                }
                                throw ex;
                            }
                            catch (Throwable ex) {
                                try {
                                    if (conn != null && !conn.getAutoCommit()) {
                                        conn.rollback();
                                    }
                                }
                                catch (Throwable e) {
                                    this.log.error("JdbcManagerCommonTable", "tablesCheckAndSetup: exception occured when rolling back: " + e.toString());
                                }
                                if (this.checkIfDBLoss(conn, this.getLogId(null, null, "tablesCheckAndSetup"), ex, "SQL request giving problems: " + req) == false) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.tablesCheckAndSetup", "", ex);
                                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.tablesCheckAndSetup", "", ex);
                            }
                        }
                        catch (Throwable var10_20) {
                            var11_14 = null;
                            if (conn == null) throw var10_20;
                            try {
                                conn.setAutoCommit(true);
                            }
                            catch (Throwable e) {
                                this.log.error("JdbcManagerCommonTable", "tablesCheckAndSetup: exception occured when setting back autocommit flag, reason: " + e.toString());
                            }
                            this.pool.releaseConnection(conn);
                            throw var10_20;
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [5 : 1379->1390)] { 
lbl92:
                    // 1 sources

                    conn.setAutoCommit(true);
                    break block33;
lbl94:
                    // 1 sources

                    catch (Throwable e) {
                        this.log.error("JdbcManagerCommonTable", "tablesCheckAndSetup: exception occured when setting back autocommit flag, reason: " + e.toString());
                    }
                }
                this.pool.releaseConnection(conn);
                return var8_9;
            }
            var11_13 = null;
            if (conn == null) return var9_18;
            ** try [egrp 4[TRYBLOCK] [5 : 1379->1390)] { 
lbl103:
            // 1 sources

            conn.setAutoCommit(true);
            break block34;
lbl105:
            // 1 sources

            catch (Throwable e) {
                this.log.error("JdbcManagerCommonTable", "tablesCheckAndSetup: exception occured when setting back autocommit flag, reason: " + e.toString());
            }
        }
        this.pool.releaseConnection(conn);
        return var9_18;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean addNode(String nodeId) throws XmlBlasterException {
        block25: {
            if (this.log.CALL) {
                this.log.call("JdbcManagerCommonTable", "addNode '" + nodeId + "'");
            }
            if (this.nodesCache.contains(nodeId)) {
                if (this.log.DUMP == false) return false;
                objs = this.nodesCache.toArray();
                i = 0;
                while (true) {
                    if (i >= this.nodesCache.size()) {
                        return false;
                    }
                    this.log.dump("JdbcManagerCommonTable", "addNode: node '" + (String)objs[i] + "' is in cache");
                    ++i;
                }
            }
            if (this.log.TRACE) {
                this.log.trace("JdbcManagerCommonTable", "addNode: the node did not exist in cache. Will add it now");
            }
            req = "SELECT count(*) from " + this.nodesTableName + " where nodeId='" + nodeId + "'";
            if (this.log.TRACE) {
                this.log.trace(this.getLogId(null, nodeId, "addNode"), "Request: '" + req + "'");
            }
            query = null;
            preStatement = null;
            ret = false;
            try {
                try {
                    query = new PreparedQuery(this.pool, req, false, this.log, -1);
                    query.rs.next();
                    size = query.rs.getInt(1);
                    if (size > 0) {
                        ret = false;
                    } else {
                        req = "INSERT INTO " + this.nodesTableName + " VALUES (?)";
                        preStatement = query.conn.prepareStatement(req);
                        preStatement.setQueryTimeout(this.pool.getQueryTimeout());
                        preStatement.setString(1, nodeId);
                        if (this.log.TRACE) {
                            this.log.trace(this.getLogId(null, nodeId, "addNode"), preStatement.toString());
                        }
                        preStatement.executeUpdate();
                        ret = true;
                    }
                    var7_10 = ret;
                    var9_12 = null;
                }
                catch (XmlBlasterException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    if (query != null) {
                        query.closeStatement();
                    }
                    if (this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(null, nodeId, "addNode"), ex) == false) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.addNode", "", ex);
                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.addNode", "", ex);
                }
            }
            catch (Throwable var8_16) {
                var9_13 = null;
                try {
                    if (preStatement != null) {
                        preStatement.close();
                    }
                }
                catch (Throwable ex1) {
                    this.log.error("JdbcManagerCommonTable", "addNode: exception occured when closing statement and query, reason: " + ex1.toString());
                }
                try {
                    if (query == null) throw var8_16;
                    query.close();
                    throw var8_16;
                }
                catch (Throwable ex1) {
                    this.log.error("JdbcManagerCommonTable", "addNode: exception occured when closing statement and query, reason: " + ex1.toString());
                    throw var8_16;
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 508->523)] { 
lbl69:
            // 1 sources

            if (preStatement != null) {
                preStatement.close();
            }
            break block25;
lbl72:
            // 1 sources

            catch (Throwable ex1) {
                this.log.error("JdbcManagerCommonTable", "addNode: exception occured when closing statement and query, reason: " + ex1.toString());
            }
        }
        ** try [egrp 3[TRYBLOCK] [4 : 557->568)] { 
lbl76:
        // 1 sources

        if (query == null) return var7_10;
        query.close();
        return var7_10;
lbl79:
        // 1 sources

        catch (Throwable ex1) {
            this.log.error("JdbcManagerCommonTable", "addNode: exception occured when closing statement and query, reason: " + ex1.toString());
        }
        return var7_10;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean removeNode(String nodeId) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call("JdbcManagerCommonTable", "removeNode");
        }
        var2_2 = this.nodesCache;
        synchronized (var2_2) {
            block20: {
                block18: {
                    block19: {
                        block17: {
                            if (this.nodesCache.contains(nodeId)) {
                                this.nodesCache.remove(nodeId);
                            }
                            postfix = this.nodesTableName + " where nodeId='" + nodeId + "'";
                            req = "SELECT count(*) from " + postfix;
                            if (this.log.TRACE) {
                                this.log.trace(this.getLogId(null, nodeId, "removeNode"), "Request: '" + req + "'");
                            }
                            query = null;
                            try {
                                try {
                                    query = new PreparedQuery(this.pool, req, false, this.log, -1);
                                    query.rs.next();
                                    size = query.rs.getInt(1);
                                    if (size < 1) {
                                        var7_8 = false;
                                        var10_10 = null;
                                        break block17;
                                    }
                                    if (!this.pool.isCascadeDeleteSuppported()) {
                                        req = "DELETE FROM " + this.queuesTableName + " where nodeId='" + nodeId + "'";
                                        this.update(req, query.conn);
                                    }
                                    req = "DELETE FROM " + postfix;
                                    this.update(req, query.conn);
                                    var8_16 = true;
                                    break block18;
                                }
                                catch (XmlBlasterException ex) {
                                    throw ex;
                                }
                                catch (Throwable ex) {
                                    if (query != null) {
                                        query.closeStatement();
                                    }
                                    if (this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(null, nodeId, "removeNode"), ex) == false) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.removeNode", "", ex);
                                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.removeNode", "", ex);
                                }
                            }
                            catch (Throwable var9_17) {
                                var10_12 = null;
                                try {
                                    if (query == null) throw var9_17;
                                    query.close();
                                    throw var9_17;
                                }
                                catch (Throwable ex1) {
                                    this.log.error("JdbcManagerCommonTable", "addNode: exception occured when closing statement and query, reason: " + ex1.toString());
                                    throw var9_17;
                                }
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [3 : 420->433)] { 
lbl53:
                        // 1 sources

                        if (query == null) return var7_8;
                        query.close();
                        break block19;
lbl56:
                        // 1 sources

                        catch (Throwable ex1) {
                            this.log.error("JdbcManagerCommonTable", "addNode: exception occured when closing statement and query, reason: " + ex1.toString());
                        }
                    }
                    return var7_8;
                }
                var10_11 = null;
                ** try [egrp 3[TRYBLOCK] [3 : 420->433)] { 
lbl63:
                // 1 sources

                if (query == null) return var8_16;
                query.close();
                break block20;
lbl66:
                // 1 sources

                catch (Throwable ex1) {
                    this.log.error("JdbcManagerCommonTable", "addNode: exception occured when closing statement and query, reason: " + ex1.toString());
                }
            }
            return var8_16;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean addQueue(String queueName, String nodeId, long numOfBytes, long numOfEntries) throws XmlBlasterException {
        block25: {
            block22: {
                block24: {
                    block21: {
                        if (this.log.CALL) {
                            this.log.call("JdbcManagerCommonTable", "addQueue");
                        }
                        this.addNode(nodeId);
                        req = "SELECT count(*) from " + this.queuesTableName + " where (queueName='" + queueName + "' AND nodeId='" + nodeId + "')";
                        if (this.log.TRACE) {
                            this.log.trace(this.getLogId(queueName, nodeId, "addQueue"), "Request: '" + req + "'");
                        }
                        query = null;
                        preStatement = null;
                        try {
                            try {
                                query = new PreparedQuery(this.pool, req, false, this.log, -1);
                                query.rs.next();
                                size = query.rs.getInt(1);
                                if (size > 0) {
                                    var11_10 = false;
                                    var14_12 = null;
                                    break block21;
                                }
                                req = "INSERT INTO " + this.queuesTableName + " VALUES (?,?,?,?)";
                                preStatement = query.conn.prepareStatement(req);
                                preStatement.setQueryTimeout(this.pool.getQueryTimeout());
                                preStatement.setString(1, queueName);
                                preStatement.setString(2, nodeId);
                                preStatement.setLong(3, numOfBytes);
                                preStatement.setLong(4, numOfEntries);
                                if (this.log.TRACE) {
                                    this.log.trace(this.getLogId(queueName, nodeId, "addQueue"), preStatement.toString());
                                }
                                preStatement.executeUpdate();
                                var12_18 = true;
                                break block22;
                            }
                            catch (XmlBlasterException ex) {
                                throw ex;
                            }
                            catch (Throwable ex) {
                                if (query != null) {
                                    query.closeStatement();
                                }
                                if (this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "addQueue"), ex) == false) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.addQueue", "", ex);
                                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.addQueue", "", ex);
                            }
                        }
                        catch (Throwable var13_19) {
                            var14_14 = null;
                            try {
                                if (preStatement != null) {
                                    preStatement.close();
                                }
                            }
                            catch (Throwable ex1) {
                                this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
                                ex1.printStackTrace();
                            }
                            try {
                                if (query == null) throw var13_19;
                                query.close();
                                throw var13_19;
                            }
                            catch (Throwable ex1) {
                                this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
                                ex1.printStackTrace();
                                throw var13_19;
                            }
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [3 : 430->445)] { 
lbl63:
                    // 1 sources

                    if (preStatement != null) {
                        preStatement.close();
                    }
                    break block24;
lbl66:
                    // 1 sources

                    catch (Throwable ex1) {
                        this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
                        ex1.printStackTrace();
                    }
                }
                ** try [egrp 3[TRYBLOCK] [4 : 484->497)] { 
lbl71:
                // 1 sources

                if (query == null) return var11_10;
                query.close();
                return var11_10;
lbl74:
                // 1 sources

                catch (Throwable ex1) {
                    this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
                    ex1.printStackTrace();
                }
                return var11_10;
            }
            var14_13 = null;
            ** try [egrp 2[TRYBLOCK] [3 : 430->445)] { 
lbl81:
            // 1 sources

            if (preStatement != null) {
                preStatement.close();
            }
            break block25;
lbl84:
            // 1 sources

            catch (Throwable ex1) {
                this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
            }
        }
        ** try [egrp 3[TRYBLOCK] [4 : 484->497)] { 
lbl89:
        // 1 sources

        if (query == null) return var12_18;
        query.close();
        return var12_18;
lbl92:
        // 1 sources

        catch (Throwable ex1) {
            this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
            ex1.printStackTrace();
        }
        return var12_18;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean removeQueue(String queueName, String nodeId) throws XmlBlasterException {
        block14: {
            block13: {
                if (this.log.CALL) {
                    this.log.call("JdbcManagerCommonTable", "removeQueue");
                }
                postfix = this.queuesTableName + " where (queueName='" + queueName + "' AND nodeId='" + nodeId + "')";
                req = "SELECT count(*) from " + postfix;
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "removeQueue"), "Request: '" + req + "'");
                }
                query = null;
                try {
                    try {
                        query = new PreparedQuery(this.pool, req, false, this.log, -1);
                        query.rs.next();
                        size = query.rs.getInt(1);
                        if (size < 1) {
                            var7_8 = false;
                            var10_10 = null;
                            break block13;
                        }
                        req = "DELETE FROM " + postfix;
                        this.update(req, query.conn);
                        var8_16 = true;
                        break block14;
                    }
                    catch (XmlBlasterException ex) {
                        throw ex;
                    }
                    catch (Throwable ex) {
                        if (query != null) {
                            query.closeStatement();
                        }
                        if (this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "removeQueue"), ex) == false) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.removeQueue", "", ex);
                        throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.removeQueue", "", ex);
                    }
                }
                catch (Throwable var9_17) {
                    var10_12 = null;
                    try {
                        if (query == null) throw var9_17;
                        query.close();
                        throw var9_17;
                    }
                    catch (Throwable ex1) {
                        this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
                        ex1.printStackTrace();
                        throw var9_17;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 338->351)] { 
lbl45:
            // 1 sources

            if (query == null) return var7_8;
            query.close();
            return var7_8;
lbl48:
            // 1 sources

            catch (Throwable ex1) {
                this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
            }
            return var7_8;
        }
        var10_11 = null;
        ** try [egrp 2[TRYBLOCK] [3 : 338->351)] { 
lbl55:
        // 1 sources

        if (query == null) return var8_16;
        query.close();
        return var8_16;
lbl58:
        // 1 sources

        catch (Throwable ex1) {
            this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
            ex1.printStackTrace();
        }
        return var8_16;
    }

    /*
     * Loose catch block
     */
    public final boolean modifyEntry(String queueName, String nodeId, I_Entry entry) throws XmlBlasterException {
        boolean ret;
        block33: {
            if (this.log.CALL) {
                this.log.call(this.getLogId(queueName, nodeId, "modifyEntry"), "Entering");
            }
            if (!this.isConnected) {
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "modifyEntry"), "For entry '" + entry.getUniqueId() + "' currently not possible. No connection to the DB");
                }
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.modifyEntry", " the connection to the DB is unavailable already before trying to add an entry");
            }
            Connection conn = null;
            Statement preStatement = null;
            Statement exStatement = null;
            ret = false;
            long dataId = entry.getUniqueId();
            int prio = entry.getPriority();
            byte[] blob = this.factory.toBlob(entry);
            String typeName = entry.getEmbeddedType();
            boolean persistent = entry.isPersistent();
            long sizeInBytes = entry.getSizeInBytes();
            if (this.log.DUMP) {
                this.log.dump(ME, "modification dataId: " + dataId + ", prio: " + prio + ", typeName: " + typeName + ", byteSize in bytes: " + sizeInBytes);
            }
            conn = this.pool.getConnection();
            String req = "UPDATE " + this.entriesTableName + " SET prio = ? , flag = ? , durable = ? , " + this.byteSizeColName + " = ? , " + this.blobVarName + " = ? WHERE  " + this.dataIdColName + " = ? AND nodeId = ? AND queueName = ?";
            if (this.log.TRACE) {
                this.log.trace(this.getLogId(queueName, nodeId, "modifyEntry"), req);
            }
            preStatement = conn.prepareStatement(req);
            preStatement.setQueryTimeout(this.pool.getQueryTimeout());
            preStatement.setInt(1, prio);
            preStatement.setString(2, typeName);
            if (persistent) {
                preStatement.setString(3, "T");
            } else {
                preStatement.setString(3, "F");
            }
            preStatement.setLong(4, sizeInBytes);
            ByteArrayInputStream blob_stream = new ByteArrayInputStream(blob);
            preStatement.setBinaryStream(5, blob_stream, blob.length);
            preStatement.setLong(6, dataId);
            preStatement.setString(7, nodeId);
            preStatement.setString(8, queueName);
            if (this.log.TRACE) {
                this.log.trace(this.getLogId(queueName, nodeId, "modifyEntry"), preStatement.toString());
            }
            int num = preStatement.executeUpdate();
            if (this.log.TRACE) {
                this.log.trace(this.getLogId(queueName, nodeId, "modifyEntry"), "Modified " + num + " entries, entryId='" + entry.getUniqueId() + "'");
            }
            ret = true;
            Object var20_19 = null;
            try {
                if (exStatement != null) {
                    exStatement.close();
                }
            }
            catch (Throwable ex) {
                this.log.warn(ME, "modifyEntry: throwable when closing the connection: " + ex.toString());
            }
            try {
                if (preStatement != null) {
                    preStatement.close();
                }
            }
            catch (Throwable ex) {
                this.log.warn(ME, "modifyEntry: throwable when closing the connection: " + ex.toString());
            }
            if (conn != null) {
                this.pool.releaseConnection(conn);
            }
            break block33;
            {
                catch (Throwable ex) {
                    if (this.log.TRACE) {
                        if (ex instanceof SQLException) {
                            this.log.trace(ME, "modifyEntry: sql exception, the sql state: '" + ((SQLException)ex).getSQLState());
                            this.log.trace(ME, "modifyEntry: sql exception, the error code: '" + ((SQLException)ex).getErrorCode());
                        } else {
                            this.log.trace(ME, "modifyEntry: exception, the error reason: '" + ex.toString());
                        }
                    }
                    try {
                        preStatement.close();
                        preStatement = null;
                    }
                    catch (Throwable ex1) {
                        this.log.error(ME, "modifyEntry: Exception when closing the statement: " + ex1.toString());
                    }
                    this.log.warn(this.getLogId(queueName, nodeId, "modifyEntry"), "Could not update entry '" + entry.getClass().getName() + "'-'" + entry.getLogId() + "-" + entry.getUniqueId() + "': " + ex.toString());
                    if (this.checkIfDBLoss(conn, this.getLogId(queueName, nodeId, "modifyEntry"), ex)) {
                        throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.modifyEntry", "", ex);
                    }
                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.modifyEntry", "", ex);
                }
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                try {
                    if (exStatement != null) {
                        exStatement.close();
                    }
                }
                catch (Throwable ex) {
                    this.log.warn(ME, "modifyEntry: throwable when closing the connection: " + ex.toString());
                }
                try {
                    if (preStatement != null) {
                        preStatement.close();
                    }
                }
                catch (Throwable ex) {
                    this.log.warn(ME, "modifyEntry: throwable when closing the connection: " + ex.toString());
                }
                if (conn != null) {
                    this.pool.releaseConnection(conn);
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * Loose catch block
     */
    private final boolean addSingleEntry(String queueName, String nodeId, I_Entry entry, Connection conn) throws XmlBlasterException {
        boolean ret;
        block39: {
            if (this.log.CALL) {
                this.log.call(this.getLogId(queueName, nodeId, "addSingleEntry"), "Entering");
            }
            if (!this.isConnected) {
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "addSingleEntry"), "For entry '" + entry.getUniqueId() + "' currently not possible. No connection to the DB");
                }
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.addSingleEntry", " the connection to the DB is unavailable already before trying to add an entry");
            }
            Statement preStatement = null;
            Statement exStatement = null;
            ret = false;
            long dataId = entry.getUniqueId();
            int prio = entry.getPriority();
            byte[] blob = this.factory.toBlob(entry);
            String typeName = entry.getEmbeddedType();
            boolean persistent = entry.isPersistent();
            long sizeInBytes = entry.getSizeInBytes();
            if (this.log.DUMP) {
                this.log.dump(ME, "addition. dataId: " + dataId + ", prio: " + prio + ", typeName: " + typeName + ", byteSize in bytes: " + sizeInBytes);
            }
            String req = "INSERT INTO " + this.entriesTableName + " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?)";
            if (this.log.TRACE) {
                this.log.trace(this.getLogId(queueName, nodeId, "addEntry"), req);
            }
            preStatement = conn.prepareStatement(req);
            preStatement.setQueryTimeout(this.pool.getQueryTimeout());
            preStatement.setLong(1, dataId);
            preStatement.setString(2, nodeId);
            preStatement.setString(3, queueName);
            preStatement.setInt(4, prio);
            preStatement.setString(5, typeName);
            if (persistent) {
                preStatement.setString(6, "T");
            } else {
                preStatement.setString(6, "F");
            }
            preStatement.setLong(7, sizeInBytes);
            ByteArrayInputStream blob_stream = new ByteArrayInputStream(blob);
            preStatement.setBinaryStream(8, blob_stream, blob.length);
            if (this.log.TRACE) {
                this.log.trace(this.getLogId(queueName, nodeId, "addEntry"), preStatement.toString());
            }
            int num = preStatement.executeUpdate();
            if (this.log.TRACE) {
                this.log.trace(this.getLogId(queueName, nodeId, "addEntry"), "Added " + num + " entries, entryId='" + entry.getUniqueId() + "'");
            }
            ret = true;
            Object var21_22 = null;
            try {
                if (exStatement != null) {
                    exStatement.close();
                }
            }
            catch (Throwable ex2) {
                this.log.warn(ME, "addEntry: throwable when closing the connection: " + ex2.toString());
            }
            try {
                if (preStatement != null) {
                    preStatement.close();
                }
                break block39;
            }
            catch (Throwable ex2) {
                this.log.warn(ME, "addEntry: throwable when closing the connection: " + ex2.toString());
            }
            break block39;
            {
                catch (Throwable ex) {
                    if (this.log.TRACE && ex instanceof SQLException) {
                        this.log.trace(ME, "addEntry: sql exception, the sql state: '" + ((SQLException)ex).getSQLState());
                        this.log.trace(ME, "addEntry: sql exception, the error code: '" + ((SQLException)ex).getErrorCode());
                    }
                    try {
                        if (preStatement != null) {
                            preStatement.close();
                            preStatement = null;
                        }
                    }
                    catch (Throwable ex1) {
                        this.log.error(ME, "exception when closing statement: " + ex1.toString());
                        ex1.printStackTrace();
                    }
                    this.log.warn(this.getLogId(queueName, nodeId, "addEntry"), "Could not insert entry '" + entry.getClass().getName() + "'-'" + entry.getLogId() + "-" + entry.getUniqueId() + "': " + ex.toString());
                    if (this.checkIfDBLoss(conn, this.getLogId(queueName, nodeId, "addEntry"), ex)) {
                        throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.addEntry", "", ex);
                    }
                    try {
                        String req2 = "SELECT count(*) from " + this.entriesTableName + " where (" + this.dataIdColName + "='" + dataId + "' AND nodeId='" + nodeId + "')";
                        if (this.log.TRACE) {
                            this.log.trace(ME, "addEntry: checking if entry already in db: request='" + req2 + "'");
                        }
                        exStatement = conn.createStatement();
                        ResultSet rs = exStatement.executeQuery(req2);
                        rs.next();
                        int size = rs.getInt(1);
                        if (size < 1) {
                            throw ex;
                        }
                    }
                    catch (Throwable ex1) {
                        if (this.log.TRACE) {
                            this.log.trace(ME, "addEntry: checking if entry already in db: exception in select: '" + ex.toString() + "'");
                        }
                        if (this.checkIfDBLoss(conn, this.getLogId(queueName, nodeId, "addEntry"), ex1)) {
                            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.addEntry", "", ex1);
                        }
                        throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.addEntry", "", ex1);
                    }
                    ret = false;
                    Object var21_23 = null;
                    try {
                        if (exStatement != null) {
                            exStatement.close();
                        }
                    }
                    catch (Throwable ex2) {
                        this.log.warn(ME, "addEntry: throwable when closing the connection: " + ex2.toString());
                    }
                    try {
                        if (preStatement != null) {
                            preStatement.close();
                        }
                        break block39;
                    }
                    catch (Throwable ex2) {
                        this.log.warn(ME, "addEntry: throwable when closing the connection: " + ex2.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var21_24 = null;
                try {
                    if (exStatement != null) {
                        exStatement.close();
                    }
                }
                catch (Throwable ex2) {
                    this.log.warn(ME, "addEntry: throwable when closing the connection: " + ex2.toString());
                }
                try {
                    if (preStatement != null) {
                        preStatement.close();
                    }
                }
                catch (Throwable ex2) {
                    this.log.warn(ME, "addEntry: throwable when closing the connection: " + ex2.toString());
                }
                throw throwable;
            }
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean addEntry(String queueName, String nodeId, I_Entry entry) throws XmlBlasterException {
        boolean bl;
        Connection conn = null;
        try {
            conn = this.pool.getConnection();
            bl = this.addSingleEntry(queueName, nodeId, entry, conn);
            Object var7_6 = null;
            if (conn == null) return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (conn == null) throw throwable;
            this.pool.releaseConnection(conn);
            throw throwable;
        }
        this.pool.releaseConnection(conn);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] addEntriesSingleMode(Connection conn, String queueName, String nodeId, I_Entry[] entries) throws XmlBlasterException {
        int i = 0;
        int[] ret = new int[entries.length];
        try {
            if (this.log.TRACE) {
                this.log.trace(ME, "addEntriesSingleMode adding each entry in single mode since an exception occured when using 'batch mode'");
            }
            i = 0;
            while (true) {
                if (i >= entries.length) {
                    if (conn.getAutoCommit()) return ret;
                    conn.commit();
                    return ret;
                }
                ret[i] = this.addSingleEntry(queueName, nodeId, entries[i], conn) ? 1 : 0;
                if (this.log.TRACE) {
                    this.log.trace(ME, "addEntriesSingleMode adding entry '" + i + "' in single mode succeeded");
                }
                ++i;
            }
        }
        catch (XmlBlasterException ex1) {}
        finally {
            try {
                int ii = 0;
                while (true) {
                    if (ii >= i) {
                        throw ex1;
                    }
                    if (ret[ii] > 0) {
                        this.deleteEntry(queueName, nodeId, entries[ii].getUniqueId());
                    }
                    ++ii;
                }
            }
            catch (Throwable ex2) {
                this.log.error(ME, "addEntriesSingleMode exception occured when rolling back (this could generate inconsistencies in the data) : " + ex2.toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] addEntries(String queueName, String nodeId, I_Entry[] entries) throws XmlBlasterException {
        block46: {
            block45: {
                block38: {
                    block44: {
                        block43: {
                            block37: {
                                if (this.log.CALL) {
                                    this.log.call(this.getLogId(queueName, nodeId, "addEntries"), "Entering");
                                }
                                if (!this.isConnected) {
                                    if (this.log.TRACE == false) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.addEntries", " the connection to the DB is unavailable already before trying to add entries");
                                    this.log.trace(this.getLogId(queueName, nodeId, "addEnties"), " for '" + entries.length + "' currently not possible. No connection to the DB");
                                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.addEntries", " the connection to the DB is unavailable already before trying to add entries");
                                }
                                preStatement = null;
                                conn = null;
                                try {
                                    try {
                                        conn = this.pool.getConnection();
                                        if (!this.supportsBatch || !this.enableBatchMode) {
                                            var6_6 = this.addEntriesSingleMode(conn, queueName, nodeId, entries);
                                            var20_8 = null;
                                            break block37;
                                        }
                                        if (conn.getAutoCommit()) {
                                            conn.setAutoCommit(false);
                                        }
                                        req = "INSERT INTO " + this.entriesTableName + " VALUES ( ?, ?, ?, ?, ?, ?, ?, ?)";
                                        if (this.log.TRACE) {
                                            this.log.trace(this.getLogId(queueName, nodeId, "addEntries"), req);
                                        }
                                        preStatement = conn.prepareStatement(req);
                                        preStatement.setQueryTimeout(this.pool.getQueryTimeout());
                                        i = 0;
                                        while (true) {
                                            if (i >= entries.length) {
                                                ret = preStatement.executeBatch();
                                                if (!conn.getAutoCommit()) {
                                                    conn.commit();
                                                }
                                                var10_22 = ret;
                                                break block38;
                                            }
                                            entry = entries[i];
                                            dataId = entry.getUniqueId();
                                            prio = entry.getPriority();
                                            blob = this.factory.toBlob(entry);
                                            typeName = entry.getEmbeddedType();
                                            persistent = entry.isPersistent();
                                            sizeInBytes = entry.getSizeInBytes();
                                            preStatement.setLong(1, dataId);
                                            preStatement.setString(2, nodeId);
                                            preStatement.setString(3, queueName);
                                            preStatement.setInt(4, prio);
                                            preStatement.setString(5, typeName);
                                            if (persistent) {
                                                preStatement.setString(6, "T");
                                            } else {
                                                preStatement.setString(6, "F");
                                            }
                                            preStatement.setLong(7, sizeInBytes);
                                            blob_stream = new ByteArrayInputStream(blob);
                                            preStatement.setBinaryStream(8, blob_stream, blob.length);
                                            if (this.log.TRACE) {
                                                this.log.trace(this.getLogId(queueName, nodeId, "addEntries"), preStatement.toString());
                                            }
                                            preStatement.addBatch();
                                            ++i;
                                        }
                                    }
                                    catch (Throwable ex) {
                                        try {
                                            if (!conn.getAutoCommit()) {
                                                conn.rollback();
                                                conn.setAutoCommit(true);
                                            }
                                        }
                                        catch (Throwable ex1) {
                                            this.log.error("JdbcManagerCommonTable", "error occured when trying to rollback after exception: reason: " + ex1.toString() + " original reason:" + ex.toString());
                                            ex.printStackTrace();
                                        }
                                        this.log.warn(this.getLogId(queueName, nodeId, "addEntries"), "Could not insert entries: " + ex.toString());
                                        if (this.supportsBatch == false) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.addEntries", "", ex);
                                        if (this.enableBatchMode == false) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.addEntries", "", ex);
                                        if (this.checkIfDBLoss(conn, this.getLogId(queueName, nodeId, "addEntries"), ex)) {
                                            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.addEntries", "", ex);
                                        }
                                        var7_18 = this.addEntriesSingleMode(conn, queueName, nodeId, entries);
                                        var20_10 = null;
                                        try {
                                            if (preStatement != null) {
                                                preStatement.close();
                                            }
                                        }
                                        catch (Throwable ex) {
                                            this.log.warn("JdbcManagerCommonTable", "addEntries: throwable when closing the statement: " + ex.toString());
                                        }
                                        try {
                                            if (conn != null && !conn.getAutoCommit()) {
                                                conn.setAutoCommit(true);
                                            }
                                        }
                                        catch (Throwable ex) {
                                            this.log.warn("JdbcManagerCommonTable", "addEntries: throwable when closing the connection: " + ex.toString());
                                        }
                                        if (conn == null) return var7_18;
                                        this.pool.releaseConnection(conn);
                                        return var7_18;
                                    }
                                }
                                catch (Throwable var19_29) {
                                    block42: {
                                        block41: {
                                            var20_11 = null;
                                            ** try [egrp 3[TRYBLOCK] [3 : 733->748)] { 
lbl95:
                                            // 1 sources

                                            if (preStatement != null) {
                                                preStatement.close();
                                            }
                                            break block41;
lbl98:
                                            // 1 sources

                                            catch (Throwable ex) {
                                                this.log.warn("JdbcManagerCommonTable", "addEntries: throwable when closing the statement: " + ex.toString());
                                            }
                                        }
                                        ** try [egrp 4[TRYBLOCK] [4 : 783->809)] { 
lbl102:
                                        // 1 sources

                                        if (conn != null && !conn.getAutoCommit()) {
                                            conn.setAutoCommit(true);
                                        }
                                        break block42;
lbl105:
                                        // 1 sources

                                        catch (Throwable ex) {
                                            this.log.warn("JdbcManagerCommonTable", "addEntries: throwable when closing the connection: " + ex.toString());
                                        }
                                    }
                                    if (conn == null) throw var19_29;
                                    this.pool.releaseConnection(conn);
                                    throw var19_29;
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [3 : 733->748)] { 
lbl113:
                            // 1 sources

                            if (preStatement != null) {
                                preStatement.close();
                            }
                            break block43;
lbl116:
                            // 1 sources

                            catch (Throwable ex) {
                                this.log.warn("JdbcManagerCommonTable", "addEntries: throwable when closing the statement: " + ex.toString());
                            }
                        }
                        ** try [egrp 4[TRYBLOCK] [4 : 783->809)] { 
lbl120:
                        // 1 sources

                        if (conn != null && !conn.getAutoCommit()) {
                            conn.setAutoCommit(true);
                        }
                        break block44;
lbl123:
                        // 1 sources

                        catch (Throwable ex) {
                            this.log.warn("JdbcManagerCommonTable", "addEntries: throwable when closing the connection: " + ex.toString());
                        }
                    }
                    if (conn == null) return var6_6;
                    this.pool.releaseConnection(conn);
                    return var6_6;
                }
                var20_9 = null;
                ** try [egrp 3[TRYBLOCK] [3 : 733->748)] { 
lbl132:
                // 1 sources

                if (preStatement != null) {
                    preStatement.close();
                }
                break block45;
lbl135:
                // 1 sources

                catch (Throwable ex) {
                    this.log.warn("JdbcManagerCommonTable", "addEntries: throwable when closing the statement: " + ex.toString());
                }
            }
            ** try [egrp 4[TRYBLOCK] [4 : 783->809)] { 
lbl139:
            // 1 sources

            if (conn != null && !conn.getAutoCommit()) {
                conn.setAutoCommit(true);
            }
            break block46;
lbl142:
            // 1 sources

            catch (Throwable ex) {
                this.log.warn("JdbcManagerCommonTable", "addEntries: throwable when closing the connection: " + ex.toString());
            }
        }
        if (conn == null) return var10_22;
        this.pool.releaseConnection(conn);
        return var10_22;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int cleanUp(String queueName, String nodeId) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.getLogId(queueName, nodeId, "cleanUp"), "Entering");
        }
        if (!this.isConnected) {
            if (!this.log.TRACE) return 0;
            this.log.trace(this.getLogId(queueName, nodeId, "cleanUp"), "Currently not possible. No connection to the DB");
            return 0;
        }
        try {
            String req = "delete from " + this.queuesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "'";
            if (!this.log.TRACE) return this.update(req);
            this.log.trace(this.getLogId(queueName, nodeId, "cleanUp"), " request is '" + req + "'");
            return this.update(req);
        }
        catch (XmlBlasterException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Connection conn = null;
            try {
                conn = this.pool.getConnection();
                if (this.checkIfDBLoss(conn, this.getLogId(queueName, nodeId, "deleteEntries"), ex)) {
                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.deleteEntries", "", ex);
                }
                Object var7_7 = null;
                if (conn == null) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.deleteEntries", "", ex);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (conn == null) throw throwable;
                this.pool.releaseConnection(conn);
                throw throwable;
            }
            this.pool.releaseConnection(conn);
            {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.deleteEntries", "", ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public int wipeOutDB(boolean doSetupNewTables) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "wipeOutDB");
        }
        this.nodesCache = new HashSet();
        PreparedQuery query = null;
        int count = 0;
        Connection conn = null;
        try {
            block32: {
                try {
                    String req;
                    try {
                        req = "DROP TABLE " + this.entriesTableName;
                        if (this.log.CALL) {
                            this.log.call(ME, "wipeOutDB " + req + " will be invoked on the DB");
                        }
                        if ((conn = this.pool.getConnection()).getAutoCommit()) {
                            conn.setAutoCommit(false);
                        }
                        this.update(req, conn);
                        ++count;
                    }
                    catch (SQLException ex) {
                        if (this.checkIfDBLoss(conn, this.getLogId(null, null, "wipeOutDB"), ex)) {
                            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, this.getLogId(null, null, "wipeOutDB"), "SQLException when wiping out DB", ex);
                        }
                        this.log.warn(ME, "Exception occurred when trying to drop the table '" + this.entriesTableName + "', it probably is already dropped. Reason: " + ex.toString());
                    }
                    try {
                        req = "DROP TABLE " + this.queuesTableName;
                        if (this.log.CALL) {
                            this.log.call(ME, "wipeOutDB " + req + " will be invoked on the DB");
                        }
                        this.update(req, conn);
                        ++count;
                    }
                    catch (Throwable ex) {
                        if (query != null) {
                            query.closeStatement();
                        }
                        if (this.checkIfDBLoss(conn, this.getLogId(null, null, "wipeOutDB"), (SQLException)ex)) {
                            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, this.getLogId(null, null, "wipeOutDB"), "SQLException when wiping out DB", ex);
                        }
                        this.log.warn(ME, "Exception occurred when trying to drop the table '" + this.queuesTableName + "', it probably is already dropped. Reason " + ex.toString());
                    }
                    try {
                        req = "DROP TABLE " + this.nodesTableName;
                        if (this.log.CALL) {
                            this.log.call(ME, "wipeOutDB " + req + " will be invoked on the DB");
                        }
                        this.update(req, conn);
                        ++count;
                    }
                    catch (Throwable ex) {
                        if (this.checkIfDBLoss(conn, this.getLogId(null, null, "wipeOutDB"), (SQLException)ex)) {
                            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, this.getLogId(null, null, "wipeOutDB"), "SQLException when wiping out DB", ex);
                        }
                        this.log.warn(ME, "Exception occurred when trying to drop the table '" + this.nodesTableName + "', it probably is already dropped. Reason " + ex.toString());
                    }
                    if (conn.getAutoCommit()) break block32;
                    conn.commit();
                }
                catch (Throwable ex) {
                    try {
                        if (conn != null) {
                            conn.rollback();
                        }
                    }
                    catch (Throwable ex1) {
                        this.log.error(ME, "wipeOutDB: exception occurred when rolling back: " + ex1.toString());
                    }
                    if (!(ex instanceof XmlBlasterException)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, this.getLogId(null, null, "wipeOutDB"), "wipeOutDB: exception ", ex);
                    throw (XmlBlasterException)ex;
                }
            }
            Object var8_11 = null;
            try {
                block33: {
                    try {
                        if (conn == null || conn.getAutoCommit()) break block33;
                        conn.setAutoCommit(true);
                    }
                    catch (Throwable ex) {
                        throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, this.getLogId(null, null, "wipeOutDB"), "wipeOutDB: exception when closing the query", ex);
                    }
                }
                Object var11_13 = null;
                if (conn != null) {
                    this.pool.releaseConnection(conn);
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (conn == null) throw throwable;
                this.pool.releaseConnection(conn);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {}
            catch (Throwable throwable2) {
                Object var11_16 = null;
                if (conn == null) throw throwable2;
                this.pool.releaseConnection(conn);
                throw throwable2;
            }
            try {}
            catch (Throwable ex) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, this.getLogId(null, null, "wipeOutDB"), "wipeOutDB: exception when closing the query", ex);
            }
            if (conn != null && !conn.getAutoCommit()) {
                conn.setAutoCommit(true);
            }
            Object var11_15 = null;
            if (conn == null) throw throwable;
            this.pool.releaseConnection(conn);
            throw throwable;
        }
        try {
            if (!doSetupNewTables) return count;
            this.setUp();
            return count;
        }
        catch (Throwable ex) {
            this.log.error(ME, "SQLException occured when cleaning up the table. Reason " + ex.toString());
        }
        return count;
    }

    public void dumpMetaData() {
        this.pool.dumpMetaData();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getNumOfBytes(String queueName, String nodeId) throws XmlBlasterException {
        block16: {
            if (!this.isConnected) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, this.getLogId(queueName, nodeId, "getNumOfBytes"), "The DB is disconnected. Handling queue '" + queueName + "' is currently not possible");
            }
            conn = null;
            st = null;
            try {
                try {
                    req = "SELECT sum(" + this.byteSizeColName + ") from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "'";
                    conn = this.pool.getConnection();
                    st = conn.prepareStatement(req);
                    st.setQueryTimeout(this.pool.getQueryTimeout());
                    rs = st.executeQuery();
                    rs.next();
                    var7_9 = rs.getLong(1);
                    var10_11 = null;
                }
                catch (XmlBlasterException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    try {
                        if (st != null) {
                            st.close();
                        }
                        st = null;
                    }
                    catch (Throwable ex1) {
                        this.log.warn("JdbcManagerCommonTable", ".getNumOfBytes: exception when closing statement: " + ex1.toString());
                    }
                    if (this.checkIfDBLoss(conn, this.getLogId(queueName, nodeId, "getNumOfBytes"), ex) == false) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.getNumOfBytes", "", ex);
                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.getNumOfBytes", "", ex);
                }
            }
            catch (Throwable var9_15) {
                var10_12 = null;
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Throwable ex) {
                    this.log.warn("JdbcManagerCommonTable", ".getNumOfBytes: exception when closing statement: " + ex.toString());
                }
                if (conn == null) throw var9_15;
                this.pool.releaseConnection(conn);
                throw var9_15;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 322->337)] { 
lbl45:
            // 1 sources

            if (st != null) {
                st.close();
            }
            break block16;
lbl48:
            // 1 sources

            catch (Throwable ex) {
                this.log.warn("JdbcManagerCommonTable", ".getNumOfBytes: exception when closing statement: " + ex.toString());
            }
        }
        if (conn == null) return var7_9;
        this.pool.releaseConnection(conn);
        return var7_9;
    }

    public final void setUp() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "setUp");
        }
        if (this.log.TRACE) {
            this.log.trace(this.getLogId(null, null, "setUp"), "Initializing the first time the pool");
        }
        this.tablesCheckAndSetup(this.pool.isDbAdmin());
        this.dbInitialized = true;
    }

    private final ArrayList processResultSet(ResultSet rs, StorageId storageId, int numOfEntries, long numOfBytes, boolean onlyId) throws SQLException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.getLogId(storageId.getStrippedId(), null, "processResultSet"), "Entering");
        }
        ArrayList<Serializable> entries = new ArrayList<Serializable>();
        int count = 0;
        long amount = 0L;
        long currentAmount = 0L;
        while (!(!rs.next() || count >= numOfEntries && numOfEntries >= 0 || amount >= numOfBytes && numOfBytes >= 0L)) {
            if (onlyId) {
                entries.add(new Long(rs.getLong(1)));
            } else {
                long dataId = rs.getLong(1);
                rs.getString(2);
                rs.getString(3);
                int prio = rs.getInt(4);
                String typeName = rs.getString(5);
                String persistentAsChar = rs.getString(6);
                boolean persistent = false;
                if ("T".equalsIgnoreCase(persistentAsChar)) {
                    persistent = true;
                }
                long sizeInBytes = rs.getLong(7);
                InputStream is = rs.getBinaryStream(8);
                if (numOfBytes < 0L || sizeInBytes + amount < numOfBytes || count == 0) {
                    if (this.log.DUMP) {
                        this.log.dump(ME, "processResultSet: dataId: " + dataId + ", prio: " + prio + ", typeName: " + typeName + " persistent: " + persistent);
                    }
                    entries.add(this.factory.createEntry(prio, dataId, typeName, persistent, sizeInBytes, is, storageId));
                    amount += sizeInBytes;
                }
            }
            ++count;
        }
        return entries;
    }

    private final ReturnDataHolder processResultSetForDeleting(ResultSet rs, int numOfEntries, long numOfBytes) throws SQLException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(ME, "processResultSetForDeleting invoked");
        }
        ReturnDataHolder ret = new ReturnDataHolder();
        long currentAmount = 0L;
        while (!(!rs.next() || ret.countEntries >= (long)numOfEntries && numOfEntries >= 0 || ret.countBytes >= numOfBytes && numOfBytes >= 0L)) {
            currentAmount = rs.getLong(2);
            if (numOfBytes >= 0L && ret.countBytes + currentAmount >= numOfBytes && ret.countEntries != 0L) continue;
            ret.list.add(new Long(rs.getLong(1)));
            ret.countBytes += currentAmount;
            ++ret.countEntries;
        }
        return ret;
    }

    public JdbcConnectionPool getPool() {
        return this.pool;
    }

    private final int update(String request) throws SQLException, XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.getLogId(null, null, "update"), "Entering request=" + request);
        }
        Connection conn = null;
        Statement statement = null;
        int ret = 0;
        try {
            conn = this.pool.getConnection();
            statement = conn.createStatement();
            statement.setQueryTimeout(this.pool.getQueryTimeout());
            ret = statement.executeUpdate(request);
            if (this.log.TRACE) {
                this.log.trace(this.getLogId(null, null, "update"), "Executed statement '" + request + "', number of changed entries=" + ret);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Throwable ex) {
                this.log.warn(ME, "update: throwable when closing statement: " + ex.toString());
            }
            if (conn != null) {
                this.pool.releaseConnection(conn);
            }
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Throwable ex) {
            this.log.warn(ME, "update: throwable when closing statement: " + ex.toString());
        }
        if (conn != null) {
            this.pool.releaseConnection(conn);
        }
        return ret;
    }

    private final int update(String request, Connection conn) throws SQLException {
        if (this.log.CALL) {
            this.log.call(this.getLogId(null, null, "update"), "Request=" + request + " and connection " + conn);
        }
        Statement statement = null;
        int ret = 0;
        try {
            statement = conn.createStatement();
            statement.setQueryTimeout(this.pool.getQueryTimeout());
            ret = statement.executeUpdate(request);
            if (this.log.TRACE) {
                this.log.trace(this.getLogId(null, null, "update"), "Executed statement '" + request + "', number of changed entries=" + ret);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Throwable ex) {
                this.log.warn(ME, "update: throwable when closing statement: " + ex.toString());
            }
            throw throwable;
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Throwable ex) {
            this.log.warn(ME, "update: throwable when closing statement: " + ex.toString());
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int deleteAllTransient(String queueName, String nodeId) throws XmlBlasterException {
        try {
            if (this.log.CALL) {
                this.log.call(this.getLogId(queueName, nodeId, "deleteAllTransient"), "deleteAllTransient");
            }
            if (!this.isConnected) {
                if (!this.log.TRACE) return 0;
                this.log.trace(this.getLogId(queueName, nodeId, "deleteAllTransient"), "Currently not possible. No connection to the DB");
                return 0;
            }
            String req = "delete from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND durable='F'";
            return this.update(req);
        }
        catch (XmlBlasterException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Connection conn = null;
            try {
                conn = this.pool.getConnection();
                if (this.checkIfDBLoss(conn, this.getLogId(queueName, nodeId, "deleteAllTransient"), ex)) {
                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.deleteAllTransient", "", ex);
                }
                Object var7_7 = null;
                if (conn == null) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.deleteAllTransient", "", ex);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (conn == null) throw throwable;
                this.pool.releaseConnection(conn);
                throw throwable;
            }
            this.pool.releaseConnection(conn);
            {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.deleteAllTransient", "", ex);
            }
        }
    }

    private final ArrayList whereInStatement(String reqPrefix, long[] uniqueIds) {
        if (this.log.CALL) {
            this.log.call(ME, "whereInStatement");
        }
        String reqPostfix = ")";
        boolean isFirst = true;
        int initialLength = reqPrefix.length() + ")".length() + 2;
        StringBuffer buf = new StringBuffer();
        int length = initialLength;
        int currentLength = 0;
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < uniqueIds.length) {
            String req = null;
            String entryId = Long.toString(uniqueIds[i]);
            currentLength = entryId.length();
            if ((length += currentLength) > this.maxStatementLength || i == uniqueIds.length - 1) {
                if (i == uniqueIds.length - 1) {
                    if (!isFirst) {
                        buf.append(",");
                    }
                    buf.append(entryId);
                }
                req = reqPrefix + buf.toString() + ")";
                ret.add(req);
                length = initialLength + currentLength;
                buf = new StringBuffer();
                isFirst = true;
            }
            if (!isFirst) {
                buf.append(",");
                ++length;
            } else {
                isFirst = false;
            }
            buf.append(entryId);
            ++i;
        }
        return ret;
    }

    private final boolean isInsideRange(int numEntries, int maxNumEntries, long numBytes, long maxNumBytes) {
        if (maxNumEntries < 0) {
            if (maxNumBytes < 0L) {
                return true;
            }
            return numBytes < maxNumBytes;
        }
        if (maxNumBytes < 0L) {
            return numEntries < maxNumEntries;
        }
        return numEntries < maxNumEntries || numBytes < maxNumBytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReturnDataHolder getAndDeleteLowest(StorageId storageId, String nodeId, int numOfEntries, long numOfBytes, int maxPriority, long minUniqueId, boolean leaveOne, boolean doDelete) throws XmlBlasterException {
        String queueName = storageId.getStrippedId();
        if (this.log.CALL) {
            this.log.call(this.getLogId(queueName, nodeId, "getAndDeleteLowest"), "Entering");
        }
        ReturnDataHolder ret = new ReturnDataHolder();
        if (!this.isConnected) {
            if (!this.log.TRACE) return ret;
            this.log.trace(this.getLogId(queueName, nodeId, "getAndDeleteLowest"), "Currently not possible. No connection to the DB");
            return ret;
        }
        PreparedQuery query = null;
        try {
            try {
                String req = "select * from " + this.entriesTableName + " WHERE queueName='" + queueName + "' AND nodeId='" + nodeId + "' ORDER BY prio ASC, " + this.dataIdColName + " DESC";
                query = new PreparedQuery(this.pool, req, false, this.log, -1);
                ResultSet rs = query.rs;
                int count = 0;
                long amount = 0L;
                boolean doContinue = true;
                boolean stillEntriesInQueue = false;
                while ((stillEntriesInQueue = rs.next()) && doContinue) {
                    long dataId = rs.getLong(1);
                    rs.getString(2);
                    rs.getString(3);
                    int prio = rs.getInt(4);
                    String typeName = rs.getString(5);
                    String persistentAsChar = rs.getString(6);
                    boolean persistent = false;
                    if ("T".equalsIgnoreCase(persistentAsChar)) {
                        persistent = true;
                    }
                    long sizeInBytes = rs.getLong(7);
                    if (!this.isInsideRange(count, numOfEntries, amount, numOfBytes)) break;
                    InputStream is = rs.getBinaryStream(8);
                    if (prio < maxPriority || prio == maxPriority && dataId > minUniqueId) {
                        if (this.log.DUMP) {
                            this.log.dump(this.getLogId(queueName, nodeId, "getAndDeleteLowest"), "dataId: " + dataId + ", prio: " + prio + ", typeName: " + typeName + " persistent: " + persistent);
                        }
                        ret.list.add(this.factory.createEntry(prio, dataId, typeName, persistent, sizeInBytes, is, storageId));
                        amount += sizeInBytes;
                    } else {
                        doContinue = false;
                    }
                    ++count;
                }
                ret.countBytes = amount;
                ret.countEntries = count;
                if (leaveOne) {
                    if (stillEntriesInQueue) {
                        stillEntriesInQueue = rs.next();
                    }
                    if (!stillEntriesInQueue && ret.list.size() > 0) {
                        --ret.countEntries;
                        I_Entry entryToDelete = (I_Entry)ret.list.remove(ret.list.size() - 1);
                        ret.countBytes -= entryToDelete.getSizeInBytes();
                        if (this.log.TRACE) {
                            this.log.trace(ME, "takeLowest size to delete: " + entryToDelete.getSizeInBytes());
                        }
                    }
                }
                if (doDelete) {
                    long[] uniqueIds = new long[ret.list.size()];
                    int i = 0;
                    while (i < uniqueIds.length) {
                        uniqueIds[i] = ((I_Entry)ret.list.get(i)).getUniqueId();
                        ++i;
                    }
                    String reqPrefix = "delete from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND " + this.dataIdColName + " in(";
                    ArrayList reqList = this.whereInStatement(reqPrefix, uniqueIds);
                    int i2 = 0;
                    while (i2 < reqList.size()) {
                        req = (String)reqList.get(i2);
                        if (this.log.TRACE) {
                            this.log.trace(this.getLogId(queueName, nodeId, "getAndDeleteLowest"), "'delete from " + req + "'");
                        }
                        this.update(req, query.conn);
                        ++i2;
                    }
                }
                if (!query.conn.getAutoCommit()) {
                    query.conn.commit();
                }
                ReturnDataHolder returnDataHolder = ret;
                Object var31_36 = null;
                try {
                    if (query == null) return returnDataHolder;
                    query.close();
                    return returnDataHolder;
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "exception when closing query: " + ex1.toString());
                    ex1.printStackTrace();
                }
                return returnDataHolder;
            }
            catch (XmlBlasterException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                try {
                    if (query != null && query.rs != null) {
                        query.rs.close();
                        query.rs = null;
                    }
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "exception occured when closing query: " + ex1.toString());
                }
                try {
                    if (query != null && query.conn != null) {
                        query.conn.rollback();
                    }
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "could not rollback: " + ex.toString());
                    ex1.printStackTrace();
                }
                Connection tmpConn = null;
                if (query != null) {
                    tmpConn = query.conn;
                    query.closeStatement();
                }
                if (!this.checkIfDBLoss(tmpConn, this.getLogId(queueName, nodeId, "getAndDeleteLowest"), ex)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.getAndDeleteLowest", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.getAndDeleteLowest", "", ex);
            }
        }
        catch (Throwable throwable) {
            Object var31_37 = null;
            try {}
            catch (Throwable ex1) {
                this.log.error(ME, "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
                throw throwable;
            }
            if (query == null) throw throwable;
            query.close();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean[] deleteEntries(String queueName, String nodeId, long[] uniqueIds) throws XmlBlasterException {
        block30: {
            block31: {
                block26: {
                    block29: {
                        if (this.log.CALL) {
                            this.log.call(this.getLogId(queueName, nodeId, "deleteEntries"), "Entering");
                        }
                        if (!this.isConnected) {
                            if (this.log.TRACE) {
                                this.log.trace(this.getLogId(queueName, nodeId, "deleteEntries"), "Currently not possible. No connection to the DB");
                            }
                            return new boolean[uniqueIds.length];
                        }
                        conn = null;
                        try {
                            try {
                                count = 0;
                                reqPrefix = "delete from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND " + this.dataIdColName + " in(";
                                reqList = this.whereInStatement(reqPrefix, uniqueIds);
                                conn = this.pool.getConnection();
                                if (conn.getAutoCommit()) {
                                    conn.setAutoCommit(false);
                                }
                                i = 0;
                                while (true) {
                                    if (i >= reqList.size()) {
                                        if (count == uniqueIds.length) break;
                                        conn.rollback();
                                        break block26;
                                    }
                                    req = (String)reqList.get(i);
                                    if (this.log.TRACE) {
                                        this.log.trace(this.getLogId(queueName, nodeId, "deleteEntries"), "' " + req + "'");
                                    }
                                    count += this.update(req, conn);
                                    ++i;
                                }
                                if (!conn.getAutoCommit()) {
                                    conn.commit();
                                }
                                ret = new boolean[uniqueIds.length];
                                i = 0;
                                while (true) {
                                    if (i >= ret.length) {
                                        var11_15 = ret;
                                        var13_16 = null;
                                        if (conn == null) return var11_15;
                                        break;
                                    }
                                    ret[i] = true;
                                    ++i;
                                }
                            }
                            catch (XmlBlasterException ex) {
                                throw ex;
                            }
                            catch (Throwable ex) {
                                if (this.checkIfDBLoss(conn, this.getLogId(queueName, nodeId, "deleteEntries"), ex)) {
                                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.deleteEntries", "", ex);
                                }
                                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.deleteEntries", "", ex);
                            }
                        }
                        catch (Throwable var12_22) {
                            var13_18 = null;
                            if (conn != null) {
                                try {
                                    if (!conn.getAutoCommit()) {
                                        conn.setAutoCommit(true);
                                    }
                                }
                                catch (Throwable ex) {
                                    this.log.error("JdbcManagerCommonTable", "error when setting autocommit to 'true'. reason: " + ex.toString());
                                    ex.printStackTrace();
                                }
                                this.pool.releaseConnection(conn);
                            }
                            throw var12_22;
                        }
                        ** try [egrp 2[TRYBLOCK] [3 : 435->456)] { 
lbl64:
                        // 1 sources

                        if (!conn.getAutoCommit()) {
                            conn.setAutoCommit(true);
                        }
                        break block29;
lbl67:
                        // 1 sources

                        catch (Throwable ex) {
                            this.log.error("JdbcManagerCommonTable", "error when setting autocommit to 'true'. reason: " + ex.toString());
                            ex.printStackTrace();
                        }
                    }
                    this.pool.releaseConnection(conn);
                    return var11_15;
                }
                var13_17 = null;
                if (conn == null) break block30;
                ** try [egrp 2[TRYBLOCK] [3 : 435->456)] { 
lbl77:
                // 1 sources

                if (!conn.getAutoCommit()) {
                    conn.setAutoCommit(true);
                }
                break block31;
lbl80:
                // 1 sources

                catch (Throwable ex) {
                    this.log.error("JdbcManagerCommonTable", "error when setting autocommit to 'true'. reason: " + ex.toString());
                    ex.printStackTrace();
                }
            }
            this.pool.releaseConnection(conn);
        }
        ret = new boolean[uniqueIds.length];
        i = 0;
        while (true) {
            if (i >= uniqueIds.length) {
                return ret;
            }
            ret[i] = this.deleteEntry(queueName, nodeId, uniqueIds[i]) == 1;
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteEntry(String queueName, String nodeId, long uniqueId) throws XmlBlasterException {
        int n;
        if (this.log.CALL) {
            this.log.call(this.getLogId(queueName, nodeId, "deleteEntry"), "Entering");
        }
        if (!this.isConnected) {
            if (!this.log.TRACE) return 0;
            this.log.trace(this.getLogId(queueName, nodeId, "deleteEntry"), "Currently not possible. No connection to the DB");
            return 0;
        }
        Connection conn = null;
        try {
            try {
                String req = "delete from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND " + this.dataIdColName + "='" + uniqueId + "'";
                conn = this.pool.getConnection();
                n = this.update(req, conn);
                Object var9_9 = null;
                if (conn == null) return n;
            }
            catch (XmlBlasterException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (!this.checkIfDBLoss(conn, this.getLogId(queueName, nodeId, "deleteEntry"), ex)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.deleteEntry", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.deleteEntry", "", ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (conn == null) throw throwable;
            this.pool.releaseConnection(conn);
            throw throwable;
        }
        this.pool.releaseConnection(conn);
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReturnDataHolder deleteFirstEntries(String queueName, String nodeId, long numOfEntries, long amount) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.getLogId(queueName, nodeId, "deleteFirstEntries called"), "Entering");
        }
        ret = new ReturnDataHolder();
        if (!this.isConnected) {
            if (this.log.TRACE == false) return ret;
            this.log.trace(this.getLogId(queueName, nodeId, "deleteFirstEntries"), "Currently not possible. No connection to the DB");
            return ret;
        }
        if (numOfEntries >= 0x7FFFFFFFL) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.getLogId(queueName, nodeId, "deleteFirstEntries"), "The number of entries=" + numOfEntries + " to be deleted is too big for this system");
        }
        query = null;
        try {
            try {
                req = "select " + this.dataIdColName + "," + this.byteSizeColName + " from " + this.entriesTableName + " WHERE queueName='" + queueName + "' AND nodeId='" + nodeId + "' ORDER BY prio DESC, " + this.dataIdColName + " ASC";
                query = new PreparedQuery(this.pool, req, false, this.log, -1);
                ret = this.processResultSetForDeleting(query.rs, (int)numOfEntries, amount);
                nmax = ret.list.size();
                if (nmax >= 1) {
                    uniqueIds = new long[nmax];
                    i = 0;
                    while (true) {
                        if (i >= nmax) break;
                        uniqueIds[i] = (Long)ret.list.get(i);
                        ++i;
                    }
                    reqList = this.whereInStatement("delete from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND " + this.dataIdColName + " in(", uniqueIds);
                    ret.countEntries = 0L;
                    i = 0;
                    while (true) {
                        if (i >= reqList.size()) break;
                        req = (String)reqList.get(i);
                        if (this.log.TRACE) {
                            this.log.trace(this.getLogId(queueName, nodeId, "deleteFirstEntries"), "'" + req + "'");
                        }
                        ret.countEntries += (long)this.update(req, query.conn);
                        ++i;
                    }
                    var16_22 = ret;
                    var18_13 = null;
                    try {
                        if (query == null) return var16_22;
                        query.close();
                        return var16_22;
                    }
                    catch (Throwable ex1) {
                        this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
                        ex1.printStackTrace();
                    }
                    return var16_22;
                }
                var11_11 = ret;
                var18_12 = null;
            }
            catch (XmlBlasterException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (query != null) {
                    query.closeStatement();
                }
                if (this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "deleteFirstEntries"), ex) == false) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.deleteFirstEntries", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.deleteFirstEntries", "", ex);
            }
        }
        catch (Throwable var17_23) {
            var18_14 = null;
            try {}
            catch (Throwable ex1) {
                this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
                throw var17_23;
            }
            if (query == null) throw var17_23;
            query.close();
            throw var17_23;
        }
        ** try [egrp 2[TRYBLOCK] [3 : 623->636)] { 
lbl71:
        // 1 sources

        if (query == null) return var11_11;
        query.close();
        return var11_11;
lbl74:
        // 1 sources

        catch (Throwable ex1) {
            this.log.error("JdbcManagerCommonTable", "exception when closing query: " + ex1.toString());
            ex1.printStackTrace();
        }
        return var11_11;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getEntriesByPriority(StorageId storageId, String nodeId, int numOfEntries, long numOfBytes, int minPrio, int maxPrio) throws XmlBlasterException {
        String queueName = storageId.getStrippedId();
        if (this.log.CALL) {
            this.log.call(this.getLogId(queueName, nodeId, "getEntriesByPriority"), "Entering");
        }
        if (!this.isConnected) {
            if (!this.log.TRACE) return new ArrayList();
            this.log.trace(this.getLogId(queueName, nodeId, "getEntriesByPriority"), "Currently not possible. No connection to the DB");
            return new ArrayList();
        }
        String req = "SELECT * from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND prio >= " + minPrio + " and prio <= " + maxPrio + " ORDER BY prio DESC, " + this.dataIdColName + " ASC";
        if (this.log.TRACE) {
            this.log.trace(this.getLogId(queueName, nodeId, "getEntriesByPriority"), "Request: '" + req + "'");
        }
        PreparedQuery query = null;
        try {
            try {
                query = new PreparedQuery(this.pool, req, this.log, numOfEntries);
                ArrayList ret = this.processResultSet(query.rs, storageId, numOfEntries, numOfBytes, false);
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "getEntriesByPriority"), "Found " + ret.size() + " entries");
                }
                ArrayList arrayList = ret;
                Object var14_14 = null;
                try {
                    if (query == null) return arrayList;
                    query.close();
                    return arrayList;
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "exception when closing query: " + ex1.toString());
                    ex1.printStackTrace();
                }
                return arrayList;
            }
            catch (XmlBlasterException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (query != null) {
                    query.closeStatement();
                }
                if (!this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "getEntriesByPriority"), ex)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.getEntriesByPriority", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.getEntriesByPriority", "", ex);
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {}
            catch (Throwable ex1) {
                this.log.error(ME, "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
                throw throwable;
            }
            if (query == null) throw throwable;
            query.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getEntriesBySamePriority(StorageId storageId, String nodeId, int numOfEntries, long numOfBytes) throws XmlBlasterException {
        String queueName = storageId.getStrippedId();
        if (this.log.CALL) {
            this.log.call(this.getLogId(queueName, nodeId, "getEntriesBySamePriority"), "Entering");
        }
        if (!this.isConnected) {
            if (!this.log.TRACE) return new ArrayList();
            this.log.trace(this.getLogId(queueName, nodeId, "getEntriesBySamePriority"), "Currently not possible. No connection to the DB");
            return new ArrayList();
        }
        String req = null;
        PreparedQuery query = null;
        try {
            try {
                if (!this.pool.isNestedBracketsSuppported()) {
                    int prio = 0;
                    req = "SELECT max(prio) from " + this.entriesTableName + " where queueName='" + queueName + "' and nodeId='" + nodeId + "'";
                    query = new PreparedQuery(this.pool, req, this.log, numOfEntries);
                    query.rs.next();
                    prio = query.rs.getInt(1);
                    if (this.log.TRACE) {
                        this.log.trace(this.getLogId(queueName, nodeId, "getEntriesBySamePriority"), "Max prio " + new Integer(prio).toString());
                    }
                    query.close();
                    query = null;
                    req = "SELECT * from " + this.entriesTableName + " where queueName='" + queueName + "' and nodeId='" + nodeId + "' and prio=" + prio + " ORDER BY " + this.dataIdColName + " ASC";
                } else {
                    req = "SELECT * from " + this.entriesTableName + " where queueName='" + queueName + "' and nodeId='" + nodeId + "' and prio=(select max(prio) from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "')  ORDER BY " + this.dataIdColName + " ASC";
                }
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "getEntriesBySamePriority"), "Request: '" + req + "'");
                }
                query = new PreparedQuery(this.pool, req, this.log, numOfEntries);
                ArrayList ret = this.processResultSet(query.rs, storageId, numOfEntries, numOfBytes, false);
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "getEntriesBySamePriority"), "Found " + ret.size() + " entries");
                }
                ArrayList arrayList = ret;
                Object var12_13 = null;
                try {
                    if (query == null) return arrayList;
                    query.close();
                    return arrayList;
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "exception when closing query: " + ex1.toString());
                    ex1.printStackTrace();
                }
                return arrayList;
            }
            catch (XmlBlasterException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (query != null) {
                    query.closeStatement();
                }
                if (!this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "getEntriesBySamePriority"), ex)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.getEntriesBySamePriority", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.getEntriesBySamePriority", "", ex);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {}
            catch (Throwable ex1) {
                this.log.error(ME, "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
                throw throwable;
            }
            if (query == null) throw throwable;
            query.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getEntries(StorageId storageId, String nodeId, int numOfEntries, long numOfBytes) throws XmlBlasterException {
        String queueName = storageId.getStrippedId();
        if (this.log.CALL) {
            this.log.call(this.getLogId(queueName, nodeId, "getEntries"), "Entering");
        }
        if (!this.isConnected) {
            if (!this.log.TRACE) return new ArrayList();
            this.log.trace(this.getLogId(queueName, nodeId, "getEntries"), "Currently not possible. No connection to the DB");
            return new ArrayList();
        }
        String req = "SELECT * from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "' ORDER BY prio DESC, " + this.dataIdColName + " ASC";
        if (this.log.TRACE) {
            this.log.trace(this.getLogId(queueName, nodeId, "getEntries"), "Request: '" + req + "' wanted limits: numOfEntries=" + numOfEntries + " numOfBytes=" + numOfBytes);
        }
        PreparedQuery query = null;
        try {
            try {
                query = new PreparedQuery(this.pool, req, this.log, numOfEntries);
                ArrayList ret = this.processResultSet(query.rs, storageId, numOfEntries, numOfBytes, false);
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "getEntries"), "Found " + ret.size() + " entries. Wanted limits: numOfEntries=" + numOfEntries + " numOfBytes=" + numOfBytes);
                }
                ArrayList arrayList = ret;
                Object var12_11 = null;
                try {
                    if (query == null) return arrayList;
                    query.close();
                    return arrayList;
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "exception when closing query: " + ex1.toString());
                    ex1.printStackTrace();
                }
                return arrayList;
            }
            catch (SQLException ex) {
                if (query != null) {
                    query.closeStatement();
                }
                if (!this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "getEntries"), ex)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.getEntries", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.getEntries", "", ex);
            }
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            try {}
            catch (Throwable ex1) {
                this.log.error(ME, "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
                throw throwable;
            }
            if (query == null) throw throwable;
            query.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getEntriesWithLimit(StorageId storageId, String nodeId, I_Entry limitEntry) throws XmlBlasterException {
        String queueName = storageId.getStrippedId();
        if (this.log.CALL) {
            this.log.call(this.getLogId(queueName, nodeId, "getEntriesWithLimit"), "Entering");
        }
        if (!this.isConnected) {
            if (!this.log.TRACE) return new ArrayList();
            this.log.trace(this.getLogId(queueName, nodeId, "getEntriesWithLimit"), "Currently not possible. No connection to the DB");
            return new ArrayList();
        }
        int limitPrio = limitEntry.getPriority();
        long limitId = limitEntry.getUniqueId();
        String req = "SELECT * from " + this.entriesTableName + " WHERE queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND (prio > " + limitPrio + " OR (prio = " + limitPrio + " AND " + this.dataIdColName + " < " + limitId + ") ) ORDER BY prio DESC, " + this.dataIdColName + " ASC";
        if (this.log.TRACE) {
            this.log.trace(this.getLogId(queueName, nodeId, "getEntriesWithLimit"), "Request: '" + req + "'");
        }
        PreparedQuery query = null;
        try {
            try {
                query = new PreparedQuery(this.pool, req, this.log, -1);
                ArrayList ret = this.processResultSet(query.rs, storageId, -1, -1L, false);
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "getEntriesWithLimit"), "Found " + ret.size() + " entries");
                }
                ArrayList arrayList = ret;
                Object var13_13 = null;
                try {
                    if (query == null) return arrayList;
                    query.close();
                    return arrayList;
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "exception when closing query: " + ex1.toString());
                    ex1.printStackTrace();
                }
                return arrayList;
            }
            catch (XmlBlasterException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (query != null) {
                    query.closeStatement();
                }
                if (!this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "getEntriesWithLimit"), ex)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.getEntriesWithLimit", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.getEntriesWithLimit", "", ex);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {}
            catch (Throwable ex1) {
                this.log.error(ME, "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
                throw throwable;
            }
            if (query == null) throw throwable;
            query.close();
            throw throwable;
        }
    }

    public long removeEntriesWithLimit(StorageId storageId, String nodeId, I_Entry limitEntry, boolean inclusive) throws XmlBlasterException {
        try {
            String queueName = storageId.getStrippedId();
            if (this.log.CALL) {
                this.log.call(this.getLogId(queueName, nodeId, "removeEntriesWithLimit"), "Entering");
            }
            if (!this.isConnected) {
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "removeEntriesWithLimit"), "Currently not possible. No connection to the DB");
                }
                return 0L;
            }
            int limitPrio = limitEntry.getPriority();
            long limitId = limitEntry.getUniqueId();
            String req = null;
            req = inclusive ? "DELETE from " + this.entriesTableName + " WHERE queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND (prio > " + limitPrio + " OR (prio = " + limitPrio + " AND " + this.dataIdColName + " <= " + limitId + ") )" : "DELETE from " + this.entriesTableName + " WHERE queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND (prio > " + limitPrio + " OR (prio = " + limitPrio + " AND " + this.dataIdColName + " < " + limitId + ") )";
            if (this.log.TRACE) {
                this.log.trace(this.getLogId(queueName, nodeId, "removeEntriesWithLimit"), "Request: '" + req + "'");
            }
            int ret = this.update(req);
            if (this.log.TRACE) {
                this.log.trace(ME, "removeEntriesWithLimit the result of the request '" + req + "' is : '" + ret + "'");
            }
            return ret;
        }
        catch (SQLException ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.removeEntriesWithLimit", "", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getEntries(StorageId storageId, String nodeId, long[] dataids) throws XmlBlasterException {
        String queueName = storageId.getStrippedId();
        if (this.log.CALL) {
            this.log.call(this.getLogId(queueName, nodeId, "getEntries"), "Entering");
        }
        if (!this.isConnected) {
            if (!this.log.TRACE) return new ArrayList();
            this.log.trace(this.getLogId(queueName, nodeId, "getEntries"), "Currently not possible. No connection to the DB");
            return new ArrayList();
        }
        String req = null;
        if (dataids == null) return new ArrayList();
        if (dataids.length < 1) {
            return new ArrayList();
        }
        req = "SELECT * FROM " + this.entriesTableName + " WHERE queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND " + this.dataIdColName + " in (";
        ArrayList requests = this.whereInStatement(req, dataids);
        PreparedQuery query = null;
        try {
            try {
                req = (String)requests.get(0);
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "getEntries"), "Request: '" + req + "'");
                }
                query = new PreparedQuery(this.pool, req, this.log, -1);
                ArrayList ret = this.processResultSet(query.rs, storageId, -1, -1L, false);
                int i = 1;
                while (true) {
                    if (i >= requests.size()) {
                        if (this.log.TRACE) {
                            this.log.trace(this.getLogId(queueName, nodeId, "getEntries"), "Found " + ret.size() + " entries");
                        }
                        break;
                    }
                    req = (String)requests.get(i);
                    if (this.log.TRACE) {
                        this.log.trace(this.getLogId(queueName, nodeId, "getEntries"), "Request: '" + req + "'");
                    }
                    query.inTransactionRequest(req);
                    ret.addAll(this.processResultSet(query.rs, storageId, -1, -1L, false));
                    ++i;
                }
                ArrayList arrayList = ret;
                Object var12_13 = null;
                try {
                    if (query == null) return arrayList;
                    query.close();
                    return arrayList;
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "exception when closing query: " + ex1.toString());
                    ex1.printStackTrace();
                }
                return arrayList;
            }
            catch (XmlBlasterException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (query != null) {
                    query.closeStatement();
                }
                if (!this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "getEntries"), ex)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.getEntries", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.getEntries", "", ex);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {}
            catch (Throwable ex1) {
                this.log.error(ME, "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
                throw throwable;
            }
            if (query == null) throw throwable;
            query.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long getNumOfEntries(String queueName, String nodeId) throws XmlBlasterException {
        if (!this.isConnected) {
            if (!this.log.TRACE) return 0L;
            this.log.trace(this.getLogId(queueName, nodeId, "getNumOfEntries"), "Currently not possible. No connection to the DB");
            return 0L;
        }
        String req = "select count(*) from " + this.entriesTableName + " WHERE queueName='" + queueName + "' AND nodeId='" + nodeId + "'";
        if (this.log.TRACE) {
            this.log.trace(this.getLogId(queueName, nodeId, "getNumOfEntries"), "Request: '" + req + "'");
        }
        PreparedQuery query = null;
        try {
            try {
                query = new PreparedQuery(this.pool, req, true, this.log, -1);
                query.rs.next();
                long ret = query.rs.getLong(1);
                if (this.log.TRACE) {
                    this.log.trace(this.getLogId(queueName, nodeId, "getNumOfEntries"), "Num=" + ret);
                }
                long l = ret;
                Object var10_8 = null;
                try {
                    if (query == null) return l;
                    query.close();
                    return l;
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "exception when closing query: " + ex1.toString());
                    ex1.printStackTrace();
                }
                return l;
            }
            catch (XmlBlasterException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (query != null) {
                    query.closeStatement();
                }
                if (!this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "getNumOfEntries"), ex)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.getNumOfEntries", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.getNumOfEntries", "", ex);
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            try {}
            catch (Throwable ex1) {
                this.log.error(ME, "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
                throw throwable;
            }
            if (query == null) throw throwable;
            query.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long getNumOfPersistents(String queueName, String nodeId) throws XmlBlasterException {
        if (!this.isConnected) {
            if (!this.log.TRACE) return 0L;
            this.log.trace(this.getLogId(queueName, nodeId, "getNumOfPersistents"), "Currently not possible. No connection to the DB");
            return 0L;
        }
        String req = "select count(*) from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND durable='T'";
        if (this.log.TRACE) {
            this.log.trace(this.getLogId(queueName, nodeId, "getNumOfPersistent"), "Request: '" + req + "'");
        }
        PreparedQuery query = null;
        try {
            try {
                long ret;
                query = new PreparedQuery(this.pool, req, true, this.log, -1);
                query.rs.next();
                long l = ret = query.rs.getLong(1);
                Object var10_8 = null;
                try {
                    if (query == null) return l;
                    query.close();
                    return l;
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "exception when closing query: " + ex1.toString());
                    ex1.printStackTrace();
                }
                return l;
            }
            catch (XmlBlasterException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (query != null) {
                    query.closeStatement();
                }
                if (!this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "getNumOfPersistents"), ex)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.getNumOfPersistents", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.getNumOfPersistents", "", ex);
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            try {}
            catch (Throwable ex1) {
                this.log.error(ME, "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
                throw throwable;
            }
            if (query == null) throw throwable;
            query.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long getSizeOfPersistents(String queueName, String nodeId) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.getLogId(queueName, nodeId, "getSizeOfPersistent"), "Entering");
        }
        if (!this.isConnected) {
            if (!this.log.TRACE) return 0L;
            this.log.trace(this.getLogId(queueName, nodeId, "getSizeOfPersistent"), "Currently not possible. No connection to the DB");
            return 0L;
        }
        String req = "select sum(" + this.byteSizeColName + ") from " + this.entriesTableName + " where queueName='" + queueName + "' AND nodeId='" + nodeId + "' AND durable='T'";
        if (this.log.TRACE) {
            this.log.trace(this.getLogId(queueName, nodeId, "getSizeOfPersistents"), "Request: '" + req + "'");
        }
        PreparedQuery query = null;
        try {
            try {
                long ret;
                query = new PreparedQuery(this.pool, req, true, this.log, -1);
                query.rs.next();
                long l = ret = query.rs.getLong(1);
                Object var10_8 = null;
                try {
                    if (query == null) return l;
                    query.close();
                    return l;
                }
                catch (Throwable ex1) {
                    this.log.error(ME, "exception when closing query: " + ex1.toString());
                    ex1.printStackTrace();
                }
                return l;
            }
            catch (XmlBlasterException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (query != null) {
                    query.closeStatement();
                }
                if (!this.checkIfDBLoss(query != null ? query.conn : null, this.getLogId(queueName, nodeId, "getSizeOfPersistents"), ex)) throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNKNOWN, "JdbcManagerCommonTable.getSizeOfPersistents", "", ex);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, "JdbcManagerCommonTable.getSizeOfPersistents", "", ex);
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            try {}
            catch (Throwable ex1) {
                this.log.error(ME, "exception when closing query: " + ex1.toString());
                ex1.printStackTrace();
                throw throwable;
            }
            if (query == null) throw throwable;
            query.close();
            throw throwable;
        }
    }

    private final String getLogId(String queueName, String nodeId, String methodName) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(ME);
        if (this.tableNamePrefix != null) {
            sb.append("-").append(this.tableNamePrefix);
        }
        if (nodeId != null) {
            sb.append("-").append(nodeId);
        }
        if (queueName != null) {
            sb.append("-").append(queueName);
        }
        if (methodName != null) {
            sb.append("-").append(methodName).append("()");
        }
        return sb.toString();
    }

    public static void wipeOutDB(Global glob, String confType, String confVersion, Properties properties, boolean setupNewTables) throws XmlBlasterException {
        LogChannel log = glob.getLog("jdbc");
        if (confType == null) {
            confType = "JDBC";
        }
        if (confVersion == null) {
            confVersion = "1.0";
        }
        QueuePluginManager pluginManager = new QueuePluginManager(glob);
        PluginInfo pluginInfo = new PluginInfo(glob, (I_PluginManager)pluginManager, confType, confVersion);
        Properties ownProperties = (Properties)((Hashtable)pluginInfo.getParameters()).clone();
        if (properties != null) {
            Enumeration enumer = ((Hashtable)properties).keys();
            while (enumer.hasMoreElements()) {
                String key = (String)enumer.nextElement();
                ((Hashtable)ownProperties).put(key, properties.getProperty(key));
            }
        }
        JdbcConnectionPool pool = new JdbcConnectionPool();
        try {
            pool.initialize(glob, pluginInfo.getParameters());
        }
        catch (ClassNotFoundException ex) {
            log.error(ME, "wipOutDB class not found: " + ex.getMessage());
            throw new XmlBlasterException(glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, ME, "wipeOutDB class not found", ex);
        }
        catch (SQLException ex) {
            throw new XmlBlasterException(glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, ME, "wipeOutDB SQL exception", ex);
        }
        String queueClassName = pluginInfo.getClassName();
        if ("org.xmlBlaster.util.queue.jdbc.JdbcQueuePlugin".equals(queueClassName)) {
            log.error(ME, "org.xmlBlaster.util.queue.jdbc.JdbcQueuePlugin is not supported anymore");
        } else if ("org.xmlBlaster.util.queue.jdbc.JdbcQueueCommonTablePlugin".equals(queueClassName)) {
            JdbcManagerCommonTable manager = new JdbcManagerCommonTable(pool, null, "cleaner");
            pool.registerStorageProblemListener(manager);
            manager.setUp();
            manager.wipeOutDB(setupNewTables);
        } else {
            throw new XmlBlasterException(glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, ME, "wipeOutDB for plugin '" + queueClassName + "' is not implemented");
        }
    }

    public static void main(String[] args) {
        Global glob = Global.instance();
        glob.init(args);
        String type = glob.getProperty().get("wipeout.pluginType", (String)null);
        String version = glob.getProperty().get("wipeout.pluginVersion", (String)null);
        if (type == null || version == null) {
            System.out.println("usage: java org.xmlBlaster.util.queue.jdbc.JdbcManagerCommonTable -wipeout.pluginType JDBC -wipeout.pluginVersion 1.0");
            System.exit(1);
        }
        try {
            JdbcManagerCommonTable.wipeOutDB(glob, type, version, null, false);
        }
        catch (Exception ex) {
            System.err.println("Main" + ex.toString());
        }
    }

    public synchronized void shutdown() {
        if (this.log.CALL) {
            this.log.call(ME, "shutdown");
        }
        if (this.pool != null) {
            this.pool.unregisterManager(this);
        }
    }

    public synchronized void registerQueue(I_Queue queue) {
        if (this.log.CALL) {
            this.log.call(ME, "registerQueue, number of queues registered (before registering this one): '" + this.queueCounter + "'");
        }
        if (queue == null) {
            return;
        }
        ++this.queueCounter;
    }

    public synchronized void unregisterQueue(I_Queue queue) {
        if (this.log.CALL) {
            this.log.call(ME, "unregisterQueue, number of queues registered (still including this one): '" + this.queueCounter + "'");
        }
        if (queue == null) {
            return;
        }
        --this.queueCounter;
        if (this.queueCounter == 0) {
            this.shutdown();
        }
    }
}

