/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.queue.jdbc;

import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.msgstore.I_ChangeCallback;
import org.xmlBlaster.engine.msgstore.I_Map;
import org.xmlBlaster.engine.msgstore.I_MapEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.I_QueuePutListener;
import org.xmlBlaster.util.queue.I_QueueSizeListener;
import org.xmlBlaster.util.queue.I_StoragePlugin;
import org.xmlBlaster.util.queue.I_StorageProblemListener;
import org.xmlBlaster.util.queue.ReturnDataHolder;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queue.jdbc.JdbcConnectionPool;
import org.xmlBlaster.util.queue.jdbc.JdbcManagerCommonTable;

public final class JdbcQueueCommonTablePlugin
implements I_Queue,
I_StoragePlugin,
I_Map {
    private String ME;
    private StorageId storageId;
    private boolean notifiedAboutAddOrRemove = false;
    private String associatedTable = null;
    private Global glob;
    private LogChannel log;
    private QueuePropertyBase property;
    private JdbcManagerCommonTable manager = null;
    private I_QueuePutListener putListener;
    private long numOfEntries = -999L;
    private long numOfPersistentEntries = -999L;
    private long numOfPersistentBytes = -999L;
    private long numOfBytes = -999L;
    boolean isDown = true;
    private Object modificationMonitor = new Object();
    private PluginInfo pluginInfo = null;
    private boolean debug = false;
    private ArrayList queueSizeListeners;
    private Object queueSizeListenersSync = new Object();
    static /* synthetic */ Class class$org$xmlBlaster$util$queue$jdbc$JdbcManagerCommonTable;

    public boolean isTransient() {
        return false;
    }

    private final void resetCounters() {
        try {
            this.numOfPersistentBytes = -999L;
            this.numOfPersistentBytes = this.getNumOfPersistentBytes_(true);
            this.numOfPersistentEntries = -999L;
            this.numOfPersistentEntries = this.getNumOfPersistentEntries_(true);
            this.numOfBytes = -999L;
            this.numOfBytes = this.getNumOfBytes_();
            this.numOfEntries = -999L;
            this.numOfEntries = this.getNumOfEntries_();
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "resetCounters exception occured: " + ex.getMessage());
        }
    }

    private String spaceLeft(long numOfEntries, long sizeInBytes) {
        numOfEntries = 0L;
        sizeInBytes = 0L;
        if (this.property == null) {
            return "Storage framework is down, current settings are" + this.toXml("");
        }
        if (numOfEntries + this.getNumOfEntries() > this.getMaxNumOfEntries()) {
            return "Queue overflow (number of entries), " + this.getNumOfEntries() + " entries are in queue, try increasing property '" + this.property.getPropName("maxEntries") + "' and '" + this.property.getPropName("maxEntriesCache") + "', current settings are" + this.toXml("");
        }
        if (sizeInBytes + this.getNumOfBytes() > this.getMaxNumOfBytes()) {
            return "Queue overflow, " + this.getMaxNumOfBytes() + " bytes are in queue, try increasing property '" + this.property.getPropName("maxBytes") + "' and '" + this.property.getPropName("maxBytesCache") + "', current settings are" + this.toXml("");
        }
        return null;
    }

    protected JdbcManagerCommonTable getJdbcQueueManagerCommonTable(PluginInfo pluginInfo) throws XmlBlasterException {
        Object object;
        String location = this.ME + "/type '" + pluginInfo.getType() + "' version '" + pluginInfo.getVersion() + "'";
        String managerName = pluginInfo.toString();
        Object obj = this.glob.getObjectEntry(managerName);
        JdbcManagerCommonTable manager = null;
        try {
            if (obj == null) {
                object = class$org$xmlBlaster$util$queue$jdbc$JdbcManagerCommonTable == null ? (class$org$xmlBlaster$util$queue$jdbc$JdbcManagerCommonTable = JdbcQueueCommonTablePlugin.class$("org.xmlBlaster.util.queue.jdbc.JdbcManagerCommonTable")) : class$org$xmlBlaster$util$queue$jdbc$JdbcManagerCommonTable;
                synchronized (object) {
                    obj = this.glob.getObjectEntry(managerName);
                    if (obj == null) {
                        JdbcConnectionPool pool = new JdbcConnectionPool();
                        pool.initialize(this.glob, pluginInfo.getParameters());
                        manager = new JdbcManagerCommonTable(pool, this.glob.getEntryFactory(), managerName);
                        pool.registerStorageProblemListener(manager);
                        manager.setUp();
                        if (this.log.TRACE) {
                            this.log.trace(this.ME, "Created JdbcManagerCommonTable instance for storage plugin configuration '" + managerName + "'");
                        }
                        this.glob.addObjectEntry(managerName, manager);
                    } else {
                        manager = (JdbcManagerCommonTable)obj;
                    }
                }
            } else {
                manager = (JdbcManagerCommonTable)obj;
            }
            if (!manager.getPool().isInitialized()) {
                manager.getPool().initialize(this.glob, pluginInfo.getParameters());
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Initialized JdbcManager pool for storage class '" + managerName + "'");
                }
            }
        }
        catch (ClassNotFoundException ex) {
            this.log.error(location, "getJdbcCommonTableQueueManager class not found: " + ex.getMessage());
            ex.printStackTrace();
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, location, "getJdbcQueueCommonTableManager: class not found when initializing the connection pool", ex);
        }
        catch (SQLException ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_DB_UNAVAILABLE, location, "getJdbcCommonTableQueueManager: sql exception when initializing the connection pool", ex);
        }
        catch (Throwable ex) {
            if (this.log.TRACE) {
                this.log.trace(location, "getJdbcQueueCommonTableManager internal exception: " + ex.toString());
                ex.printStackTrace();
            }
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, location, "getJdbcQueueManager: throwable when initializing the connection pool", ex);
        }
        if (this.glob.getWipeOutDB()) {
            object = this.glob;
            synchronized (object) {
                if (this.glob.getWipeOutDB()) {
                    manager.wipeOutDB(true);
                    this.glob.setWipeOutDB(false);
                }
            }
        }
        return manager;
    }

    public synchronized void initialize(StorageId uniqueQueueId, Object userData) throws XmlBlasterException {
        boolean dbg;
        if (this.isDown) {
            this.property = null;
            this.setProperties(userData);
            this.glob = this.property.getGlobal();
            this.log = this.glob.getLog("jdbc");
            this.ME = this.getClass().getName() + "-" + uniqueQueueId;
            this.storageId = uniqueQueueId;
            if (this.log.CALL) {
                this.log.call(this.ME, "initialize '" + this.storageId + "'");
            }
            this.manager = this.getJdbcQueueManagerCommonTable(this.pluginInfo);
            String nodeId = this.glob.getStrippedId();
            this.manager.addNode(nodeId);
            this.manager.addQueue(this.storageId.getStrippedId(), nodeId, this.property.getMaxBytes(), this.property.getMaxEntries());
            this.numOfEntries = this.manager.getNumOfEntries(this.getStorageId().getStrippedId(), this.glob.getStrippedId());
            this.numOfBytes = this.manager.getNumOfBytes(this.storageId.getStrippedId(), this.glob.getStrippedId());
            this.numOfPersistentEntries = this.manager.getNumOfPersistents(this.getStorageId().getStrippedId(), this.glob.getStrippedId());
            this.numOfPersistentBytes = this.manager.getSizeOfPersistents(this.getStorageId().getStrippedId(), this.glob.getStrippedId());
            this.isDown = false;
            this.manager.registerQueue(this);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Successful initialized");
            }
        }
        if (dbg = this.glob.getProperty().get("queue/debug", false)) {
            this.property.setDebug(true);
        }
        this.debug = this.property.getDebug();
        if (this.debug) {
            this.log.warn(this.ME, "initialize: debugging is enabled");
        }
    }

    public void setProperties(Object userData) throws XmlBlasterException {
        QueuePropertyBase newProp;
        if (userData == null) {
            return;
        }
        try {
            newProp = (QueuePropertyBase)userData;
        }
        catch (Throwable e) {
            this.log.error(this.ME, "Can't configure queue, your properties are invalid: " + e.toString());
            e.printStackTrace();
            return;
        }
        this.property = newProp;
    }

    public Object getProperties() {
        return this.property;
    }

    public void setNotifiedAboutAddOrRemove(boolean notify) {
        this.notifiedAboutAddOrRemove = notify;
    }

    public boolean isNotifiedAboutAddOrRemove() {
        return this.notifiedAboutAddOrRemove;
    }

    public void addPutListener(I_QueuePutListener l) {
        if (l == null) {
            throw new IllegalArgumentException(this.ME + ": addPustListener(null) is not allowed");
        }
        if (this.putListener != null) {
            throw new IllegalArgumentException(this.ME + ": addPustListener() failed, there is a listener registered already");
        }
        this.putListener = l;
    }

    public void removePutListener(I_QueuePutListener l) {
        this.putListener = null;
    }

    public long[] getEntryReferences() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "getEntryReferences not implemented");
    }

    public ArrayList getEntries() throws XmlBlasterException {
        return this.manager.getEntries(this.getStorageId(), this.glob.getStrippedId(), -1, -1L);
    }

    public void put(I_QueueEntry queueEntry, boolean ignorePutInterceptor) throws XmlBlasterException {
        if (queueEntry == null) {
            return;
        }
        if (this.putListener != null && !ignorePutInterceptor && !this.putListener.putPre(queueEntry)) {
            return;
        }
        this.put(queueEntry);
        if (this.putListener != null && !ignorePutInterceptor) {
            this.putListener.putPost(queueEntry);
        }
    }

    private boolean put(I_Entry entry) throws XmlBlasterException {
        boolean ret = false;
        Object object = this.modificationMonitor;
        synchronized (object) {
            String exTxt = null;
            exTxt = this.spaceLeft(1L, entry.getSizeInBytes());
            if (exTxt != null) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, exTxt);
            }
            if (this.getNumOfBytes_() > this.getMaxNumOfBytes()) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_BYTES, this.ME, "put: the maximum number of bytes reached. Number of bytes=" + this.numOfBytes + " maxmimum number of bytes=" + this.getMaxNumOfBytes() + " status: " + this.toXml(""));
            }
            try {
                if (this.manager.addEntry(this.storageId.getStrippedId(), this.glob.getStrippedId(), entry)) {
                    ++this.numOfEntries;
                    this.numOfBytes += entry.getSizeInBytes();
                    if (entry.isPersistent()) {
                        ++this.numOfPersistentEntries;
                        this.numOfPersistentBytes += entry.getSizeInBytes();
                    }
                    ret = true;
                }
            }
            catch (XmlBlasterException ex) {
                this.resetCounters();
                throw ex;
            }
        }
        if (ret && this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    public void put(I_QueueEntry[] queueEntries, boolean ignorePutInterceptor) throws XmlBlasterException {
        XmlBlasterException ex0 = null;
        if (queueEntries == null) {
            return;
        }
        if (this.putListener != null && !ignorePutInterceptor && !this.putListener.putPre(queueEntries)) {
            return;
        }
        Object object = this.modificationMonitor;
        synchronized (object) {
            String exTxt = null;
            exTxt = this.spaceLeft(queueEntries.length, 0L);
            if (exTxt != null) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, exTxt);
            }
            if (this.getNumOfBytes_() > this.getMaxNumOfBytes()) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_BYTES, this.ME, "put[]: the maximum number of bytes reached. Number of bytes=" + this.numOfBytes + " maxmimum number of bytes=" + this.getMaxNumOfBytes() + " status: " + this.toXml(""));
            }
            try {
                int[] help = this.manager.addEntries(this.storageId.getStrippedId(), this.glob.getStrippedId(), queueEntries);
                int i = 0;
                while (i < queueEntries.length) {
                    boolean isProcessed;
                    boolean bl = isProcessed = help[i] > 0 || help[i] == -2;
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "put(I_Entry[]) the entry nr. " + i + " returned '" + help[i] + "'");
                    }
                    if (isProcessed) {
                        ++this.numOfEntries;
                        this.numOfBytes += queueEntries[i].getSizeInBytes();
                        if (queueEntries[i].isPersistent()) {
                            ++this.numOfPersistentEntries;
                            this.numOfPersistentBytes += queueEntries[i].getSizeInBytes();
                        }
                    }
                    ++i;
                }
            }
            catch (XmlBlasterException ex) {
                ex0 = ex;
                this.resetCounters();
            }
            if (ex0 != null) {
                throw ex0;
            }
        }
        if (this.putListener != null && !ignorePutInterceptor) {
            this.putListener.putPost(queueEntries);
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
    }

    public StorageId getStorageId() {
        return this.storageId;
    }

    public I_QueueEntry take() throws XmlBlasterException {
        Object object = this.modificationMonitor;
        synchronized (object) {
            I_QueueEntry ret = this.peek();
            this.removeRandom(ret.getUniqueId());
            I_QueueEntry i_QueueEntry = ret;
            return i_QueueEntry;
        }
    }

    public ArrayList takeWithPriority(int numOfEntries, long numOfBytes, int minPriority, int maxPriority) throws XmlBlasterException {
        if (numOfEntries == 0) {
            return new ArrayList();
        }
        Object object = this.modificationMonitor;
        synchronized (object) {
            ArrayList ret = this.peekWithPriority(numOfEntries, numOfBytes, minPriority, maxPriority);
            this.removeRandom(ret.toArray(new I_QueueEntry[ret.size()]));
            ArrayList arrayList = ret;
            return arrayList;
        }
    }

    public ArrayList take(int numOfEntries, long numOfBytes) throws XmlBlasterException {
        if (numOfEntries == 0) {
            return new ArrayList();
        }
        ArrayList ret = null;
        Object object = this.modificationMonitor;
        synchronized (object) {
            try {
                ret = this.manager.getEntries(this.getStorageId(), this.glob.getStrippedId(), numOfEntries, numOfBytes);
                long[] ids = new long[ret.size()];
                int i = 0;
                while (i < ids.length) {
                    ids[i] = ((I_QueueEntry)ret.get(i)).getUniqueId();
                    ++i;
                }
                boolean[] tmp = this.manager.deleteEntries(this.getStorageId().getStrippedId(), this.glob.getStrippedId(), ids);
                int i2 = 0;
                while (i2 < tmp.length) {
                    if (tmp[i2]) {
                        --this.numOfEntries;
                    }
                    ++i2;
                }
                Object var11_9 = null;
                this.resetCounters();
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                this.resetCounters();
                throw throwable;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    public ArrayList takeLowest(int numOfEntries, long numOfBytes, I_QueueEntry limitEntry, boolean leaveOne) throws XmlBlasterException {
        long minUniqueId = 0L;
        int maxPriority = Integer.MAX_VALUE;
        if (limitEntry != null) {
            minUniqueId = limitEntry.getUniqueId();
            maxPriority = limitEntry.getPriority();
        }
        ReturnDataHolder ret = null;
        Object object = this.modificationMonitor;
        synchronized (object) {
            try {
                ret = this.manager.getAndDeleteLowest(this.getStorageId(), this.glob.getStrippedId(), numOfEntries, numOfBytes, maxPriority, minUniqueId, leaveOne, true);
                this.numOfBytes -= ret.countBytes;
                this.numOfEntries -= ret.countEntries;
                this.numOfPersistentBytes = -999L;
                this.numOfPersistentBytes = this.getNumOfPersistentBytes_(true);
                this.numOfPersistentEntries = -999L;
                this.numOfPersistentEntries = this.getNumOfPersistentEntries_(true);
            }
            catch (XmlBlasterException ex) {
                this.resetCounters();
                throw ex;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        if (ret == null) {
            return null;
        }
        return ret.list;
    }

    public ArrayList peekLowest(int numOfEntries, long numOfBytes, I_QueueEntry limitEntry, boolean leaveOne) throws XmlBlasterException {
        long minUniqueId = 0L;
        int maxPriority = Integer.MAX_VALUE;
        if (limitEntry != null) {
            minUniqueId = limitEntry.getUniqueId();
            maxPriority = limitEntry.getPriority();
        }
        ReturnDataHolder ret = this.manager.getAndDeleteLowest(this.getStorageId(), this.glob.getStrippedId(), numOfEntries, numOfBytes, maxPriority, minUniqueId, leaveOne, false);
        return ret.list;
    }

    public I_QueueEntry peek() throws XmlBlasterException {
        ArrayList ret = this.manager.getEntries(this.getStorageId(), this.glob.getStrippedId(), 1, -1L);
        if (ret.size() < 1) {
            return null;
        }
        return (I_QueueEntry)ret.get(0);
    }

    public ArrayList peek(int numOfEntries, long numOfBytes) throws XmlBlasterException {
        if (numOfEntries == 0) {
            return new ArrayList();
        }
        ArrayList ret = this.manager.getEntries(this.getStorageId(), this.glob.getStrippedId(), numOfEntries, numOfBytes);
        return ret;
    }

    public ArrayList peekSamePriority(int numOfEntries, long numOfBytes) throws XmlBlasterException {
        if (numOfEntries == 0) {
            return new ArrayList();
        }
        ArrayList ret = this.manager.getEntriesBySamePriority(this.getStorageId(), this.glob.getStrippedId(), numOfEntries, numOfBytes);
        return ret;
    }

    public ArrayList peekWithPriority(int numOfEntries, long numOfBytes, int minPriority, int maxPriority) throws XmlBlasterException {
        if (numOfEntries == 0) {
            return new ArrayList();
        }
        ArrayList ret = this.manager.getEntriesByPriority(this.getStorageId(), this.glob.getStrippedId(), numOfEntries, numOfBytes, minPriority, maxPriority);
        return ret;
    }

    public ArrayList peekWithLimitEntry(I_QueueEntry limitEntry) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "peekWithLimitEntry called");
        }
        if (limitEntry == null) {
            return new ArrayList();
        }
        return this.manager.getEntriesWithLimit(this.getStorageId(), this.glob.getStrippedId(), limitEntry);
    }

    public long removeWithLimitEntry(I_QueueEntry limitEntry, boolean inclusive) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "removeWithLimitEntry called");
        }
        if (limitEntry == null) {
            return 0L;
        }
        long ret = 0L;
        Object object = this.modificationMonitor;
        synchronized (object) {
            try {
                ret = this.manager.removeEntriesWithLimit(this.getStorageId(), this.glob.getStrippedId(), limitEntry, inclusive);
                if (ret != 0L) {
                    this.resetCounters();
                }
            }
            catch (XmlBlasterException ex) {
                this.resetCounters();
                throw ex;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    public int remove() throws XmlBlasterException {
        ReturnDataHolder ret = null;
        Object object = this.modificationMonitor;
        synchronized (object) {
            try {
                ret = this.manager.deleteFirstEntries(this.getStorageId().getStrippedId(), this.glob.getStrippedId(), 1L, -1L);
                this.numOfEntries -= (long)((int)ret.countEntries);
                this.numOfBytes -= ret.countBytes;
                this.numOfPersistentBytes = -999L;
                this.numOfPersistentBytes = this.getNumOfPersistentBytes_(true);
                this.numOfPersistentEntries = -999L;
                this.numOfPersistentEntries = this.getNumOfPersistentEntries_(true);
            }
            catch (XmlBlasterException ex) {
                this.resetCounters();
                throw ex;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        if (ret == null) {
            return 0;
        }
        return (int)ret.countEntries;
    }

    public long remove(long numOfEntries, long numOfBytes) throws XmlBlasterException {
        if (numOfEntries == 0L) {
            return 0L;
        }
        ReturnDataHolder ret = null;
        Object object = this.modificationMonitor;
        synchronized (object) {
            try {
                ret = this.manager.deleteFirstEntries(this.getStorageId().getStrippedId(), this.glob.getStrippedId(), numOfEntries, numOfBytes);
                this.numOfEntries -= (long)((int)ret.countEntries);
                this.numOfBytes -= ret.countBytes;
                this.numOfPersistentBytes = -999L;
                this.numOfPersistentBytes = this.getNumOfPersistentBytes_(true);
                this.numOfPersistentEntries = -999L;
                this.numOfPersistentEntries = this.getNumOfPersistentEntries_(true);
            }
            catch (XmlBlasterException ex) {
                this.resetCounters();
                throw ex;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        if (ret == null) {
            return 0L;
        }
        return ret.countEntries;
    }

    public int removeRandom(long dataId) throws XmlBlasterException {
        long[] args = new long[]{dataId};
        if (this.removeRandom(args)[0]) {
            return 1;
        }
        return 0;
    }

    public boolean[] removeRandom(long[] dataIdArray) throws XmlBlasterException {
        ArrayList list = this.manager.getEntries(this.getStorageId(), this.glob.getStrippedId(), dataIdArray);
        return this.removeRandom(list.toArray(new I_Entry[list.size()]));
    }

    public int removeRandom(I_Entry entry) throws XmlBlasterException {
        if (entry == null) {
            return 0;
        }
        long id = entry.getUniqueId();
        long currentAmount = entry.getSizeInBytes();
        long currentPersistentSize = 0L;
        long currentPersistentEntries = 0L;
        if (entry.isPersistent()) {
            currentPersistentSize += currentAmount;
            currentPersistentEntries = 1L;
        }
        int ret = 0;
        Object object = this.modificationMonitor;
        synchronized (object) {
            ret = this.manager.deleteEntry(this.getStorageId().getStrippedId(), this.glob.getStrippedId(), id);
            if (ret > 0) {
                --this.numOfEntries;
                this.numOfBytes -= currentAmount;
                this.numOfPersistentBytes -= currentPersistentSize;
                this.numOfPersistentEntries -= currentPersistentEntries;
            }
        }
        if (this.queueSizeListeners != null && ret > 0) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    public boolean[] removeRandom(I_Entry[] queueEntries) throws XmlBlasterException {
        if (queueEntries == null || queueEntries.length == 0) {
            return new boolean[0];
        }
        boolean[] ret = new boolean[queueEntries.length];
        long[] ids = new long[queueEntries.length];
        long currentAmount = 0L;
        long currentPersistentSize = 0L;
        long currentPersistentEntries = 0L;
        int i = 0;
        while (i < ids.length) {
            ids[i] = queueEntries[i].getUniqueId();
            currentAmount += queueEntries[i].getSizeInBytes();
            if (queueEntries[i].isPersistent()) {
                currentPersistentSize += queueEntries[i].getSizeInBytes();
                ++currentPersistentEntries;
            }
            ++i;
        }
        boolean[] tmp = null;
        Object object = this.modificationMonitor;
        synchronized (object) {
            try {
                tmp = this.manager.deleteEntries(this.getStorageId().getStrippedId(), this.glob.getStrippedId(), ids);
                long sum = 0L;
                int i2 = 0;
                while (i2 < tmp.length) {
                    if (tmp[i2]) {
                        ++sum;
                    }
                    ++i2;
                }
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "randomRemove: the number of removed entries is '" + sum + "'");
                }
                this.numOfEntries -= sum;
                if ((int)sum != queueEntries.length) {
                    this.resetCounters();
                } else {
                    this.numOfBytes -= currentAmount;
                    this.numOfPersistentBytes -= currentPersistentSize;
                    this.numOfPersistentEntries -= currentPersistentEntries;
                }
            }
            catch (XmlBlasterException ex) {
                this.resetCounters();
                throw ex;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return tmp;
    }

    public long removeWithPriority(long numOfEntries, long numOfBytes, int minPriority, int maxPriority) throws XmlBlasterException {
        ArrayList array = this.peekWithPriority((int)numOfEntries, numOfBytes, minPriority, maxPriority);
        boolean[] ret = this.removeRandom(array.toArray(new I_QueueEntry[array.size()]));
        long count = 0L;
        int i = 0;
        while (i < ret.length) {
            if (ret[i]) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int removeTransient() throws XmlBlasterException {
        int ret = 0;
        Object object = this.modificationMonitor;
        synchronized (object) {
            try {
                ret = this.manager.deleteAllTransient(this.getStorageId().getStrippedId(), this.glob.getStrippedId());
                this.numOfEntries -= (long)ret;
                this.numOfBytes = -999L;
                this.numOfBytes = this.getNumOfBytes_();
            }
            catch (XmlBlasterException ex) {
                this.resetCounters();
                throw ex;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    private final long getNumOfEntries_() throws XmlBlasterException {
        if (this.numOfEntries > -1L && !this.debug) {
            return this.numOfEntries;
        }
        Object object = this.modificationMonitor;
        synchronized (object) {
            long oldValue = this.numOfEntries;
            this.numOfEntries = this.manager.getNumOfEntries(this.getStorageId().getStrippedId(), this.glob.getStrippedId());
            if (this.debug) {
                if (oldValue != this.numOfEntries && oldValue != -999L) {
                    String txt = "getNumOfEntries: an inconsistency occured between the cached value and the real value of 'numOfEntries': it was '" + oldValue + "' but should have been '" + this.numOfEntries + "'";
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, txt + this.toXml(""));
                }
            } else if (this.log.TRACE) {
                this.log.trace(this.ME, "getNumOfEntries_ old (cached) value: '" + oldValue + "' new (real) value: '" + this.numOfEntries + "'");
            }
            long l = this.numOfEntries;
            return l;
        }
    }

    public long getNumOfEntries() {
        try {
            return this.getNumOfEntries_();
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "getNumOfEntries, exception: " + ex.getMessage());
            return this.numOfEntries;
        }
    }

    private long getNumOfPersistentEntries_(boolean verbose) throws XmlBlasterException {
        if (this.numOfPersistentEntries > -1L && !this.debug) {
            return this.numOfPersistentEntries;
        }
        Object object = this.modificationMonitor;
        synchronized (object) {
            try {
                long oldValue = this.numOfPersistentEntries;
                this.numOfPersistentEntries = this.manager.getNumOfPersistents(this.getStorageId().getStrippedId(), this.glob.getStrippedId());
                if (this.debug) {
                    if (oldValue != this.numOfPersistentEntries && oldValue != -999L) {
                        String txt = "getNumOfPersistentEntries: an inconsistency occured between the cached value and the real value of 'numOfPersistentEntries': it was '" + oldValue + "' but should have been '" + this.numOfPersistentEntries + "'";
                        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, txt + this.toXml(""));
                    }
                } else if (this.log.TRACE) {
                    this.log.trace(this.ME, "getNumOfPersistentEntries_ old (cached) value: '" + oldValue + "' new (real) value: '" + this.numOfPersistentEntries + "'");
                }
                long l = this.numOfPersistentEntries;
                return l;
            }
            catch (XmlBlasterException ex) {
                if (verbose) {
                    throw ex;
                }
                long l = -1L;
                return l;
            }
        }
    }

    public long getNumOfPersistentEntries() {
        try {
            return this.getNumOfPersistentEntries_(true);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "getNumOfEntries, exception: " + ex.getMessage());
            return this.numOfPersistentEntries;
        }
    }

    public long getMaxNumOfEntries() {
        return this.property.getMaxEntries();
    }

    private long getNumOfBytes_() throws XmlBlasterException {
        if (this.numOfBytes > -1L && !this.debug) {
            return this.numOfBytes;
        }
        Object object = this.modificationMonitor;
        synchronized (object) {
            long oldValue = this.numOfBytes;
            this.numOfBytes = this.manager.getNumOfBytes(this.getStorageId().getStrippedId(), this.glob.getStrippedId());
            if (this.debug) {
                if (oldValue != this.numOfBytes && oldValue != -999L) {
                    String txt = "getNumOfBytes: an inconsistency occured between the cached value and the real value of 'numOfPersistentBytes': it was '" + oldValue + "' but should have been '" + this.numOfBytes + "'";
                    throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, txt + this.toXml(""));
                }
            } else if (this.log.TRACE) {
                this.log.warn(this.ME, "getNumOfBytes_ old (cached) value: '" + oldValue + "' new (real) value: '" + this.numOfBytes + "'");
            }
            long l = this.numOfBytes;
            return l;
        }
    }

    public long getNumOfBytes() {
        try {
            return this.getNumOfBytes_();
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "getNumOfBytes, exception: " + ex.getMessage());
            return this.numOfBytes;
        }
    }

    private long getNumOfPersistentBytes_(boolean verbose) throws XmlBlasterException {
        if (this.numOfPersistentBytes > -1L && !this.debug) {
            return this.numOfPersistentBytes;
        }
        Object object = this.modificationMonitor;
        synchronized (object) {
            try {
                long oldValue = this.numOfPersistentBytes;
                this.numOfPersistentBytes = this.manager.getSizeOfPersistents(this.getStorageId().getStrippedId(), this.glob.getStrippedId());
                if (this.debug) {
                    if (oldValue != this.numOfPersistentBytes && oldValue != -999L) {
                        String txt = "getNumOfPersistentBytes: an inconsistency occured between the cached value and the real value of 'numOfPersistentBytes': it was '" + oldValue + "' but should have been '" + this.numOfPersistentBytes + "'";
                        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, txt + this.toXml(""));
                    }
                } else if (this.log.TRACE) {
                    this.log.warn(this.ME, "getNumOfPersistentBytes_ old (cached) value: '" + oldValue + "' new (real) value: '" + this.numOfPersistentBytes + "'");
                }
                long l = this.numOfPersistentBytes;
                return l;
            }
            catch (XmlBlasterException ex) {
                if (verbose) {
                    throw ex;
                }
                long l = -1L;
                return l;
            }
        }
    }

    public long getNumOfPersistentBytes() {
        try {
            return this.getNumOfPersistentBytes_(true);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "getNumOfPersistentBytes, exception: " + ex.getMessage());
            return this.numOfPersistentBytes;
        }
    }

    public long getMaxNumOfBytes() {
        return this.property.getMaxBytes();
    }

    public int update(I_QueueEntry queueEntry) throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "update not implemented");
    }

    public JdbcManagerCommonTable getManager() {
        return this.manager;
    }

    public long clear() {
        try {
            ReturnDataHolder ret = this.manager.deleteFirstEntries(this.getStorageId().getStrippedId(), this.glob.getStrippedId(), -1L, -1L);
            this.numOfEntries = 0L;
            this.numOfBytes = 0L;
            this.numOfPersistentEntries = 0L;
            this.numOfPersistentBytes = 0L;
            if (this.queueSizeListeners != null) {
                this.invokeQueueSizeListener();
            }
            return ret.countEntries;
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "exception: " + ex.getMessage());
            return 0L;
        }
    }

    public long removeHead(I_QueueEntry toEntry) throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeHead not implemented yet");
    }

    public synchronized void shutdown() {
        if (this.log.CALL) {
            this.log.call(this.ME, "shutdown '" + this.storageId + "' (currently the value of 'isDown' is '" + this.isDown + "'");
        }
        if (this.isDown) {
            return;
        }
        this.isDown = true;
        this.manager.unregisterQueue(this);
        this.removeQueueSizeListener(null);
    }

    public boolean isShutdown() {
        return this.isDown;
    }

    public String usage() {
        return "no usage";
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(1000);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<JdbcQueueCommonTablePlugin id='").append(this.getStorageId().getId());
        sb.append("' type='").append(this.getType());
        sb.append("' version='").append(this.getVersion());
        sb.append("' numOfEntries='").append(this.numOfEntries);
        sb.append("' numOfBytes='").append(this.numOfBytes);
        sb.append("'>");
        if (this.property != null) {
            sb.append(this.property.toXml(extraOffset + " "));
        } else {
            sb.append(offset).append("<isDown>").append(this.isDown).append("</isDown>");
        }
        try {
            sb.append(offset).append(" <numOfPersistentsCached>").append(this.numOfPersistentEntries).append("</numOfPersistentsCached>");
            sb.append(offset).append(" <sizeOfPersistentsCached>").append(this.getNumOfPersistentBytes()).append("</sizeOfPersistentsCached>");
            sb.append(offset).append(" <numOfEntriesCached>").append(this.numOfEntries).append("</numOfEntriesCached>");
            sb.append(offset).append(" <numOfBytesCached>").append(this.getNumOfBytes()).append("</numOfBytesCached>");
            sb.append(offset).append(" <numOfEntries>").append(this.getNumOfEntries_()).append("</numOfEntries>");
            sb.append(offset).append(" <numOfBytes>").append(this.getNumOfBytes_()).append("</numOfBytes>");
            sb.append(offset).append(" <numOfPersistents>").append(this.getNumOfPersistentEntries_(false)).append("</numOfPersistents>");
            sb.append(offset).append(" <sizeOfPersistents>").append(this.getNumOfPersistentBytes_(false)).append("</sizeOfPersistents>");
        }
        catch (XmlBlasterException e) {
            // empty catch block
        }
        sb.append(offset).append("</JdbcQueueCommonTablePlugin>");
        return sb.toString();
    }

    public void init(Global glob, PluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
    }

    public String getType() {
        return "JDBC";
    }

    public String getVersion() {
        return "1.0";
    }

    public PluginInfo getInfo() {
        return this.pluginInfo;
    }

    public void destroy() throws XmlBlasterException {
        this.clear();
        this.shutdown();
        this.property = null;
        this.manager.cleanUp(this.storageId.getStrippedId(), this.glob.getStrippedId());
    }

    public I_MapEntry get(long uniqueId) throws XmlBlasterException {
        long[] idArr = new long[]{uniqueId};
        ArrayList list = this.manager.getEntries(this.getStorageId(), this.glob.getStrippedId(), idArr);
        if (list.size() < 1) {
            return null;
        }
        return (I_MapEntry)list.get(0);
    }

    public I_MapEntry[] getAll() throws XmlBlasterException {
        ArrayList list = this.peek(-1, -1L);
        return list.toArray(new I_MapEntry[list.size()]);
    }

    public int put(I_MapEntry mapEntry) throws XmlBlasterException {
        if (mapEntry == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "put(I_MapEntry=" + mapEntry + ")");
        }
        Object object = this.modificationMonitor;
        synchronized (object) {
            if (this.put((I_Entry)mapEntry)) {
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
    }

    public int remove(I_MapEntry mapEntry) throws XmlBlasterException {
        int num = this.removeRandom(mapEntry);
        Object object = this.modificationMonitor;
        synchronized (object) {
        }
        return num;
    }

    public I_MapEntry removeOldest() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeOldest is not implemented");
    }

    public boolean registerStorageProblemListener(I_StorageProblemListener listener) {
        if (this.manager == null) {
            return false;
        }
        return this.manager.registerStorageProblemListener(listener);
    }

    public boolean unRegisterStorageProblemListener(I_StorageProblemListener listener) {
        if (this.manager == null || listener == null) {
            return false;
        }
        return this.manager.unRegisterStorageProblemListener(listener);
    }

    public I_MapEntry change(I_MapEntry entry, I_ChangeCallback callback) throws XmlBlasterException {
        JdbcQueueCommonTablePlugin jdbcQueueCommonTablePlugin = this;
        synchronized (jdbcQueueCommonTablePlugin) {
            long oldSizeInBytes = entry.getSizeInBytes();
            I_MapEntry newEntry = entry;
            if (callback != null) {
                newEntry = callback.changeEntry(entry);
            }
            if (oldSizeInBytes != newEntry.getSizeInBytes()) {
                throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME + ".change", "the size of the entry '" + entry.getUniqueId() + "' has changed from '" + oldSizeInBytes + "' to '" + newEntry.getSizeInBytes() + "'. This is not allowed");
            }
            this.manager.modifyEntry(this.getStorageId().getStrippedId(), this.glob.getStrippedId(), newEntry);
            I_MapEntry i_MapEntry = newEntry;
            return i_MapEntry;
        }
    }

    public I_MapEntry change(long uniqueId, I_ChangeCallback callback) throws XmlBlasterException {
        JdbcQueueCommonTablePlugin jdbcQueueCommonTablePlugin = this;
        synchronized (jdbcQueueCommonTablePlugin) {
            I_MapEntry oldEntry = this.get(uniqueId);
            I_MapEntry i_MapEntry = this.change(oldEntry, callback);
            return i_MapEntry;
        }
    }

    public void addQueueSizeListener(I_QueueSizeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(this.ME + ": addQueueSizeListener(null) is not allowed");
        }
        Object object = this.queueSizeListenersSync;
        synchronized (object) {
            if (this.queueSizeListeners == null) {
                this.queueSizeListeners = new ArrayList();
            }
            this.queueSizeListeners.add(listener);
        }
    }

    public void removeQueueSizeListener(I_QueueSizeListener listener) {
        Object object = this.queueSizeListenersSync;
        synchronized (object) {
            if (listener == null) {
                this.queueSizeListeners = null;
            } else {
                if (!((AbstractCollection)this.queueSizeListeners).remove(listener)) {
                    this.log.warn(this.ME, "removeQueueSizeListener: could not remove listener '" + listener.toString() + "' since not registered");
                }
                if (this.queueSizeListeners.size() == 0) {
                    this.queueSizeListeners = null;
                }
            }
        }
    }

    private final void invokeQueueSizeListener() {
        if (this.queueSizeListeners != null) {
            I_QueueSizeListener[] listeners = null;
            Object object = this.queueSizeListenersSync;
            synchronized (object) {
                listeners = this.queueSizeListeners.toArray(new I_QueueSizeListener[this.queueSizeListeners.size()]);
            }
            int i = 0;
            while (i < listeners.length) {
                block7: {
                    try {
                        listeners[i].changed(this, this.getNumOfEntries(), this.getNumOfBytes());
                    }
                    catch (NullPointerException e) {
                        if (!this.log.TRACE) break block7;
                        this.log.trace(this.ME, "invokeQueueSizeListener() call is not possible as another thread has removed queueSizeListeners, this is OK to prevent a synchronize.");
                    }
                }
                ++i;
            }
        }
    }

    public boolean hasQueueSizeListener(I_QueueSizeListener listener) {
        if (listener == null) {
            return this.queueSizeListeners != null;
        }
        return this.queueSizeListeners.contains(listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

