/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.queue.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.queue.jdbc.JdbcConnectionPool;

class PreparedQuery {
    public static final String ME = "PreparedQuery";
    private LogChannel log;
    Connection conn;
    private Statement st;
    ResultSet rs;
    private JdbcConnectionPool pool;
    private boolean isClosed = true;
    private boolean isException = false;

    /*
     * Loose catch block
     */
    public PreparedQuery(JdbcConnectionPool pool, String request, boolean isAutoCommit, LogChannel log, int fetchSize) throws SQLException, XmlBlasterException {
        this.log = log;
        this.pool = pool;
        this.isClosed = false;
        if (this.log.CALL) {
            this.log.call(ME, "Constructor. autocommit is '" + isAutoCommit + "'");
        }
        try {
            this.conn = this.pool.getConnection();
            if (this.conn.getAutoCommit() != isAutoCommit) {
                this.conn.setAutoCommit(isAutoCommit);
            }
            this.st = this.conn.createStatement();
            this.st.setQueryTimeout(this.pool.getQueryTimeout());
            this.rs = this.st.executeQuery(request);
        }
        catch (XmlBlasterException ex) {
            block32: {
                block31: {
                    String additionalInfo;
                    block30: {
                        additionalInfo = "request='" + request + "' isAutocommit='" + isAutoCommit + "' fetchSize='" + fetchSize + "' ";
                        this.log.trace(ME, "Constructor. Exception. " + additionalInfo + ": " + ex.getMessage());
                        if (this.conn == null) break block32;
                        if (this.conn.getAutoCommit()) break block30;
                        this.conn.rollback();
                        this.conn.setAutoCommit(true);
                    }
                    Object var10_9 = null;
                    try {
                        if (this.st != null) {
                            this.st.close();
                        }
                        break block31;
                    }
                    catch (Throwable ex3) {
                        this.log.warn(ME, "constructor exception occured when closing statement " + additionalInfo + ": " + ex3.toString());
                    }
                    break block31;
                    {
                        catch (Throwable ex2) {
                            this.log.warn(ME, "constructor exception occured when rolling back " + additionalInfo + ": " + ex2.toString());
                            Object var10_10 = null;
                            try {
                                if (this.st != null) {
                                    this.st.close();
                                }
                                break block31;
                            }
                            catch (Throwable ex3) {
                                this.log.warn(ME, "constructor exception occured when closing statement " + additionalInfo + ": " + ex3.toString());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        try {
                            if (this.st != null) {
                                this.st.close();
                            }
                        }
                        catch (Throwable ex3) {
                            this.log.warn(ME, "constructor exception occured when closing statement " + additionalInfo + ": " + ex3.toString());
                        }
                        throw throwable;
                    }
                }
                if (this.conn != null) {
                    this.pool.releaseConnection(this.conn);
                }
                this.conn = null;
            }
            this.isClosed = true;
            throw ex;
        }
        catch (SQLException ex) {
            String additionalInfo = "request='" + request + "' isAutocommit='" + isAutoCommit + "' fetchSize='" + fetchSize + "' ";
            this.log.trace(ME, "Constructor. " + additionalInfo + " SQLException: " + ex.getMessage());
            if (this.conn != null) {
                try {
                    if (!this.conn.getAutoCommit()) {
                        this.conn.rollback();
                        this.conn.setAutoCommit(true);
                    }
                    if (this.st != null) {
                        this.st.close();
                    }
                }
                catch (Throwable ex2) {
                    this.log.warn(ME, "constructor: exception occured when handling SQL Exception: " + additionalInfo + ex2.toString());
                }
                if (this.conn != null) {
                    this.pool.releaseConnection(this.conn);
                }
                this.conn = null;
            }
            this.isClosed = true;
            throw ex;
        }
        catch (Throwable ex) {
            String additionalInfo = "request='" + request + "' isAutocommit='" + isAutoCommit + "' fetchSize='" + fetchSize + "' ";
            this.log.warn(ME, "Constructor. Throwable: " + additionalInfo + ex.toString());
            if (this.conn != null) {
                try {
                    if (!this.conn.getAutoCommit()) {
                        this.conn.rollback();
                        this.conn.setAutoCommit(true);
                    }
                    if (this.st != null) {
                        this.st.close();
                    }
                }
                catch (Throwable ex2) {
                    this.log.warn(ME, "constructor: " + additionalInfo + " exception occured when handling SQL Exception: " + ex2.toString());
                }
                if (this.conn != null) {
                    this.pool.releaseConnection(this.conn);
                }
                this.conn = null;
            }
            this.isClosed = true;
            throw new XmlBlasterException(this.pool.getGlobal(), ErrorCode.RESOURCE_DB_UNKNOWN, "PreparedQuery.constructor " + additionalInfo, "", ex);
        }
    }

    public void closeStatement() {
        try {
            if (this.st != null) {
                this.st.close();
                this.st = null;
            }
        }
        catch (Throwable ex) {
            this.log.warn(ME, "closeStatement: exception when closing statement:" + ex.getMessage());
        }
    }

    public final ResultSet inTransactionRequest(String request) throws XmlBlasterException, SQLException {
        this.log.call(ME, "inTransactionRequest: " + request);
        if (this.conn.getAutoCommit()) {
            throw new XmlBlasterException(this.pool.getGlobal(), ErrorCode.INTERNAL_UNKNOWN, ME, "inTransactionRequest should not be called if autocommit is on");
        }
        try {
            if (this.st != null) {
                this.st.close();
            }
            this.st = this.conn.createStatement();
            this.st.setQueryTimeout(this.pool.getQueryTimeout());
            this.rs = this.st.executeQuery(request);
        }
        catch (SQLException ex) {
            this.log.trace(ME, "inTransactionRequest. Exception: " + ex.getMessage());
            this.isException = true;
            this.close();
            throw ex;
        }
        catch (Throwable ex) {
            this.log.warn(ME, "inTransactionRequest. Throwable: " + ex.toString());
            this.close();
            throw new XmlBlasterException(this.pool.getGlobal(), ErrorCode.RESOURCE_DB_UNKNOWN, "PreparedQuery.inTransactionRequest", "", ex);
        }
        return this.rs;
    }

    public PreparedQuery(JdbcConnectionPool pool, String request, LogChannel log, int fetchSize) throws SQLException, XmlBlasterException {
        this(pool, request, false, log, fetchSize);
    }

    public final void close() throws XmlBlasterException, SQLException {
        if (this.isClosed) {
            return;
        }
        if (!this.conn.getAutoCommit()) {
            if (this.log.TRACE) {
                this.log.trace(ME, "close with autocommit 'false'");
            }
            try {
                if (this.isException) {
                    this.log.warn(ME, "close with autocommit 'false': rollback");
                    this.conn.rollback();
                } else {
                    this.conn.commit();
                }
            }
            catch (Throwable ex) {
                this.log.warn(ME, "close: exception when closing statement: " + ex.toString());
            }
            try {
                this.conn.setAutoCommit(true);
            }
            catch (Throwable ex) {
                this.log.warn(ME, "close: exception when setAutoCommit(true): " + ex.toString());
            }
        }
        try {
            if (this.st != null) {
                this.st.close();
                this.st = null;
            }
        }
        catch (Throwable ex) {
            this.log.warn(ME, "close: exception when closing statement: " + ex.toString());
        }
        if (this.conn != null) {
            this.pool.releaseConnection(this.conn);
        }
        this.conn = null;
        this.isClosed = true;
    }

    public void finalize() {
        try {
            if (!this.isClosed) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

