/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.queue.ram;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.I_QueuePutListener;
import org.xmlBlaster.util.queue.I_QueueSizeListener;
import org.xmlBlaster.util.queue.I_StoragePlugin;
import org.xmlBlaster.util.queue.I_StorageProblemListener;
import org.xmlBlaster.util.queue.ReturnDataHolder;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queue.ram.MsgComparator;

public final class RamQueuePlugin
implements I_Queue,
I_StoragePlugin {
    private String ME = "RamQueuePlugin";
    private StorageId storageId;
    private boolean notifiedAboutAddOrRemove = false;
    private TreeSet storage;
    private QueuePropertyBase property;
    private Global glob;
    private LogChannel log;
    private I_QueuePutListener putListener;
    private boolean isShutdown = false;
    private final I_QueueEntry[] DUMMY_ARR = new I_QueueEntry[0];
    private MsgComparator comparator;
    private final int MAX_PRIO = 9;
    private long sizeInBytes = 0L;
    private long persistentSizeInBytes = 0L;
    private long numOfPersistentEntries = 0L;
    private PluginInfo pluginInfo = null;
    private ArrayList queueSizeListeners;
    private Object queueSizeListenersSync = new Object();

    public void initialize(StorageId uniqueQueueId, Object userData) throws XmlBlasterException {
        this.property = null;
        this.setProperties(userData);
        this.glob = this.property.getGlobal();
        this.log = this.glob.getLog("queue");
        this.storageId = uniqueQueueId;
        if (this.storageId == null || this.glob == null) {
            Thread.dumpStack();
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "Illegal arguments in RamQueuePlugin constructor: storageId=" + this.storageId);
        }
        this.ME = "RamQueuePlugin-" + this.storageId.getId();
        long maxEntries = this.property.getMaxEntries();
        if (maxEntries > Integer.MAX_VALUE) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "initialize: The maximum number of messages is too big");
        }
        this.comparator = new MsgComparator();
        this.storage = new TreeSet(this.comparator);
        this.numOfPersistentEntries = 0L;
        this.persistentSizeInBytes = 0L;
        this.isShutdown = false;
    }

    public void setProperties(Object userData) throws XmlBlasterException {
        QueuePropertyBase newProp;
        if (userData == null) {
            return;
        }
        try {
            newProp = (QueuePropertyBase)userData;
        }
        catch (Throwable e) {
            throw XmlBlasterException.convert(this.glob, this.ME, "Can't configure queue, your properties are invalid", e);
        }
        this.property = newProp;
    }

    public Object getProperties() {
        return this.property;
    }

    public boolean isTransient() {
        return true;
    }

    public void setNotifiedAboutAddOrRemove(boolean notify) {
        this.notifiedAboutAddOrRemove = notify;
    }

    public boolean isNotifiedAboutAddOrRemove() {
        return this.notifiedAboutAddOrRemove;
    }

    public void addPutListener(I_QueuePutListener l) {
        if (l == null) {
            throw new IllegalArgumentException(this.ME + ": addPustListener(null) is not allowed");
        }
        if (this.putListener != null) {
            throw new IllegalArgumentException(this.ME + ": addPustListener() failed, there is a listener registered already");
        }
        this.putListener = l;
    }

    public void removePutListener(I_QueuePutListener l) {
        this.putListener = null;
    }

    public long[] getEntryReferences() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "getEntryReferences() is not implemented");
    }

    public ArrayList getEntries() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "getEntries() is not implemented");
    }

    public void finalize() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "finalize - garbage collected");
        }
    }

    public StorageId getStorageId() {
        return this.storageId;
    }

    public void shutdown() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Entering shutdown(" + this.storage.size() + ")");
        }
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            if (this.storage.size() > 0) {
                String reason = "Shutting down RAM queue which contains " + this.storage.size() + " messages";
                if (this.log.TRACE) {
                    this.log.trace(this.ME, reason);
                }
            }
            this.isShutdown = true;
            this.removeQueueSizeListener(null);
        }
        if (this.log.CALL) {
            this.log.call(this.ME, "shutdown() of queue " + this.getStorageId() + " which contains " + this.storage.size() + "messages");
        }
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public long clear() {
        long ret = 0L;
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            ret = this.storage.size();
            I_QueueEntry[] entries = this.storage.toArray(new I_QueueEntry[this.storage.size()]);
            int ii = 0;
            while (ii < entries.length) {
                entries[ii].setStored(false);
                if (this.notifiedAboutAddOrRemove) {
                    entries[ii].removed(this.storageId);
                }
                ++ii;
            }
            this.storage.clear();
            this.sizeInBytes = 0L;
            this.persistentSizeInBytes = 0L;
            this.numOfPersistentEntries = 0L;
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    public int remove() throws XmlBlasterException {
        return (int)this.remove(1L, -1L);
    }

    public long remove(long numOfEntries, long numOfBytes) throws XmlBlasterException {
        if (numOfEntries > Integer.MAX_VALUE) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "remove: too many entries to remove " + numOfEntries);
        }
        long size = 0L;
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            ReturnDataHolder ret = this.genericPeek((int)numOfEntries, numOfBytes, 0, 9);
            ArrayList elementsToDelete = ret.list;
            int i = 0;
            while (i < elementsToDelete.size()) {
                I_QueueEntry entry = (I_QueueEntry)elementsToDelete.get(i);
                if (entry.isPersistent()) {
                    --this.numOfPersistentEntries;
                    this.persistentSizeInBytes -= entry.getSizeInBytes();
                }
                entry.setStored(false);
                if (this.notifiedAboutAddOrRemove) {
                    entry.removed(this.storageId);
                }
                ++i;
            }
            this.storage.removeAll(elementsToDelete);
            this.sizeInBytes -= ret.countBytes;
            size = elementsToDelete.size();
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return size;
    }

    public long removeWithPriority(long numOfEntries, long numOfBytes, int minPriority, int maxPriority) throws XmlBlasterException {
        if (numOfEntries > Integer.MAX_VALUE) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, this.ME, "remove: too many entries to remove " + numOfEntries);
        }
        ArrayList elementsToRemove = this.peekWithPriority((int)numOfEntries, numOfBytes, minPriority, maxPriority);
        boolean[] ret = this.removeRandom(elementsToRemove.toArray(new I_Entry[elementsToRemove.size()]));
        long count = 0L;
        int i = 0;
        while (i < ret.length) {
            if (ret[i]) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int removeTransient() throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeTransient() is not implemented");
    }

    public I_QueueEntry peek() {
        if (this.getNumOfEntries() < 1L) {
            return null;
        }
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            I_QueueEntry i_QueueEntry = (I_QueueEntry)this.storage.first();
            return i_QueueEntry;
        }
    }

    public ArrayList peekWithPriority(int numOfEntries, long numOfBytes, int minPrio, int maxPrio) throws XmlBlasterException {
        return this.genericPeek((int)numOfEntries, (long)numOfBytes, (int)minPrio, (int)maxPrio).list;
    }

    private ReturnDataHolder genericPeek(int numOfEntries, long numOfBytes, int minPrio, int maxPrio) throws XmlBlasterException {
        ReturnDataHolder ret = new ReturnDataHolder();
        long currentSizeInBytes = 0L;
        if (this.getNumOfEntries() < 1L) {
            return ret;
        }
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            Iterator iter = this.storage.iterator();
            while (iter.hasNext() && (ret.countEntries < (long)numOfEntries || numOfEntries < 0)) {
                I_QueueEntry entry = (I_QueueEntry)iter.next();
                currentSizeInBytes = entry.getSizeInBytes();
                if (ret.countBytes + currentSizeInBytes >= numOfBytes && ret.countEntries > 0L && numOfBytes > -1L) break;
                int prio = entry.getPriority();
                if (minPrio < 0) {
                    maxPrio = minPrio = prio;
                }
                if (prio < minPrio) break;
                if (prio > maxPrio) continue;
                ret.countBytes += currentSizeInBytes;
                ret.list.add(entry);
                ++ret.countEntries;
            }
        }
        return ret;
    }

    public ArrayList peek(int numOfEntries, long numOfBytes) throws XmlBlasterException {
        return this.genericPeek((int)numOfEntries, (long)numOfBytes, (int)0, (int)9).list;
    }

    public ArrayList peekSamePriority(int numOfEntries, long numOfBytes) throws XmlBlasterException {
        return this.genericPeek((int)numOfEntries, (long)numOfBytes, (int)-1, (int)-1).list;
    }

    public ArrayList peekWithLimitEntry(I_QueueEntry limitEntry) throws XmlBlasterException {
        if (limitEntry == null) {
            return new ArrayList();
        }
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            ArrayList<I_QueueEntry> arrayList = new ArrayList<I_QueueEntry>(this.storage.headSet(limitEntry));
            return arrayList;
        }
    }

    public long removeWithLimitEntry(I_QueueEntry limitEntry, boolean inclusive) throws XmlBlasterException {
        long ret = 0L;
        if (limitEntry == null) {
            return ret;
        }
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            SortedSet<I_QueueEntry> set = this.storage.headSet(limitEntry);
            ret = set.size();
            this.storage.removeAll(set);
            if (inclusive && this.storage.remove(limitEntry)) {
                ++ret;
            }
            long l = ret;
            return l;
        }
    }

    public long getNumOfEntries() {
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            long l = this.storage.size();
            return l;
        }
    }

    public long getNumOfPersistentEntries() {
        return this.numOfPersistentEntries;
    }

    public long getMaxNumOfEntries() {
        return this.property.getMaxEntries();
    }

    public long getNumOfBytes() {
        return this.sizeInBytes;
    }

    public long getNumOfPersistentBytes() {
        return this.persistentSizeInBytes;
    }

    public long getSynchronizedNumOfBytes() {
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            Iterator iter = this.storage.iterator();
            long sum = 0L;
            while (iter.hasNext()) {
                sum += ((I_QueueEntry)iter.next()).getSizeInBytes();
            }
            long l = sum;
            return l;
        }
    }

    public long getMaxNumOfBytes() {
        return this.property.getMaxBytes();
    }

    public int removeRandom(I_Entry entry) throws XmlBlasterException {
        I_Entry[] arr = new I_Entry[]{entry};
        if (this.removeRandom(arr)[0]) {
            return 1;
        }
        return 0;
    }

    public boolean[] removeRandom(I_Entry[] queueEntries) throws XmlBlasterException {
        if (queueEntries == null || queueEntries.length == 0) {
            return new boolean[0];
        }
        boolean[] ret = new boolean[queueEntries.length];
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            if (this.storage.size() == 0) {
                boolean[] blArray = ret;
                return blArray;
            }
            int j = 0;
            while (j < queueEntries.length) {
                if (queueEntries[j] != null) {
                    if (this.notifiedAboutAddOrRemove) {
                        queueEntries[j].removed(this.storageId);
                    }
                    queueEntries[j].setStored(false);
                    if (this.storage.remove(queueEntries[j])) {
                        ret[j] = true;
                        I_Entry entry = queueEntries[j];
                        this.sizeInBytes -= entry.getSizeInBytes();
                        if (entry.isPersistent()) {
                            this.persistentSizeInBytes -= entry.getSizeInBytes();
                            --this.numOfPersistentEntries;
                        }
                    }
                }
                ++j;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    public I_QueueEntry take() throws XmlBlasterException {
        ArrayList list = this.take(1, -1L);
        if (list == null || list.size() < 1) {
            return null;
        }
        return (I_QueueEntry)list.get(0);
    }

    public ArrayList take(int numOfEntries, long numOfBytes) throws XmlBlasterException {
        return this.takeWithPriority(numOfEntries, numOfBytes, 0, 9);
    }

    public ArrayList takeSamePriority(int numOfEntries, long numOfBytes) throws XmlBlasterException {
        return this.takeWithPriority(numOfEntries, numOfBytes, -1, -1);
    }

    public ArrayList takeWithPriority(int numOfEntries, long numOfBytes, int minPriority, int maxPriority) throws XmlBlasterException {
        if (this.isShutdown) {
            this.log.warn(this.ME, "The queue is shutdown, no message access is possible.");
            if (this.log.TRACE) {
                Thread.dumpStack();
            }
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "The queue is shutdown, no message access is possible.");
        }
        ArrayList ret = null;
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            ret = this.genericPeek((int)numOfEntries, (long)numOfBytes, (int)minPriority, (int)maxPriority).list;
            int i = 0;
            while (i < ret.size()) {
                I_QueueEntry entry = (I_QueueEntry)ret.get(i);
                if (this.notifiedAboutAddOrRemove) {
                    entry.removed(this.storageId);
                }
                entry.setStored(false);
                if (this.storage.remove(entry)) {
                    this.sizeInBytes -= entry.getSizeInBytes();
                    if (entry.isPersistent()) {
                        --this.numOfPersistentEntries;
                        this.persistentSizeInBytes -= entry.getSizeInBytes();
                    }
                }
                ++i;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    private final boolean isInsideRange(int numEntries, int maxNumEntries, long numBytes, long maxNumBytes) {
        if (maxNumEntries < 0) {
            if (maxNumBytes < 0L) {
                return true;
            }
            return numBytes < maxNumBytes;
        }
        if (maxNumBytes < 0L) {
            return numEntries < maxNumEntries;
        }
        return numEntries < maxNumEntries || numBytes < maxNumBytes;
    }

    public ArrayList takeLowest(int numOfEntries, long numOfBytes, I_QueueEntry limitEntry, boolean leaveOne) throws XmlBlasterException {
        return this.takeOrPeekLowest(numOfEntries, numOfBytes, limitEntry, leaveOne, true);
    }

    public ArrayList peekLowest(int numOfEntries, long numOfBytes, I_QueueEntry limitEntry, boolean leaveOne) throws XmlBlasterException {
        return this.takeOrPeekLowest(numOfEntries, numOfBytes, limitEntry, leaveOne, false);
    }

    private ArrayList takeOrPeekLowest(int numOfEntries, long numOfBytes, I_QueueEntry limitEntry, boolean leaveOne, boolean doDelete) throws XmlBlasterException {
        ArrayList<I_QueueEntry> ret = null;
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            LinkedList list = new LinkedList(this.storage);
            ListIterator iter = list.listIterator(list.size());
            int count = 0;
            long currentSizeInBytes = 0L;
            long totalSizeInBytes = 0L;
            ret = new ArrayList<I_QueueEntry>();
            while (iter.hasPrevious()) {
                I_QueueEntry entry = (I_QueueEntry)iter.previous();
                currentSizeInBytes = entry.getSizeInBytes();
                if (!this.isInsideRange(count, numOfEntries, totalSizeInBytes, numOfBytes)) break;
                totalSizeInBytes += currentSizeInBytes;
                if (limitEntry != null && this.comparator.compare(limitEntry, entry) >= 0) break;
                ret.add(entry);
                ++count;
            }
            if (leaveOne && this.storage.size() == ret.size()) {
                ret.remove(ret.size() - 1);
            }
            if (doDelete) {
                int i = 0;
                while (i < ret.size()) {
                    I_QueueEntry entry = (I_QueueEntry)ret.get(i);
                    if (this.notifiedAboutAddOrRemove) {
                        entry.removed(this.storageId);
                    }
                    entry.setStored(false);
                    if (this.storage.remove(entry)) {
                        this.sizeInBytes -= entry.getSizeInBytes();
                        if (entry.isPersistent()) {
                            --this.numOfPersistentEntries;
                            this.persistentSizeInBytes -= entry.getSizeInBytes();
                        }
                    }
                    ++i;
                }
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        return ret;
    }

    public void put(I_QueueEntry entry, boolean ignorePutInterceptor) throws XmlBlasterException {
        if (entry == null) {
            return;
        }
        if (this.isShutdown) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "The queue is shutdown, put() of message " + entry.getUniqueId() + " failed");
            }
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "The queue is shutdown, put() of message " + entry.getUniqueId() + " failed");
        }
        if (this.putListener != null && !ignorePutInterceptor && !this.putListener.putPre(entry)) {
            return;
        }
        if (this.getNumOfEntries() > this.property.getMaxEntries()) {
            String reason = "Queue overflow (number of entries), " + this.property.getMaxEntries() + " messages are in queue, try increasing '" + this.property.getPropName("maxEntries") + "' on client login.";
            if (this.log.TRACE) {
                this.log.trace(this.ME, reason);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, reason);
        }
        if (this.getNumOfBytes() > this.property.getMaxBytes()) {
            String reason = "Queue overflow, " + this.getNumOfBytes() + " bytes are in queue, try increasing '" + this.property.getPropName("maxBytes") + "' on client login.";
            if (this.log.TRACE) {
                this.log.trace(this.ME, reason);
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, reason);
        }
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            if (!this.storage.contains(entry)) {
                if (this.storage.add(entry)) {
                    entry.setStored(true);
                    this.sizeInBytes += entry.getSizeInBytes();
                    if (entry.isPersistent()) {
                        ++this.numOfPersistentEntries;
                        this.persistentSizeInBytes += entry.getSizeInBytes();
                    }
                    if (this.notifiedAboutAddOrRemove) {
                        entry.added(this.storageId);
                    }
                }
            } else {
                this.log.error(this.ME, "Ignoring IDENTICAL uniqueId=" + entry.getUniqueId());
                Thread.dumpStack();
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        if (this.putListener != null && !ignorePutInterceptor) {
            this.putListener.putPost(entry);
        }
    }

    public void put(I_QueueEntry[] msgArr, boolean ignorePutInterceptor) throws XmlBlasterException {
        if (msgArr == null) {
            return;
        }
        if (this.isShutdown) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "The queue is shutdown, put() of " + msgArr.length + " messages failed");
            }
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "The queue is shutdown, put() of " + msgArr.length + " messages failed");
        }
        if (this.putListener != null && !ignorePutInterceptor && !this.putListener.putPre(msgArr)) {
            return;
        }
        if (this.getNumOfEntries() > this.property.getMaxEntries()) {
            String reason = "Queue overflow (num of entries), " + this.property.getMaxEntries() + " messages are in queue, try increasing '" + this.property.getPropName("maxEntries") + "' on client login.";
            if (this.log.TRACE) {
                this.log.trace(this.ME, reason + this.toXml());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, reason);
        }
        if (this.getNumOfBytes() > this.property.getMaxBytes()) {
            String reason = "Queue overflow, " + this.getNumOfBytes() + " bytes are in queue, try increasing '" + this.property.getPropName("maxBytes") + "' on client login.";
            if (this.log.TRACE) {
                this.log.trace(this.ME, reason + this.toXml());
            }
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, this.ME, reason);
        }
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            int i = 0;
            while (i < msgArr.length) {
                I_QueueEntry entry = msgArr[i];
                if (!this.storage.contains(entry) && this.storage.add(entry)) {
                    entry.setStored(true);
                    this.sizeInBytes += entry.getSizeInBytes();
                    if (entry.isPersistent()) {
                        ++this.numOfPersistentEntries;
                        this.persistentSizeInBytes += entry.getSizeInBytes();
                    }
                    if (this.notifiedAboutAddOrRemove) {
                        entry.added(this.storageId);
                    }
                }
                ++i;
            }
        }
        if (this.queueSizeListeners != null) {
            this.invokeQueueSizeListener();
        }
        if (this.putListener != null && !ignorePutInterceptor) {
            this.putListener.putPost(msgArr);
        }
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<RamQueuePlugin id='").append(this.getStorageId().getId());
        sb.append("' type='").append(this.getType());
        sb.append("' version='").append(this.getVersion());
        sb.append("' numOfEntries='").append(this.getNumOfEntries());
        sb.append("' numOfBytes='").append(this.getNumOfBytes());
        sb.append("' numOfPersistentEntries='").append(this.getNumOfPersistentEntries());
        sb.append("' numOfPersistentBytes='").append(this.getNumOfPersistentBytes());
        sb.append("'>");
        sb.append(this.property.toXml(extraOffset + " "));
        sb.append(offset).append("</RamQueuePlugin>");
        return sb.toString();
    }

    public long removeHead(I_QueueEntry toEntry) throws XmlBlasterException {
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "removeHead() is not implemented");
    }

    public void destroy() throws XmlBlasterException {
        RamQueuePlugin ramQueuePlugin = this;
        synchronized (ramQueuePlugin) {
            this.storage.clear();
        }
        this.shutdown();
        this.property = null;
    }

    public String usage() {
        return "no usage";
    }

    public void init(Global glob, PluginInfo pluginInfo) {
        this.pluginInfo = pluginInfo;
    }

    public String getType() {
        return "RAM";
    }

    public String getVersion() {
        return "1.0";
    }

    public PluginInfo getInfo() {
        return this.pluginInfo;
    }

    public boolean registerStorageProblemListener(I_StorageProblemListener listener) {
        return false;
    }

    public boolean unRegisterStorageProblemListener(I_StorageProblemListener listener) {
        return false;
    }

    public void addQueueSizeListener(I_QueueSizeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(this.ME + ": addQueueSizeListener(null) is not allowed");
        }
        Object object = this.queueSizeListenersSync;
        synchronized (object) {
            if (this.queueSizeListeners == null) {
                this.queueSizeListeners = new ArrayList();
            }
            this.queueSizeListeners.add(listener);
        }
    }

    public void removeQueueSizeListener(I_QueueSizeListener listener) {
        Object object = this.queueSizeListenersSync;
        synchronized (object) {
            if (listener == null) {
                this.queueSizeListeners = null;
            } else {
                if (!((AbstractCollection)this.queueSizeListeners).remove(listener)) {
                    this.log.warn(this.ME, "removeQueueSizeListener: could not remove listener '" + listener.toString() + "' since not registered");
                }
                if (this.queueSizeListeners.size() == 0) {
                    this.queueSizeListeners = null;
                }
            }
        }
    }

    private final void invokeQueueSizeListener() {
        if (this.queueSizeListeners != null) {
            I_QueueSizeListener[] listeners = null;
            Object object = this.queueSizeListenersSync;
            synchronized (object) {
                listeners = this.queueSizeListeners.toArray(new I_QueueSizeListener[this.queueSizeListeners.size()]);
            }
            int i = 0;
            while (i < listeners.length) {
                block7: {
                    try {
                        listeners[i].changed(this, this.getNumOfEntries(), this.getNumOfBytes());
                    }
                    catch (NullPointerException e) {
                        if (!this.log.TRACE) break block7;
                        this.log.trace(this.ME, "invokeQueueSizeListener() call is not possible as another thread has removed queueSizeListeners, this is OK to prevent a synchronize.");
                    }
                }
                ++i;
            }
        }
    }

    public boolean hasQueueSizeListener(I_QueueSizeListener listener) {
        if (listener == null) {
            return this.queueSizeListeners != null;
        }
        return this.queueSizeListeners.contains(listener);
    }
}

