/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.queuemsg;

import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.StorageId;

public abstract class MsgQueueEntry
implements I_QueueEntry,
Cloneable {
    private static final String ME = "MsgQueueEntry";
    protected transient Global glob;
    protected transient LogChannel log;
    protected transient boolean wantReturnObj = true;
    protected transient Object returnObj;
    protected transient MsgQueueEntry refToCloneOrigin;
    private String logId;
    protected final StorageId storageId;
    protected int redeliverCounter = 0;
    protected final Timestamp uniqueIdTimestamp;
    protected final PriorityEnum priority;
    protected boolean persistent;
    protected final String entryType;
    private transient boolean stored = false;
    protected final String uniqueIdString;

    public MsgQueueEntry(Global glob, MethodName methodName, PriorityEnum priority, StorageId storageId, boolean persistent) {
        this(glob, methodName.toString(), priority, null, storageId, persistent);
    }

    public MsgQueueEntry(Global glob, String entryType, PriorityEnum priority, StorageId storageId, boolean persistent) {
        this(glob, entryType, priority, null, storageId, persistent);
    }

    public MsgQueueEntry(Global glob, String entryType, PriorityEnum priority, Timestamp timestamp, StorageId storageId, boolean persistent) {
        this.uniqueIdTimestamp = timestamp == null ? new Timestamp() : timestamp;
        this.uniqueIdString = "" + this.uniqueIdTimestamp.getTimestamp();
        if (entryType == null || priority == null || glob == null || storageId == null) {
            glob.getLog("dispatch").error(ME, "Invalid constructor parameter");
            Thread.dumpStack();
            throw new IllegalArgumentException("MsgQueueEntry: Invalid constructor parameter");
        }
        this.glob = glob;
        this.log = glob.getLog("dispatch");
        this.entryType = entryType;
        this.priority = priority;
        this.storageId = storageId;
        this.persistent = persistent;
    }

    public final void setGlobal(Global global) {
        this.glob = global;
        this.log = this.glob.getLog("dispatch");
    }

    public void finalize() {
        if (this.log.TRACE) {
            this.log.trace(ME, "finalize - garbage collect");
        }
    }

    public int getPriority() {
        return this.priority.getInt();
    }

    public final PriorityEnum getPriorityEnum() {
        return this.priority;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public long getUniqueId() {
        return this.uniqueIdTimestamp.getTimestamp();
    }

    public Long getUniqueIdLong() {
        return this.uniqueIdTimestamp.getTimestampLong();
    }

    public abstract boolean isExpired();

    public abstract boolean isDestroyed();

    public abstract boolean isInternal();

    public abstract SessionName getSender();

    public abstract SessionName getReceiver();

    public abstract String getKeyOid();

    public final StorageId getStorageId() {
        return this.storageId;
    }

    public final void incrRedeliverCounter() {
        ++this.redeliverCounter;
    }

    public final int getRedeliverCounter() {
        return this.redeliverCounter;
    }

    public long getSizeInBytes() {
        return 100L;
    }

    public final int compare(I_QueueEntry m2) {
        int diff = m2.getPriority() - this.getPriority();
        if (diff != 0) {
            return diff;
        }
        long dif = m2.getUniqueId() - this.getUniqueId();
        if (dif < 0L) {
            return 1;
        }
        if (dif > 0L) {
            return -1;
        }
        return 0;
    }

    public final boolean equals(I_QueueEntry m2) {
        return this.getPriority() == m2.getPriority() && this.getUniqueId() == m2.getUniqueId();
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(200);
        String offset = "\n   ";
        if (extraOffset != null) {
            offset = offset + extraOffset;
        }
        sb.append(offset).append("<MsgQueueEntry type='").append(this.entryType).append("'>");
        sb.append(offset).append("   <priority>").append(this.getPriority()).append("</priority>");
        sb.append(offset).append("   <persistent>").append(this.isPersistent()).append("</persistent>");
        sb.append(offset).append("   <uniqueId>").append(this.getUniqueId()).append("</uniqueId>");
        sb.append(offset).append("   <sender>").append(this.getSender()).append("</sender>");
        sb.append(offset).append("   <receiver>").append(this.getReceiver()).append("</receiver>");
        sb.append(offset).append("   <expired>").append(this.isExpired()).append("</expired>");
        sb.append(offset).append("   <isInternal>").append(this.isInternal()).append("</isInternal>");
        sb.append(offset).append("</MsgQueueEntry>\n");
        return sb.toString();
    }

    public String toString() {
        return this.getLogId();
    }

    public String getEmbeddedType() {
        return this.entryType;
    }

    public void added(StorageId storageId) {
        this.log.info(ME, this.getLogId() + " is added to queue: REFERENCE COUNTER IMPL MISSING");
    }

    public void removed(StorageId storageId) {
        this.log.info(ME, this.getLogId() + " is removed from queue: REFERENCE COUNTER IMPL MISSING");
    }

    public MethodName getMethodName() {
        return MethodName.toMethodName(this.entryType);
    }

    public boolean wantReturnObj() {
        return this.wantReturnObj;
    }

    public void setWantReturnObject(boolean wantReturnObj) {
        this.wantReturnObj = wantReturnObj;
    }

    void setRefToCloneOrigin(MsgQueueEntry origEntry) {
        this.refToCloneOrigin = origEntry;
    }

    public Object getReturnObj() {
        return this.returnObj;
    }

    public void setReturnObj(Object returnObj) {
        if (this.refToCloneOrigin != null) {
            this.refToCloneOrigin.setReturnObj(returnObj);
            this.refToCloneOrigin = null;
        }
        this.returnObj = returnObj;
    }

    public Object clone() {
        MsgQueueEntry entry = null;
        try {
            entry = (MsgQueueEntry)super.clone();
            if (entry.wantReturnObj) {
                entry.setRefToCloneOrigin(this);
            }
        }
        catch (CloneNotSupportedException e) {
            this.log.error(ME, "Internal clone problem: " + e.toString());
        }
        return entry;
    }

    public final String getLogId() {
        if (this.logId == null) {
            StringBuffer sb = new StringBuffer(80);
            sb.append(this.getStorageId());
            sb.append("/").append(this.priority);
            sb.append("/").append(this.getUniqueId());
            sb.append("/").append(this.getKeyOid());
            this.logId = sb.toString();
        }
        return this.logId;
    }

    public final void setStored(boolean stored) {
        this.stored = stored;
    }

    public final boolean isStored() {
        return this.stored;
    }

    public abstract Object getEmbeddedObject();
}

