/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.recorder.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.recorder.file.I_UserDataHandler;

public class FileIO {
    private final String ME = "FileIO";
    private final Global glob;
    private long currReadPos;
    private long lastReadPos;
    private File file;
    private RandomAccessFile ra;
    private long numUnread;
    private boolean firstUnread = true;
    private final long UNREAD_POS = 8L;
    private boolean firstLost = true;
    private long numLost;
    private final long LOST_POS = 16L;
    private long numFileDeleteLost = 0L;
    private boolean useSync;
    private final I_UserDataHandler userDataHandler;
    private String fileName;
    private long maxEntries;
    private final int modeException = 0;
    private final int modeDiscardOldest = 1;
    private final int modeDiscard = 2;
    private int mode = 0;

    public FileIO(Global glob, String fileName, I_UserDataHandler userDataHandler, long maxEntries, boolean useSync) throws IOException {
        this.glob = glob;
        this.fileName = fileName;
        this.maxEntries = maxEntries < 0L ? Long.MAX_VALUE : maxEntries;
        this.useSync = useSync;
        this.userDataHandler = userDataHandler;
        this.initialize();
    }

    public void initialize() throws IOException {
        this.lastReadPos = this.currReadPos = -1L;
        this.numUnread = 0L;
        this.numLost = 0L;
        this.file = this.mkfile(this.fileName);
        try {
            this.ra = new RandomAccessFile(this.file, "rw");
        }
        catch (IllegalArgumentException e) {
            this.ra = new RandomAccessFile(this.file, "rw");
        }
        if (this.ra.length() <= 24L) {
            this.ra.writeLong(0L);
            this.ra.writeLong(0L);
            this.ra.writeLong(0L);
            if (this.useSync) {
                this.ra.getFD().sync();
            }
        }
    }

    public File mkfile(String fullName) throws IOException {
        File f = new File(fullName);
        File dir = f.getAbsoluteFile().getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        f.createNewFile();
        return f;
    }

    public synchronized Object readNext(boolean autoCommit) throws IOException, XmlBlasterException {
        if (this.file == null) {
            this.initialize();
        }
        if (!this.file.exists()) {
            this.numFileDeleteLost = this.getNumUnread();
            this.initialize();
            throw new XmlBlasterException("FileRecorder.FileLost", this.fileName + " has disappeared, " + this.numFileDeleteLost + " messages are lost.");
        }
        this.currReadPos = this.getCurrReadPos();
        if (this.currReadPos > 0L) {
            this.ra.seek(this.currReadPos);
            Object data = this.userDataHandler.readData(this.ra);
            this.lastReadPos = this.currReadPos;
            this.currReadPos = this.ra.getFilePointer();
            if (autoCommit) {
                this.saveCurrReadPos();
            }
            --this.numUnread;
            this.ra.seek(8L);
            this.ra.writeLong(this.numUnread);
            return data;
        }
        this.ra.seek(24L);
        return null;
    }

    public synchronized boolean undo() {
        boolean ret = this.lastReadPos != this.currReadPos;
        this.currReadPos = this.lastReadPos;
        try {
            this.saveCurrReadPos();
        }
        catch (IOException e) {
            return false;
        }
        return ret;
    }

    public void writeNext(Object data) throws IOException, XmlBlasterException {
        String errorText = null;
        if (this.file == null) {
            this.initialize();
        }
        if (!this.file.exists()) {
            this.numFileDeleteLost = this.getNumUnread();
            errorText = this.fileName + " disappeared, " + this.getNumUnread() + " messages are lost, creating a new one and storing your message.";
            this.initialize();
        }
        if (this.numUnread >= this.maxEntries) {
            if (this.mode == 1) {
                this.readNext(true);
                ++this.numLost;
                this.ra.seek(16L);
                this.ra.writeLong(this.numLost);
            } else {
                if (this.mode == 2) {
                    ++this.numLost;
                    this.ra.seek(16L);
                    this.ra.writeLong(this.numLost);
                    return;
                }
                String text = "Maximum size=" + this.maxEntries + " of '" + this.fileName + "' reached, message rejected.";
                this.glob.getLog("recorder").warn("FileRecorder.MaxSize", text);
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, "FileIO", text);
            }
        }
        this.ra.seek(this.ra.length());
        this.userDataHandler.writeData(this.ra, data);
        if (this.useSync) {
            this.ra.getFD().sync();
        }
        ++this.numUnread;
        this.ra.seek(8L);
        this.ra.writeLong(this.numUnread);
        if (errorText != null) {
            this.glob.getLog("recorder").error("FileRecorder.FileLost", errorText);
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_FILEIO_FILELOST, "FileIO", errorText);
        }
    }

    public final void saveCurrReadPos() throws IOException {
        this.ra.seek(0L);
        this.ra.writeLong(this.currReadPos);
        if (this.useSync) {
            this.ra.getFD().sync();
        }
    }

    public final long getCurrReadPos() throws IOException {
        if (this.currReadPos <= 0L) {
            if (this.ra.length() > 24L) {
                this.ra.seek(0L);
                this.currReadPos = this.ra.readLong();
                if (this.currReadPos == 0L) {
                    this.lastReadPos = this.currReadPos = 24L;
                }
            } else {
                this.lastReadPos = this.currReadPos = -1L;
            }
        }
        if (this.currReadPos >= this.ra.length()) {
            this.file.delete();
            this.initialize();
        }
        return this.currReadPos;
    }

    public final long getNumUnread() {
        if (this.firstUnread) {
            this.firstUnread = false;
            try {
                this.ra.seek(8L);
                this.numUnread = this.ra.readLong();
            }
            catch (IOException e) {
                this.glob.getLog("recorder").error("FileIO.getNumUnread()", e.toString());
            }
        }
        return this.numUnread;
    }

    public long getNumLost() {
        if (this.firstLost) {
            this.firstLost = false;
            try {
                this.ra.seek(16L);
                this.numLost = this.ra.readLong();
            }
            catch (IOException e) {
                this.glob.getLog("recorder").error("FileIO.getNumLost()", e.toString());
            }
        }
        return this.numLost;
    }

    public final long getNumFileDeleteLost() {
        return this.numFileDeleteLost;
    }

    public void setModeDiscard() {
        this.mode = 2;
    }

    public void setModeDiscardOldest() {
        this.mode = 1;
    }

    public void setModeException() {
        this.mode = 0;
    }

    public void shutdown() {
        if (this.ra != null) {
            try {
                this.ra.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ra = null;
        }
        this.lastReadPos = this.currReadPos = -1L;
        this.numUnread = 0L;
        this.numLost = 0L;
    }

    public void destroy() {
        this.shutdown();
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }
}

