/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.recorder.file;

import java.io.IOException;
import org.jutils.log.LogChannel;
import org.jutils.time.TimeHelper;
import org.xmlBlaster.client.protocol.I_XmlBlaster;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.StatusQosData;
import org.xmlBlaster.util.recorder.I_InvocationRecorder;
import org.xmlBlaster.util.recorder.file.FileIO;
import org.xmlBlaster.util.recorder.file.MsgDataHandler;
import org.xmlBlaster.util.recorder.file.RequestContainer;

public class FileRecorder
implements I_Plugin,
I_InvocationRecorder {
    private final String ME = "FileRecorder";
    private Global glob;
    private LogChannel log;
    private FileIO rb;
    private String fileName;
    private I_XmlBlaster serverCallback = null;
    private final MsgUnit[] dummyMArr = new MsgUnit[0];
    private final String[] dummySArr = new String[0];
    private final String dummyS = "";
    private final PublishReturnQos[] dummyPubRetQosArr = new PublishReturnQos[0];
    private PublishReturnQos dummyPubRet;
    private SubscribeReturnQos dummySubRet;
    private UnSubscribeReturnQos[] dummyUnSubRet = new UnSubscribeReturnQos[0];
    private final EraseReturnQos[] dummyEraseReturnQosArr = new EraseReturnQos[0];
    private long maxEntries;
    private boolean autoCommit = true;

    public void initialize(Global glob, String fn, long maxEntries, I_XmlBlaster serverCallback) throws XmlBlasterException {
        this.glob = glob;
        this.serverCallback = serverCallback;
        this.log = glob.getLog("recorder");
        StatusQosData statRetQos = new StatusQosData(glob, MethodName.PUBLISH);
        statRetQos.setStateInfo("QUEUED");
        this.dummyPubRet = new PublishReturnQos(glob, statRetQos);
        StatusQosData subRetQos = new StatusQosData(glob, MethodName.SUBSCRIBE);
        subRetQos.setStateInfo("QUEUED");
        this.dummySubRet = new SubscribeReturnQos(glob, subRetQos);
        this.fileName = this.createPathString(fn);
        boolean useSync = glob.getProperty().get("recorder.useSync", false);
        try {
            this.rb = new FileIO(glob, this.fileName, new MsgDataHandler(glob), maxEntries, useSync);
            if (this.rb.getNumUnread() > 0L) {
                boolean destroyOld = glob.getProperty().get("recorder.destroyOld", false);
                if (destroyOld) {
                    this.log.warn("FileRecorder", "Destroyed " + this.rb.getNumUnread() + " unprocessed tail back messages in '" + this.fileName + "' as requested with option 'recorder.destroyOld=true'.");
                    this.rb.destroy();
                    this.rb.initialize();
                } else {
                    this.log.info("FileRecorder", "Found " + this.rb.getNumUnread() + " unprocessed tail back messages in '" + this.fileName + "'.");
                }
            } else if (this.log.TRACE) {
                this.log.trace("FileRecorder", "Using persistence file '" + this.fileName + "' for tail back messages.");
            }
        }
        catch (IOException ex) {
            this.log.error("FileRecorder", "Error at creation of RecordBuffer. It is not possible to buffer any messages: " + ex.toString());
            throw new XmlBlasterException("FileRecorder", "Initializing FileRecorder failed: Error at creation of RecordBuffer. It is not possible to buffer any messages: " + ex.toString());
        }
        if (maxEntries < 0L) {
            this.log.info("FileRecorder", "FileRecorder is ready, unlimited tail back messages are stored in '" + this.fileName + "'");
        } else {
            this.log.info("FileRecorder", "FileRecorder is ready, max=" + maxEntries + " tail back messages are stored in '" + this.fileName + "'");
        }
    }

    private String createPathString(String fn) {
        String fullName = this.glob.getProperty().get("recorder.path", (String)null);
        fullName = this.glob.getProperty().get("recorder.path[" + this.glob.getId() + "]", fullName);
        if (fullName == null) {
            fullName = this.glob.getProperty().get("Persistence.Path", System.getProperty("user.home") + System.getProperty("file.separator") + "tmp");
            fullName = fullName + System.getProperty("file.separator") + "fileRecorder";
        }
        if (fn == null) {
            fn = this.glob.getProperty().get("recorder.fn", (String)null);
            fn = this.glob.getProperty().get("recorder.fn[" + this.glob.getId() + "]", fn);
            if (fn == null) {
                fn = "tailback-" + this.glob.getStrippedId() + ".frc";
            }
        }
        return fullName + System.getProperty("file.separator") + fn;
    }

    public String getFullFileName() {
        return this.fileName;
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public String getType() {
        return "FileRecorder";
    }

    public String getVersion() {
        return "1.0";
    }

    public void setMode(String mode) {
        if (mode == null) {
            return;
        }
        if (mode.equals("discardOldest")) {
            this.rb.setModeDiscardOldest();
        } else if (mode.equals("discard")) {
            this.rb.setModeDiscard();
        } else if (mode.equals("exception")) {
            this.rb.setModeException();
            this.log.trace("FileRecorder", "Setting onOverflow mode to exception");
        } else {
            this.log.warn("FileRecorder", "Ignoring unknown onOverflow mode '" + mode + "', using default mode 'exception'.");
        }
    }

    public final boolean isFull() throws XmlBlasterException {
        return false;
    }

    public final long getNumUnread() {
        return this.rb.getNumUnread();
    }

    public void pullback(long startDate, long endDate, double motionFactor) throws XmlBlasterException {
        long elaps;
        this.log.info("FileRecorder", "Invoking pullback(startDate=" + startDate + ", endDate=" + endDate + ", motionFactor=" + motionFactor + ") numUnread=" + this.getNumUnread());
        RequestContainer cont = null;
        long startOfPullback = System.currentTimeMillis();
        long numAtBeginning = this.getNumUnread();
        while (this.rb.getNumUnread() > 0L) {
            try {
                cont = (RequestContainer)this.rb.readNext(this.autoCommit);
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (cont == null || startDate == 0L || cont.timestamp >= startDate) break;
        }
        if (cont == null) {
            this.log.warn("FileRecorder.NoInvoc", "Sorry, no invocations found, queue is empty or your start date is to late");
            return;
        }
        long startTime = cont.timestamp;
        long playbackStart = System.currentTimeMillis();
        while (cont != null) {
            if (endDate != 0L && cont.timestamp > endDate) break;
            if (motionFactor == 0.0) {
                this.callback(cont);
            } else {
                long originalElapsed = cont.timestamp - startTime;
                long actualElapsed = (long)((double)(System.currentTimeMillis() - playbackStart) * motionFactor);
                if (originalElapsed > actualElapsed) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(originalElapsed - actualElapsed);
                    }
                    catch (InterruptedException e) {
                        this.log.warn("FileRecorder", "Thread sleep got interrupted, this invocation is not in sync");
                    }
                }
                this.callback(cont);
            }
            try {
                cont = (RequestContainer)this.rb.readNext(this.autoCommit);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if ((elaps = System.currentTimeMillis() - startOfPullback) > 0L) {
            this.log.info("FileRecorder", "Pullback of " + (numAtBeginning - this.getNumUnread()) + " messages done - elapsed " + TimeHelper.millisToNice(elaps) + " average rate was " + numAtBeginning * 1000L / elaps + " msg/sec, numUnread=" + this.getNumUnread());
        } else {
            this.log.info("FileRecorder", "Pullback of " + (numAtBeginning - this.getNumUnread()) + " messages done very fast");
        }
    }

    public void pullback(float msgPerSec) throws XmlBlasterException {
        this.log.info("FileRecorder", "Invoking pullback(msgPerSec=" + msgPerSec + ") numUnread=" + this.getNumUnread());
        RequestContainer cont = null;
        long startOfPullback = System.currentTimeMillis();
        long numAtBeginning = this.getNumUnread();
        while (true) {
            long timeToUse;
            long startTime = System.currentTimeMillis();
            int numSent = 0;
            do {
                int localCount = 0;
                FileIO fileIO = this.rb;
                synchronized (fileIO) {
                    try {
                        cont = (RequestContainer)this.rb.readNext(this.autoCommit);
                        if (cont == null) {
                            long elaps = System.currentTimeMillis() - startOfPullback;
                            if (elaps == 0L) {
                                elaps = 1L;
                            }
                            this.log.info("FileRecorder", "Pullback of " + (numAtBeginning - this.getNumUnread()) + " messages done - elapsed " + TimeHelper.millisToNice(elaps) + " average rate was " + numAtBeginning * 1000L / elaps + " msg/sec, numUnread=" + this.getNumUnread());
                            return;
                        }
                        localCount = cont.msgUnitArr != null ? cont.msgUnitArr.length : 1;
                        this.callback(cont);
                        numSent += localCount;
                    }
                    catch (Exception e) {
                        String text;
                        if (this.rb.undo()) {
                            text = "Playback of tail back messages failed, " + this.getNumUnread() + " messages are kept savely in '" + this.fileName + "': " + e.toString();
                            this.log.warn("FileRecorder", text);
                        } else {
                            text = "Playback of tail back messages failed, " + this.getNumUnread() + " messages are in queue, " + localCount + " are lost, check '" + this.fileName + "': " + e.toString();
                            this.log.error("FileRecorder", text);
                        }
                        throw new XmlBlasterException("FileRecorder", text);
                    }
                }
            } while ((double)msgPerSec <= 0.0 || !((float)numSent >= msgPerSec));
            long actualElapsed = System.currentTimeMillis() - startTime;
            if (actualElapsed >= (timeToUse = (long)(1000.0 * (double)numSent / (double)msgPerSec))) continue;
            try {
                Thread.currentThread();
                Thread.sleep(timeToUse - actualElapsed);
                continue;
            }
            catch (InterruptedException i) {
                this.log.warn("FileRecorder", "Unexpected interrupt when sleeping for pullback");
                continue;
            }
            break;
        }
    }

    public long getNumLost() {
        return this.rb.getNumLost();
    }

    public void playback(long startDate, long endDate, double motionFactor) throws XmlBlasterException {
        this.log.error("FileRecorder.NoImpl", "Sorry, playback() is not implemented, use pullback() or implement it");
        throw new XmlBlasterException("FileRecorder.NoImpl", "Sorry, only pullback is implemented");
    }

    private void callback(RequestContainer cont) throws XmlBlasterException {
        if (this.serverCallback != null) {
            if (cont.method == MethodName.PUBLISH_ONEWAY) {
                this.serverCallback.publishOneway(cont.msgUnitArr);
                return;
            }
            if (cont.method == MethodName.PUBLISH) {
                if (cont.msgUnitArr.length == 1) {
                    this.serverCallback.publish(cont.msgUnitArr[0]);
                } else {
                    this.serverCallback.publishArr(cont.msgUnitArr);
                }
                return;
            }
            if (cont.method == MethodName.GET) {
                this.serverCallback.get(cont.xmlKey, cont.xmlQos);
                return;
            }
            if (cont.method == MethodName.SUBSCRIBE) {
                this.serverCallback.subscribe(cont.xmlKey, cont.xmlQos);
                return;
            }
            if (cont.method == MethodName.UNSUBSCRIBE) {
                this.serverCallback.unSubscribe(cont.xmlKey, cont.xmlQos);
                return;
            }
            if (cont.method == MethodName.ERASE) {
                this.serverCallback.erase(cont.xmlKey, cont.xmlQos);
                return;
            }
        }
        this.log.error("FileRecorder", "Internal error: Method '" + cont.method + "' is unknown");
        throw new XmlBlasterException("FileRecorder", "Internal error: Method '" + cont.method + "' is unknown");
    }

    public SubscribeReturnQos subscribe(String xmlKey, String qos) throws XmlBlasterException {
        RequestContainer cont = new RequestContainer();
        cont.method = MethodName.SUBSCRIBE;
        cont.xmlKey = xmlKey;
        cont.xmlQos = qos;
        try {
            this.rb.writeNext(cont);
        }
        catch (IOException ex) {
            throw new XmlBlasterException("FileRecorder", cont.method + " invocation: " + ex.toString());
        }
        return this.dummySubRet;
    }

    public UnSubscribeReturnQos[] unSubscribe(String xmlKey, String qos) throws XmlBlasterException {
        RequestContainer cont = new RequestContainer();
        cont.method = MethodName.UNSUBSCRIBE;
        cont.xmlKey = xmlKey;
        cont.xmlQos = qos;
        try {
            this.rb.writeNext(cont);
        }
        catch (IOException ex) {
            throw new XmlBlasterException("FileRecorder", cont.method + " invocation: " + ex.toString());
        }
        return this.dummyUnSubRet;
    }

    public PublishReturnQos publish(MsgUnit msgUnit) throws XmlBlasterException {
        RequestContainer cont = new RequestContainer();
        cont.method = MethodName.PUBLISH;
        cont.msgUnitArr = new MsgUnit[]{msgUnit};
        try {
            this.rb.writeNext(cont);
        }
        catch (IOException ex) {
            throw new XmlBlasterException("FileRecorder", cont.method + " invocation: " + ex.toString());
        }
        return this.dummyPubRet;
    }

    public void publishOneway(MsgUnit[] msgUnitArr) throws XmlBlasterException {
        RequestContainer cont = new RequestContainer();
        cont.method = MethodName.PUBLISH_ONEWAY;
        cont.msgUnitArr = msgUnitArr;
        try {
            this.rb.writeNext(cont);
        }
        catch (IOException ex) {
            this.log.error("FileRecorder", cont.method + " invocation failed: " + ex.toString());
        }
    }

    public PublishReturnQos[] publishArr(MsgUnit[] msgUnitArr) throws XmlBlasterException {
        RequestContainer cont = new RequestContainer();
        cont.method = MethodName.PUBLISH;
        cont.msgUnitArr = msgUnitArr;
        try {
            this.rb.writeNext(cont);
        }
        catch (IOException ex) {
            throw new XmlBlasterException("FileRecorder", cont.method + " invocation: " + ex.toString());
        }
        return this.dummyPubRetQosArr;
    }

    public EraseReturnQos[] erase(String xmlKey, String qos) throws XmlBlasterException {
        RequestContainer cont = new RequestContainer();
        cont.method = MethodName.ERASE;
        cont.xmlKey = xmlKey;
        cont.xmlQos = qos;
        try {
            this.rb.writeNext(cont);
        }
        catch (IOException ex) {
            throw new XmlBlasterException("FileRecorder", cont.method + " invocation: " + ex.toString());
        }
        return this.dummyEraseReturnQosArr;
    }

    public MsgUnit[] get(String xmlKey, String qos) throws XmlBlasterException {
        RequestContainer cont = new RequestContainer();
        cont.method = MethodName.GET;
        cont.xmlKey = xmlKey;
        cont.xmlQos = qos;
        try {
            this.rb.writeNext(cont);
        }
        catch (IOException ex) {
            throw new XmlBlasterException("FileRecorder", cont.method + " invocation: " + ex.toString());
        }
        return this.dummyMArr;
    }

    public boolean ping() {
        return false;
    }

    public String[] update(String cbSessionId, MsgUnit[] msgUnitArr) throws XmlBlasterException {
        RequestContainer cont = new RequestContainer();
        cont.method = MethodName.UPDATE;
        cont.cbSessionId = cbSessionId;
        cont.msgUnitArr = msgUnitArr;
        try {
            this.rb.writeNext(cont);
        }
        catch (IOException ex) {
            throw new XmlBlasterException("FileRecorder", cont.method + " invocation: " + ex.toString());
        }
        String[] ret = new String[msgUnitArr.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = "";
            ++i;
        }
        return ret;
    }

    public void updateOneway(String cbSessionId, MsgUnit[] msgUnitArr) {
        RequestContainer cont = new RequestContainer();
        cont.method = MethodName.UPDATE_ONEWAY;
        cont.cbSessionId = cbSessionId;
        cont.msgUnitArr = msgUnitArr;
        try {
            this.rb.writeNext(cont);
        }
        catch (IOException ex) {
            this.log.error("FileRecorder", cont.method + " invocation failed: " + ex.toString());
        }
        catch (XmlBlasterException ex) {
            this.log.error("FileRecorder", cont.method + " invocation failed: " + ex.toString());
        }
    }

    public void destroy() {
        this.rb.destroy();
    }

    public void shutdown() {
        this.rb.shutdown();
    }
}

