/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.recorder.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.recorder.file.I_UserDataHandler;
import org.xmlBlaster.util.recorder.file.RequestContainer;

final class MsgDataHandler
implements I_UserDataHandler {
    private final Global glob;
    private final String ME = "MsgDataHandler";

    public MsgDataHandler(Global glob) {
        this.glob = glob;
    }

    public final void writeData(RandomAccessFile ra, Object userData) throws IOException, XmlBlasterException {
        RequestContainer cont = (RequestContainer)userData;
        ra.writeUTF(cont.method.getMethodName());
        if (cont.method.wantsMsgArrArg() || cont.method.wantsStrMsgArrArg()) {
            if (cont.method.wantsStrMsgArrArg()) {
                ra.writeUTF(cont.cbSessionId);
            }
            ra.writeInt(cont.msgUnitArr.length);
            int i = 0;
            while (i < cont.msgUnitArr.length) {
                ra.writeUTF(cont.msgUnitArr[i].getKey());
                ra.writeInt(cont.msgUnitArr[i].getContent().length);
                ra.write(cont.msgUnitArr[i].getContent());
                ra.writeUTF(cont.msgUnitArr[i].getQos());
                ++i;
            }
        } else if (cont.method.wantsKeyQosArg()) {
            ra.writeUTF(cont.xmlKey);
            ra.writeUTF(cont.xmlQos);
        } else if (cont.method.wantsQosArg()) {
            ra.writeUTF(cont.xmlQos);
        } else {
            throw new XmlBlasterException("MsgDataHandler", "Internal problem: Unknown method '" + cont.method + "' can't handle it");
        }
    }

    public final Object readData(RandomAccessFile ra) throws IOException, XmlBlasterException {
        RequestContainer cont = new RequestContainer();
        cont.method = MethodName.toMethodName(ra.readUTF());
        if (cont.method.wantsMsgArrArg() || cont.method.wantsStrMsgArrArg()) {
            if (cont.method.wantsStrMsgArrArg()) {
                cont.cbSessionId = ra.readUTF();
            }
            cont.msgUnitArr = new MsgUnit[ra.readInt()];
            int i = 0;
            while (i < cont.msgUnitArr.length) {
                String key = ra.readUTF();
                byte[] content = new byte[ra.readInt()];
                ra.read(content);
                cont.msgUnitArr[i] = new MsgUnit(this.glob, key, content, ra.readUTF());
                ++i;
            }
        } else if (cont.method.wantsKeyQosArg()) {
            cont.xmlKey = ra.readUTF();
            cont.xmlQos = ra.readUTF();
        } else if (cont.method.wantsQosArg()) {
            cont.xmlQos = ra.readUTF();
        } else {
            throw new XmlBlasterException("MsgDataHandler", "Internal problem: Unknown method '" + cont.method + "' can't handle it");
        }
        return cont;
    }
}

