/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.recorder.ram;

import org.jutils.JUtilsException;
import org.jutils.collection.Queue;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.I_XmlBlaster;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.plugin.I_Plugin;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.StatusQosData;
import org.xmlBlaster.util.recorder.I_InvocationRecorder;

public class RamRecorder
implements I_Plugin,
I_InvocationRecorder {
    private String ME = "RamRecorder";
    private Global glob;
    private LogChannel log;
    private Queue queue;
    private I_XmlBlaster serverCallback = null;
    private final MsgUnit[] dummyMArr = new MsgUnit[0];
    private final String[] dummySArr = new String[0];
    private final String dummyS = new String();
    private final PublishReturnQos[] dummyPubRetQosArr = new PublishReturnQos[0];
    private PublishReturnQos dummyPubRet;
    private SubscribeReturnQos dummySubRet;
    private final UnSubscribeReturnQos[] dummyUbSubRetQosArr = new UnSubscribeReturnQos[0];
    private final EraseReturnQos[] dummyEraseReturnQosArr = new EraseReturnQos[0];

    public void initialize(Global glob, String fn, long maxEntries, I_XmlBlaster serverCallback) {
        this.glob = glob;
        this.log = glob.getLog("recorder");
        StatusQosData statRetQos = new StatusQosData(glob, MethodName.UNKNOWN);
        statRetQos.setStateInfo("QUEUED");
        this.dummyPubRet = new PublishReturnQos(glob, statRetQos);
        StatusQosData subQos = new StatusQosData(glob, MethodName.SUBSCRIBE);
        subQos.setStateInfo("QUEUED");
        this.dummySubRet = new SubscribeReturnQos(glob, subQos);
        if (this.log.CALL) {
            this.log.call(this.ME, "Initializing new RamRecorder(" + maxEntries + ") ...");
        }
        if (maxEntries >= Integer.MAX_VALUE) {
            this.log.warn(this.ME, "Stripping queue size to Integer.MAX_VALUE");
            maxEntries = Integer.MAX_VALUE;
        }
        this.queue = new Queue(this.ME, (int)maxEntries);
        this.serverCallback = serverCallback;
        this.log.info(this.ME, "Invocation recorder is initialized to queue max=" + maxEntries + " tail back messages on failure");
    }

    public String getFullFileName() {
        return null;
    }

    public void init(Global glob, PluginInfo pluginInfo) {
    }

    public String getType() {
        return "RamRecorder";
    }

    public String getVersion() {
        return "1.0";
    }

    public void setMode(String mode) {
        if (mode == null) {
            return;
        }
        if (mode.equals("discardOldest")) {
            this.queue.setModeToDiscardOldest();
        } else if (mode.equals("discard")) {
            this.queue.setModeToDiscard();
        } else if (mode.equals("exception")) {
            this.log.trace(this.ME, "Setting onOverflow mode to exception");
        } else {
            this.log.warn(this.ME, "Ignoring unknown onOverflow mode '" + mode + "', using default mode 'exception'.");
        }
    }

    public final boolean isFull() throws XmlBlasterException {
        try {
            return this.queue.isFull();
        }
        catch (JUtilsException e) {
            throw this.convert(e);
        }
    }

    public final long getNumUnread() {
        return this.queue.size();
    }

    public void pullback(long startDate, long endDate, double motionFactor) throws XmlBlasterException {
        this.log.info(this.ME, "Invoking pullback(startDate=" + startDate + ", endDate=" + endDate + ", motionFactor=" + motionFactor + ") queue.size=" + this.queue.size());
        InvocationContainer cont = null;
        while (this.queue.size() > 0) {
            cont = (InvocationContainer)this.queue.pull();
            if (startDate == 0L || cont.timestamp >= startDate) break;
        }
        if (cont == null) {
            this.log.warn(this.ME + ".NoInvoc", "Sorry, no invocations found, queue is empty or your start date is to late");
            throw new XmlBlasterException(this.ME + ".NoInvoc", "Sorry, no invocations found, queue is empty or your start date is to late");
        }
        long startTime = cont.timestamp;
        long playbackStart = System.currentTimeMillis();
        while (cont != null) {
            if (endDate != 0L && cont.timestamp > endDate) break;
            if (motionFactor == 0.0) {
                this.callback(cont);
            } else {
                long originalElapsed = cont.timestamp - startTime;
                long actualElapsed = (long)((double)(System.currentTimeMillis() - playbackStart) * motionFactor);
                if (originalElapsed > actualElapsed) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(originalElapsed - actualElapsed);
                    }
                    catch (InterruptedException e) {
                        this.log.warn(this.ME, "Thread sleep got interrupted, this invocation is not in sync");
                    }
                }
                this.callback(cont);
            }
            cont = (InvocationContainer)this.queue.pull();
        }
    }

    public void pullback(float msgPerSec) throws XmlBlasterException {
        this.log.warn(this.ME, "Sorry, pullback(msgPerSec) is not implemented, we switch to full speed mode");
        this.pullback(0L, 0L, 0.0);
    }

    public void destroy() {
        while (this.queue.size() > 0) {
            this.queue.pull();
        }
    }

    public void shutdown() {
    }

    public long getNumLost() {
        return this.queue.getNumLost();
    }

    public void playback(long startDate, long endDate, double motionFactor) throws XmlBlasterException {
        this.log.error(this.ME + "." + ErrorCode.INTERNAL_NOTIMPLEMENTED.getErrorCode(), "Sorry, playback() is not implemented, use pullback() or implement it");
        throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, this.ME, "Sorry, only pullback is implemented");
    }

    private void callback(InvocationContainer cont) throws XmlBlasterException {
        if (this.serverCallback != null) {
            if (cont.method.equals("publish")) {
                this.serverCallback.publish(cont.msgUnit);
                return;
            }
            if (cont.method.equals("get")) {
                this.serverCallback.get(cont.xmlKey, cont.xmlQos);
                return;
            }
            if (cont.method.equals("subscribe")) {
                this.serverCallback.subscribe(cont.xmlKey, cont.xmlQos);
                return;
            }
            if (cont.method.equals("unSubscribe")) {
                this.serverCallback.unSubscribe(cont.xmlKey, cont.xmlQos);
                return;
            }
            if (cont.method.equals("publishArr")) {
                this.serverCallback.publishArr(cont.msgUnitArr);
                return;
            }
            if (cont.method.equals("publishOneway")) {
                this.serverCallback.publishOneway(cont.msgUnitArr);
                return;
            }
            if (cont.method.equals("erase")) {
                this.serverCallback.erase(cont.xmlKey, cont.xmlQos);
                return;
            }
        }
        this.log.error(this.ME, "Internal error: Method '" + cont.method + "' is unknown");
        throw new XmlBlasterException(this.ME, "Internal error: Method '" + cont.method + "' is unknown");
    }

    public SubscribeReturnQos subscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        InvocationContainer cont = new InvocationContainer();
        cont.method = "subscribe";
        cont.xmlKey = xmlKey_literal;
        cont.xmlQos = qos_literal;
        try {
            this.queue.push(cont);
        }
        catch (JUtilsException e) {
            throw this.convert(e);
        }
        return this.dummySubRet;
    }

    private XmlBlasterException convert(JUtilsException e) {
        if (e.id.indexOf(".MaxSize") >= 0) {
            return new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES, e.id, e.reason);
        }
        return new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, e.id, e.reason);
    }

    public UnSubscribeReturnQos[] unSubscribe(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        InvocationContainer cont = new InvocationContainer();
        cont.method = "unSubscribe";
        cont.xmlKey = xmlKey_literal;
        cont.xmlQos = qos_literal;
        try {
            this.queue.push(cont);
        }
        catch (JUtilsException e) {
            throw this.convert(e);
        }
        return this.dummyUbSubRetQosArr;
    }

    public PublishReturnQos publish(MsgUnit msgUnit) throws XmlBlasterException {
        InvocationContainer cont = new InvocationContainer();
        cont.method = "publish";
        cont.msgUnit = msgUnit;
        cont.xmlQos = msgUnit.getQos();
        try {
            this.queue.push(cont);
        }
        catch (JUtilsException e) {
            throw this.convert(e);
        }
        return this.dummyPubRet;
    }

    public void publishOneway(MsgUnit[] msgUnitArr) {
        InvocationContainer cont = new InvocationContainer();
        cont.method = "publishOneway";
        cont.msgUnitArr = msgUnitArr;
        try {
            this.queue.push(cont);
        }
        catch (JUtilsException e) {
            this.log.error(this.ME + ".publishOneway", e.toString());
        }
    }

    public PublishReturnQos[] publishArr(MsgUnit[] msgUnitArr) throws XmlBlasterException {
        InvocationContainer cont = new InvocationContainer();
        cont.method = "publishArr";
        cont.msgUnitArr = msgUnitArr;
        try {
            this.queue.push(cont);
        }
        catch (JUtilsException e) {
            throw this.convert(e);
        }
        return this.dummyPubRetQosArr;
    }

    public EraseReturnQos[] erase(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        InvocationContainer cont = new InvocationContainer();
        cont.method = "erase";
        cont.xmlKey = xmlKey_literal;
        cont.xmlQos = qos_literal;
        try {
            this.queue.push(cont);
        }
        catch (JUtilsException e) {
            throw this.convert(e);
        }
        return this.dummyEraseReturnQosArr;
    }

    public MsgUnit[] get(String xmlKey_literal, String qos_literal) throws XmlBlasterException {
        InvocationContainer cont = new InvocationContainer();
        cont.method = "get";
        cont.xmlKey = xmlKey_literal;
        cont.xmlQos = qos_literal;
        try {
            this.queue.push(cont);
        }
        catch (JUtilsException e) {
            throw this.convert(e);
        }
        return this.dummyMArr;
    }

    public boolean ping() {
        return false;
    }

    public String[] update(String cbSessionId, MsgUnit[] msgUnitArr) throws XmlBlasterException {
        InvocationContainer cont = new InvocationContainer();
        cont.method = "update";
        cont.cbSessionId = cbSessionId;
        cont.msgUnitArr = msgUnitArr;
        try {
            this.queue.push(cont);
        }
        catch (JUtilsException e) {
            throw this.convert(e);
        }
        String[] ret = new String[msgUnitArr.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = "";
            ++i;
        }
        return ret;
    }

    public void updateOneway(String cbSessionId, MsgUnit[] msgUnitArr) {
        InvocationContainer cont = new InvocationContainer();
        cont.method = "updateOneway";
        cont.cbSessionId = cbSessionId;
        cont.msgUnitArr = msgUnitArr;
        try {
            this.queue.push(cont);
        }
        catch (JUtilsException e) {
            this.log.error(this.ME, "Can't push updateOneway(): " + e.getMessage());
        }
    }

    private class InvocationContainer {
        long timestamp = System.currentTimeMillis();
        String method;
        String cbSessionId;
        String xmlKey;
        String xmlQos;
        MsgUnit msgUnit;
        MsgUnit[] msgUnitArr;

        InvocationContainer() {
        }
    }
}

