/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.collection;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jutils.JUtilsException;

public class Queue {
    private String ME = "Queue";
    private String name = "";
    private final int MAX_ENTRIES;
    private boolean discardOldest = false;
    private boolean discard = false;
    private long numLost = 0L;
    private LinkedList queueList = null;

    public Queue(String string, int n) {
        this.name = string;
        this.MAX_ENTRIES = n;
        this.init();
    }

    public long getNumLost() {
        return this.numLost;
    }

    private void init() {
        this.queueList = new LinkedList();
    }

    public final boolean isFull() throws JUtilsException {
        return this.queueList.size() >= this.MAX_ENTRIES;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 3;
        Queue queue = new Queue("Test", n);
        queue.setModeToDiscardOldest();
        try {
            queue.push("Hello ");
            queue.push("world ");
            queue.push("my ");
            queue.push("dear ");
            queue.push("friend!");
        }
        catch (JUtilsException jUtilsException) {}
        StringBuffer stringBuffer = new StringBuffer("");
        while (queue.size() > 0) {
            stringBuffer.append(queue.pull());
        }
        System.out.println("For a queue with max size=" + n + " the result is: " + stringBuffer.toString());
    }

    public final Object pull() {
        try {
            LinkedList linkedList = this.queueList;
            synchronized (linkedList) {
                Object e = this.queueList.removeLast();
                Object var3_3 = null;
                return e;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public final void push(Object object) throws JUtilsException {
        LinkedList linkedList = this.queueList;
        synchronized (linkedList) {
            if (this.queueList.size() >= this.MAX_ENTRIES) {
                if (this.discardOldest) {
                    this.pull();
                    ++this.numLost;
                } else {
                    if (this.discard) {
                        ++this.numLost;
                        Object var3_3 = null;
                        return;
                    }
                    throw new JUtilsException(String.valueOf(this.ME) + ".MaxSize", "Maximun size=" + this.MAX_ENTRIES + " of queue '" + this.name + "' reached");
                }
            }
            this.queueList.addFirst(object);
        }
    }

    public final ListIterator queueIterator(int n) throws IndexOutOfBoundsException {
        return this.queueList.listIterator(n);
    }

    public void setModeToDiscard() {
        this.discardOldest = false;
        this.discard = true;
    }

    public void setModeToDiscardOldest() {
        this.discard = false;
        this.discardOldest = true;
    }

    public final int size() {
        return this.queueList.size();
    }
}

