/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.corba;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.jutils.corba.HandleRequest;
import org.jutils.corba.HttpIORClient;
import org.jutils.init.Property;
import org.jutils.log.LogChannel;
import org.jutils.log.LogDeviceConsole;
import org.jutils.log.LogManager;

public class HttpIORServer
extends Thread {
    private String ME = "HttpIORServer";
    private int HTTP_PORT = 7109;
    private String ior = null;
    private ServerSocket listen = null;
    private boolean running = true;
    protected static String LCN = null;
    private Property prop = null;
    public String pathToIORFile = null;
    public String IORservicename = "";

    public HttpIORServer(int n, String string, String string2) {
        this.ior = string;
        this.HTTP_PORT = n;
        this.IORservicename = string2;
        LogChannel logChannel = new LogChannel(null);
        LogDeviceConsole logDeviceConsole = new LogDeviceConsole(logChannel);
        logChannel.setLogLevel(255);
        logChannel.addLogDevice(logDeviceConsole);
        LogManager.addLogChannel(this.ME, logChannel);
        LCN = this.ME;
        LogManager.call(LCN, this.ME, "Creating new HttpIORServer with ior = " + string + " on port " + n);
        this.start();
    }

    public HttpIORServer(int n, String string, String string2, String string3) {
        this.ior = string;
        this.HTTP_PORT = n;
        LCN = string2;
        this.IORservicename = string3;
        LogManager.call(string2, this.ME, "Creating new HttpIORServer with ior = " + string + " on port " + n);
        this.start();
    }

    public HttpIORServer(String string) {
        this.ior = string;
        LogChannel logChannel = new LogChannel(null);
        LogDeviceConsole logDeviceConsole = new LogDeviceConsole(logChannel);
        logChannel.setLogLevel(255);
        logChannel.addLogDevice(logDeviceConsole);
        LogManager.addLogChannel(this.ME, logChannel);
        LCN = this.ME;
        LogManager.call(LCN, this.ME, "Creating new HttpIORServer with ior = " + string + " on port " + this.HTTP_PORT);
        this.start();
    }

    public static void main(String[] stringArray) {
        HttpIORServer httpIORServer = new HttpIORServer(6001, "IOR:098080809809808", "authserver.ior");
        HttpIORClient httpIORClient = new HttpIORClient();
        String string = httpIORClient.getIORFromUrl("http://localhost:6001/authserver.ior");
        System.out.println("received ior = " + string);
        string = httpIORClient.getIORFromUrl("http://localhost:6001/test.ior");
        System.out.println("received ior = " + string);
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {}
        httpIORServer.shutdown();
    }

    public void run() {
        int n = 50;
        try {
            this.listen = new ServerSocket(this.HTTP_PORT, n);
            while (this.running) {
                Socket socket = this.listen.accept();
                if (!this.running) {
                    LogManager.info(LCN, this.ME, "Closing http server port=" + this.HTTP_PORT + ".");
                    break;
                }
                HandleRequest handleRequest = new HandleRequest(socket, this.ior, this.pathToIORFile, this.IORservicename);
            }
        }
        catch (BindException bindException) {
            LogManager.error(LCN, this.ME, "HTTP server problem: " + bindException.toString());
        }
        catch (SocketException socketException) {
            LogManager.info(LCN, this.ME, "Socket closed successfully: " + socketException.toString());
        }
        catch (IOException iOException) {
            LogManager.error(LCN, this.ME, "HTTP server problem: " + iOException.toString());
        }
        if (this.listen != null) {
            try {
                this.listen.close();
            }
            catch (IOException iOException) {
                LogManager.warn(LCN, this.ME, "listen.close()" + iOException.toString());
            }
            this.listen = null;
        }
    }

    public void setPath(String string) {
        this.pathToIORFile = string;
    }

    public void shutdown() {
        LogManager.call(LCN, this.ME, "Entering shutdown");
        this.running = false;
        boolean bl = true;
        if (this.listen != null && bl) {
            try {
                Socket socket = new Socket(this.listen.getInetAddress(), this.HTTP_PORT);
                socket.close();
            }
            catch (IOException iOException) {
                LogManager.warn(LCN, this.ME, "shutdown problem: " + iOException.toString());
            }
        }
        try {
            if (this.listen != null) {
                this.listen.close();
                this.listen = null;
            }
        }
        catch (Exception exception) {
            LogManager.warn(LCN, this.ME, "die zweite problem: " + exception.toString());
        }
    }
}

