/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.csv;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class CSVWriter {
    PrintWriter pw;
    boolean forceQuotes;
    char separator;
    boolean wasPreviousField = false;
    String comment;
    String lineSeparator;

    public CSVWriter(PrintWriter printWriter) {
        this.pw = printWriter;
        this.forceQuotes = false;
        this.separator = (char)44;
        this.comment = "# ";
        this.lineSeparator = System.getProperty("line.separator");
    }

    public CSVWriter(PrintWriter printWriter, char c) {
        this.pw = printWriter;
        this.forceQuotes = false;
        this.separator = (char)44;
        this.comment = String.valueOf(String.valueOf(c)) + " ";
        this.lineSeparator = System.getProperty("line.separator");
    }

    public CSVWriter(PrintWriter printWriter, boolean bl, char c, String string) {
        this.pw = printWriter;
        this.forceQuotes = bl;
        this.separator = c;
        this.comment = "# ";
        this.lineSeparator = string;
    }

    public void close() {
        if (this.pw != null) {
            this.pw.close();
            this.pw = null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(stringArray[0]));
            CSVWriter cSVWriter = new CSVWriter(printWriter, false, ',', System.getProperty("line.separator"));
            cSVWriter.writeCommentln("This is a test csv-file: '" + stringArray[0] + "'");
            cSVWriter.write("abc");
            cSVWriter.write("def");
            cSVWriter.write("g h i");
            cSVWriter.write("jk,l");
            cSVWriter.write("m\"n'o ");
            cSVWriter.writeln();
            cSVWriter.write("m\"n'o ");
            cSVWriter.write("    ");
            cSVWriter.write("a");
            cSVWriter.write("x,y,z");
            cSVWriter.write("x;y;z");
            cSVWriter.writeln();
            cSVWriter.writeln(new String[]{"This", "is", "an", "array."});
            cSVWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException.getMessage());
        }
    }

    public void write(String string) {
        if (this.wasPreviousField) {
            this.pw.print(this.separator);
        }
        if (string == null) {
            this.pw.print("");
            return;
        }
        if ((string = string.trim()).indexOf(34) >= 0) {
            this.pw.print('\"');
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\"') {
                    this.pw.print("\"\"");
                } else {
                    this.pw.print(c);
                }
                ++n;
            }
            this.pw.print('\"');
        } else if (string.indexOf(10) >= 0) {
            this.pw.print('\"');
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\n') {
                    this.pw.print("\\n");
                } else {
                    this.pw.print(c);
                }
                ++n;
            }
            this.pw.print('\"');
        } else if (this.forceQuotes || string.indexOf(this.separator) >= 0) {
            this.pw.print('\"');
            this.pw.print(string);
            this.pw.print('\"');
        } else {
            this.pw.print(string);
        }
        this.wasPreviousField = true;
    }

    public void writeCommentln(String string) {
        if (this.wasPreviousField) {
            this.writeln();
        }
        this.pw.print(this.comment);
        this.write(string);
        this.writeln();
    }

    public void writeln() {
        this.wasPreviousField = false;
        this.pw.print(this.lineSeparator);
    }

    public void writeln(String string) {
        this.write(string);
        this.writeln();
    }

    public void writeln(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.write(stringArray[n]);
            ++n;
        }
        this.writeln();
    }
}

