/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.init;

import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.jutils.JUtilsException;
import org.jutils.init.Args;
import org.jutils.init.I_PropertyChangeListener;
import org.jutils.init.PropertyChangeEvent;
import org.jutils.io.FileUtil;
import org.jutils.text.StringHelper;

public class Property
implements Cloneable {
    private static final String ME = "Property";
    private static String separator = null;
    private static String userHome = null;
    private String currentPath = null;
    private String projectHomePath = null;
    private static String javaHomeExt = null;
    private static String javaHome = null;
    private String propertyFileName = null;
    private Properties jutilsProperties = null;
    private final Properties dummyProperties = new Properties();
    private Map jutilsMap = null;
    private boolean scanSystemProperties = true;
    private boolean replaceVariables = true;
    private boolean supportArrays = true;
    private boolean wantsHelp = false;
    private Applet applet = null;
    private HashMap changeListenerMap = new HashMap();
    public static final int MAX_NEST = 50;
    public static final int DEFAULT_VERBOSE = 1;
    public int verbose = 1;
    static /* synthetic */ Class class$org$jutils$init$Property;

    public Property() {
        this.jutilsProperties = new Properties();
    }

    public Property(String string, boolean bl, Applet applet, boolean bl2) throws JUtilsException {
        System.out.println("Property for Applet: propertyFileUrl=" + string + ", scanSystemProperties=" + bl + ", replaceVariables=" + bl2);
        this.scanSystemProperties = bl;
        this.replaceVariables = bl2;
        this.applet = applet;
        if (string == null) {
            this.loadProps(null, null);
            if (this.jutilsProperties == null) {
                this.jutilsProperties = this.dummyProperties;
            }
            return;
        }
        URL uRL = null;
        FileInfo fileInfo = new FileInfo(string);
        try {
            uRL = new URL(string);
            fileInfo.fullPath = this.propertyFileName = uRL.getFile();
            try {
                fileInfo.in = uRL.openStream();
            }
            catch (IOException iOException) {
                System.out.println("Property file " + uRL + " read error, continuing without it: " + iOException.toString());
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Property file " + string + " is malformed, continuing without it: " + malformedURLException.toString());
        }
        this.loadProps(fileInfo, null);
        if (this.jutilsProperties == null) {
            this.jutilsProperties = this.dummyProperties;
        }
    }

    public Property(String string, boolean bl, String string2, boolean bl2) throws JUtilsException {
        this.init(string, bl, null, bl2, this.supportArrays);
        FileInputStream fileInputStream = null;
        String string3 = null;
        try {
            Serializable serializable;
            if (userHome != null) {
                string3 = String.valueOf(userHome) + "/projects.properties";
                serializable = new File(string3);
                fileInputStream = new FileInputStream((File)serializable);
            }
            serializable = new Properties();
            ((Properties)serializable).load(fileInputStream);
            if (!((Properties)serializable).getProperty(string2, "").equals("")) {
                this.projectHomePath = ((Properties)serializable).getProperty(string2);
                if (this.verbose >= 1) {
                    System.out.println("Property: found " + string2 + " in " + string3);
                }
            } else {
                throw new JUtilsException("Property.Error", "Unable to find " + string2 + " in " + string3);
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new JUtilsException("Property.Error", "Unable to find " + string3 + ": " + iOException);
        }
    }

    public Property(String string, boolean bl, Properties properties, boolean bl2) throws JUtilsException {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        boolean bl3 = false;
        while (enumeration.hasMoreElements()) {
            objectArray = (String)enumeration.nextElement();
            vector.add(new String("-" + (String)objectArray));
            vector.add(properties.getProperty((String)objectArray));
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.init(string, bl, (String[])objectArray, bl2, this.supportArrays);
    }

    public Property(String string, boolean bl, String[] stringArray, boolean bl2) throws JUtilsException {
        this.init(string, bl, stringArray, bl2, this.supportArrays);
    }

    public Property(String string, boolean bl, String[] stringArray, boolean bl2, boolean bl3) throws JUtilsException {
        if (bl3) {
            this.verbose = 2;
        }
        this.init(string, bl, stringArray, bl2, this.supportArrays);
    }

    public void addArgs2Props(Properties properties) throws JUtilsException {
        this.addArgs2Props(Property.propsToArgs(properties));
    }

    private void addArgs2Props(Properties properties, Properties properties2) throws JUtilsException {
        String string;
        Object object;
        if (properties2 == null) {
            return;
        }
        FileInfo fileInfo = this.findArgsFile(properties2);
        if (fileInfo != null) {
            object = fileInfo.getInputStream();
            if (object != null) {
                try {
                    block10: {
                        try {
                            properties.load((InputStream)object);
                            if (this.verbose >= 2) {
                                System.out.println("Property: Loaded file " + fileInfo.getFullPath());
                            }
                        }
                        catch (IOException iOException) {
                            if (this.verbose < 0) break block10;
                            System.out.println("Property: ERROR loading file " + fileInfo.getFullPath());
                        }
                    }
                    string = null;
                    fileInfo.closeInputStream();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    fileInfo.closeInputStream();
                    throw throwable;
                }
            }
            if (this.verbose >= 1) {
                System.out.println("Property: No property file given.");
            }
        }
        object = ((Hashtable)properties2).keys();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            string = (String)((Hashtable)properties2).get(string2);
            String string3 = ((Hashtable)properties).put(string2, string);
            this.fireChangeEvent(string2, string3, string);
        }
    }

    public void addArgs2Props(String[] stringArray) throws JUtilsException {
        Properties properties;
        if (stringArray == null) {
            return;
        }
        if (System.getProperty("property.verbose") != null) {
            try {
                this.verbose = Integer.parseInt(System.getProperty("property.verbose").trim());
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("-property.verbose expects a number");
            }
        }
        if (this.jutilsProperties == null) {
            this.jutilsProperties = new Properties();
        }
        if ((properties = Property.argsToProps(stringArray)) != null && ((Hashtable)properties).get("---help") != null) {
            this.wantsHelp = true;
        }
        this.addArgs2Props(this.jutilsProperties, properties);
        this.replaceVariables();
        if (this.supportArrays) {
            this.scanArrays();
        }
        if (this.verbose >= 1) {
            System.out.println("Property: Added " + stringArray.length / 2 + " property pairs");
        }
    }

    public final I_PropertyChangeListener addPropertyChangeListener(String string, String string2, I_PropertyChangeListener i_PropertyChangeListener) {
        if (string == null || i_PropertyChangeListener == null) {
            throw new IllegalArgumentException("addPropertyChangeListener got illegal arguments key=" + string);
        }
        Object object = this.changeListenerMap.get(string);
        if (object == null) {
            object = new HashSet();
            this.changeListenerMap.put(string, object);
        }
        HashSet hashSet = (HashSet)object;
        hashSet.add(i_PropertyChangeListener);
        if (string2 != null) {
            String string3;
            i_PropertyChangeListener.propertyChanged(new PropertyChangeEvent(string, string3, (string3 = this.get_(string)) == null ? string2 : string3));
        }
        return i_PropertyChangeListener;
    }

    public final I_PropertyChangeListener addPropertyChangeListener(String string, I_PropertyChangeListener i_PropertyChangeListener) {
        return this.addPropertyChangeListener(string, null, i_PropertyChangeListener);
    }

    public static Properties argsToProps(String[] stringArray) throws JUtilsException {
        Properties properties = null;
        if (stringArray == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null && string.startsWith("-")) {
                String string2 = string;
                if (string.equals("--help") || string.equals("-?") || string.equals("-h") || string.equals("-help")) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    ((Hashtable)properties).put("---help", "true");
                } else {
                    if (string.startsWith("--")) {
                        string2 = string.substring(2);
                    } else if (string.startsWith("-")) {
                        string2 = string.substring(1);
                    }
                    if (string2.length() < 1) {
                        throw new JUtilsException("Property.Invalid", "Ignoring argument <" + string + ">.");
                    }
                    if (n + 1 >= stringArray.length) {
                        throw new JUtilsException("Property.MissingValue", "The property '" + string + "' has no value.");
                    }
                    String string3 = stringArray[n + 1];
                    if (string3 == null) {
                        string3 = "";
                    }
                    if (properties == null) {
                        properties = new Properties();
                    }
                    ((Hashtable)properties).put(string2, string3);
                    ++n;
                }
            } else {
                throw new JUtilsException("Property.Invalid", "Ignoring unknown argument <" + string + ">, it should start with '-'.");
            }
            ++n;
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        try {
            Property property = (Property)super.clone();
            property.jutilsProperties = (Properties)((Hashtable)this.jutilsProperties).clone();
            property.jutilsMap = this.jutilsMap != null ? (TreeMap)((TreeMap)this.jutilsMap).clone() : null;
            property.changeListenerMap = (HashMap)this.changeListenerMap.clone();
            return property;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (this.verbose >= 1) {
                System.err.println("Property clone failed: " + cloneNotSupportedException.toString());
            }
            throw new RuntimeException("org.jutils.init.Property clone failed: " + cloneNotSupportedException.toString());
        }
    }

    public final FileInfo findArgsFile(Properties properties) {
        String string = (String)((Hashtable)properties).get("propertyFile");
        if (string != null) {
            FileInfo fileInfo = this.findPath(string);
            if (fileInfo != null) {
                this.propertyFileName = string;
            } else if (this.verbose >= 0) {
                System.out.println("Property: ERROR: File '-propertyFile " + string + "' not found!");
            }
            return fileInfo;
        }
        return null;
    }

    public final FileInfo findFile(String string, Properties properties) {
        FileInfo fileInfo = this.findArgsFile(properties);
        if (fileInfo != null) {
            return fileInfo;
        }
        return this.findGivenFile(string);
    }

    public final FileInfo findGivenFile(String string) {
        if (string == null) {
            if (this.verbose >= 2) {
                System.out.println("Property: No property file specified.");
            }
            return null;
        }
        FileInfo fileInfo = this.findPath(string);
        if (fileInfo == null && this.verbose >= 1) {
            System.err.println("Property: File '" + string + "' not found");
        }
        return fileInfo;
    }

    public final FileInfo findPath(String string) {
        Object object;
        ClassLoader classLoader;
        if (string == null) {
            return null;
        }
        File file = null;
        FileInfo fileInfo = new FileInfo(string);
        file = new File(this.currentPath, string);
        if (file.exists()) {
            if (this.verbose >= 1) {
                System.out.println("Property: Loading " + string + " from directory " + this.currentPath);
            }
            fileInfo.path = this.currentPath;
            return fileInfo;
        }
        if (this.verbose >= 2) {
            System.out.println("Property: File '" + string + "' is not in current directory " + this.currentPath);
        }
        if ((file = new File(string)).exists()) {
            if (this.verbose >= 1) {
                System.out.println("Property: Loading " + string + " from directory " + this.currentPath);
            }
            fileInfo.path = file.getName();
            fileInfo.fullPath = string;
            return fileInfo;
        }
        if (this.verbose >= 2) {
            System.out.println("Property: File '" + string + "' is not in current directory " + this.currentPath);
        }
        if (this.projectHomePath == null) {
            if (this.verbose >= 2) {
                System.out.println("Property: File '" + string + "' is not in PROJECT_HOME, 'java -DPROJECT_HOME=...' is not set ...");
            }
        } else {
            if (!this.projectHomePath.endsWith(separator)) {
                this.projectHomePath = String.valueOf(this.projectHomePath) + separator;
            }
            if ((file = new File(this.projectHomePath, string)).exists()) {
                if (this.verbose >= 1) {
                    System.out.println("Property: Loading " + string + " from directory " + this.projectHomePath);
                }
                fileInfo.path = this.projectHomePath;
                return fileInfo;
            }
            if (this.verbose >= 2) {
                System.out.println("Property: File '" + string + "' is not in directory PROJECT_HOME=" + this.projectHomePath);
            }
        }
        if ((file = new File(userHome, string)).exists()) {
            if (this.verbose >= 1) {
                System.out.println("Property: Loading " + string + " from directory " + userHome);
            }
            fileInfo.path = userHome;
            return fileInfo;
        }
        if (this.verbose >= 2) {
            System.out.println("Property: File '" + string + "' is not in user.home directory " + userHome);
        }
        if ((classLoader = (class$org$jutils$init$Property != null ? class$org$jutils$init$Property : (class$org$jutils$init$Property = Property.class$("org.jutils.init.Property"))).getClassLoader()) != null && (object = classLoader.getResource(string)) != null) {
            fileInfo.in = classLoader.getResourceAsStream(string);
            fileInfo.fullPath = ((URL)object).getFile();
            if (this.verbose >= 1) {
                System.out.println("Property: Loading " + string + " from CLASSPATH " + fileInfo.getFullPath());
            }
            return fileInfo;
        }
        if (this.verbose >= 2) {
            System.out.println("Property: File '" + string + "' is not in CLASSPATH");
        }
        if ((file = new File(javaHomeExt, string)).exists()) {
            if (this.verbose >= 1) {
                System.out.println("Property: Loading " + string + " from directory " + javaHomeExt);
            }
            fileInfo.path = javaHomeExt;
            return fileInfo;
        }
        if (this.verbose >= 2) {
            System.out.println("Property: File '" + string + "' is not in java.home/lib/ext directory " + javaHomeExt);
        }
        if ((file = new File(javaHome, string)).exists()) {
            if (this.verbose >= 1) {
                System.out.println("Property: Loading " + string + " from directory " + javaHome);
            }
            fileInfo.path = javaHome;
            return fileInfo;
        }
        if (this.verbose >= 2) {
            System.out.println("Property: File '" + string + "' is not in java.home directory " + javaHome);
        }
        if ((file = new File((String)(object = separator.equals("/") ? "/usr/local/jutils/" : "\\jutils\\"), string)).exists()) {
            if (this.verbose >= 1) {
                System.out.println("Property: Loading " + string + " from directory " + (String)object);
            }
            fileInfo.path = object;
            return fileInfo;
        }
        if (this.verbose >= 2) {
            System.out.println("Property: File '" + string + "' is not in directory " + (String)object);
        }
        return null;
    }

    private void fireChangeEvent(String string, String string2, String string3) {
        if (string == null || string3 != null && string3.equals(string2) || string3 == null && string2 == null) {
            return;
        }
        Object v = this.changeListenerMap.get(string);
        if (v != null) {
            Set set = (Set)v;
            Iterator iterator = set.iterator();
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(string, string2, string3);
            while (iterator.hasNext()) {
                I_PropertyChangeListener i_PropertyChangeListener = (I_PropertyChangeListener)iterator.next();
                i_PropertyChangeListener.propertyChanged(propertyChangeEvent);
            }
        }
    }

    public final double get(String string, double d) {
        String string2 = this.get_(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public final float get(String string, float f) {
        String string2 = this.get_(string);
        if (string2 == null) {
            return f;
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (Exception exception) {
            return f;
        }
    }

    public final int get(String string, int n) {
        String string2 = this.get_(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public final long get(String string, long l) {
        String string2 = this.get_(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public final String get(String string, String string2) {
        String string3 = this.get_(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public final Map get(String string, Map map) {
        Map map2 = this.getMap_(string);
        if (map2 == null) {
            return map;
        }
        return map2;
    }

    public final boolean get(String string, boolean bl) {
        String string2 = this.get_(string);
        if (string2 == null) {
            return bl;
        }
        try {
            return Property.toBool(string2);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public final String[] get(String string, String[] stringArray, String string2) {
        String string3 = this.get_(string);
        if (string3 == null) {
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n2++] = stringTokenizer.nextToken().trim();
        }
        return stringArray2;
    }

    private Map getMap_(String string) {
        if (this.jutilsMap == null) {
            return null;
        }
        return (Map)this.jutilsMap.get(string);
    }

    public final Properties getProperties() {
        return this.jutilsProperties;
    }

    private String get_(String string) {
        String string2;
        if (this.applet != null && (string2 = this.applet.getParameter(string)) != null) {
            return string2;
        }
        return (String)((Hashtable)this.jutilsProperties).get(string);
    }

    private void init(String string, boolean bl, String[] stringArray, boolean bl2, boolean bl3) throws JUtilsException {
        Properties properties;
        this.propertyFileName = string;
        if (System.getProperty("property.verbose") != null) {
            try {
                this.verbose = Integer.parseInt(System.getProperty("property.verbose").trim());
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("-property.verbose expects a number");
            }
        }
        if ((properties = Property.argsToProps(stringArray)) != null && ((Hashtable)properties).get("---help") != null) {
            this.wantsHelp = true;
        }
        if (this.verbose >= 2) {
            System.out.println("Property: filenName=" + string + ", scanSystemProperties=" + bl + ", args=" + (properties == null ? "null" : "[" + ((Hashtable)properties).size() + "]") + ", replaceVariables=" + bl2 + ", supportArrays=" + bl3);
        }
        this.propertyFileName = string;
        this.scanSystemProperties = bl;
        this.replaceVariables = bl2;
        this.supportArrays = bl3;
        separator = System.getProperty("file.separator");
        userHome = System.getProperty("user.home");
        this.currentPath = System.getProperty("user.dir");
        this.projectHomePath = System.getProperty("PROJECT_HOME");
        javaHomeExt = System.getProperty("java.ext.dirs");
        javaHome = System.getProperty("java.home");
        this.loadProps(this.findGivenFile(this.propertyFileName), properties);
        if (this.jutilsProperties == null) {
            this.jutilsProperties = this.dummyProperties;
        }
    }

    public final Properties loadProps(FileInfo fileInfo, Properties properties) throws JUtilsException {
        if (this.jutilsProperties != null && this.verbose >= 1) {
            System.out.println("Property: reload loadProps()");
        }
        this.jutilsProperties = new Properties();
        try {
            String string;
            Object object;
            block19: {
                block17: {
                    block18: {
                        block16: {
                            if (fileInfo == null) break block17;
                            object = fileInfo.getInputStream();
                            if (object == null) break block18;
                            try {
                                this.jutilsProperties.load((InputStream)object);
                                if (this.verbose < 2) break block16;
                                System.out.println("Property: Loaded file " + this.propertyFileName);
                            }
                            catch (Throwable throwable) {
                                Object var5_6 = null;
                                fileInfo.closeInputStream();
                                throw throwable;
                            }
                        }
                        string = null;
                        fileInfo.closeInputStream();
                        break block19;
                    }
                    if (this.verbose >= 1) {
                        System.out.println("Property: No property file given.");
                    }
                    break block19;
                }
                if (this.verbose >= 0 && this.propertyFileName != null) {
                    System.err.println("Property: Please copy " + this.propertyFileName + " to your home directory. We continue with default settings.");
                }
            }
            if (this.scanSystemProperties) {
                object = System.getProperties();
                Enumeration<?> enumeration = ((Properties)object).propertyNames();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    String string2 = System.getProperty(string);
                    ((Hashtable)this.jutilsProperties).put(string, string2);
                    this.fireChangeEvent(string, null, string2);
                }
            } else if (this.verbose >= 1) {
                System.out.println("Property: No system properties scanned.");
            }
            if (properties != null) {
                this.addArgs2Props(this.jutilsProperties, properties);
            } else if (this.verbose >= 1) {
                System.out.println("Property: No args array given.");
            }
            if (this.replaceVariables) {
                this.replaceVariables();
            }
            if (this.supportArrays) {
                this.scanArrays();
            }
        }
        catch (IOException iOException) {
            throw new JUtilsException("Property.Error", "Unable to initialize " + this.propertyFileName + ": " + iOException);
        }
        return this.jutilsProperties;
    }

    public static void main(String[] stringArray) {
        Object object;
        Cloneable cloneable;
        boolean bl;
        String string = ME;
        try {
            bl = Args.getArg(stringArray, "-dump", false);
            if (bl) {
                cloneable = new Property("jutils-test.properties", true, stringArray, true);
                System.out.println(((Property)cloneable).toXml());
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        try {
            bl = Args.getArg(stringArray, "-testClasspathProperties", false);
            if (bl) {
                cloneable = new Property("jutils-test.properties", true, stringArray, true);
                System.out.println("data=" + ((Property)cloneable).get("data", "ERROR"));
                ((Property)cloneable).saveProps();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        try {
            boolean bl2 = Args.getArg(stringArray, "-testSetArray", false);
            if (bl2) {
                cloneable = new Property(null, true, stringArray, true);
                ((Property)cloneable).set("Array[a][b]", "arrayvalue");
                System.out.println(((Property)cloneable).toXml());
                System.exit(0);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        try {
            boolean bl3 = Args.getArg(stringArray, "-urlVariant", false);
            if (bl3) {
                System.out.println("*** Test 1");
                cloneable = new Property(null, true, null, true);
                System.out.println("TestVariable=" + ((Property)cloneable).get("TestVariable", "ERROR"));
                System.out.println("java.home=" + ((Property)cloneable).get("java.home", "ERROR"));
                System.out.println("*** Test 2");
                object = Args.getArg(stringArray, "-url", "http://localhost/xy.properties");
                Property property = new Property((String)object, true, null, true);
                System.out.println("TestVariable=" + property.get("TestVariable", "ERROR"));
                System.out.println("java.home=" + property.get("java.home", "ERROR"));
                System.exit(0);
            }
        }
        catch (JUtilsException jUtilsException) {
            System.err.println(jUtilsException.toString());
            System.exit(0);
        }
        try {
            boolean bl4 = Args.getArg(stringArray, "-hashVariant", false);
            if (bl4) {
                System.out.println("*** Test 1");
                cloneable = new Properties();
                ((Hashtable)cloneable).put("city", "Auckland");
                ((Hashtable)cloneable).put("country", "NewZealand");
                object = new Property(null, true, (Properties)cloneable, true);
                System.out.println("city=" + ((Property)object).get("city", "ERROR"));
                System.out.println("country=" + ((Property)object).get("country", "ERROR"));
                System.out.println("TestVariable=" + ((Property)object).get("TestVariable", "shouldBeUndef"));
                System.out.println("java.home=" + ((Property)object).get("java.home", "ERROR"));
                System.exit(0);
            }
        }
        catch (JUtilsException jUtilsException) {
            System.err.println(jUtilsException.toString());
            System.exit(0);
        }
    }

    public final boolean propertyExists(String string) {
        String string2 = this.get_(string);
        return string2 != null;
    }

    public static String[] propsToArgs(Properties properties) {
        if (properties == null) {
            return new String[0];
        }
        String[] stringArray = new String[((Hashtable)properties).size() * 2];
        Enumeration enumeration = ((Hashtable)properties).keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringArray[n] = "-" + string;
            stringArray[++n] = properties.getProperty(string);
            ++n;
        }
        return stringArray;
    }

    public final String removeProperty(String string) {
        String string2 = (String)((Hashtable)this.jutilsProperties).remove(string);
        this.fireChangeEvent(string, string2, null);
        return string2;
    }

    public final void removePropertyChangeListener(String string, I_PropertyChangeListener i_PropertyChangeListener) {
        if (string == null) {
            throw new IllegalArgumentException("removePropertyChangeListener got illegal arguments key=" + string);
        }
        Object v = this.changeListenerMap.get(string);
        if (v != null) {
            Set set = (Set)v;
            if (i_PropertyChangeListener != null) {
                set.remove(i_PropertyChangeListener);
            } else {
                set.clear();
            }
            if (set.size() < 1) {
                this.changeListenerMap.remove(string);
            }
        }
    }

    private final String replaceVariable(String string, String string2) throws JUtilsException {
        string2 = this.replaceVariableWithException(string, string2);
        return this.replaceVariableNoException(string, string2);
    }

    private final String replaceVariableNoException(String string, String string2) throws JUtilsException {
        if (!this.replaceVariables) {
            return string2;
        }
        String string3 = string2;
        int n = 0;
        while (true) {
            String string4;
            String string5;
            int n2;
            if ((n2 = string2.indexOf("$_{")) != -1) {
                int n3 = string2.indexOf("}", n2);
                if (n3 == -1) {
                    throw new JUtilsException("Property.InvalidVariable", "Invalid variable '" + string2.substring(n2) + "', expecting ${} syntax.");
                }
                string5 = string2.substring(n2, n3 + 1);
                String string6 = string5.substring(3, string5.length() - 1);
                string4 = this.get_(string6);
                if (string4 == null) {
                    if (this.verbose >= 2) {
                        System.out.println("Property: Unknown variable " + string5 + " is not replaced");
                    }
                    return string2;
                }
            } else {
                if (n > 0 && this.verbose >= 2) {
                    System.out.println("Property: Replacing '" + string + "=" + string3 + "' to '" + string2 + "'");
                }
                return string2;
            }
            string2 = StringHelper.replaceAll(string2, string5, string4);
            if (n > 50) {
                if (this.verbose >= 1) {
                    System.out.println("Property: Maximum nested depth of 50 reached for variable '" + this.get_(string) + "'.");
                }
                return string2;
            }
            ++n;
        }
    }

    private final String replaceVariableWithException(String string, String string2) throws JUtilsException {
        if (!this.replaceVariables) {
            return string2;
        }
        String string3 = string2;
        int n = 0;
        while (true) {
            String string4;
            String string5;
            int n2;
            if ((n2 = string2.indexOf("${")) != -1) {
                int n3 = string2.indexOf("}", n2);
                if (n3 == -1) {
                    throw new JUtilsException("Property.InvalidVariable", "Invalid variable '" + string2.substring(n2) + "', expecting ${} syntax.");
                }
                string5 = string2.substring(n2, n3 + 1);
                String string6 = string5.substring(2, string5.length() - 1);
                string4 = this.get_(string6);
                if (string4 == null) {
                    throw new JUtilsException("Property.UnknownVariable", "Unknown variable " + string5);
                }
            } else {
                if (n > 0 && this.verbose >= 2) {
                    System.out.println("Property: Replacing '" + string + "=" + string3 + "' to '" + string2 + "'");
                }
                return string2;
            }
            string2 = StringHelper.replaceAll(string2, string5, string4);
            if (n > 50) {
                throw new JUtilsException("Property.MaxNest", "Maximum nested depth of 50 reached for variable '" + this.get_(string) + "'.");
            }
            ++n;
        }
    }

    private final void replaceVariables() throws JUtilsException {
        if (!this.replaceVariables) {
            return;
        }
        Enumeration enumeration = ((Hashtable)this.jutilsProperties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.get_(string);
            if (string2.equals("${PROJECT_HOME}")) {
                ((Hashtable)this.jutilsProperties).put(string, new File("").getAbsolutePath());
                continue;
            }
            String string3 = this.replaceVariable(string, string2);
            if (string3 == null || string3.equals(string2)) continue;
            ((Hashtable)this.jutilsProperties).put(string, string3);
            this.fireChangeEvent(string, string2, string3);
        }
    }

    public void saveProps() throws IOException {
        FileInfo fileInfo = this.findGivenFile(this.propertyFileName);
        if (fileInfo.isLocalDisk()) {
            this.saveProps(fileInfo.getFullPath());
        } else {
            this.saveProps(this.propertyFileName);
        }
    }

    public void saveProps(String string) throws IOException {
        File file = new File(string);
        System.out.println("Property: Saving property to file '" + file.getAbsolutePath() + "'");
        Properties properties = this.getProperties();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, "JUtils property file, including system properties");
        ((OutputStream)fileOutputStream).close();
        System.out.println("Property: Done.");
    }

    private final void scanArray(String string, String string2) throws JUtilsException {
        String string3;
        TreeMap<String, String> treeMap;
        int n = string.indexOf("[");
        if (n < 0) {
            return;
        }
        int n2 = string.indexOf("]", n);
        if (n2 < 0) {
            throw new JUtilsException("Property.scanArrays", "Invalid array, missing closing ']' braket for key='" + string + "'");
        }
        String string4 = string.substring(0, n);
        if (this.jutilsMap == null) {
            this.jutilsMap = new TreeMap();
        }
        if ((treeMap = this.getMap_(string4)) == null) {
            treeMap = new TreeMap<String, String>();
            string3 = (String)((Object)this.jutilsMap.put(string4, treeMap));
        }
        string3 = string.substring(n + 1, n2);
        int n3 = string.indexOf("[", n2 + 1);
        if (n3 >= 0) {
            int n4 = string.indexOf("]", n3);
            if (n4 < 0) {
                throw new JUtilsException("Property.scanArrays", "Invalid array, missing closing ']' braket for key='" + string + "'");
            }
            string3 = String.valueOf(string3) + ":";
            string3 = String.valueOf(string3) + string.substring(n3 + 1, n4);
        }
        string3 = this.replaceVariable(string, string3);
        String string5 = treeMap.put(string3, string2);
        this.fireChangeEvent(string3, string5, string2);
    }

    private final void scanArrays() throws JUtilsException {
        if (!this.supportArrays) {
            return;
        }
        Enumeration enumeration = ((Hashtable)this.jutilsProperties).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.get_(string);
            this.scanArray(string, string2);
        }
    }

    public final String set(String string, String string2) throws JUtilsException {
        String string3 = this.get_(string);
        string2 = this.replaceVariable(string, string2);
        this.jutilsProperties.setProperty(string, string2);
        this.fireChangeEvent(string, string3, string2);
        if (this.supportArrays) {
            this.scanArray(string, string2);
        }
        return string2;
    }

    public void setApplet(Applet applet) {
        this.applet = applet;
        if (applet.getParameter("--help") != null || applet.getParameter("-?") != null || applet.getParameter("-h") != null || applet.getParameter("-help") != null) {
            this.wantsHelp = true;
        }
    }

    public static final boolean toBool(String string) throws JUtilsException {
        if (string == null) {
            throw new JUtilsException(ME, "Can't parse <null> to true or false");
        }
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1") || string.equalsIgnoreCase("ok") || string.equalsIgnoreCase("yes")) {
            return true;
        }
        if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0") || string.equalsIgnoreCase("no")) {
            return false;
        }
        throw new JUtilsException(ME, "Can't parse <" + string + "> to true or false");
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(String string) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(5000);
        if (string == null) {
            string = "";
        }
        String string2 = "\n " + string;
        stringBuffer.append(string2).append("<Property>");
        Enumeration<?> enumeration = this.jutilsProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).indexOf("[") != -1) continue;
            object = StringHelper.replaceAll((String)object, "/", ".");
            stringBuffer.append(string2).append("  <");
            stringBuffer.append((String)object).append(">");
            stringBuffer.append(StringHelper.replaceAll((String)((Hashtable)this.jutilsProperties).get(object), "<", "&lt;"));
            stringBuffer.append("</").append((String)object).append(">");
        }
        if (this.jutilsMap != null) {
            object = this.jutilsMap.keySet().iterator();
            stringBuffer.append(string2).append("  <arrays>");
            while (object.hasNext()) {
                String string3 = (String)object.next();
                Map map = this.get(string3, (Map)null);
                string3 = StringHelper.replaceAll(string3, "/", ".");
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    stringBuffer.append(string2).append("    <").append(string3).append(" index='").append(string4).append("'>");
                    stringBuffer.append(StringHelper.replaceAll((String)map.get(string4), "<", "&lt;"));
                    stringBuffer.append("</").append(string3).append(">");
                }
            }
            stringBuffer.append(string2).append("  </arrays>");
        }
        stringBuffer.append(string2).append("</Property>");
        return stringBuffer.toString();
    }

    public final boolean wantsHelp() {
        return this.wantsHelp;
    }

    public class FileInfo {
        String path;
        String fileName;
        String fullPath;
        InputStream in;

        FileInfo(String string) {
            this.fileName = string;
        }

        public void closeInputStream() {
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
            }
            catch (IOException iOException) {}
        }

        public String getFullPath() {
            if (this.fullPath != null) {
                return this.fullPath;
            }
            if (this.path == null && this.fileName == null) {
                return null;
            }
            if (this.path == null) {
                return this.fileName;
            }
            if (this.fileName == null) {
                return this.path;
            }
            return FileUtil.concatPath(this.path, this.fileName);
        }

        public InputStream getInputStream() throws JUtilsException {
            try {
                if (this.in != null) {
                    return this.in;
                }
                if (this.getFullPath() != null) {
                    if (this.getFullPath().indexOf("!") >= 0) {
                        ClassLoader classLoader = (class$org$jutils$init$Property != null ? class$org$jutils$init$Property : (class$org$jutils$init$Property = Property.class$("org.jutils.init.Property"))).getClassLoader();
                        this.in = classLoader.getResourceAsStream(this.getFullPath());
                    } else {
                        File file = new File(this.getFullPath());
                        this.in = new FileInputStream(file);
                    }
                }
                return this.in;
            }
            catch (IOException iOException) {
                throw new JUtilsException("Property.FileInfo", iOException.toString());
            }
        }

        public boolean isLocalDisk() {
            return this.getFullPath() != null && this.getFullPath().indexOf("!") < 0;
        }
    }
}

