/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.log;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.jutils.JUtilsException;
import org.jutils.init.Property;
import org.jutils.log.LogConstants;
import org.jutils.log.LogDeviceConsole;
import org.jutils.log.LogDeviceFile;
import org.jutils.log.LogableDevice;
import org.jutils.runtime.StackTrace;

public class LogChannel
implements LogConstants {
    private Vector devices = null;
    private Property property = null;
    protected int LOGLEVEL = 135;
    private int lookAndFeelDate = 2;
    private int lookAndFeelTime = 2;
    private Locale country = Locale.getDefault();
    private String currentLogFormat = "{0} {1} {4} {2} : {3} ";
    private boolean logFormatPropertyRead = false;
    private String channelKey = null;
    public boolean CALL = false;
    public boolean TIME = false;
    public boolean TRACE = false;
    public boolean DUMP = false;
    public boolean PLAIN = false;

    public LogChannel(String string, Property property) {
        this.setChannelKey(string);
        this.property = property;
        this.devices = new Vector();
        if (this.property != null) {
            this.initialize();
        }
    }

    public LogChannel(Property property) {
        this.property = property;
        this.devices = new Vector();
        if (this.property != null) {
            this.initialize();
        }
    }

    public boolean addLogDevice(LogableDevice logableDevice) {
        if (logableDevice != null) {
            this.devices.addElement(logableDevice);
            return true;
        }
        return false;
    }

    public void addLogLevel(int n) {
        this.LOGLEVEL |= n;
        this.initLevel();
    }

    public void addLogLevel(String string) {
        int n = LogChannel.logLevelToBit(string);
        this.LOGLEVEL |= n;
        this.initLevel();
    }

    public void addLogLevelChecked(String string) throws JUtilsException {
        int n = LogChannel.logLevelToBitChecked(string);
        this.LOGLEVEL |= n;
        this.initLevel();
    }

    public static final String bitToLogLevel(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) > 0) {
            stringBuffer.append("ERROR");
        }
        if ((n & 2) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("WARN");
        }
        if ((n & 4) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("INFO");
        }
        if ((n & 8) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CALL");
        }
        if ((n & 0x10) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("TIME");
        }
        if ((n & 0x20) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("TRACE");
        }
        if ((n & 0x40) > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("DUMP");
        }
        return stringBuffer.toString();
    }

    public void call(String string, String string2) {
        this.log(8, string, string2);
    }

    public void dump(String string, String string2) {
        this.log(64, string, string2);
    }

    public void error(String string, String string2) {
        this.log(1, string, string2);
    }

    public void exception(String string, Throwable throwable) {
        String string2 = StackTrace.getStackTrace(throwable);
        this.log(1, string, string2);
    }

    public String formatLogData(String string, int n, String string2, String string3) {
        String string4 = (n & 0x80) != 0 ? "{3}" : this.currentLogFormat;
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(this.lookAndFeelDate, this.lookAndFeelTime, this.country);
        String string5 = dateFormat.format(date);
        Object[] objectArray = new Object[]{string5, string, string2, string3, Thread.currentThread().getName()};
        String string6 = MessageFormat.format(string4, objectArray);
        return string6;
    }

    public String getChannelKey() {
        return this.channelKey;
    }

    public int getLogLevel() {
        return this.LOGLEVEL;
    }

    public void info(String string, String string2) {
        this.log(4, string, string2);
    }

    private final void initLevel() {
        this.CALL = this.isLoglevelEnabled(8);
        this.TIME = this.isLoglevelEnabled(16);
        this.TRACE = this.isLoglevelEnabled(32);
        this.DUMP = this.isLoglevelEnabled(64);
        this.PLAIN = this.isLoglevelEnabled(128);
    }

    private void initialize() {
        boolean bl;
        String string;
        this.logFormatPropertyRead = true;
        if (this.property == null) {
            try {
                this.property = new Property(null, false, null, false);
            }
            catch (JUtilsException jUtilsException) {
                System.err.println(jUtilsException.toXml(true));
                return;
            }
        }
        if (this.property.propertyExists("error")) {
            if (this.property.get("error", false)) {
                this.addLogLevel("ERROR");
            } else {
                this.removeLogLevel("ERROR");
            }
        }
        if (this.channelKey != null && this.property.propertyExists(string = "error[" + this.channelKey + "]")) {
            if (this.property.get(string, false)) {
                this.addLogLevel("ERROR");
            } else {
                this.removeLogLevel("ERROR");
            }
        }
        if (this.property.propertyExists("warn")) {
            if (this.property.get("warn", false)) {
                this.addLogLevel("WARN");
            } else {
                this.removeLogLevel("WARN");
            }
        }
        if (this.channelKey != null && this.property.propertyExists(string = "warn[" + this.channelKey + "]")) {
            if (this.property.get(string, false)) {
                this.addLogLevel("WARN");
            } else {
                this.removeLogLevel("WARN");
            }
        }
        if (this.property.propertyExists("info")) {
            if (this.property.get("info", false)) {
                this.addLogLevel("INFO");
            } else {
                this.removeLogLevel("INFO");
            }
        }
        if (this.channelKey != null && this.property.propertyExists(string = "info[" + this.channelKey + "]")) {
            if (this.property.get(string, false)) {
                this.addLogLevel("INFO");
            } else {
                this.removeLogLevel("INFO");
            }
        }
        if (this.property.propertyExists("call")) {
            if (this.property.get("call", false)) {
                this.addLogLevel("CALL");
            } else {
                this.removeLogLevel("CALL");
            }
        }
        if (this.channelKey != null && this.property.propertyExists(string = "call[" + this.channelKey + "]")) {
            if (this.property.get(string, false)) {
                this.addLogLevel("CALL");
            } else {
                this.removeLogLevel("CALL");
            }
        }
        if (this.property.propertyExists("time")) {
            if (this.property.get("time", false)) {
                this.addLogLevel("TIME");
            } else {
                this.removeLogLevel("TIME");
            }
        }
        if (this.channelKey != null && this.property.propertyExists(string = "time[" + this.channelKey + "]")) {
            if (this.property.get(string, false)) {
                this.addLogLevel("TIME");
            } else {
                this.removeLogLevel("TIME");
            }
        }
        if (this.property.propertyExists("trace")) {
            if (this.property.get("trace", false)) {
                this.addLogLevel("TRACE");
            } else {
                this.removeLogLevel("TRACE");
            }
        }
        if (this.channelKey != null && this.property.propertyExists(string = "trace[" + this.channelKey + "]")) {
            if (this.property.get(string, false)) {
                this.addLogLevel("TRACE");
            } else {
                this.removeLogLevel("TRACE");
            }
        }
        if (this.property.propertyExists("dump")) {
            if (this.property.get("dump", false)) {
                this.addLogLevel("DUMP");
            } else {
                this.removeLogLevel("DUMP");
            }
        }
        if (this.channelKey != null && this.property.propertyExists(string = "dump[" + this.channelKey + "]")) {
            if (this.property.get(string, false)) {
                this.addLogLevel("DUMP");
            } else {
                this.removeLogLevel("DUMP");
            }
        }
        if (this.property.propertyExists("plain")) {
            if (this.property.get("plain", false)) {
                this.addLogLevel("PLAIN");
            } else {
                this.removeLogLevel("PLAIN");
            }
        }
        if (this.channelKey != null && this.property.propertyExists(string = "plain[" + this.channelKey + "]")) {
            if (this.property.get(string, false)) {
                this.addLogLevel("PLAIN");
            } else {
                this.removeLogLevel("PLAIN");
            }
        }
        this.currentLogFormat = this.property.get("LogFormat", this.currentLogFormat);
        string = this.property.get("LogFormat.Date", "MEDIUM").trim();
        if (string.equalsIgnoreCase("SHORT")) {
            this.lookAndFeelDate = 3;
        } else if (string.equalsIgnoreCase("MEDIUM")) {
            this.lookAndFeelDate = 2;
        } else if (string.equalsIgnoreCase("LONG")) {
            this.lookAndFeelDate = 1;
        } else if (string.equalsIgnoreCase("FULL")) {
            this.lookAndFeelDate = 0;
        }
        string = this.property.get("LogFormat.Time", "MEDIUM").trim();
        if (string.equalsIgnoreCase("SHORT")) {
            this.lookAndFeelTime = 3;
        } else if (string.equalsIgnoreCase("MEDIUM")) {
            this.lookAndFeelTime = 2;
        } else if (string.equalsIgnoreCase("LONG")) {
            this.lookAndFeelTime = 1;
        } else if (string.equalsIgnoreCase("FULL")) {
            this.lookAndFeelTime = 0;
        }
        String string2 = this.property.get("LogFormat.Language", (String)null);
        String string3 = this.property.get("LogFormat.Country", (String)null);
        if (string2 != null && string3 != null) {
            this.country = new Locale(string2, string3);
        }
        if (bl = this.property.get("removeAll", false)) {
            this.removeAllDevices();
        }
        this.initLevel();
    }

    public final void initialize(Property property) {
        this.property = property;
        this.initialize();
    }

    public final void initialize(String[] stringArray) {
        try {
            this.property = new Property(null, false, stringArray, false);
        }
        catch (JUtilsException jUtilsException) {
            System.err.println(jUtilsException.toXml(true));
            return;
        }
        this.initialize(this.property);
    }

    public boolean isLoglevelEnabled(int n) {
        return (this.LOGLEVEL & n) == n;
    }

    public boolean isLoglevelEnabled(String string) throws JUtilsException {
        return this.isLoglevelEnabled(LogChannel.logLevelToBitChecked(string));
    }

    public void log(int n, String string, String string2) {
        if ((this.LOGLEVEL & n) != 0) {
            Enumeration enumeration = this.devices.elements();
            while (enumeration.hasMoreElements()) {
                LogableDevice logableDevice = (LogableDevice)enumeration.nextElement();
                if (logableDevice == null) continue;
                logableDevice.log(n, string, string2);
            }
        }
    }

    private static final int logLevelToBit(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("ERROR")) {
            return 1;
        }
        if (string.equalsIgnoreCase("WARN")) {
            return 2;
        }
        if (string.equalsIgnoreCase("INFO")) {
            return 4;
        }
        if (string.equalsIgnoreCase("CALL")) {
            return 8;
        }
        if (string.equalsIgnoreCase("TIME")) {
            return 16;
        }
        if (string.equalsIgnoreCase("TRACE")) {
            return 32;
        }
        if (string.equalsIgnoreCase("DUMP")) {
            return 64;
        }
        if (string.equalsIgnoreCase("PLAIN")) {
            return 128;
        }
        System.err.println("Unknown logging level '" + string + "'");
        return 0;
    }

    private static final int logLevelToBitChecked(String string) throws JUtilsException {
        int n = LogChannel.logLevelToBit(string);
        if (n == 0) {
            throw new JUtilsException("LogChannel", "Given log level '" + string + "' is illegal");
        }
        return n;
    }

    public static void main(String[] stringArray) {
        LogChannel logChannel = new LogChannel(null);
        System.out.println("TEST 1:");
        System.out.println("Test if NO logging device does exist.");
        logChannel.error("Source1", "Text1");
        logChannel.warn("Source2", "Text2");
        logChannel.info("Source3", "Text3");
        logChannel.call("Source4", "Text4");
        logChannel.time("Source5", "Text5");
        logChannel.trace("Source6", "Text6");
        logChannel.plain("Source7", "Text7");
        System.out.println("END TEST 1\n");
        System.out.println("TEST 2:");
        System.out.println("Test with 1 console logging device with standard LOGLEVEL");
        LogDeviceConsole logDeviceConsole = new LogDeviceConsole(logChannel);
        logChannel.addLogDevice(logDeviceConsole);
        logChannel.error("Source1", "Text1");
        logChannel.warn("Source2", "Text2");
        logChannel.info("Source3", "Text3");
        logChannel.call("Source4", "Text4");
        logChannel.time("Source5", "Text5");
        logChannel.trace("Source6", "Text6");
        logChannel.plain("Source7", "Text7");
        System.out.println("END TEST 2\n");
        System.out.println("TEST 3:");
        System.out.println("Test with 1 console logging device with all LOGLEVELS activated");
        logChannel.setLogLevel(255);
        logChannel.error("Source1", "Text1");
        logChannel.warn("Source2", "Text2");
        logChannel.info("Source3", "Text3");
        logChannel.call("Source4", "Text4");
        logChannel.time("Source5", "Text5");
        logChannel.trace("Source6", "Text6");
        logChannel.plain("Source7", "Text7");
        System.out.println("END TEST 3\n");
        logChannel.initialize(stringArray);
        System.out.println("###\nFrom now on the user defined debug levels are used!\n###");
        System.out.println("TEST 4:");
        System.out.println("Test with 2 console logging devices, one without color");
        LogDeviceConsole logDeviceConsole2 = new LogDeviceConsole(logChannel);
        logDeviceConsole2.setColorMode(false);
        logChannel.addLogDevice(logDeviceConsole2);
        logChannel.error("Source1", "Text1");
        logChannel.warn("Source2", "Text2");
        logChannel.info("Source3", "Text3");
        logChannel.call("Source4", "Text4");
        logChannel.time("Source5", "Text5");
        logChannel.trace("Source6", "Text6");
        logChannel.plain("Source7", "Text7");
        logChannel.removeLogDevice(logDeviceConsole2);
        System.out.println("END TEST 4\n");
        System.out.println("TEST 5:");
        System.out.println("Test with 1 console device and 1 file device");
        LogDeviceFile logDeviceFile = new LogDeviceFile(logChannel, "./test.log");
        logChannel.addLogDevice(logDeviceFile);
        logChannel.error("Source1", "Text1");
        logChannel.warn("Source2", "Text2");
        logChannel.info("Source3", "Text3");
        logChannel.call("Source4", "Text4");
        logChannel.time("Source5", "Text5");
        logChannel.trace("Source6", "Text6");
        logChannel.plain("Source7", "Text7");
        logChannel.removeLogDevice(logDeviceConsole);
        System.out.println("END TEST 5\n");
    }

    public void plain(String string, String string2) {
        this.log(128, string, string2);
    }

    public void removeAllDevices() {
        this.devices.removeAllElements();
    }

    public LogableDevice removeLogDevice(LogableDevice logableDevice) {
        if (logableDevice != null) {
            this.devices.removeElement(logableDevice);
            return logableDevice;
        }
        return null;
    }

    public void removeLogLevel(int n) {
        this.LOGLEVEL &= ~n;
        this.initLevel();
    }

    public void removeLogLevel(String string) {
        int n = LogChannel.logLevelToBit(string);
        this.LOGLEVEL &= ~n;
        this.initLevel();
    }

    public void removeLogLevelChecked(String string) throws JUtilsException {
        int n = LogChannel.logLevelToBitChecked(string);
        this.LOGLEVEL &= ~n;
        this.initLevel();
    }

    private void setChannelKey(String string) {
        this.channelKey = string;
        if (this.channelKey != null && this.channelKey.length() < 1) {
            this.channelKey = null;
        }
    }

    public final void setDefaultLogLevel() {
        this.LOGLEVEL = 135;
        this.initLevel();
    }

    public void setLogFormat(String string, int n, int n2, Locale locale) {
        if (string != null) {
            this.currentLogFormat = string;
        }
        if (n == 3 || n == 2 || n == 1 || n == 0) {
            this.lookAndFeelDate = n;
        }
        if (n2 == 3 || n2 == 2 || n2 == 1 || n2 == 0) {
            this.lookAndFeelTime = n2;
        }
        if (locale != null) {
            this.country = locale;
        }
    }

    public void setLogLevel(int n) {
        this.LOGLEVEL = n;
        this.initLevel();
    }

    public void time(String string, String string2) {
        this.log(16, string, string2);
    }

    public String toXml() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string = "\n";
        stringBuffer.append(string).append("<LogChannel id='").append(this.channelKey).append("'>");
        stringBuffer.append(string).append("  <error>").append((this.LOGLEVEL & 1) == 1).append("</error>");
        stringBuffer.append(string).append("  <warn>").append((this.LOGLEVEL & 2) == 2).append("</warn>");
        stringBuffer.append(string).append("  <info>").append((this.LOGLEVEL & 4) == 4).append("</info>");
        stringBuffer.append(string).append("  <call>").append((this.LOGLEVEL & 8) == 8).append("</call>");
        stringBuffer.append(string).append("  <time>").append((this.LOGLEVEL & 0x10) == 16).append("</time>");
        stringBuffer.append(string).append("  <trace>").append((this.LOGLEVEL & 0x20) == 32).append("</trace>");
        stringBuffer.append(string).append("  <dump>").append((this.LOGLEVEL & 0x40) == 64).append("</dump>");
        stringBuffer.append(string).append("</LogChannel>");
        return stringBuffer.toString();
    }

    public void trace(String string, String string2) {
        this.log(32, string, string2);
    }

    public void warn(String string, String string2) {
        this.log(2, string, string2);
    }
}

