/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.log;

import org.jutils.log.LogChannel;
import org.jutils.log.LogConstants;
import org.jutils.log.LogableDevice;

public class LogDeviceConsole
implements LogConstants,
LogableDevice {
    private static final String ESC = "\u001b[0m";
    private static final String BOLD = "\u001b[1m";
    private static final String RED_BLACK = "\u001b[31;40m";
    private static final String GREEN_BLACK = "\u001b[32;40m";
    private static final String YELLOW_BLACK = "\u001b[33;40m";
    private static final String BLUE_BLACK = "\u001b[34;40m";
    private static final String PINK_BLACK = "\u001b[35;40m";
    private static final String LTGREEN_BLACK = "\u001b[36;40m";
    private static final String WHITE_BLACK = "\u001b[37;40m";
    private static final String WHITE_RED = "\u001b[37;41m";
    private static final String BLACK_RED = "\u001b[30;41m";
    private static final String BLACK_GREEN = "\u001b[40;42m";
    private static final String BLACK_PINK = "\u001b[40;45m";
    private static final String BLACK_LTGREEN = "\u001b[40;46m";
    private static final String errorX = new String("ERROR");
    private static final String warnX = new String("WARN ");
    private static final String infoX = new String("INFO ");
    private static final String callX = new String("CALL ");
    private static final String timeX = new String("TIME ");
    private static final String traceX = new String("TRACE");
    private static final String dumpX = new String("DUMP ");
    private static final String plainX = new String("     ");
    private static final String errorE = new String("\u001b[31;40mERROR\u001b[0m");
    private static final String warnE = new String("\u001b[33;40mWARN \u001b[0m");
    private static final String infoE = new String("\u001b[32;40mINFO \u001b[0m");
    private static final String callE = new String("\u001b[34;40mCALL \u001b[0m");
    private static final String timeE = new String("\u001b[36;40mTIME \u001b[0m");
    private static final String traceE = new String("\u001b[37;40mTRACE\u001b[0m");
    private static final String dumpE = new String("\u001b[35;40mDUMP \u001b[0m");
    private static final String plainE = new String("\u001b[37;40m     \u001b[0m");
    private LogChannel channel = null;
    private boolean withXtermEscapeColor = false;

    public LogDeviceConsole(LogChannel logChannel) {
        this.channel = logChannel;
        this.initialize();
    }

    private String convertLevelToString(int n) {
        if ((n & 1) > 0) {
            if (this.withXtermEscapeColor) {
                return errorE;
            }
            return errorX;
        }
        if ((n & 2) > 0) {
            if (this.withXtermEscapeColor) {
                return warnE;
            }
            return warnX;
        }
        if ((n & 4) > 0) {
            if (this.withXtermEscapeColor) {
                return infoE;
            }
            return infoX;
        }
        if ((n & 8) > 0) {
            if (this.withXtermEscapeColor) {
                return callE;
            }
            return callX;
        }
        if ((n & 0x10) > 0) {
            if (this.withXtermEscapeColor) {
                return timeE;
            }
            return timeX;
        }
        if ((n & 0x20) > 0) {
            if (this.withXtermEscapeColor) {
                return traceE;
            }
            return traceX;
        }
        if ((n & 0x40) > 0) {
            if (this.withXtermEscapeColor) {
                return dumpE;
            }
            return dumpX;
        }
        return "UNKNOWN LEVEL" + n;
    }

    public boolean getColorMode() {
        return this.withXtermEscapeColor;
    }

    public void initialize() {
        String string = System.getProperty("os.name");
        this.withXtermEscapeColor = !string.startsWith("Window");
    }

    public void log(int n, String string, String string2) {
        if (this.channel == null) {
            return;
        }
        String string3 = this.convertLevelToString(n);
        String string4 = this.channel.formatLogData(string3, n, string, string2);
        if ((n & 1) != 0 || (n & 2) != 0) {
            System.err.println(string4);
        } else {
            System.out.println(string4);
        }
    }

    public void setColorMode(boolean bl) {
        this.withXtermEscapeColor = bl;
    }
}

