/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.pool;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.jutils.JUtilsException;
import org.jutils.pool.I_PoolManager;
import org.jutils.pool.ResourceWrapper;

public class PoolManager {
    private String ME = "PoolManager";
    private String poolName = "Resource";
    private I_PoolManager callback = null;
    private Hashtable busy = null;
    private Vector idle = null;
    private int maxInstances = 100;
    private long busyToIdleTimeout = 0L;
    private long idleToEraseTimeout = 0L;
    private long counter = 1L;
    public static final String USE_HASH_CODE = "h";
    public static final String USE_OBJECT_REF = "o";
    public static final String GENERATE_RANDOM = "r";
    private final Object meetingPoint = new Object();

    public PoolManager(String string, I_PoolManager i_PoolManager, int n, long l, long l2) {
        this.poolName = string;
        this.callback = i_PoolManager;
        this.ME = String.valueOf(string) + "-PoolManager";
        this.setMaxInstances(n);
        this.setBusyToIdleTimeout(l);
        this.setIdleToEraseTimeout(l2);
        this.busy = new Hashtable(n);
        this.idle = new Vector(n);
    }

    public void busyRefresh(String string) throws JUtilsException {
        Object object = this.meetingPoint;
        synchronized (object) {
            ResourceWrapper resourceWrapper = this.findLow(string);
            resourceWrapper.touchBusy();
        }
    }

    private String createId(String string) throws JUtilsException {
        if (string == null || !string.equals(GENERATE_RANDOM)) {
            return string;
        }
        try {
            String string2;
            Serializable serializable;
            try {
                serializable = InetAddress.getLocalHost();
                string2 = ((InetAddress)serializable).getHostAddress();
            }
            catch (Exception exception) {
                string2 = "localhost";
            }
            serializable = new Random();
            return String.valueOf(string2) + "-" + this.poolName + "-" + System.currentTimeMillis() + "-" + ((Random)serializable).nextInt() + "-" + this.counter++;
        }
        catch (Exception exception) {
            String string3 = "Can't generate a unique instanceId: " + exception.toString();
            throw new JUtilsException("ResourceNoId", string3);
        }
    }

    public void destroy() {
        Object object = this.meetingPoint;
        synchronized (object) {
            Enumeration enumeration = this.busy.elements();
            while (enumeration.hasMoreElements()) {
                this.erase((ResourceWrapper)enumeration.nextElement());
            }
            this.busy.clear();
            int n = 0;
            while (n < this.idle.size()) {
                ResourceWrapper resourceWrapper = (ResourceWrapper)this.idle.elementAt(n);
                this.callback.toErased(resourceWrapper.getResource());
                resourceWrapper.destroy();
                ++n;
            }
            this.idle.removeAllElements();
        }
    }

    public void erase(String string) {
        if (string == null || string.length() < 1) {
            return;
        }
        Object object = this.meetingPoint;
        synchronized (object) {
            ResourceWrapper resourceWrapper = this.findBusySilent(string);
            if (resourceWrapper == null) {
                resourceWrapper = this.findIdleSilent(string);
            }
            this.erase(resourceWrapper);
        }
    }

    private void erase(ResourceWrapper resourceWrapper) {
        if (resourceWrapper == null) {
            return;
        }
        Object object = this.meetingPoint;
        synchronized (object) {
            if (this.busy.get(resourceWrapper.getInstanceId()) != null) {
                this.swap(resourceWrapper, false);
            }
            this.idle.remove(resourceWrapper);
            this.callback.toErased(resourceWrapper.getResource());
            resourceWrapper.destroy();
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    private ResourceWrapper findBusySilent(String string) {
        if (string == null) {
            return null;
        }
        return (ResourceWrapper)this.busy.get(string);
    }

    private ResourceWrapper findIdleSilent(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this.idle.size()) {
            ResourceWrapper resourceWrapper = (ResourceWrapper)this.idle.elementAt(n);
            if (resourceWrapper.getInstanceId().equals(string)) {
                return resourceWrapper;
            }
            ++n;
        }
        return null;
    }

    private ResourceWrapper findLow(String string) throws JUtilsException {
        if (string == null) {
            String string2 = "Your resource ID is null";
            throw new JUtilsException("ResourceNotFound", string2);
        }
        ResourceWrapper resourceWrapper = this.findBusySilent(string);
        if (resourceWrapper == null) {
            String string3 = "Resource '" + string + "' is invalid, timed out?";
            throw new JUtilsException("ResourceNotFound", string3);
        }
        return resourceWrapper;
    }

    public int getNumBusy() {
        return this.busy.size();
    }

    public int getNumIdle() {
        return this.idle.size();
    }

    public String getState() {
        return "Overview for '" + this.ME + "':" + " BUSY=" + this.busy.size() + " IDLE=" + this.idle.size() + " MAX_AVAILABLE=" + (this.maxInstances - this.busy.size());
    }

    public boolean isBusy(String string) {
        ResourceWrapper resourceWrapper = this.findBusySilent(string);
        return resourceWrapper != null;
    }

    public void release(String string) throws JUtilsException {
        Object object = this.meetingPoint;
        synchronized (object) {
            this.swap(this.findLow(string), false);
        }
    }

    public ResourceWrapper reserve() throws JUtilsException {
        return this.reserve(this.busyToIdleTimeout, this.idleToEraseTimeout, GENERATE_RANDOM);
    }

    public ResourceWrapper reserve(long l, long l2, String string) throws JUtilsException {
        Object object = this.meetingPoint;
        synchronized (object) {
            ResourceWrapper resourceWrapper = null;
            if (string != null && string.length() > 1 && (resourceWrapper = this.findBusySilent(string)) != null) {
                ResourceWrapper resourceWrapper2 = resourceWrapper;
                Object var8_8 = null;
                return resourceWrapper2;
            }
            if (this.idle.size() > 0) {
                resourceWrapper = (ResourceWrapper)this.idle.lastElement();
                resourceWrapper.init(this.createId(string), resourceWrapper.getResource(), l, l2);
                this.swap(resourceWrapper, true);
            } else {
                if (this.busy.size() >= this.maxInstances) {
                    throw new JUtilsException("ResourceExhaust", "Sorry, " + this.maxInstances + " resources consumed, no more resources available");
                }
                string = this.createId(string);
                Object object2 = this.callback.toCreate(string);
                resourceWrapper = new ResourceWrapper(this, string, object2, l, this.idleToEraseTimeout);
                resourceWrapper.toBusy();
                this.busy.put(resourceWrapper.getInstanceId(), resourceWrapper);
            }
            ResourceWrapper resourceWrapper3 = resourceWrapper;
            Object var8_9 = null;
            return resourceWrapper3;
        }
    }

    public ResourceWrapper reserve(String string) throws JUtilsException {
        return this.reserve(this.busyToIdleTimeout, this.idleToEraseTimeout, string);
    }

    private void setBusyToIdleTimeout(long l) {
        this.busyToIdleTimeout = l > 0L && l < 100L ? 100L : l;
    }

    private void setIdleToEraseTimeout(long l) {
        this.idleToEraseTimeout = l > 0L && l < 100L ? 100L : l;
    }

    private void setMaxInstances(int n) {
        this.maxInstances = n;
    }

    private void swap(ResourceWrapper resourceWrapper, boolean bl) {
        if (resourceWrapper == null) {
            System.err.println("##########INTERNAL PROBLEM IN PollManager");
            return;
        }
        if (bl) {
            this.idle.removeElementAt(this.idle.size() - 1);
            this.busy.put(resourceWrapper.getInstanceId(), resourceWrapper);
            resourceWrapper.toBusy();
            this.callback.idleToBusy(resourceWrapper.getResource());
        } else {
            this.busy.remove(resourceWrapper.getInstanceId());
            this.idle.addElement(resourceWrapper);
            resourceWrapper.toIdle();
            this.callback.busyToIdle(resourceWrapper.getResource());
        }
    }

    void timeoutBusyToIdle(ResourceWrapper resourceWrapper) {
        Object object = this.meetingPoint;
        synchronized (object) {
            this.swap(resourceWrapper, false);
        }
    }

    void timeoutIdleToErase(ResourceWrapper resourceWrapper) {
        this.erase(resourceWrapper);
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\n";
        if (string == null) {
            string = "";
        }
        string2 = String.valueOf(string2) + string;
        Object object = this.meetingPoint;
        synchronized (object) {
            stringBuffer.append(string2).append("<").append(this.ME).append(" maxInstances='").append(this.maxInstances);
            stringBuffer.append("' busyToIdleTimeout='").append(this.busyToIdleTimeout);
            stringBuffer.append("' idleToEraseTimeout='").append(this.idleToEraseTimeout).append("'>");
            stringBuffer.append(string2).append("   <busy num='").append(this.busy.size()).append("'>");
            Enumeration enumeration = this.busy.elements();
            while (enumeration.hasMoreElements()) {
                ResourceWrapper resourceWrapper = (ResourceWrapper)enumeration.nextElement();
                stringBuffer.append(resourceWrapper.toXml(String.valueOf(string) + "   "));
            }
            stringBuffer.append(string2).append("   </busy>");
            stringBuffer.append(string2).append("   <idle num='").append(this.idle.size()).append("'>");
            int n = 0;
            while (n < this.idle.size()) {
                ResourceWrapper resourceWrapper = (ResourceWrapper)this.idle.elementAt(n);
                stringBuffer.append(resourceWrapper.toXml(String.valueOf(string) + "   "));
                ++n;
            }
            stringBuffer.append(string2).append("   </idle>");
            stringBuffer.append(string2).append("</" + this.ME + ">");
        }
        return stringBuffer.toString();
    }
}

