/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.pool;

import org.jutils.JUtilsException;
import org.jutils.pool.PoolManager;
import org.jutils.time.I_Timeout;
import org.jutils.time.Timeout;

public class ResourceWrapper
implements I_Timeout {
    private String ME = "ResourceWrapper";
    private String instanceId;
    private Object resource;
    private long creationTime;
    private static final String BUSY_TO_IDLE_TIMEOUT = "BI";
    private static final String IDLE_TO_ERASE_TIMEOUT = "IE";
    private long busyToIdleTimeout;
    private Long busyToIdleTimeoutHandle;
    private long idleToEraseTimeout;
    private Long idleToEraseTimeoutHandle;
    private PoolManager poolManager;

    ResourceWrapper(PoolManager poolManager) {
        this.poolManager = poolManager;
        this.init(null, null, 0L, 0L);
    }

    ResourceWrapper(PoolManager poolManager, String string, Object object, long l, long l2) {
        this.poolManager = poolManager;
        this.init(string, object, l, l2);
    }

    public long busyElapsed() {
        if (this.busyToIdleTimeout <= 0L) {
            return -1L;
        }
        return System.currentTimeMillis() - this.creationTime;
    }

    public void destroy() {
        if (this.busyToIdleTimeoutHandle != null) {
            Timeout.getInstance().removeTimeoutListener(this.busyToIdleTimeoutHandle);
            this.busyToIdleTimeoutHandle = null;
        }
        if (this.idleToEraseTimeoutHandle != null) {
            Timeout.getInstance().removeTimeoutListener(this.idleToEraseTimeoutHandle);
            this.idleToEraseTimeoutHandle = null;
        }
        this.instanceId = null;
        this.resource = null;
        this.poolManager = null;
    }

    public long getBusyToIdleTimeout() {
        return Timeout.getInstance().getTimeout(this.busyToIdleTimeoutHandle);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getIdleToEraseTimeout() {
        return Timeout.getInstance().getTimeout(this.idleToEraseTimeoutHandle);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Object getResource() {
        return this.resource;
    }

    void init(String string, Object object, long l, long l2) {
        this.creationTime = System.currentTimeMillis();
        this.instanceId = string;
        this.resource = object;
        this.setBusyToIdle(l);
        this.setIdleToErase(l2);
        if (object != null) {
            if (this.instanceId == null || this.instanceId.equals("h")) {
                this.instanceId = String.valueOf(object.hashCode());
            } else if (this.instanceId.equals("o")) {
                this.instanceId = String.valueOf(String.valueOf(object));
            }
        }
    }

    public boolean isBusyExpired() {
        if (this.busyToIdleTimeout <= 0L) {
            return false;
        }
        if (this.busyToIdleTimeoutHandle == null) {
            return false;
        }
        return Timeout.getInstance().isExpired(this.busyToIdleTimeoutHandle);
    }

    private void setBusyToIdle(long l) {
        this.stopBusyToIdleTimeout();
        if (l > 0L && l < 100L) {
            l = 100L;
        }
        this.busyToIdleTimeout = l;
    }

    private void setIdleToErase(long l) {
        this.stopIdleToEraseTimeout();
        if (l > 0L && l < 100L) {
            l = 100L;
        }
        this.idleToEraseTimeout = l;
    }

    void setResource(Object object) {
        this.resource = object;
        if (object != null) {
            if (this.instanceId == null || this.instanceId.equals("h")) {
                this.instanceId = String.valueOf(object.hashCode());
            } else if (this.instanceId.equals("o")) {
                this.instanceId = String.valueOf(String.valueOf(object));
            }
        }
        System.out.println("AAAAAAAAAAAAAA:" + this.instanceId);
    }

    public long spanOfTimeToErase() {
        if (this.idleToEraseTimeout <= 0L) {
            return 0L;
        }
        if (this.idleToEraseTimeoutHandle == null) {
            return 0L;
        }
        return Timeout.getInstance().spanToTimeout(this.idleToEraseTimeoutHandle);
    }

    public long spanOfTimeToIdle() {
        if (this.busyToIdleTimeout <= 0L) {
            return 0L;
        }
        if (this.busyToIdleTimeoutHandle == null) {
            return 0L;
        }
        return Timeout.getInstance().spanToTimeout(this.busyToIdleTimeoutHandle);
    }

    private void startBusyToIdleTimeout() {
        this.stopBusyToIdleTimeout();
        if (this.busyToIdleTimeout > 0L) {
            this.busyToIdleTimeoutHandle = Timeout.getInstance().addTimeoutListener(this, this.busyToIdleTimeout, BUSY_TO_IDLE_TIMEOUT);
        }
    }

    private void startIdleToEraseTimeout() {
        this.stopIdleToEraseTimeout();
        if (this.idleToEraseTimeout > 0L) {
            this.idleToEraseTimeoutHandle = Timeout.getInstance().addTimeoutListener(this, this.idleToEraseTimeout, IDLE_TO_ERASE_TIMEOUT);
        }
    }

    private void stopBusyToIdleTimeout() {
        if (this.busyToIdleTimeoutHandle != null) {
            Timeout.getInstance().removeTimeoutListener(this.busyToIdleTimeoutHandle);
            this.busyToIdleTimeoutHandle = null;
        }
    }

    private void stopIdleToEraseTimeout() {
        if (this.idleToEraseTimeoutHandle != null) {
            Timeout.getInstance().removeTimeoutListener(this.idleToEraseTimeoutHandle);
            this.idleToEraseTimeoutHandle = null;
        }
    }

    public void timeout(Object object) {
        String string = (String)object;
        if (string.equals(BUSY_TO_IDLE_TIMEOUT)) {
            this.busyToIdleTimeoutHandle = null;
            this.poolManager.timeoutBusyToIdle(this);
        } else if (string.equals(IDLE_TO_ERASE_TIMEOUT)) {
            this.idleToEraseTimeoutHandle = null;
            this.poolManager.timeoutIdleToErase(this);
        }
    }

    void toBusy() {
        this.stopIdleToEraseTimeout();
        this.startBusyToIdleTimeout();
    }

    void toIdle() {
        this.stopBusyToIdleTimeout();
        this.startIdleToEraseTimeout();
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\n   ";
        if (string == null) {
            string = "";
        }
        string2 = String.valueOf(string2) + string;
        stringBuffer.append(string2).append("<").append(this.ME).append(" instanceId='").append(this.instanceId);
        stringBuffer.append("'>");
        stringBuffer.append(string2).append("   <busyToIdle timeout='").append(this.busyToIdleTimeout).append("' handle='").append(this.busyToIdleTimeoutHandle).append("' />");
        stringBuffer.append(string2).append("   <idleToErase timeout='").append(this.idleToEraseTimeout).append("' handle='").append(this.idleToEraseTimeoutHandle).append("' />");
        stringBuffer.append(string2).append("</").append(this.ME).append("'>");
        return stringBuffer.toString();
    }

    public void touchBusy() {
        if (this.busyToIdleTimeoutHandle == null) {
            return;
        }
        try {
            this.busyToIdleTimeoutHandle = Timeout.getInstance().refreshTimeoutListener(this.busyToIdleTimeoutHandle, this.busyToIdleTimeout);
        }
        catch (JUtilsException jUtilsException) {}
    }
}

