/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.runtime;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class ThreadLister {
    public static int countThreads() {
        return ThreadLister.getRootThreadGroup().activeCount();
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup threadGroup3 = threadGroup2.getParent();
        while (threadGroup3 != null) {
            threadGroup2 = threadGroup3;
            threadGroup3 = threadGroup3.getParent();
        }
        return threadGroup2;
    }

    public static String listAllThreads() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        PrintStream printStream = new PrintStream(byteArrayOutputStream, true);
        ThreadLister.listAllThreads(printStream);
        return byteArrayOutputStream.toString();
    }

    public static void listAllThreads(PrintStream printStream) {
        ThreadLister.list_group(printStream, ThreadLister.getRootThreadGroup(), "");
    }

    private static void list_group(PrintStream printStream, ThreadGroup threadGroup, String string) {
        if (threadGroup == null) {
            return;
        }
        int n = threadGroup.activeCount();
        int n2 = threadGroup.activeGroupCount();
        Thread[] threadArray = new Thread[n];
        ThreadGroup[] threadGroupArray = new ThreadGroup[n2];
        threadGroup.enumerate(threadArray, false);
        threadGroup.enumerate(threadGroupArray, false);
        printStream.println(String.valueOf(string) + "Thread Group: " + threadGroup.getName() + "  Max Priority: " + threadGroup.getMaxPriority() + (threadGroup.isDaemon() ? " Daemon" : ""));
        int n3 = 0;
        while (n3 < n) {
            ThreadLister.print_thread_info(printStream, threadArray[n3], String.valueOf(string) + "    ");
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            ThreadLister.list_group(printStream, threadGroupArray[n4], String.valueOf(string) + "    ");
            ++n4;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Thread overview:\n" + ThreadLister.listAllThreads());
        System.out.println("There are " + ThreadLister.countThreads() + " threads in use");
    }

    private static void print_thread_info(PrintStream printStream, Thread thread, String string) {
        if (thread == null) {
            return;
        }
        printStream.println(String.valueOf(string) + "Thread: " + thread.getName() + "  Priority: " + thread.getPriority() + (thread.isDaemon() ? " Daemon" : "") + (thread.isAlive() ? "" : " Not Alive"));
    }
}

