/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.text;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class StringHelper {
    private static final String ME = "StringHelper";

    public static final String[] addToStringArray(String[] stringArray, String string) {
        String[] stringArray2 = null;
        stringArray2 = StringHelper.addToStringArray(stringArray, string, null);
        return stringArray2;
    }

    public static final String[] addToStringArray(String[] stringArray, String string, String[] stringArray2) {
        String[] stringArray3 = stringArray2;
        if (stringArray3 == null) {
            stringArray3 = new String[stringArray.length + 1];
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                throw new IllegalArgumentException("Value '" + string + "' already present in String array!");
            }
            ++n;
        }
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        stringArray3[stringArray3.length - 1] = string;
        return stringArray3;
    }

    public static String adjustLeading(String string, char c, int n) {
        if (string == null || string.length() > n) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = n - string.length();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append(c);
                ++n3;
            }
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String charChain(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(c);
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public static Object clone(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        }
        return stringArray2;
    }

    public static boolean contailsAll(String string, List list) {
        Iterator iterator = list.iterator();
        boolean bl = iterator.hasNext();
        while (bl && iterator.hasNext()) {
            boolean bl2 = bl = string.indexOf(iterator.next().toString()) > -1;
        }
        return bl;
    }

    public static boolean contains(String[] stringArray, String string) {
        return StringHelper.contains(stringArray, string, false);
    }

    public static boolean contains(String[] stringArray, String string, boolean bl) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Cannot search null pointer arrays!");
        }
        boolean bl2 = false;
        int n = StringHelper.getFirstIndex(stringArray, string, bl);
        bl2 = n > -1;
        return bl2;
    }

    public static int countOccurrence(String string, String string2, boolean bl) {
        int n = 0;
        if (!bl) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        int n2 = string.indexOf(string2);
        while (n2 > -1) {
            ++n;
            n2 = string.indexOf(string2, n2 + 1);
        }
        return n;
    }

    public static int getFirstIndex(String[] stringArray, String string, boolean bl) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Casnnot search null pointer arrays!");
        }
        int n = stringArray.length * -1;
        int n2 = 0;
        boolean bl2 = n2 >= stringArray.length;
        while (!bl2) {
            if (stringArray[n2] != null) {
                if (stringArray[n2] == string || stringArray[n2].equals(string)) {
                    n = n2;
                    bl2 = true;
                }
            } else if (bl) {
                bl2 = true;
                n = n2;
            }
            if (bl2) continue;
            boolean bl3 = bl2 = ++n2 >= stringArray.length;
        }
        return n;
    }

    public static String htmlEncode(String string) {
        string = StringHelper.replaceAll(string, "#", " ");
        string = StringHelper.replaceAll(string, "&", "+");
        string = StringHelper.replaceAll(string, " ", " ");
        string = StringHelper.replaceAll(string, "%", " ");
        string = StringHelper.replaceAll(string, "<", " ");
        string = StringHelper.replaceAll(string, ">", " ");
        string = StringHelper.replaceAll(string, "\u00e4", "ae");
        string = StringHelper.replaceAll(string, "\u00f6", "oe");
        string = StringHelper.replaceAll(string, "\u00fc", "ue");
        char[] cArray = string.toCharArray();
        return string;
    }

    public static void main(String[] stringArray) {
        String string = ME;
        String string2 = "Hello my friend, my dear friend";
        System.out.println("Converting '" + string2 + "' to (one replacement):\n" + "'" + StringHelper.replaceFirst(string2, "friend", "Jacqueline") + "'");
        System.out.println("Converting '" + string2 + "' to (all replacement):\n" + "'" + StringHelper.replaceAll(string2, "friend", "Jacqueline") + "'");
        string2 = "Hello my friend, my dear friend";
        System.out.println("Converting '" + string2 + "' to (one replacement):\n" + "'" + StringHelper.replaceFirst(string2, "H", "") + "'");
        System.out.println("Converting '" + string2 + "' to (all replacement):\n" + "'" + StringHelper.replaceAll(string2, "H", "") + "'");
        string2 = "Hello my friend, my dear friend";
        System.out.println("Converting '" + string2 + "' to (one replacement):\n" + "'" + StringHelper.replaceFirst(string2, null, "") + "'");
        System.out.println("Converting '" + string2 + "' to (all replacement):\n" + "'" + StringHelper.replaceAll(string2, null, "") + "'");
        string2 = "Hello my friend, my dear friend";
        System.out.println("Converting '" + string2 + "' to (one replacement):\n" + "'" + StringHelper.replaceFirst(string2, "#", "Jacqueline") + "'");
        System.out.println("Converting '" + string2 + "' to (all replacement):\n" + "'" + StringHelper.replaceAll(string2, "#", "Jacqueline") + "'");
        string2 = "Hello my friend, my dear friend";
        System.out.println("Converting '" + string2 + "' to (one replacement):\n" + "'" + StringHelper.replaceFirst(string2, "l", "&l;") + "'");
        System.out.println("Converting '" + string2 + "' to (all replacement):\n" + "'" + StringHelper.replaceAll(string2, "l", "&l;") + "'");
        string2 = " ";
        System.out.println("Converting '" + string2 + "' to (one replacement):\n" + "'" + StringHelper.replaceFirst(string2, "l", "&l;") + "'");
        System.out.println("Converting '" + string2 + "' to (all replacement):\n" + "'" + StringHelper.replaceAll(string2, "l", "&l;") + "'");
        int n = 0;
        System.out.println("==============================================================");
        System.out.println("Testing methods for manipulation of String arrays ...");
        System.out.println("--------------------------------------------------------------");
        System.out.println("Initializing ...");
        int n2 = 1000;
        String[] stringArray2 = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray2[n3] = String.valueOf(n3);
            ++n3;
        }
        System.out.println("Checking clone ...");
        long l = System.currentTimeMillis();
        String[] stringArray3 = (String[])StringHelper.clone(stringArray2);
        long l2 = System.currentTimeMillis();
        System.out.println("Time needed to clone: " + String.valueOf(l2 - l) + " ms.");
        int n4 = 0;
        while (n4 < stringArray2.length) {
            if (stringArray2[n4] != stringArray3[n4]) {
                System.err.println("error detected in clone at element " + n4 + "!");
                ++n;
            }
            ++n4;
        }
        int n5 = StringHelper.getFirstIndex(stringArray3, stringArray3[0], false);
        if (n5 != 0) {
            System.err.println("asking getFirstIndex for the first element did return wrong index! (" + n5 + ")");
            ++n;
        }
        if ((n5 = StringHelper.getFirstIndex(stringArray3, stringArray3[stringArray3.length - 1], false)) != stringArray3.length - 1) {
            System.err.println("asking getFirstIndex for the last element did return wrong index! (" + n5 + ")");
            ++n;
        }
        int n6 = Math.max(stringArray3.length / 10, Math.min(stringArray3.length, 10));
        System.out.println("Randomly checking " + n6 + " elements...");
        int n7 = 0;
        while (n7 < n6) {
            n5 = (int)((double)stringArray2.length * Math.random());
            if (stringArray2[n5] != stringArray3[n5]) {
                System.err.println("Error at position " + n5 + " !");
                ++n;
            }
            ++n7;
        }
        System.out.println("Checking addToStringArray ...");
        String string3 = String.valueOf(n2);
        l = System.currentTimeMillis();
        stringArray3 = StringHelper.addToStringArray(stringArray3, string3);
        l2 = System.currentTimeMillis();
        System.out.println("Time needed to add : " + String.valueOf(l2 - l) + " ms.");
        if (stringArray3[stringArray3.length - 1] != string3) {
            System.err.println("'addToStringArray' did not append the specified element!");
            ++n;
        }
        System.out.println("Checking removeFromStringArray...");
        l = System.currentTimeMillis();
        stringArray3 = StringHelper.removeFromStringArray(stringArray3, string3);
        l2 = System.currentTimeMillis();
        System.out.println("Time needed to remove : " + String.valueOf(l2 - l) + " ms.");
        if (StringHelper.getFirstIndex(stringArray3, string3, false) > -1) {
            System.err.println("'removeFromStringArray' did not append the specified element!");
            ++n;
        }
        System.out.println("Testing htmlEncode() ...");
        String string4 = "We went to the \udcberholspur and were <marvellously> refreshed!";
        string4 = StringHelper.htmlEncode(string4);
        System.out.println(string4);
        System.out.println("--------------------------------------------------------------");
        System.out.println(String.valueOf(String.valueOf(n)) + " errors detected.");
        System.out.println("==============================================================");
        System.exit(n);
    }

    public static final String[] removeFromStringArray(String[] stringArray, String string) {
        String[] stringArray2 = null;
        stringArray2 = StringHelper.removeFromStringArray(stringArray, string, false, true);
        return stringArray2;
    }

    public static final String[] removeFromStringArray(String[] stringArray, String string, boolean bl) {
        String[] stringArray2 = null;
        stringArray2 = StringHelper.removeFromStringArray(stringArray, string, bl, true);
        return stringArray2;
    }

    public static final String[] removeFromStringArray(String[] stringArray, String string, boolean bl, boolean bl2) {
        String[] stringArray2 = null;
        stringArray2 = StringHelper.removeFromStringArray(stringArray, string, bl, bl2, null);
        return stringArray2;
    }

    public static final String[] removeFromStringArray(String[] stringArray, String string, boolean bl, boolean bl2, String[] stringArray2) {
        if (stringArray == null) {
            throw new IllegalArgumentException("You cannot handle a null pointer array!");
        }
        if (stringArray2 != null && stringArray2.length < stringArray.length - 1) {
            throw new IllegalArgumentException("Cannot copy to an array with a length smaller that the original arrays length - 1!");
        }
        if (string == null) {
            throw new IllegalArgumentException("Cannot handle null values - yet!");
        }
        String[] stringArray3 = stringArray2;
        int n = StringHelper.getFirstIndex(stringArray, string, bl);
        if (n > -1) {
            if (stringArray3 == null) {
                stringArray3 = new String[stringArray.length - 1];
            }
            if (n > 0) {
                System.arraycopy(stringArray, 0, stringArray3, 0, n - 1);
            }
            if (n < stringArray3.length - 1) {
                System.arraycopy(stringArray, n + 1, stringArray3, n, stringArray3.length - n - 1);
            }
        } else if (stringArray3 != stringArray) {
            if (stringArray3 == null) {
                stringArray3 = new String[stringArray.length];
            }
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        }
        return stringArray3;
    }

    public static final String replaceAll(String string, String string2, String string3) {
        int n;
        if (string == null || string.length() < 1 || string2 == null || string3 == null) {
            return string;
        }
        if (string.indexOf(string2) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        String string4 = string;
        while ((n = string4.indexOf(string2)) >= 0) {
            if (n > 0) {
                stringBuffer.append(string4.substring(0, n));
            }
            stringBuffer.append(string3);
            string4 = string4.substring(n + string2.length());
        }
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    public static final String replaceFirst(String string, String string2, String string3) {
        if (string == null || string.length() < 1 || string2 == null || string3 == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer("");
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append(string3);
            stringBuffer.append(string.substring(n + string2.length()));
            return stringBuffer.toString();
        }
        return string;
    }

    public static final String[] toArray(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        if (string2 == null) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    public static String toString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray != null) {
            if (objectArray.length > 0) {
                stringBuffer.append('[');
                int n = 0;
                while (n < objectArray.length) {
                    if (n > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(objectArray[n]);
                    ++n;
                }
                stringBuffer.append(']');
            } else {
                stringBuffer.append("[]");
            }
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

