/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.time;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jutils.JUtilsException;

public class DateTime {
    public static final String DATE = "date";
    public static final String FROMDATE = "fromdate";
    public static final String TODATE = "todate";
    private Date myDate = new Date();
    private String thisDate = null;
    private String year = "2000";
    private String month = "01";
    private String day = "01";
    private String hour = "00";
    private String minute = "00";
    private String second = "00";
    private String datetimetype = "date";
    private SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy hh:mm", Locale.GERMANY);

    public DateTime() {
        this.myDate = new Date();
        this.setDateElements();
    }

    public DateTime(long l) {
        this.myDate = new Date(l);
        this.thisDate = this.sdf.format(this.myDate);
        this.setDateElements();
    }

    public DateTime(String string) throws JUtilsException {
        this.setDateTime(string);
        this.setDateElements();
    }

    public DateTime(String string, String string2) throws JUtilsException {
        this.sdf = new SimpleDateFormat(string2, Locale.GERMAN);
        this.setDateTime(string);
        this.setDateElements();
    }

    public String getAsString() {
        return this.thisDate;
    }

    public String getAsXml() {
        String string = "<" + this.datetimetype + ">\n" + "   <day>" + this.day + "</day>\n" + "   <month>" + this.month + "</month>\n" + "   <year>" + this.year + "</year>\n" + "   <hour>" + this.hour + "</hour>\n" + "   <minute>" + this.minute + "</minute>\n" + "   <second>" + this.second + "</second>\n" + "</" + this.datetimetype + ">\n";
        return string;
    }

    public Date getDate() {
        return this.myDate;
    }

    public String getDay() {
        return this.day;
    }

    public String getHour() {
        return this.hour;
    }

    public String getMinute() {
        return this.minute;
    }

    public String getMonth() {
        return this.month;
    }

    public String getSecond() {
        return this.second;
    }

    public long getTimeInMillis() {
        return this.getDate().getTime();
    }

    public String getYear() {
        return this.year;
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            String string = "DateTime-Tester";
            DateTime dateTime = new DateTime("12.12.1980 00:01");
            DateTime dateTime2 = new DateTime("12.12.1980 00:00");
            DateTime dateTime3 = new DateTime(System.currentTimeMillis());
            System.out.println("from=" + dateTime2.getAsString() + "  to=" + dateTime.getAsString());
            System.out.println("from=" + dateTime2.getDate().getTime() + "  to=" + dateTime.getDate().getTime());
            System.out.println(dateTime2.getAsXml());
            System.out.println(dateTime.getAsXml());
            System.out.println(dateTime3.getAsString());
        }
        catch (JUtilsException jUtilsException) {
            System.out.println(jUtilsException.reason);
        }
    }

    private void setDateElements() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm:ss", Locale.GERMANY);
        String string = simpleDateFormat.format(this.myDate);
        this.day = string.substring(0, string.indexOf("."));
        this.month = string.substring(string.indexOf(".") + 1, string.lastIndexOf("."));
        this.year = string.substring(string.lastIndexOf(".") + 1, string.lastIndexOf(".") + 5);
        this.hour = string.substring(string.indexOf(":") - 2, string.indexOf(":"));
        this.minute = string.substring(string.indexOf(":") + 1, string.indexOf(":") + 3);
        this.second = string.substring(string.indexOf(":") + 4, string.indexOf(":") + 6);
    }

    private void setDateTime(String string) {
        ParsePosition parsePosition = new ParsePosition(0);
        this.myDate = this.sdf.parse(string, parsePosition);
        this.thisDate = this.sdf.format(this.myDate);
    }

    public void setSecond(String string) {
        this.second = string;
    }

    public void setType(String string) {
        if (string.equals(DATE)) {
            this.datetimetype = DATE;
        }
        if (string.equals(FROMDATE)) {
            this.datetimetype = FROMDATE;
        }
        if (string.equals(TODATE)) {
            this.datetimetype = TODATE;
        }
    }

    public String toString() {
        return this.getAsString();
    }
}

