/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.time;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jutils.time.TimeHelper;

public class StopWatch {
    private long startTime;
    private long stopTime;

    public StopWatch() {
        this.restart();
    }

    public final long elapsed() {
        if (this.stopTime == -1L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    public static void main(String[] stringArray) throws Exception {
        StopWatch stopWatch = new StopWatch();
        double d = 1.0;
        int n = 100000;
        int n2 = 0;
        while (n2 < n) {
            d *= d;
            ++n2;
        }
        stopWatch.stop();
        System.out.println("Time for 100000 loops = " + stopWatch.elapsed() + " Millisec");
        System.out.println("Time for 100000 loops = " + stopWatch.nice(false));
        System.out.println("Time for 100000 loops = " + stopWatch.nice(n));
        stopWatch.restart();
        try {
            Thread.currentThread();
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {}
        System.out.println("4000 -> " + stopWatch.nice(1L));
        System.out.println("4000 -> " + stopWatch.nice(false));
    }

    public final String nice() {
        String string = this.toString();
        this.restart();
        return string;
    }

    public final String nice(long l) {
        this.stop();
        long l2 = this.elapsed();
        double d = (double)l / (double)l2;
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        if (d > 10000.0) {
            decimalFormat.applyPattern("########");
            return String.valueOf(TimeHelper.millisToNice(l2)) + " for " + l + " iterations -> " + decimalFormat.format(d / 1000.0) + " iterations/microsecond";
        }
        if (d > 100.0) {
            decimalFormat.applyPattern("########");
        } else if (d > 10.0) {
            decimalFormat.applyPattern("######.#");
        } else {
            if (d > 0.1) {
                decimalFormat.applyPattern("######.#");
                return String.valueOf(TimeHelper.millisToNice(l2)) + " for " + l + " iterations -> " + decimalFormat.format(d * 1000.0) + " iterations/second";
            }
            decimalFormat.applyPattern("##########");
            return String.valueOf(TimeHelper.millisToNice(l2)) + " for " + l + " iterations -> " + decimalFormat.format(d * 1000.0) + " iterations/second";
        }
        return String.valueOf(TimeHelper.millisToNice(l2)) + " for " + l + " iterations -> " + decimalFormat.format(d) + " iterations/millisecond";
    }

    public final String nice(boolean bl) {
        String string = this.toString();
        if (bl) {
            this.restart();
        }
        return string;
    }

    public final void restart() {
        this.startTime = System.currentTimeMillis();
        this.stopTime = -1L;
    }

    public final void stop() {
        if (this.stopTime == -1L) {
            this.stopTime = System.currentTimeMillis();
        }
    }

    public final String toString() {
        return TimeHelper.millisToNice(this.elapsed());
    }
}

