/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.time;

import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.jutils.JUtilsException;
import org.jutils.time.I_Timeout;
import org.jutils.time.Timeout;

public class Timeout
extends Thread {
    private static String ME = "Timeout";
    private static Timeout theTimeout = null;
    private TreeMap map = new TreeMap();
    private boolean running = true;
    private static final Object SYNCHRONIZER = new Object();

    private Timeout() {
        super("Timeout-Thread");
    }

    public final Long addTimeoutListener(I_Timeout i_Timeout, long l, Object object) {
        Long l2 = null;
        Object object2 = this.map;
        synchronized (object2) {
            Object v;
            while ((v = this.map.get(l2 = new Long(System.currentTimeMillis() + l))) != null) {
            }
            this.map.put(l2, new Container(i_Timeout, object));
        }
        object2 = theTimeout;
        synchronized (object2) {
            theTimeout.notify();
        }
        return l2;
    }

    public final void destroy() {
        this.removeAll();
        this.running = false;
        Object object = theTimeout;
        synchronized (object) {
            theTimeout.notify();
        }
        object = SYNCHRONIZER;
        synchronized (object) {
            theTimeout = null;
        }
    }

    public final long elapsed(Long l) {
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Container container = (Container)this.map.get(l);
            if (container == null) {
                long l2 = -1L;
                Object var5_6 = null;
                return l2;
            }
            long l3 = System.currentTimeMillis() - container.creation;
            Object var5_7 = null;
            return l3;
        }
    }

    public static Timeout getInstance() {
        if (theTimeout == null) {
            Object object = SYNCHRONIZER;
            synchronized (object) {
                if (theTimeout == null) {
                    theTimeout = new Timeout();
                    theTimeout.setDaemon(true);
                    theTimeout.start();
                }
            }
        }
        return theTimeout;
    }

    public final long getTimeout(Long l) {
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public final boolean isExpired(Long l) {
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.get(l) == null;
            Object var4_4 = null;
            return bl;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "Timeout-Tester";
        Timeout timeout = Timeout.getInstance();
        System.out.println("Phase 1: Testing basic functionality ...");
        timeout.removeTimeoutListener(null);
        timeout.removeTimeoutListener(new Long(12L));
        Long[] longArray = new Long[4];
        class Dummy1
        implements I_Timeout {
            private final /* synthetic */ Long[] val$keyArr;
            private String ME;
            private int counter;

            Dummy1(Long[] longArray) {
                this.val$keyArr = longArray;
                this.ME = "Dummy1";
                this.counter = 0;
            }

            public void timeout(Object object) {
                long l = System.currentTimeMillis();
                long l2 = l - this.val$keyArr[this.counter];
                if (Math.abs(l2) < 40L) {
                    System.out.println("Timeout occurred for " + object.toString() + " at " + l + " millis, real time failure=" + l2 + " millis.");
                } else {
                    System.err.println("*****ERROR: Wrong timeout occurred for " + object.toString() + " at " + l + " millis, scheduled was " + this.val$keyArr[this.counter] + " , real time failure=" + l2 + " millis.");
                }
                ++this.counter;
            }
        }
        Dummy1 dummy1 = new Dummy1(longArray);
        longArray[2] = timeout.addTimeoutListener(dummy1, 4000L, "timer-4000");
        longArray[3] = timeout.addTimeoutListener(dummy1, 5000L, "timer-5000");
        longArray[3] = timeout.refreshTimeoutListener(longArray[3], 5500L);
        longArray[0] = timeout.addTimeoutListener(dummy1, 1000L, "timer-1000");
        longArray[1] = timeout.addTimeoutListener(dummy1, 1000L, "timer-1000");
        long l = 0L;
        l = timeout.spanToTimeout(longArray[2]);
        if (l < 3000L) {
            System.err.println("*****ERROR: This short span to timeout = " + l + " is probably wrong, or you have a very slow computer.");
        } else {
            System.out.println("Span to life of " + l + " is reasonable");
        }
        Long l2 = timeout.addTimeoutListener(dummy1, 1000L, "timer-1000");
        timeout.removeTimeoutListener(l2);
        try {
            l2 = timeout.refreshTimeoutListener(l2, 1500L);
        }
        catch (JUtilsException jUtilsException) {
            System.out.println("Refresh failed which is OK (it is a test): " + jUtilsException.reason);
        }
        if (timeout.isExpired(longArray[2])) {
            System.err.println("*****ERROR: Should not be expired");
        } else {
            System.out.println("Correct, is not expired");
        }
        try {
            Thread.currentThread();
            Thread.sleep(7000L);
        }
        catch (Exception exception) {
            System.err.println("*****ERROR: main interrupt: " + exception.toString());
        }
        if (!timeout.isExpired(longArray[2])) {
            System.err.println("*****ERROR: Should be expired");
        } else {
            System.out.println("Correct, is expired");
        }
        int n = 1000;
        System.out.println("Phase 2: Testing 1000 timeouts ...");
        timeout.destroy();
        timeout = Timeout.getInstance();
        class Dummy2
        implements I_Timeout {
            private final /* synthetic */ int val$numTimers;
            private String ME;
            private int counter;
            private long start;

            Dummy2(int n) {
                this.val$numTimers = n;
                this.ME = "Dummy2";
                this.counter = 0;
                this.start = 0L;
            }

            public void timeout(Object object) {
                if (this.counter == 0) {
                    this.start = System.currentTimeMillis();
                }
                ++this.counter;
                if (this.counter == this.val$numTimers) {
                    long l = System.currentTimeMillis() - this.start;
                    if (l < 2000L) {
                        System.out.println("Success, tested " + this.val$numTimers + " timers, all updates came in " + l + " millis");
                    } else {
                        System.err.println("*****ERROR: Error testing " + this.val$numTimers + " timers, all updates needed " + l + " millis");
                    }
                }
            }
        }
        Dummy2 dummy2 = new Dummy2(n);
        long l3 = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < 1000) {
            timeout.addTimeoutListener(dummy2, 4000L, "timer-" + n2);
            ++n2;
        }
        System.out.println("Feeding of 1000 done, " + (long)(1000000.0 / (double)(System.currentTimeMillis() - l3)) + " adds/sec");
        System.out.println("Waiting in main");
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            System.err.println("*****ERROR:main interrupt: " + exception.toString());
        }
        System.err.println("*****ERROR:Test failed");
    }

    public final Long refreshTimeoutListener(Long l, long l2) throws JUtilsException {
        Long l3 = null;
        Object object = this.map;
        synchronized (object) {
            Object v;
            Container container = (Container)this.map.remove(l);
            if (container == null) {
                throw new JUtilsException(ME, "The timeout handle '" + l + "' is unknown, no timeout refresh done");
            }
            while ((v = this.map.get(l3 = new Long(System.currentTimeMillis() + l2))) != null) {
            }
            this.map.put(l3, container);
        }
        object = theTimeout;
        synchronized (object) {
            theTimeout.notify();
        }
        return l3;
    }

    public final void removeAll() {
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.clear();
        }
    }

    public final void removeTimeoutListener(Long l) {
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Container container = (Container)this.map.remove(l);
            if (container != null) {
                container.callback = null;
                container.userData = null;
                container = null;
            }
        }
    }

    public void run() {
        while (this.running) {
            long l = 100000L;
            Object object = this.map;
            synchronized (object) {
                try {
                    Long l2 = (Long)this.map.firstKey();
                    long l3 = l2;
                    long l4 = System.currentTimeMillis();
                    l = l3 - l4;
                    if (l <= 0L) {
                        Container container = (Container)this.map.remove(l2);
                        container.callback.timeout(container.userData);
                        Object var4_3 = null;
                        continue;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            try {
                object = theTimeout;
                synchronized (object) {
                    theTimeout.wait(l);
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final long spanToTimeout(Long l) {
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Container container = (Container)this.map.get(l);
            if (container == null) {
                long l2 = -1L;
                Object var5_6 = null;
                return l2;
            }
            long l3 = this.getTimeout(l) - System.currentTimeMillis();
            Object var5_7 = null;
            return l3;
        }
    }

    private class Container {
        I_Timeout callback;
        Object userData;
        long creation;

        Container(I_Timeout i_Timeout, Object object) {
            this.callback = i_Timeout;
            this.userData = object;
            this.creation = System.currentTimeMillis();
        }
    }
}

