/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.adapter;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.ldbc.core.Adapter;
import org.ldbc.core.Command;
import org.ldbc.core.DataType;
import org.ldbc.core.Factory;
import org.ldbc.core.Table;
import org.ldbc.jdbc.jdbcConnection;
import org.ldbc.jdbc.jdbcPreparedStatement;
import org.ldbc.jdbc.jdbcSQLException;

public class Base
implements Adapter {
    jdbcConnection mExternalConn;
    Connection mConn;
    Hashtable mAutoIncrementColumns;
    static final String AUTOINC_TABLE = "LDBC_SYS_AUTOINCREMENT";

    public void setConnection(jdbcConnection externalConn, Connection conn) throws SQLException {
        this.mExternalConn = externalConn;
        this.mConn = conn;
        this.init();
    }

    public void init() throws SQLException {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public String getDriverClass() {
        return "";
    }

    public String getDefaultSchema() throws SQLException {
        return null;
    }

    public void convertDataType(DataType type) throws SQLException {
        type.update(type.getDataType(), type.getPrecision(), type.getScale());
    }

    public String getStringConcatenation(String a, String b) {
        return a + " || " + b;
    }

    public String getStringConstant(String s) {
        return s;
    }

    public String getDataTypeString(DataType type) throws SQLException {
        return Base.getDefaultDataTypeString(type);
    }

    public static String getDefaultDataTypeString(DataType type) throws SQLException {
        int datatype = type.getDataType();
        String name = DataType.getDataTypeString(datatype);
        switch (datatype) {
            case 4: 
            case 93: 
            case 2004: 
            case 2005: {
                return name;
            }
            case 12: {
                return name + "(" + type.getPrecision() + ")";
            }
            case 3: {
                return name + "(" + type.getPrecision() + "," + type.getScale() + ")";
            }
        }
        throw Factory.getGeneralException("datatype:" + datatype);
    }

    public String getDateConstant(String s) {
        s = Date.valueOf(s).toString();
        return "{ts '" + s + " 00:00:00.0'}";
    }

    public String getTimestampConstant(String s) {
        s = Timestamp.valueOf(s).toString();
        return "{ts '" + s + "'}";
    }

    public String getBinaryConstant(String s) {
        return "X'" + s + "'";
    }

    public String getCast(String value, DataType type) throws SQLException {
        String s = this.getDataTypeString(type);
        return "CAST(" + value + " AS " + s + ")";
    }

    public String getLength(String value) throws SQLException {
        return "LENGTH(" + value + ")";
    }

    public String getMod(String v1, String v2) throws SQLException {
        return "MOD(" + v1 + "," + v2 + ")";
    }

    public String getNow() throws SQLException {
        return "NOW()";
    }

    public String getCreateTable(String tableName, String columns) throws SQLException {
        return "CREATE TABLE " + this.quote(tableName) + "(" + columns + ")";
    }

    public SQLException convertThrowable(Throwable e) {
        if (e instanceof SQLException) {
            return this.convertSQLException((SQLException)e);
        }
        return Factory.getSQLException("HY000", e.toString(), e);
    }

    public SQLException convertSQLException(SQLException e) {
        return new jdbcSQLException(e.getSQLState(), e.getMessage(), e);
    }

    public String getDefaultLikeEscape() {
        return "";
    }

    public boolean supportsAnsiJoinSyntax() {
        return true;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.mConn.setTransactionIsolation(level);
    }

    public void cancel(Statement stat) throws SQLException {
        stat.cancel();
    }

    public byte[] getBytes(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getBytes(columnIndex);
    }

    public Reader getCharacterStream(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getCharacterStream(columnIndex);
    }

    public String getClobString(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getString(columnIndex);
    }

    public void setString(jdbcPreparedStatement prep, int parameterIndex, String x) throws SQLException {
        prep.getVendorObject().setString(prep.translateParameterIndex(parameterIndex), x);
    }

    public void setCharacterStream(jdbcPreparedStatement prep, int parameterIndex, Reader x, int length) throws SQLException {
        prep.getVendorObject().setCharacterStream(prep.translateParameterIndex(parameterIndex), x, length);
    }

    public void setAsciiStream(jdbcPreparedStatement prep, int parameterIndex, InputStream x, int length) throws SQLException {
        prep.getVendorObject().setAsciiStream(prep.translateParameterIndex(parameterIndex), x, length);
    }

    public void setNull(jdbcPreparedStatement prep, int parameterIndex, int sqlType) throws SQLException {
        prep.getVendorObject().setNull(prep.translateParameterIndex(parameterIndex), sqlType);
    }

    public void setBytes(jdbcPreparedStatement prep, int parameterIndex, byte[] x) throws SQLException {
        prep.getVendorObject().setBytes(prep.translateParameterIndex(parameterIndex), x);
    }

    public void setBinaryStream(jdbcPreparedStatement prep, int parameterIndex, InputStream x, int length) throws SQLException {
        prep.getVendorObject().setBinaryStream(prep.translateParameterIndex(parameterIndex), x, length);
    }

    public boolean needExplicitIndexOnForeignKey() {
        return false;
    }

    public String getDropIndexSQL(String tableName, String uniqueIndexName) {
        return "DROP INDEX " + this.quote(tableName) + "." + this.quote(uniqueIndexName);
    }

    public String truncateIndexName(String indexName) {
        return indexName;
    }

    public String getNullConstant() {
        return "NULL";
    }

    public boolean isSystemTable(String tableName) {
        if (tableName == null) {
            return false;
        }
        return tableName.equals(AUTOINC_TABLE);
    }

    void loadAutoIncrementColumns() throws SQLException {
        Table table;
        this.mAutoIncrementColumns = new Hashtable();
        DatabaseMetaData meta = this.mConn.getMetaData();
        ResultSet rs = meta.getTables(null, this.getDefaultSchema(), AUTOINC_TABLE, null);
        boolean exists = rs.next();
        rs.close();
        Statement stat = this.mConn.createStatement();
        if (!exists) {
            stat.execute("CREATE TABLE " + this.quote(AUTOINC_TABLE) + "(" + "TABLE_NAME VARCHAR(255) NOT NULL PRIMARY KEY," + "COLUMN_NAME VARCHAR(255),NEXT_KEY INT)");
        } else {
            rs = stat.executeQuery("SELECT * FROM " + this.quote(AUTOINC_TABLE));
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                table = new Table(tableName, null, columnName);
                this.mAutoIncrementColumns.put(tableName, table);
            }
            rs.close();
        }
        Hashtable<String, Table> tables = new Hashtable<String, Table>();
        rs = meta.getTables(null, this.getDefaultSchema(), null, null);
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            table = new Table(tableName, null, null);
            tables.put(tableName, table);
        }
        rs.close();
        PreparedStatement prep = this.mConn.prepareStatement("INSERT INTO " + this.quote(AUTOINC_TABLE) + " VALUES(?,NULL,NULL)");
        Enumeration t = tables.keys();
        while (t.hasMoreElements()) {
            String tableName = (String)t.nextElement();
            if (this.mAutoIncrementColumns.get(tableName) != null) continue;
            prep.setString(1, tableName);
            prep.executeUpdate();
            Table table2 = new Table(tableName, null, null);
            this.mAutoIncrementColumns.put(tableName, table2);
        }
        prep.close();
        prep = this.mConn.prepareStatement("DELETE FROM " + this.quote(AUTOINC_TABLE) + " WHERE TABLE_NAME=?");
        Enumeration t2 = this.mAutoIncrementColumns.keys();
        while (t2.hasMoreElements()) {
            String tableName = (String)t2.nextElement();
            if (tables.get(tableName) != null) continue;
            prep.setString(1, tableName);
            prep.executeUpdate();
            this.mAutoIncrementColumns.remove(tableName);
        }
        prep.close();
        stat.close();
        Enumeration t3 = this.mAutoIncrementColumns.keys();
        while (t3.hasMoreElements()) {
            String tableName = (String)t3.nextElement();
            Table table3 = (Table)this.mAutoIncrementColumns.get(tableName);
            rs = meta.getColumns(null, this.getDefaultSchema(), tableName, null);
            Vector<String> v = new Vector<String>();
            while (rs.next()) {
                v.addElement(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            Object[] cols = new String[v.size()];
            v.copyInto(cols);
            table3.setColumns((String[])cols);
        }
    }

    public void addAutoIncrementColumn(String tableName, String[] cols, String columnName) throws SQLException {
        if (this.mAutoIncrementColumns == null) {
            this.loadAutoIncrementColumns();
        }
        PreparedStatement prep = this.mConn.prepareStatement("UPDATE " + this.quote(AUTOINC_TABLE) + " SET COLUMN_NAME=?,NEXT_KEY=0 WHERE TABLE_NAME=?");
        prep.setString(1, columnName);
        prep.setString(2, tableName);
        int count = prep.executeUpdate();
        prep.close();
        if (count == 0) {
            prep = this.mConn.prepareStatement("INSERT INTO " + this.quote(AUTOINC_TABLE) + " VALUES(?,?,0)");
            prep.setString(1, tableName);
            prep.setString(2, columnName);
            prep.executeUpdate();
            prep.close();
        }
        Table table = new Table(tableName, cols, columnName);
        this.mAutoIncrementColumns.put(tableName, table);
    }

    public String getAutoIncrementColumn(String tableName) throws SQLException {
        Table table = this.getTable(tableName);
        if (table == null) {
            return null;
        }
        return table.mAutoIncrementColumn;
    }

    Table getTable(String tableName) throws SQLException {
        if (this.mAutoIncrementColumns == null) {
            this.loadAutoIncrementColumns();
        }
        int i = 0;
        while (i < 2) {
            Table table = (Table)this.mAutoIncrementColumns.get(tableName);
            if (table != null) {
                return table;
            }
            ++i;
        }
        return null;
    }

    public boolean needToAddAutoIncrement(String tableName, Vector v) throws SQLException {
        Table table = this.getTable(tableName);
        if (table == null) {
            return false;
        }
        String col = table.mAutoIncrementColumn;
        if (col == null) {
            return false;
        }
        int i = 0;
        while (i < v.size()) {
            String c = (String)v.elementAt(i);
            if (c.equals(col)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addAllColumns(String tableName, Vector v) throws SQLException {
        Table table = this.getTable(tableName);
        if (table == null) {
            return;
        }
        String[] cols = table.mColumns;
        String auto = table.mAutoIncrementColumn;
        int i = 0;
        while (i < cols.length) {
            String c = cols[i];
            if (!c.equals(auto)) {
                v.addElement(c);
            }
            ++i;
        }
    }

    public int getAutoIncrementNextId(String tableName) throws SQLException {
        Connection conn = this.mConn;
        PreparedStatement prep = conn.prepareStatement("UPDATE " + this.quote(AUTOINC_TABLE) + " SET NEXT_KEY=NEXT_KEY+1 WHERE TABLE_NAME=?");
        prep.setString(1, tableName);
        prep.executeUpdate();
        prep = conn.prepareStatement("SELECT NEXT_KEY FROM " + this.quote(AUTOINC_TABLE) + " WHERE TABLE_NAME=?");
        prep.setString(1, tableName);
        ResultSet rs = prep.executeQuery();
        rs.next();
        int id = rs.getInt(1);
        rs.close();
        prep.close();
        return id;
    }

    public void prepareExecute(PreparedStatement nativePrep, Command command) throws SQLException {
        if (command.isAutoIncrement()) {
            String tableName = command.getTableName();
            int id = this.getAutoIncrementNextId(tableName);
            nativePrep.setInt(1, id);
        }
    }

    public String quote(String identifier) {
        return "\"" + identifier + "\"";
    }
}

