/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.adapter;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ldbc.adapter.Base;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;
import org.ldbc.jdbc.jdbcPreparedStatement;

public class DB2
extends Base
implements Adapter {
    public String getName() {
        return this.getClass().getName();
    }

    public String getDriverClass() {
        return "COM.ibm.db2.jdbc.net.DB2Driver";
    }

    public String getDataTypeString(DataType type) throws SQLException {
        int datatype = type.getDataType();
        switch (datatype) {
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2005: {
                return "CLOB(2000000)";
            }
            case 2004: {
                return "BLOB(2000000)";
            }
        }
        return Base.getDefaultDataTypeString(type);
    }

    public void convertDataType(DataType type) throws SQLException {
        int precision = type.getPrecision();
        int scale = type.getScale();
        String typename = type.getTypeName();
        switch (type.getDataType()) {
            case -4: {
                type.update(2004, 0, 0);
                break;
            }
            case -1: {
                type.update(2005, 0, 0);
            }
        }
        type.update(type.getDataType(), type.getPrecision(), type.getScale());
    }

    public String truncateIndexName(String indexName) {
        if (indexName == null) {
            return null;
        }
        if (indexName.startsWith("SQL") && indexName.length() > 14) {
            return "SQL000000000000000";
        }
        return indexName;
    }

    public String getDropIndexSQL(String tableName, String uniqueIndexName) {
        return "DROP INDEX " + this.quote(uniqueIndexName);
    }

    public String getBinaryConstant(String s) {
        return "BLOB(X'" + s + "')";
    }

    public Reader getCharacterStream(ResultSet rs, int columnIndex) throws SQLException {
        String s = rs.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringReader(s);
    }

    public String getNullConstant() {
        return "NULLIF(1,1)";
    }

    public String getCast(String value, DataType type) throws SQLException {
        switch (type.getDataType()) {
            case 12: {
                return "RTRIM(CAST(CAST(" + value + " AS CHAR(254)) AS VARCHAR(255)))";
            }
        }
        String s = this.getDataTypeString(type);
        return "CAST(" + value + " AS " + s + ")";
    }

    public String getNow() throws SQLException {
        return "CURRENT TIMESTAMP";
    }

    public void setNull(jdbcPreparedStatement prep, int parameterIndex, int sqlType) throws SQLException {
        if (sqlType == 2005) {
            prep.getVendorObject().setNull(prep.translateParameterIndex(parameterIndex), 12);
        } else if (sqlType == 2004) {
            prep.getVendorObject().setNull(prep.translateParameterIndex(parameterIndex), -2);
        } else {
            prep.getVendorObject().setNull(prep.translateParameterIndex(parameterIndex), sqlType);
        }
    }

    public synchronized void setBinaryStream(jdbcPreparedStatement prep, int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            prep.getVendorObject().setNull(prep.translateParameterIndex(parameterIndex), -2);
            return;
        }
        byte[] buffer = new byte[length];
        int offset = 0;
        try {
            while (length > 0) {
                int i = x.read(buffer, offset, length);
                offset += i;
                length -= i;
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
        prep.getVendorObject().setBytes(prep.translateParameterIndex(parameterIndex), buffer);
    }

    public void setCharacterStream(jdbcPreparedStatement prep, int parameterIndex, Reader x, int length) throws SQLException {
        if (x == null) {
            prep.getVendorObject().setNull(prep.translateParameterIndex(parameterIndex), 12);
            return;
        }
        char[] buffer = new char[length];
        int offset = 0;
        try {
            while (length > 0) {
                int i = x.read(buffer, offset, length);
                offset += i;
                length -= i;
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
        prep.getVendorObject().setString(prep.translateParameterIndex(parameterIndex), new String(buffer));
    }

    public String getDefaultLikeEscape() {
        return "ESCAPE '\\'";
    }
}

