/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.adapter;

import java.sql.SQLException;
import org.ldbc.adapter.Base;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;

public class HSQLDB
extends Base
implements Adapter {
    public String getName() {
        return this.getClass().getName();
    }

    public String getDriverClass() {
        return "org.hsqldb.jdbcDriver";
    }

    public String getBinaryConstant(String s) {
        return "'" + s + "'";
    }

    public String getDataTypeString(DataType type) throws SQLException {
        int datatype = type.getDataType();
        switch (datatype) {
            case 2005: {
                return "LONGVARCHAR(2000000)";
            }
            case 2004: {
                return "BINARY";
            }
        }
        return Base.getDefaultDataTypeString(type);
    }

    public void convertDataType(DataType type) throws SQLException {
        switch (type.getDataType()) {
            case -2: {
                type.update(2004, 0, 0);
                break;
            }
            case -1: {
                type.update(2005, 0, 0);
                break;
            }
            case 12: {
                if (type.getPrecision() != 2000000) break;
                type.update(2005, 0, 0);
                break;
            }
            case -5: 
            case 2: {
                type.update(4, 0, 0);
            }
        }
        type.update(type.getDataType(), type.getPrecision(), type.getScale());
    }

    public String getCast(String value, DataType type) throws SQLException {
        String s = "";
        switch (type.getDataType()) {
            case 12: {
                return "CAST(" + value + " AS VARCHAR)";
            }
        }
        return super.getCast(value, type);
    }

    public String getDefaultLikeEscape() {
        return "ESCAPE '\\'";
    }

    public void setTransactionIsolation(int level) throws SQLException {
    }

    public String getDropIndexSQL(String tableName, String uniqueIndexName) {
        return "DROP INDEX " + this.quote(uniqueIndexName);
    }
}

