/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.adapter;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.ldbc.adapter.Base;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;
import org.ldbc.core.Factory;

public class MySQL
extends Base
implements Adapter {
    public String getName() {
        return this.getClass().getName();
    }

    public String getDriverClass() {
        return "com.mysql.jdbc.Driver";
    }

    public String getStringConstant(String s) {
        char[] ch = s.toCharArray();
        StringBuffer buff = new StringBuffer();
        buff.append("'");
        int i = 1;
        while (i < ch.length - 1) {
            char c = ch[i];
            if (c == '\\') {
                buff.append(c);
            }
            buff.append(c);
            ++i;
        }
        buff.append("'");
        return buff.toString();
    }

    public void convertDataType(DataType type) throws SQLException {
        int precision = type.getPrecision();
        int scale = type.getScale();
        switch (type.getDataType()) {
            case -4: 
            case -3: 
            case -2: {
                type.update(2004, 0, 0);
                break;
            }
            case -1: {
                type.update(2005, 0, 0);
                break;
            }
            case -5: {
                type.update(4, 0, 0);
                break;
            }
            case 8: {
                type.update(3, precision, scale);
                break;
            }
            case 1: {
                type.update(12, precision, scale);
            }
        }
        type.update(type.getDataType(), type.getPrecision(), type.getScale());
    }

    public String getDataTypeString(DataType type) throws SQLException {
        int datatype = type.getDataType();
        switch (datatype) {
            case 2005: {
                return "MEDIUMTEXT";
            }
            case 2004: {
                return "MEDIUMBLOB";
            }
        }
        return Base.getDefaultDataTypeString(type);
    }

    public String getBinaryConstant(String s) {
        return "0x" + s;
    }

    public String getCast(String value, DataType type) throws SQLException {
        String s = "";
        switch (type.getDataType()) {
            case 4: {
                return "((" + value + ")+0)";
            }
            case 12: {
                return "CONCAT(" + value + ")";
            }
            case 93: {
                s = "DATETIME";
                break;
            }
            case 3: {
                return "(" + value + "+0.0)";
            }
        }
        return "CAST(" + value + " AS " + s + ")";
    }

    public String getStringConcatenation(String a, String b) {
        return "CONCAT(" + a + "," + b + ")";
    }

    public String getCreateTable(String tableName, String columns) throws SQLException {
        return "CREATE TABLE " + this.quote(tableName) + "(" + columns + ") TYPE=InnoDB";
    }

    public void init() throws SQLException {
        Connection conn = this.mConn;
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("show variables like \"have_innodb\"");
        if (!rs.next() || !rs.getString("Value").equals("YES")) {
            throw Factory.getGeneralException("This database does not support InnoDB.");
        }
        rs.close();
        stat.close();
    }

    public Reader getCharacterStream(ResultSet rs, int columnIndex) throws SQLException {
        String s = rs.getString(columnIndex);
        if (s == null) {
            return null;
        }
        return new StringReader(s);
    }

    public boolean needExplicitIndexOnForeignKey() {
        return true;
    }

    public String getDropIndexSQL(String tableName, String uniqueIndexName) {
        return "DROP INDEX " + this.quote(uniqueIndexName) + " ON " + this.quote(tableName);
    }

    public String quote(String identifier) {
        return identifier.toUpperCase();
    }
}

