/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.adapter;

import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ldbc.adapter.Base;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;

public class PointBase
extends Base
implements Adapter {
    public String getName() {
        return this.getClass().getName();
    }

    public String getDriverClass() {
        return "com.pointbase.jdbc.jdbcUniversalDriver";
    }

    public String getDataTypeString(DataType type) throws SQLException {
        int datatype = type.getDataType();
        switch (datatype) {
            case 93: {
                return "TIMESTAMP";
            }
            case 2005: {
                return "CLOB(2147483647)";
            }
            case 2004: {
                return "BLOB(2147483647)";
            }
        }
        return Base.getDefaultDataTypeString(type);
    }

    public void convertDataType(DataType type) throws SQLException {
        switch (type.getDataType()) {
            case -4: {
                type.update(2004, 0, 0);
                break;
            }
            case -1: {
                type.update(2005, 0, 0);
                break;
            }
            case 1: {
                type.update(12, type.getPrecision(), 0);
            }
        }
        type.update(type.getDataType(), type.getPrecision(), type.getScale());
    }

    public String getNow() throws SQLException {
        return "CURRENT_TIMESTAMP";
    }

    public String getClobString(ResultSet rs, int columnIndex) throws SQLException {
        Reader reader = rs.getCharacterStream(columnIndex);
        if (reader == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            while ((c = reader.read()) != -1) {
                buffer.append((char)c);
            }
            return buffer.toString();
        }
        catch (IOException e) {
            throw this.convertThrowable(e);
        }
    }
}

