/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.adapter;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.ldbc.adapter.Base;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;

public class PostgreSQL
extends Base
implements Adapter {
    public static void main(String[] argv) throws Exception {
        Class.forName("org.postgresql.Driver");
        Connection conn = DriverManager.getConnection("jdbc:postgresql:ldbc", "ldbc", "ldbc");
        Statement stat = conn.createStatement();
        conn.setAutoCommit(false);
        stat.cancel();
        try {
            stat.execute("CREATE TABLE \"TEST2\"(ID INT,V BYTEA)");
        }
        catch (SQLException e) {
            // empty catch block
        }
        stat.execute("INSERT INTO \"TEST2\" VALUES(1, '\\1\\2\\0'::bytea)");
        ResultSet rs = stat.executeQuery("SELECT * FROM \"TEST2\"");
        while (rs.next()) {
            int i = rs.getInt(1);
            byte[] b = rs.getBytes(2);
            System.out.println("i=" + i + " b.length=" + b.length + " b[0]=" + b[0] + " 1=" + b[1]);
        }
        stat.execute("DROP TABLE \"TEST2\"");
        System.out.println("end...");
        conn.close();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public String getDriverClass() {
        return "org.postgresql.Driver";
    }

    public String getDataTypeString(DataType type) throws SQLException {
        int datatype = type.getDataType();
        switch (datatype) {
            case 2005: {
                return "TEXT";
            }
            case 2004: {
                return "BYTEA";
            }
        }
        return Base.getDefaultDataTypeString(type);
    }

    public String quote(String identifier) {
        return "\"" + identifier + "\"";
    }

    public SQLException convertThrowable(Throwable e) {
        SQLException ex = super.convertThrowable(e);
        try {
            this.mConn.rollback();
        }
        catch (SQLException e2) {}
        return ex;
    }

    public SQLException convertSQLException(SQLException e) {
        SQLException ex = super.convertSQLException(e);
        try {
            this.mConn.rollback();
        }
        catch (SQLException e2) {}
        return ex;
    }

    public void convertDataType(DataType type) throws SQLException {
        int precision = type.getPrecision();
        int scale = type.getScale();
        String typename = type.getTypeName();
        switch (type.getDataType()) {
            case 2: {
                type.update(3, type.getPrecision(), type.getScale());
                break;
            }
            case -2: {
                type.update(2004, 0, 0);
                break;
            }
            case 12: {
                if (!typename.equals("text")) break;
                type.update(2005, 0, 0);
                break;
            }
            case -5: {
                type.update(4, 0, 0);
                break;
            }
            case 1111: {
                type.update(0, 0, 0);
            }
        }
        type.update(type.getDataType(), type.getPrecision(), type.getScale());
    }

    public String getDropIndexSQL(String tableName, String uniqueIndexName) {
        return "DROP INDEX " + this.quote(uniqueIndexName);
    }

    public String getStringConstant(String s) {
        char[] ch = s.toCharArray();
        StringBuffer buff = new StringBuffer();
        buff.append("'");
        int i = 1;
        while (i < ch.length - 1) {
            char c = ch[i];
            if (c == '\\') {
                buff.append(c);
            }
            buff.append(c);
            ++i;
        }
        buff.append("'");
        return buff.toString();
    }

    public String getBinaryConstant(String s) {
        StringBuffer buff = new StringBuffer("'");
        int i = 0;
        while (i < s.length()) {
            int j = Integer.parseInt(s.substring(i, i + 2), 16);
            buff.append("\\");
            buff.append(Integer.toOctalString(j));
            i += 2;
        }
        buff.append("'::bytea");
        return buff.toString();
    }

    public void cancel(Statement stat) throws SQLException {
    }
}

