/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.adapter;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.ldbc.adapter.Base;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;

public class QED
extends Base
implements Adapter {
    public static void main(String[] argv) throws Exception {
        Class.forName("com.quadcap.jdbc.JdbcDriver");
        Connection conn = DriverManager.getConnection("jdbc:qed:sample;create=true", "ldbc", "ldbc");
        Statement stat = conn.createStatement();
        try {
            stat.execute("DROP INDEX IDX_TEST");
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            stat.execute("DROP TABLE TEST");
        }
        catch (SQLException e) {
            // empty catch block
        }
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,I INT)");
        ResultSet rs = stat.executeQuery("SELECT I FROM TEST ORDER BY ID");
        stat.execute("CREATE INDEX IDX_TEST ON TEST(NAME)");
        stat.execute("DROP TABLE TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY,NAME VARCHAR(255))");
        stat.execute("CREATE INDEX IDX_TEST ON TEST(NAME)");
        conn.close();
    }

    public String getName() {
        return this.getClass().getName();
    }

    public String getDriverClass() {
        return "com.quadcap.jdbc.JdbcDriver";
    }

    public String getDataTypeString(DataType type) throws SQLException {
        int datatype = type.getDataType();
        switch (datatype) {
            case 93: {
                return "TIMESTAMP";
            }
        }
        return Base.getDefaultDataTypeString(type);
    }

    public String getDropIndexSQL(String tableName, String uniqueIndexName) {
        return "DROP INDEX " + this.quote(uniqueIndexName);
    }

    public String getBinaryConstant(String s) {
        return "0x" + s;
    }

    public void setTransactionIsolation(int level) throws SQLException {
    }

    public void convertDataType(DataType type) throws SQLException {
        int precision = type.getPrecision();
        int scale = type.getScale();
        String typename = type.getTypeName();
        switch (type.getDataType()) {
            case 1111: {
                type.update(4, 0, 0);
            }
        }
        type.update(type.getDataType(), type.getPrecision(), type.getScale());
    }
}

