/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.ldbc.adapter.Base;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;
import org.ldbc.core.Factory;
import org.ldbc.jdbc.jdbcPreparedStatement;

public class SQLServer
extends Base
implements Adapter {
    public String getName() {
        return this.getClass().getName();
    }

    public String getDriverClass() {
        return "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    }

    public void init() throws SQLException {
        Connection conn = this.mConn;
        boolean auto = conn.getAutoCommit();
        try {
            conn.setAutoCommit(false);
            Statement s1 = conn.createStatement();
            Statement s2 = conn.createStatement();
            s1.close();
            s2.close();
        }
        catch (SQLException e) {
            throw Factory.getGeneralException("Make sure the url contains ';SelectMethod=cursor'");
        }
        conn.setAutoCommit(auto);
    }

    public String getStringConcatenation(String a, String b) {
        return a + " + " + b;
    }

    public void convertDataType(DataType type) throws SQLException {
        switch (type.getDataType()) {
            case -4: {
                type.update(2004, 0, 0);
                break;
            }
            case -1: {
                type.update(2005, 0, 0);
            }
        }
        type.update(type.getDataType(), type.getPrecision(), type.getScale());
    }

    public String getDataTypeString(DataType type) throws SQLException {
        int datatype = type.getDataType();
        switch (datatype) {
            case 2005: {
                return "TEXT";
            }
            case 2004: {
                return "IMAGE";
            }
        }
        return Base.getDefaultDataTypeString(type);
    }

    public String getBinaryConstant(String s) {
        return "0x" + s;
    }

    public String getLength(String value) throws SQLException {
        return "LEN(" + value + ")";
    }

    public String getMod(String v1, String v2) throws SQLException {
        return "((" + v1 + ")%(" + v2 + "))";
    }

    public String getNow() throws SQLException {
        return "GETDATE()";
    }

    public String getDefaultLikeEscape() {
        return "ESCAPE '\\'";
    }

    public void setNull(jdbcPreparedStatement prep, int parameterIndex, int sqlType) throws SQLException {
        if (sqlType == 2005) {
            prep.getVendorObject().setNull(prep.translateParameterIndex(parameterIndex), 12);
        } else if (sqlType == 2004) {
            prep.getVendorObject().setNull(prep.translateParameterIndex(parameterIndex), -2);
        } else {
            prep.getVendorObject().setNull(prep.translateParameterIndex(parameterIndex), sqlType);
        }
    }
}

