/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.antlr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import org.ldbc.antlr.ANTLRTokdefLexer;
import org.ldbc.antlr.ANTLRTokdefParser;
import org.ldbc.antlr.Grammar;
import org.ldbc.antlr.RecognitionException;
import org.ldbc.antlr.SimpleTokenManager;
import org.ldbc.antlr.StringLiteralSymbol;
import org.ldbc.antlr.TokenStreamException;
import org.ldbc.antlr.TokenSymbol;
import org.ldbc.antlr.Tool;

class ImportVocabTokenManager
extends SimpleTokenManager
implements Cloneable {
    private String filename;
    protected Grammar grammar;

    ImportVocabTokenManager(Grammar grammar, String string, String string2, Tool tool) {
        super(string2, tool);
        this.grammar = grammar;
        File file = new File(string);
        if (!file.exists() && !(file = new File(Tool.getOutputDirectory(), string)).exists()) {
            Tool.panic("Cannot find importVocab file '" + this.filename);
        }
        this.filename = string;
        this.setReadOnly(true);
        try {
            FileReader fileReader = new FileReader(file);
            ANTLRTokdefLexer aNTLRTokdefLexer = new ANTLRTokdefLexer(fileReader);
            ANTLRTokdefParser aNTLRTokdefParser = new ANTLRTokdefParser(aNTLRTokdefLexer);
            aNTLRTokdefParser.setFilename(this.filename);
            aNTLRTokdefParser.file(this);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Tool.panic("Cannot find importVocab file '" + this.filename);
        }
        catch (RecognitionException recognitionException) {
            Tool.panic("Error parsing importVocab file '" + this.filename + "': " + recognitionException.toString());
        }
        catch (TokenStreamException tokenStreamException) {
            Tool.panic("Error reading importVocab file '" + this.filename + "'");
        }
    }

    public Object clone() {
        ImportVocabTokenManager importVocabTokenManager = (ImportVocabTokenManager)super.clone();
        importVocabTokenManager.filename = this.filename;
        importVocabTokenManager.grammar = this.grammar;
        return importVocabTokenManager;
    }

    public void define(TokenSymbol tokenSymbol) {
        super.define(tokenSymbol);
    }

    public void define(String string, int n) {
        TokenSymbol tokenSymbol = null;
        tokenSymbol = string.startsWith("\"") ? new StringLiteralSymbol(string) : new TokenSymbol(string);
        tokenSymbol.setTokenType(n);
        super.define(tokenSymbol);
        this.maxToken = n + 1 > this.maxToken ? n + 1 : this.maxToken;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int nextTokenType() {
        return super.nextTokenType();
    }
}

