/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.core;

import java.sql.SQLException;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;

public class Column {
    String mName;
    DataType mType;
    boolean mNotNull;
    boolean mPrimaryKey;
    boolean mAutoincrement;

    public Column(String name, DataType type, boolean notNull) {
        this.mName = name;
        this.mType = type;
        this.mNotNull = notNull;
    }

    public void setNotNull() {
        this.mNotNull = true;
    }

    public void setPrimaryKey() {
        this.mPrimaryKey = true;
        this.mNotNull = true;
    }

    public void setAutoincrement() {
        this.mAutoincrement = true;
    }

    public boolean isAutoincrement() {
        return this.mAutoincrement;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isPrimaryKey() {
        return this.mPrimaryKey;
    }

    public String getCreateSQL(Adapter adapter) throws SQLException {
        String sql = adapter.getDataTypeString(this.mType);
        sql = adapter.quote(this.mName) + " " + sql;
        if (this.mNotNull) {
            sql = sql + " NOT NULL";
        }
        return sql;
    }
}

