/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.core;

import java.sql.SQLException;
import org.ldbc.core.Adapter;
import org.ldbc.core.Factory;

public class Command {
    Adapter mAdapter;
    boolean mIsSelect;
    boolean mIsCreateOrDrop;
    boolean mIsPseudo;
    int mPseudoCommand;
    public static final int COMMIT = 0;
    public static final int ROLLBACK = 1;
    public static final int AUTOCOMMIT_TRUE = 2;
    public static final int AUTOCOMMIT_FALSE = 3;
    static final String[] PSEUDO = new String[]{"COMMIT", "ROLLBACK", "AUTOCOMMIT_TRUE", "AUTOCOMMIT_FALSE"};
    String mOriginalSQL;
    String mVendorSQL;
    boolean mIsAutoIncrement;
    int mParameterIndexOffset;
    String mTableName;

    public Command(Adapter adapter) {
        this.mAdapter = adapter;
    }

    public void setOriginalSQL(String sql) {
        this.mOriginalSQL = sql;
    }

    public void setVendorSQL(String sql) {
        this.mVendorSQL = sql;
    }

    public int translateParameterIndex(int parameterIndex) {
        return this.mParameterIndexOffset + parameterIndex;
    }

    public void setParameterIndexOffset(int offset) {
        this.mParameterIndexOffset = offset;
    }

    public String getVendorSQL() {
        return this.mVendorSQL;
    }

    public void checkQuery() throws SQLException {
        if (!this.mIsSelect) {
            throw Factory.getSQLException("37000", this.mOriginalSQL + " (EXECUTE QUERY)");
        }
    }

    public void checkUpdate() throws SQLException {
        if (this.mIsSelect) {
            throw Factory.getSQLException("37000", this.mOriginalSQL + " (EXECUTE UPDATE)");
        }
    }

    public boolean isCreateOrDrop() {
        return this.mIsCreateOrDrop;
    }

    public boolean isUpdate() {
        return !this.mIsSelect;
    }

    public boolean isPseudo() {
        return this.mIsPseudo;
    }

    public int getPseudoCommand() {
        return this.mPseudoCommand;
    }

    public void setCreateOrDrop() {
        this.mIsCreateOrDrop = true;
    }

    public void setSelect() {
        this.mIsSelect = true;
    }

    public void setPseudoCommand(int command) {
        this.mIsPseudo = true;
        this.mPseudoCommand = command;
        this.mVendorSQL = "- " + PSEUDO[command] + " -";
    }

    public void setAutoIncrement(boolean autoinc, String tableName) {
        this.mIsAutoIncrement = autoinc;
        this.mTableName = tableName;
    }

    public boolean isAutoIncrement() {
        return this.mIsAutoIncrement;
    }

    public String getTableName() {
        return this.mTableName;
    }
}

