/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.core;

import java.sql.SQLException;
import org.ldbc.core.Factory;

public class DataType {
    static final int DEFAULT = -1;
    String mTypeName;
    int mDataType;
    int mPrecision;
    int mScale;

    public DataType(String typename, int datatype, int precision, int scale) {
        this.mTypeName = typename;
        this.mDataType = datatype;
        this.mPrecision = precision;
        this.mScale = scale;
    }

    public String getTypeName() throws SQLException {
        return this.mTypeName;
    }

    public int getDataType() {
        return this.mDataType;
    }

    public int getPrecision() throws SQLException {
        return this.mPrecision;
    }

    public int getScale() throws SQLException {
        return this.mScale;
    }

    public void update(int datatype, int precision, int scale) throws SQLException {
        this.mDataType = datatype;
        this.mTypeName = DataType.getDataTypeString(datatype);
        switch (datatype) {
            case 0: 
            case 4: 
            case 93: 
            case 2004: 
            case 2005: {
                scale = -1;
                precision = -1;
                break;
            }
            case 12: {
                scale = -1;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw Factory.getGeneralException("datatype:" + datatype);
            }
        }
        if (precision == -1) {
            precision = DataType.getDefaultPrecision(datatype);
        }
        if (scale == -1) {
            scale = DataType.getDefaultScale(datatype);
        }
        this.mPrecision = precision;
        this.mScale = scale;
    }

    public static int getDefaultPrecision(int datatype) throws SQLException {
        switch (datatype) {
            case 0: {
                return 0;
            }
            case 4: {
                return 9;
            }
            case 12: {
                return 255;
            }
            case 3: {
                return 20;
            }
            case 93: {
                return 0;
            }
            case 2004: 
            case 2005: {
                return 1000000000;
            }
            case 5: {
                return 4;
            }
            case -7: {
                return 0;
            }
        }
        throw Factory.getGeneralException("datatype:" + datatype);
    }

    public static int getDefaultScale(int datatype) throws SQLException {
        switch (datatype) {
            case -7: 
            case 0: 
            case 4: 
            case 5: 
            case 12: 
            case 93: 
            case 2004: 
            case 2005: {
                return 0;
            }
            case 3: {
                return 2;
            }
        }
        throw Factory.getGeneralException("datatype:" + datatype);
    }

    public static String getDataTypeString(int datatype) throws SQLException {
        switch (datatype) {
            case 0: {
                return "NULL";
            }
            case 4: {
                return "INTEGER";
            }
            case 12: {
                return "VARCHAR";
            }
            case 3: {
                return "DECIMAL";
            }
            case 93: {
                return "DATETIME";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 5: {
                return "SMALLINT";
            }
            case -7: {
                return "BIT";
            }
        }
        throw Factory.getGeneralException("datatype:" + datatype);
    }
}

