/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.core;

import java.io.StringReader;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import org.ldbc.core.Adapter;
import org.ldbc.core.Messages;
import org.ldbc.jdbc.jdbcSQLException;
import org.ldbc.parser.SQLLexer;
import org.ldbc.parser.SQLParser;

public class Factory {
    private static final String[] LIST = new String[]{"pointbase", "org.ldbc.adapter.PointBase", "hsqldb", "org.ldbc.adapter.HSQLDB", "oracle", "org.ldbc.adapter.Oracle", "microsoft", "org.ldbc.adapter.SQLServer", "db2", "org.ldbc.adapter.DB2", "qed", "org.ldbc.adapter.QED", "mysql", "org.ldbc.adapter.MySQL", "dbcp", "org.ldbc.adapter.FirstSQL", "borland", "org.ldbc.adapter.JDataStore", "mckoi", "org.ldbc.adapter.Mckoi", "postgresql", "org.ldbc.adapter.PostgreSQL"};
    private static ListResourceBundle MESSAGES = new Messages();
    private static Factory mSingleton = new Factory();
    private Hashtable mMap = new Hashtable();

    private Factory() {
    }

    public static Adapter getAdapter(String url) throws SQLException {
        int i2;
        int i1 = url.indexOf(58) + 1;
        String adapterClass = (String)Factory.mSingleton.mMap.get(url = url.substring(i1, i2 = url.indexOf(58, i1 + 1)));
        if (adapterClass == null) {
            return null;
        }
        try {
            Adapter adapter = (Adapter)Class.forName(adapterClass).newInstance();
            return adapter;
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    public static SQLException getSQLException(String sqlstate, String param) {
        return Factory.getSQLException(sqlstate, param, null);
    }

    public static SQLException getSQLException(String sqlstate, String param, Throwable th) {
        String message;
        try {
            message = MESSAGES.getString(sqlstate);
        }
        catch (MissingResourceException e) {
            message = "Resource not found: " + sqlstate;
        }
        if (param != null) {
            message = message + ": " + param;
        }
        return new jdbcSQLException(message, sqlstate, th);
    }

    public static SQLException getSQLException(String sqlstate) {
        return Factory.getSQLException(sqlstate, null);
    }

    public static SQLException getUnsupportedException() {
        return Factory.getSQLException("IM001");
    }

    public static SQLException getGeneralException(String param) {
        return Factory.getSQLException("HY000", param);
    }

    public static SQLException getInvalidValueException(String param) {
        return Factory.getSQLException("HY009", param);
    }

    public static SQLException getClosedException() {
        return Factory.getSQLException("24000");
    }

    public static void checkStatement(String sql) throws SQLException {
        try {
            StringReader in = new StringReader(sql);
            SQLLexer lexer = new SQLLexer(in);
            SQLParser parser = new SQLParser(lexer);
            parser.statement();
        }
        catch (Throwable e) {
            throw Factory.getSQLException("37000", sql + " " + e.toString());
        }
    }

    static {
        int i = 0;
        while (i < LIST.length) {
            Factory.mSingleton.mMap.put(LIST[i], LIST[i + 1]);
            i += 2;
        }
    }
}

