/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.core;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.ldbc.core.DataType;
import org.ldbc.core.Factory;

public class MemoryResultSet
implements ResultSet,
ResultSetMetaData {
    int mColumnCount;
    int mRowCount;
    String[] mLabels;
    int[] mDataTypes;
    Object[][] mData;
    int mCurrent;
    boolean mWasNull;

    public boolean next() throws SQLException {
        if (this.mCurrent >= this.mRowCount) {
            throw Factory.getClosedException();
        }
        ++this.mCurrent;
        return this.mCurrent < this.mRowCount;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    public String getString(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getString(columnIndex);
    }

    public String getString(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkCurrentRow();
        Object d = this.mData[this.mCurrent][columnIndex - 1];
        if (d == null) {
            this.mWasNull = true;
            return null;
        }
        this.mWasNull = false;
        return d.toString();
    }

    public boolean wasNull() throws SQLException {
        return this.mWasNull;
    }

    public int findColumn(String columnName) throws SQLException {
        columnName = columnName.toUpperCase();
        int i = 0;
        while (i < this.mColumnCount) {
            if (columnName.equals(this.mLabels[i])) {
                return i + 1;
            }
            ++i;
        }
        throw Factory.getSQLException("42S22", columnName);
    }

    public int getInt(int columnIndex) throws SQLException {
        this.checkColumnIndex(columnIndex);
        this.checkCurrentRow();
        Object d = this.mData[this.mCurrent][columnIndex - 1];
        if (d == null) {
            this.mWasNull = true;
            return 0;
        }
        this.mWasNull = false;
        int datatype = this.mDataTypes[columnIndex - 1];
        switch (datatype) {
            case 4: {
                return (Integer)d;
            }
            case -7: {
                return (Boolean)d != false ? 1 : 0;
            }
        }
        return Integer.parseInt(d.toString());
    }

    public int getInt(String columnName) throws SQLException {
        int columnIndex = this.findColumn(columnName);
        return this.getInt(columnIndex);
    }

    public void close() throws SQLException {
    }

    public int getColumnType(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.mDataTypes[column - 1];
    }

    public String getColumnTypeName(int column) throws SQLException {
        int type = this.getColumnType(column);
        return DataType.getDataTypeString(type);
    }

    public int getColumnCount() throws SQLException {
        return this.mColumnCount;
    }

    public String getColumnLabel(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.mLabels[column - 1];
    }

    public String getColumnName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.mLabels[column - 1];
    }

    public int getPrecision(int column) throws SQLException {
        this.checkColumnIndex(column);
        return DataType.getDefaultPrecision(this.mDataTypes[column - 1]);
    }

    public int getScale(int column) throws SQLException {
        this.checkColumnIndex(column);
        return DataType.getDefaultScale(this.mDataTypes[column - 1]);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getInt(columnIndex) != 0;
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getInt(columnName) != 0;
    }

    public byte getByte(int columnIndex) throws SQLException {
        return (byte)this.getInt(columnIndex);
    }

    public byte getByte(String columnName) throws SQLException {
        return (byte)this.getInt(columnName);
    }

    public short getShort(int columnIndex) throws SQLException {
        return (short)this.getInt(columnIndex);
    }

    public short getShort(String columnName) throws SQLException {
        return (short)this.getInt(columnName);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this.getInt(columnIndex);
    }

    public long getLong(String columnName) throws SQLException {
        return this.getInt(columnName);
    }

    public float getFloat(int columnIndex) throws SQLException {
        return this.getInt(columnIndex);
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getInt(columnName);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this.getInt(columnIndex);
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getInt(columnName);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        int i = this.getInt(columnIndex);
        if (this.wasNull()) {
            return null;
        }
        return new BigDecimal("" + i);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        int i = this.getInt(columnName);
        if (this.wasNull()) {
            return null;
        }
        return new BigDecimal("" + i);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Date getDate(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Time getTime(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public byte[] getBytes(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Date getDate(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Time getTime(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public SQLWarning getWarnings() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void clearWarnings() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public String getCursorName() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Object getObject(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Object getObject(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isBeforeFirst() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isAfterLast() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isFirst() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isLast() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void beforeFirst() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void afterLast() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean first() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean last() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getRow() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean absolute(int row) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean relative(int rows) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean previous() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getFetchDirection() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void setFetchSize(int rows) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getFetchSize() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getType() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getConcurrency() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean rowUpdated() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean rowInserted() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean rowDeleted() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateNull(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void insertRow() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateRow() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void deleteRow() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void refreshRow() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void cancelRowUpdates() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void moveToInsertRow() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void moveToCurrentRow() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Statement getStatement() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Ref getRef(int i) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Blob getBlob(int i) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Clob getClob(int i) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Array getArray(int i) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Ref getRef(String colName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Blob getBlob(String colName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Clob getClob(String colName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Array getArray(String colName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isSearchable(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isCurrency(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int isNullable(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isSigned(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public String getSchemaName(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public String getTableName(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public String getCatalogName(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isReadOnly(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isWritable(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public String getColumnClassName(int column) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public URL getURL(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public MemoryResultSet(ResultSet rs, String[] labels, int[] datatypes) throws SQLException {
        int columncount = labels.length;
        if (datatypes.length != columncount) {
            throw new Error("Internal error");
        }
        this.mColumnCount = columncount;
        this.mDataTypes = datatypes;
        this.mLabels = labels;
        Vector<Object[]> rows = new Vector<Object[]>();
        if (rs != null) {
            while (rs.next()) {
                Object[] row = new Object[columncount];
                int i = 0;
                while (i < columncount) {
                    row[i] = MemoryResultSet.getObject(rs, i, datatypes[i]);
                    ++i;
                }
                rows.addElement(row);
            }
            rs.close();
            this.mRowCount = rows.size();
        }
        this.mData = new Object[this.mRowCount][];
        rows.copyInto((Object[])this.mData);
        this.mCurrent = -1;
    }

    private static Object getObject(ResultSet rs, int column, int datatype) throws SQLException {
        switch (datatype) {
            case 4: {
                int dataInt = rs.getInt(column + 1);
                if (rs.wasNull()) {
                    return null;
                }
                return new Integer(dataInt);
            }
            case 1: 
            case 12: {
                return rs.getString(column + 1);
            }
            case 5: {
                short dataShort = rs.getShort(column + 1);
                if (rs.wasNull()) {
                    return null;
                }
                return new Short(dataShort);
            }
            case -7: {
                boolean bit = rs.getBoolean(column + 1);
                if (rs.wasNull()) {
                    return null;
                }
                return new Boolean(bit);
            }
        }
        throw Factory.getGeneralException("datatype:" + datatype);
    }

    void checkCurrentRow() throws SQLException {
        if (this.mCurrent < 0 || this.mCurrent >= this.mRowCount) {
            throw Factory.getInvalidValueException("current:" + this.mCurrent + " rowcount:" + this.mRowCount);
        }
    }

    void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.mColumnCount) {
            throw Factory.getInvalidValueException("columnIndex:" + columnIndex + " min:1 max:" + this.mColumnCount);
        }
    }

    public void setInt(int row, int columnIndex, int x) {
        this.mData[row][--columnIndex] = new Integer(x);
    }

    public void setString(int row, int columnIndex, String x) {
        this.mData[row][--columnIndex] = x;
    }

    public void appendRow(Object[] data) {
        Object[][] newdata = new Object[this.mRowCount + 1][];
        System.arraycopy(this.mData, 0, newdata, 0, this.mRowCount);
        newdata[this.mRowCount] = data;
        ++this.mRowCount;
        this.mData = newdata;
        this.reset();
    }

    public void deleteRow(int row) {
        --this.mRowCount;
        Object[][] newdata = new Object[this.mRowCount][];
        if (row > 0) {
            System.arraycopy(this.mData, 0, newdata, 0, row);
        }
        if (this.mRowCount - row > 0) {
            System.arraycopy(this.mData, row + 1, newdata, row, this.mRowCount - row);
        }
        this.mData = newdata;
        this.reset();
    }

    public void reset() {
        this.mCurrent = -1;
    }

    public void setNull(int row, int columnIndex) {
        this.mData[row][--columnIndex] = null;
    }

    public void convertAllToUpperCase(int columnIndex) {
        --columnIndex;
        int i = 0;
        while (i < this.mRowCount) {
            Object[] row = this.mData[i];
            Object s = row[columnIndex];
            if (s != null) {
                row[columnIndex] = s.toString().toUpperCase();
            }
            ++i;
        }
    }

    public void setAllString(int columnIndex, String text) {
        --columnIndex;
        int i = 0;
        while (i < this.mRowCount) {
            Object[] row = this.mData[i];
            row[columnIndex] = text;
            ++i;
        }
    }

    public void setAllInt(int columnIndex, int value) {
        --columnIndex;
        Integer v = new Integer(value);
        int i = 0;
        while (i < this.mRowCount) {
            Object[] row = this.mData[i];
            row[columnIndex] = v;
            ++i;
        }
    }

    public void setAllNull(int columnIndex) {
        --columnIndex;
        int i = 0;
        while (i < this.mRowCount) {
            this.mData[i][columnIndex] = null;
            ++i;
        }
    }

    public void setAllShort(int columnIndex, short x) {
        --columnIndex;
        Short o = new Short(x);
        int i = 0;
        while (i < this.mRowCount) {
            this.mData[i][columnIndex] = o;
            ++i;
        }
    }

    public void sort(int[] index) throws SQLException {
        int cols = index.length;
        int i = 1;
        while (i < this.mRowCount) {
            Object[] row = this.mData[i];
            int j = i - 1;
            while (j >= 0 && this.bigger(this.mData[j], row, cols, index)) {
                this.mData[j + 1] = this.mData[j];
                --j;
            }
            this.mData[j + 1] = row;
            ++i;
        }
    }

    public boolean bigger(Object[] a, Object[] b, int len, int[] index) throws SQLException {
        int i = 0;
        while (i < len) {
            int idx = index[i] - 1;
            Object o1 = a[idx];
            Object o2 = b[idx];
            if (o1 == null || o2 == null) {
                throw Factory.getUnsupportedException();
            }
            int datatype = this.mDataTypes[idx];
            switch (datatype) {
                case 12: {
                    int compare = ((String)o1).compareTo((String)o2);
                    if (compare == 0) break;
                    return compare > 0;
                }
                case 4: {
                    int i1 = (Integer)o1;
                    int i2 = (Integer)o2;
                    if (i1 == i2) break;
                    return i1 > i2;
                }
                case 5: {
                    short s1 = (Short)o1;
                    short s2 = (Short)o2;
                    if (s1 == s2) break;
                    return s1 > s2;
                }
                case -7: {
                    boolean b1 = (Boolean)o1;
                    boolean b2 = (Boolean)o2;
                    if (b1 == b2) break;
                    return b1 && !b2;
                }
                default: {
                    throw Factory.getGeneralException("datatype:" + datatype);
                }
            }
            ++i;
        }
        return false;
    }
}

