/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.core;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

public class Trace {
    static boolean mEnabled;
    static boolean mDetailed;
    static PrintStream mStream;
    static final String CLASSNAME;
    static final String PACKAGE = "org.ldbc.jdbc.";

    public static void setOption(String value) {
        mStream = System.out;
        int comma = value.indexOf(44);
        String file = null;
        if (comma != -1) {
            file = value.substring(comma + 1);
            value = value.substring(0, comma);
        }
        if (value.equals("on")) {
            mEnabled = true;
            mDetailed = false;
            Trace.setFile(file);
        } else if (value.equals("off")) {
            mEnabled = false;
            mDetailed = false;
        } else if (value.equals("detailed")) {
            mEnabled = true;
            mDetailed = true;
            Trace.setFile(file);
        } else {
            System.out.println("ldbc.trace must be one of {on|off|detailed} but is: <" + value + "> - logging off");
        }
    }

    static void setFile(String fileName) {
        try {
            if (fileName == null) {
                return;
            }
            mStream = new PrintStream(new FileOutputStream(fileName, true));
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println("Can not write to file: " + fileName + " using System.out instead.");
        }
    }

    public static boolean isEnabled() {
        return mEnabled;
    }

    public static boolean isDetailed() {
        return mDetailed;
    }

    public static void trace(String id) {
        Trace.traceSub(id, null);
    }

    public static void println(String s) {
        mStream.println(s);
    }

    public static void traceQuote(String id, String param) {
        Trace.traceSub(id, Trace.quote(param));
    }

    public static void trace(String id, int param) {
        Trace.traceSub(id, String.valueOf(param));
    }

    public static void trace(String id, String param) {
        Trace.traceSub(id, param);
    }

    public static void traceResult(boolean result) {
        if (mDetailed) {
            mStream.println("\treturns " + result);
        }
    }

    public static void traceResult(int result) {
        if (mDetailed) {
            mStream.println("\treturns " + result);
        }
    }

    public static void traceResult(String result) {
        if (mDetailed) {
            mStream.println("\treturns " + result);
        }
    }

    public static void traceResultQuote(String result) {
        if (mDetailed) {
            mStream.println("\treturns " + Trace.quote(result));
        }
    }

    public static void traceException(Exception e) {
        mStream.println("\tthrows " + e.toString());
    }

    private static void traceSub(String id, String param) {
        String caller = Trace.getCaller();
        if (caller == null) {
            return;
        }
        param = param != null ? "(" + param + ")" : "()";
        caller = id + "." + caller + param;
        mStream.println(caller);
    }

    private static String getCaller() {
        StringWriter writer = new StringWriter();
        new Exception().printStackTrace(new PrintWriter(writer));
        String trace = writer.getBuffer().toString();
        LineNumberReader reader = new LineNumberReader(new StringReader(trace));
        String caller = null;
        try {
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                int space = (line = line.trim()).indexOf(32);
                if (space != -1) {
                    line = line.substring(space).trim();
                }
                if (line.startsWith(CLASSNAME)) continue;
                int open = line.indexOf(40);
                if (open != -1) {
                    line = line.substring(0, open);
                }
                if (line.startsWith(PACKAGE)) {
                    caller = line;
                }
                break;
            }
        }
        catch (IOException e) {
            caller = null;
        }
        if (caller == null) {
            return null;
        }
        int dot = caller.lastIndexOf(46);
        if (dot != -1) {
            caller = caller.substring(dot + 1);
        }
        return caller;
    }

    public static String quote(String[] s) {
        if (s == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer("{");
        int i = 0;
        while (i < s.length) {
            if (i > 0) {
                buff.append(',');
            }
            buff.append(Trace.quote(s[i]));
            ++i;
        }
        buff.append('}');
        return buff.toString();
    }

    public static String quote(String s) {
        if (s == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer("\"");
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    buff.append("\\b");
                    break;
                }
                case '\t': {
                    buff.append("\\t");
                    break;
                }
                case '\n': {
                    buff.append("\\n");
                    break;
                }
                case '\f': {
                    buff.append("\\f");
                    break;
                }
                case '\r': {
                    buff.append("\\r");
                    break;
                }
                case '\\': {
                    buff.append("\\\\");
                    break;
                }
                case '\"': {
                    buff.append("\\\"");
                    break;
                }
                default: {
                    if (c > '\u00ff' || c < ' ') {
                        buff.append("\\u");
                        buff.append(Integer.toHexString(c >> 12));
                        buff.append(Integer.toHexString(c >> 8 & 0xF));
                        buff.append(Integer.toHexString(c >> 4 & 0xF));
                        buff.append(Integer.toHexString(c & 0xF));
                        break;
                    }
                    buff.append(c);
                }
            }
            ++i;
        }
        buff.append("\"");
        return buff.toString();
    }

    public static String quote(int[] data) {
        if (data == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer("{");
        int i = 0;
        while (i < data.length) {
            if (i > 0) {
                buff.append(',');
            }
            buff.append(data[i]);
            ++i;
        }
        buff.append('}');
        return buff.toString();
    }

    public static String quoteObject(Object o) {
        if (o == null) {
            return "null";
        }
        return "(" + o.getClass().getName() + ")o_" + System.identityHashCode(o);
    }

    static {
        try {
            String trace = System.getProperty("ldbc.trace", "off").toLowerCase();
            Trace.setOption(trace);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        CLASSNAME = new Trace().getClass().getName();
    }
}

