/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.ldbc.core.Adapter;
import org.ldbc.core.Command;
import org.ldbc.core.Factory;
import org.ldbc.core.Trace;
import org.ldbc.jdbc.jdbcCallableStatement;
import org.ldbc.jdbc.jdbcDatabaseMetaData;
import org.ldbc.jdbc.jdbcPreparedStatement;
import org.ldbc.jdbc.jdbcStatement;
import org.ldbc.parser.Translator;

public class jdbcConnection
implements Connection {
    static int mCounter;
    int mId = mCounter++;
    Connection mConn;
    String mUrl;
    String mUser;
    Translator mTranslate;
    Adapter mAdapter;
    boolean mClosed;
    boolean mReadOnlyOptimization;
    int mTransactionIsolationLevel = 2;
    boolean mAutoCommit;

    public Statement createStatement() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            jdbcStatement stat = new jdbcStatement(this.mAdapter, this);
            if (Trace.isEnabled()) {
                Trace.traceResult(stat.getId());
            }
            return stat;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.traceQuote(this.getId(), sql);
            }
            this.checkClosed();
            sql = this.translateSQL(sql);
            jdbcPreparedStatement prep = new jdbcPreparedStatement(this.mAdapter, this, sql);
            if (Trace.isEnabled()) {
                Trace.traceResult(prep.getId());
            }
            return prep;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            jdbcDatabaseMetaData meta = new jdbcDatabaseMetaData(this, this.mConn.getMetaData());
            if (Trace.isEnabled()) {
                Trace.traceResult(meta.getId());
            }
            return meta;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void close() throws SQLException {
        block5: {
            try {
                if (Trace.isEnabled()) {
                    Trace.trace(this.getId());
                }
                if (this.mClosed) break block5;
                try {
                    this.mConn.rollback();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                this.mClosed = true;
                this.mConn.close();
            }
            catch (Throwable e) {
                throw this.convertThrowable(e);
            }
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), "" + autoCommit);
            }
            this.checkClosed();
            this.mAutoCommit = autoCommit;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            boolean result = this.mAutoCommit;
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void commit() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            if (!this.mAutoCommit) {
                this.commitInternal();
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void rollback() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            if (!this.mAutoCommit) {
                this.mConn.rollback();
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isClosed() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        if (Trace.isEnabled()) {
            Trace.traceResult(this.mClosed);
        }
        return this.mClosed;
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.traceQuote(this.getId(), sql);
            }
            this.checkClosed();
            sql = this.translateSQL(sql);
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(sql);
            }
            return sql;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), "" + readOnly);
            }
            this.checkClosed();
            this.mReadOnlyOptimization = readOnly;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            if (Trace.isEnabled()) {
                Trace.traceResult(this.mReadOnlyOptimization);
            }
            return this.mReadOnlyOptimization;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.traceQuote(this.getId(), catalog);
            }
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getCatalog() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            return null;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), resultSetType + "," + resultSetConcurrency);
            }
            this.checkClosed();
            if (resultSetType != 1003 || resultSetConcurrency != 1007) {
                throw Factory.getInvalidValueException("resultSetType:" + resultSetType + " resultSetConcurrency:" + resultSetConcurrency);
            }
            jdbcStatement stat = new jdbcStatement(this.mAdapter, this);
            if (Trace.isEnabled()) {
                Trace.traceResult(stat.getId());
            }
            return stat;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(sql) + "," + resultSetType + "," + resultSetConcurrency);
            }
            this.checkClosed();
            if (resultSetType != 1003 || resultSetConcurrency != 1007) {
                throw Factory.getInvalidValueException("resultSetType:" + resultSetType + " resultSetConcurrency:" + resultSetConcurrency);
            }
            sql = this.translateSQL(sql);
            jdbcPreparedStatement prep = new jdbcPreparedStatement(this.mAdapter, this, sql);
            if (Trace.isEnabled()) {
                Trace.traceResult(prep.getId());
            }
            return prep;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), level);
            }
            this.checkClosed();
            if (level != 2 && level != 8) {
                throw Factory.getInvalidValueException("level:" + level);
            }
            this.commitInternal();
            this.mAdapter.setTransactionIsolation(level);
            this.mTransactionIsolationLevel = level;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = this.mTransactionIsolationLevel;
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Map getTypeMap() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), Trace.quoteObject(map));
        }
        throw Factory.getUnsupportedException();
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.traceQuote(this.getId(), sql);
            }
            this.checkClosed();
            sql = this.translateSQL(sql);
            jdbcCallableStatement call = new jdbcCallableStatement(this.mAdapter, this, sql);
            if (Trace.isEnabled()) {
                Trace.traceResult(call.getId());
            }
            return call;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(sql) + "," + resultSetType + "," + resultSetConcurrency);
            }
            this.checkClosed();
            if (resultSetType != 1003 || resultSetConcurrency != 1007) {
                throw Factory.getInvalidValueException("resultSetType:" + resultSetType + " resultSetConcurrency:" + resultSetConcurrency);
            }
            sql = this.translateSQL(sql);
            jdbcCallableStatement call = new jdbcCallableStatement(this.mAdapter, this, sql);
            if (Trace.isEnabled()) {
                Trace.traceResult(call.getId());
            }
            return call;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getHoldability() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Savepoint setSavepoint() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Connection getVendorObject() {
        return this.mConn;
    }

    jdbcConnection(String url, String user, Adapter adapter, Connection conn) throws SQLException {
        this.mUrl = url;
        this.mUser = user;
        this.mConn = conn;
        this.mAdapter = adapter;
        this.mTranslate = new Translator(adapter);
        this.mAutoCommit = true;
        this.mAdapter.setConnection(this, conn);
        try {
            this.mConn.setAutoCommit(false);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    Adapter getAdapter() {
        return this.mAdapter;
    }

    Command translate(String sql) throws SQLException {
        return this.mTranslate.translate(sql);
    }

    Connection getConnection() {
        return this.mConn;
    }

    String translateSQL(String sql) {
        if (sql == null) {
            return null;
        }
        if (sql.indexOf(123) == -1) {
            return sql;
        }
        int len = sql.length();
        int start = -1;
        int i = 0;
        while (i < len) {
            switch (sql.charAt(i)) {
                case '\'': {
                    i = sql.indexOf(39, i + 1);
                    break;
                }
                case '\"': {
                    i = sql.indexOf(34, i + 1);
                    break;
                }
                case '{': {
                    if (start != -1) {
                        return sql;
                    }
                    start = i;
                    break;
                }
                case '}': {
                    if (start == -1) {
                        return sql;
                    }
                    String left = sql.substring(0, start);
                    String mid = sql.substring(start + 1, i);
                    String right = sql.substring(i + 1);
                    String key = mid.toLowerCase();
                    sql = key.startsWith("fn") || key.startsWith("oj") ? left + mid.substring(3) + right : (key.startsWith("ts") ? left + "TIMESTAMP " + mid.substring(3) + right : (key.startsWith("t") ? left + "TIME " + mid.substring(2) + right : (key.startsWith("d") ? left + "DATE " + mid.substring(2) + right : left + mid + right)));
                    return this.translateSQL(sql);
                }
            }
            ++i;
        }
        return sql;
    }

    void checkClosed() throws SQLException {
        if (this.mClosed) {
            throw Factory.getClosedException();
        }
    }

    String getId() {
        return "conn" + this.mId;
    }

    SQLException convertThrowable(Throwable e) {
        SQLException x = this.mAdapter.convertThrowable(e);
        if (Trace.isEnabled()) {
            Trace.traceException(x);
        }
        return x;
    }

    void commitInternal() throws SQLException {
        try {
            this.mConn.commit();
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    void executePseudo(int command) throws SQLException {
        switch (command) {
            case 0: {
                this.commit();
                break;
            }
            case 1: {
                this.rollback();
                break;
            }
            case 2: {
                this.setAutoCommit(true);
                break;
            }
            case 3: {
                this.setAutoCommit(false);
            }
        }
    }
}

