/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;
import org.ldbc.core.Factory;
import org.ldbc.core.MemoryResultSet;
import org.ldbc.core.Trace;
import org.ldbc.jdbc.jdbcConnection;
import org.ldbc.jdbc.jdbcResultSet;
import org.ldbc.parser.Translator;

public class jdbcDatabaseMetaData
implements DatabaseMetaData {
    static final String NOT_A_TABLE = "+";
    static int mCounter;
    int mId = mCounter++;
    jdbcConnection mConn;
    Adapter mAdapter;
    DatabaseMetaData mMeta;

    public int getDriverMajorVersion() {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        return 0;
    }

    public int getDriverMinorVersion() {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        return 1;
    }

    public String getDatabaseProductName() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            String name = this.mMeta.getDatabaseProductName();
            String line = jdbcDatabaseMetaData.getFirstLine(name);
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(line);
            }
            return line;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getDatabaseProductVersion() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            String version = this.mMeta.getDatabaseProductVersion();
            String line = jdbcDatabaseMetaData.getFirstLine(version);
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(line);
            }
            return line;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getDriverName() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            String driver = this.mMeta.getDriverName();
            String line = "LDBC " + jdbcDatabaseMetaData.getFirstLine(driver);
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(line);
            }
            return line;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getDriverVersion() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            String line = "0.1";
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(line);
            }
            return line;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schemaPattern) + "," + Trace.quote(tableNamePattern) + "," + Trace.quote(types));
            }
            this.checkClosed();
            if (catalog != null || schemaPattern != null) {
                throw Factory.getInvalidValueException("catalog:" + catalog + " schemaPattern:" + schemaPattern);
            }
            this.checkValidNamePattern(tableNamePattern);
            schemaPattern = this.getSchema();
            if (types != null) {
                if (types.length != 1 || !types[0].equals("TABLE")) {
                    throw Factory.getInvalidValueException("types:" + Trace.quote(types));
                }
            } else {
                types = new String[]{"TABLE"};
            }
            ResultSet rs = this.mMeta.getTables(catalog, schemaPattern, null, types);
            MemoryResultSet memrs = new MemoryResultSet(rs, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS"}, new int[]{12, 12, 12, 12, 12});
            memrs.convertAllToUpperCase(3);
            int row = 0;
            while (memrs.next()) {
                String table = memrs.getString(3);
                if (!jdbcDatabaseMetaData.testPattern(table, tableNamePattern) || !this.testTable(table)) {
                    memrs.deleteRow(row);
                    row = -1;
                }
                ++row;
            }
            memrs.reset();
            memrs.setAllNull(1);
            memrs.setAllNull(2);
            memrs.setAllString(4, "TABLE");
            memrs.setAllNull(5);
            memrs.sort(new int[]{3});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schemaPattern) + "," + Trace.quote(tableNamePattern) + "," + Trace.quote(columnNamePattern));
            }
            this.checkClosed();
            if (catalog != null || schemaPattern != null) {
                throw Factory.getInvalidValueException("catalog:" + catalog + " schemaPattern:" + schemaPattern);
            }
            this.checkValidNamePattern(tableNamePattern);
            this.checkValidNamePattern(columnNamePattern);
            schemaPattern = this.getSchema();
            ResultSet rs = this.mMeta.getColumns(catalog, schemaPattern, null, null);
            MemoryResultSet memrs = new MemoryResultSet(rs, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"}, new int[]{12, 12, 12, 12, 5, 12, 4, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12});
            memrs.setAllNull(1);
            memrs.setAllNull(2);
            memrs.convertAllToUpperCase(3);
            memrs.convertAllToUpperCase(4);
            int row = 0;
            while (memrs.next()) {
                String table = memrs.getString(3);
                String column = memrs.getString(4);
                if (!jdbcDatabaseMetaData.testPattern(table, tableNamePattern) || !this.testTable(table)) {
                    memrs.deleteRow(row);
                    row = -1;
                } else if (!jdbcDatabaseMetaData.testPattern(column, columnNamePattern)) {
                    memrs.deleteRow(row);
                    row = -1;
                }
                ++row;
            }
            memrs.reset();
            int row2 = 0;
            while (memrs.next()) {
                int datatype = memrs.getInt(5);
                String typename = memrs.getString(6);
                int precision = memrs.getInt(7);
                int scale = memrs.getInt(9);
                DataType type = new DataType(typename, datatype, precision, scale);
                this.mConn.getAdapter().convertDataType(type);
                memrs.setInt(row2, 5, type.getDataType());
                String typeName = type.getTypeName();
                String tableName = memrs.getString(3);
                String columnName = memrs.getString(4);
                String autoinc = this.mAdapter.getAutoIncrementColumn(tableName);
                if (columnName.equals(autoinc)) {
                    typeName = typeName + " AUTOINCREMENT";
                }
                memrs.setString(row2, 6, typeName);
                memrs.setInt(row2, 7, type.getPrecision());
                memrs.setInt(row2, 9, type.getScale());
                int nullable = memrs.getInt(11);
                if (nullable == 0) {
                    memrs.setString(row2, 18, "NO");
                } else if (nullable == 1) {
                    memrs.setString(row2, 18, "YES");
                } else {
                    throw Factory.getInvalidValueException("nullable:" + nullable);
                }
                ++row2;
            }
            memrs.reset();
            memrs.setAllNull(8);
            memrs.setAllInt(10, 10);
            memrs.setAllNull(12);
            memrs.setAllNull(13);
            memrs.setAllNull(14);
            memrs.setAllNull(15);
            memrs.setAllNull(16);
            memrs.sort(new int[]{3, 17});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schema) + "," + Trace.quote(table) + "," + unique + "," + approximate);
            }
            this.checkClosed();
            if (catalog != null || schema != null) {
                throw Factory.getInvalidValueException("catalog:" + catalog + " schema:" + schema);
            }
            this.checkValidName(table);
            schema = this.getSchema();
            if (!this.testTable(table)) {
                table = NOT_A_TABLE;
            }
            String pkname = this.getPrimaryKeyName(catalog, schema, table);
            ResultSet rs = this.mMeta.getIndexInfo(catalog, schema, table, unique, true);
            MemoryResultSet memrs = new MemoryResultSet(rs, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"}, new int[]{12, 12, 12, -7, 12, 12, 5, 5, 12, 12, 4, 4, 12});
            memrs.setAllNull(1);
            memrs.setAllNull(2);
            memrs.convertAllToUpperCase(3);
            memrs.setAllNull(5);
            memrs.convertAllToUpperCase(6);
            memrs.setAllShort(7, (short)3);
            memrs.convertAllToUpperCase(9);
            memrs.setAllString(10, "A");
            memrs.setAllNull(11);
            memrs.setAllNull(12);
            memrs.setAllNull(13);
            if (pkname != null) {
                int row = 0;
                while (memrs.next()) {
                    String indexname = memrs.getString(6);
                    if ((indexname = this.mAdapter.truncateIndexName(indexname)) == null) {
                        memrs.deleteRow(row);
                        row = -1;
                    } else if (indexname.equals(pkname)) {
                        memrs.setString(row, 6, "PRIMARY_KEY");
                    } else if (indexname.equals("PRIMARY")) {
                        memrs.setString(row, 6, "PRIMARY_KEY");
                    } else if (indexname.startsWith(table + "_")) {
                        indexname = indexname.substring(table.length() + 1);
                        memrs.setString(row, 6, indexname);
                    }
                    ++row;
                }
            }
            memrs.reset();
            memrs.sort(new int[]{4, 7, 6, 8});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schema) + "," + Trace.quote(table));
            }
            this.checkClosed();
            if (catalog != null || schema != null) {
                throw Factory.getInvalidValueException("catalog:" + catalog + " schema:" + schema);
            }
            this.checkValidName(table);
            schema = this.getSchema();
            if (!this.testTable(table)) {
                table = NOT_A_TABLE;
            }
            ResultSet rs = this.mMeta.getPrimaryKeys(catalog, schema, table);
            MemoryResultSet memrs = new MemoryResultSet(rs, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"}, new int[]{12, 12, 12, 12, 5, 12});
            memrs.setAllNull(1);
            memrs.setAllNull(2);
            memrs.convertAllToUpperCase(3);
            memrs.convertAllToUpperCase(4);
            memrs.setAllString(6, "PRIMARY_KEY");
            memrs.sort(new int[]{4});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            return true;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean allTablesAreSelectable() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            return true;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getURL() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            String url = this.mConn.mUrl;
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(url);
            }
            return url;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getUserName() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            String user = this.mConn.mUser;
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(user);
            }
            return user;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            boolean result = this.mConn.isReadOnly();
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            boolean result = this.mMeta.nullsAreSortedHigh();
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean nullsAreSortedLow() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            boolean result = this.mMeta.nullsAreSortedLow();
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            boolean result = this.mMeta.nullsAreSortedAtStart();
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            boolean result = this.mMeta.nullsAreSortedAtEnd();
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            if (Trace.isEnabled()) {
                Trace.traceResult(this.mConn.getId());
            }
            return this.mConn;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schemaPattern) + "," + Trace.quote(procedureNamePattern));
            }
            this.checkClosed();
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "NUM_INPUT_PARAMS", "NUM_OUTPUT_PARAMS", "NUM_RESULT_SETS", "REMARKS", "PROCEDURE_TYPE"}, new int[]{12, 12, 12, 4, 4, 4, 12, 5});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schemaPattern) + "," + Trace.quote(procedureNamePattern) + "," + Trace.quote(columnNamePattern));
            }
            this.checkClosed();
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"PROCEDURE_CAT", "PROCEDURE_SCHEM", "PROCEDURE_NAME", "COLUMN_NAME", "COLUMN_TYPE", "DATA_TYPE", "TYPE_NAME", "PRECISION", "LENGTH", "SCALE", "RADIX", "NULLABLE", "REMARKS"}, new int[]{12, 12, 12, 12, 5, 5, 12, 4, 4, 5, 4, 5, 12});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getSchemas() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"TABLE_SCHEM"}, new int[]{12});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getCatalogs() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"TABLE_SCHEM"}, new int[]{12});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getTableTypes() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"TABLE_TYPE"}, new int[]{12});
            memrs.appendRow(new Object[]{"TABLE"});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schema) + "," + Trace.quote(table) + "," + Trace.quote(columnNamePattern));
            }
            this.checkClosed();
            if (!this.testTable(table)) {
                table = NOT_A_TABLE;
            }
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schemaPattern) + "," + Trace.quote(tableNamePattern));
            }
            this.checkClosed();
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"}, new int[]{12, 12, 12, 12, 12, 12, 12});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schema) + "," + Trace.quote(table) + "," + scope + "," + nullable);
            }
            this.checkClosed();
            if (!this.testTable(table)) {
                table = NOT_A_TABLE;
            }
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"}, new int[]{5, 12, 5, 12, 4, 4, 5, 5});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schema) + "," + Trace.quote(table));
            }
            this.checkClosed();
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"}, new int[]{5, 12, 5, 12, 4, 4, 5, 5});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schema) + "," + Trace.quote(table));
            }
            this.checkClosed();
            if (catalog != null || schema != null) {
                throw Factory.getInvalidValueException("catalog:" + catalog + " schema:" + schema);
            }
            this.checkValidName(table);
            schema = this.getSchema();
            if (!this.testTable(table)) {
                table = NOT_A_TABLE;
            }
            ResultSet rs = this.mMeta.getImportedKeys(catalog, schema, table);
            MemoryResultSet memrs = new MemoryResultSet(rs, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5});
            memrs.setAllNull(1);
            memrs.setAllNull(2);
            memrs.convertAllToUpperCase(3);
            memrs.convertAllToUpperCase(4);
            memrs.setAllNull(5);
            memrs.setAllNull(6);
            memrs.convertAllToUpperCase(7);
            memrs.convertAllToUpperCase(8);
            memrs.setAllInt(10, 3);
            memrs.setAllInt(11, 3);
            memrs.setAllNull(12);
            memrs.setAllNull(13);
            memrs.setAllInt(14, 7);
            memrs.reset();
            memrs.sort(new int[]{1, 2, 3, 9});
            String tab = null;
            int seq = 0;
            int row = 0;
            while (memrs.next()) {
                String t = memrs.getString(3);
                if (tab == null || tab.equals(t)) {
                    seq = 1;
                }
                memrs.setInt(row, 9, seq++);
                ++row;
            }
            memrs.reset();
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schema) + "," + Trace.quote(table));
            }
            this.checkClosed();
            if (catalog != null || schema != null) {
                throw Factory.getInvalidValueException("catalog:" + catalog + " schema:" + schema);
            }
            this.checkValidName(table);
            schema = this.getSchema();
            if (!this.testTable(table)) {
                table = NOT_A_TABLE;
            }
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(primaryCatalog) + "," + Trace.quote(primarySchema) + "," + Trace.quote(primaryTable) + "," + Trace.quote(foreignCatalog) + "," + Trace.quote(foreignSchema) + "," + Trace.quote(foreignTable));
            }
            this.checkClosed();
            if (primaryCatalog != null || primarySchema != null) {
                throw Factory.getInvalidValueException("primaryCatalog:" + primaryCatalog + " primarySchema:" + primarySchema);
            }
            this.checkValidName(primaryTable);
            primarySchema = this.getSchema();
            if (foreignCatalog != null || foreignSchema != null) {
                throw Factory.getInvalidValueException("foreignCatalog:" + foreignCatalog + " foreignSchema:" + foreignSchema);
            }
            this.checkValidName(foreignTable);
            foreignSchema = this.getSchema();
            if (!this.testTable(foreignTable)) {
                foreignTable = NOT_A_TABLE;
            }
            if (!this.testTable(primaryTable)) {
                primaryTable = NOT_A_TABLE;
            }
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), Trace.quote(catalog) + "," + Trace.quote(schemaPattern) + "," + Trace.quote(typeNamePattern) + "," + Trace.quote(types));
            }
            this.checkClosed();
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS"}, new int[]{12, 12, 12, 12, 5, 12});
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getTypeInfo() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            MemoryResultSet memrs = new MemoryResultSet(null, new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"}, new int[]{12, 5, 4, 12, 12, 12, 5, 5, 5, 5, 5, 5, 12, 5, 5, 4, 4, 4});
            this.addDatatypeRow(memrs, 3, null, null, false, "precision,scale", 10);
            this.addDatatypeRow(memrs, 4, null, null, false, null, 10);
            this.addDatatypeRow(memrs, 4, null, null, true, null, 10);
            this.addDatatypeRow(memrs, 12, "'", "'", false, "length", 10);
            this.addDatatypeRow(memrs, 93, "DATETIME '", "'", false, null, 10);
            this.addDatatypeRow(memrs, 2005, "'", "'", false, null, 10);
            this.addDatatypeRow(memrs, 2004, "X'", "'", false, null, 10);
            jdbcResultSet result = new jdbcResultSet(this.mConn, memrs);
            if (Trace.isEnabled()) {
                Trace.traceResult(result.getId());
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    private void addDatatypeRow(MemoryResultSet rs, int dt, String prefix, String suffix, boolean autoinc, String params, int radix) throws SQLException {
        Object[] row = new Object[18];
        String datatype = DataType.getDataTypeString(dt);
        if (autoinc) {
            datatype = "AUTOINCREMENT " + datatype;
        }
        row[12] = row[0] = datatype;
        row[15] = row[1] = new Integer(dt);
        row[2] = new Integer(DataType.getDefaultPrecision(dt));
        row[3] = prefix;
        row[4] = suffix;
        row[5] = params;
        row[6] = new Integer(1);
        row[10] = row[11] = new Integer(0);
        row[9] = row[11];
        row[7] = row[11];
        if (autoinc) {
            row[11] = new Integer(1);
        }
        row[8] = new Integer(3);
        if (radix == 10) {
            row[13] = new Integer(0);
            row[14] = new Integer(DataType.getDefaultScale(dt));
            row[17] = new Integer(radix);
        }
        rs.appendRow(row);
    }

    public boolean usesLocalFiles() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        String keywords = Translator.getKeywords();
        return keywords;
    }

    public String getNumericFunctions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return "";
    }

    public String getStringFunctions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return "CAST";
    }

    public String getTimeDateFunctions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return "\"";
    }

    public String getExtraNameCharacters() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public String getSchemaTerm() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return "Schema";
    }

    public String getProcedureTerm() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return "Procedure";
    }

    public String getCatalogTerm() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return "Catalog";
    }

    public boolean isCatalogAtStart() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsTransactions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), level);
            }
            this.checkClosed();
            boolean result = level == 2 || level == 8;
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        try {
            boolean result;
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            boolean bl = result = type == 1003;
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        try {
            boolean result;
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), type + "," + concurrency);
            }
            this.checkClosed();
            boolean bl = result = type == 1003 && concurrency == 1007;
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), type);
        }
        this.checkClosed();
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), type);
        }
        this.checkClosed();
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), type);
        }
        this.checkClosed();
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), type);
        }
        this.checkClosed();
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), type);
        }
        this.checkClosed();
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), type);
        }
        this.checkClosed();
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), type);
        }
        this.checkClosed();
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), type);
        }
        this.checkClosed();
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), type);
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 2;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return true;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxStatementLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        return 0;
    }

    public DatabaseMetaData getVendorObject() {
        return this.mMeta;
    }

    public boolean supportsSavepoints() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean supportsNamedParameters() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getResultSetHoldability() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getDatabaseMajorVersion() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getDatabaseMinorVersion() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getJDBCMajorVersion() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getJDBCMinorVersion() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getSQLStateType() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean supportsStatementPooling() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    jdbcDatabaseMetaData(jdbcConnection conn, DatabaseMetaData meta) {
        this.mConn = conn;
        this.mAdapter = conn.mAdapter;
        this.mMeta = meta;
    }

    static String getFirstLine(String s) {
        if (s == null) {
            s = "";
        }
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < ' ') {
                return s.substring(0, i);
            }
            ++i;
        }
        return s;
    }

    String getSchema() throws SQLException {
        return this.mConn.getAdapter().getDefaultSchema();
    }

    void checkValidNamePattern(String s) throws SQLException {
        if (s == null) {
            return;
        }
        if (s.length() == 0) {
            throw Factory.getInvalidValueException("length:0");
        }
        char first = s.charAt(0);
        if (first >= '0' && first <= '9') {
            throw Factory.getInvalidValueException("s:<" + s + ">");
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (i >= len) {
                    throw Factory.getInvalidValueException("s:<" + s + ">");
                }
                if ((c = s.charAt(++i)) != '_') {
                    throw Factory.getInvalidValueException("s:<" + s + ">");
                }
            } else if (!(c == '_' || c == '%' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                throw Factory.getInvalidValueException("s:<" + s + ">");
            }
            ++i;
        }
    }

    void checkValidName(String s) throws SQLException {
        if (s == null || s.length() == 0) {
            throw Factory.getInvalidValueException("s:" + s);
        }
        char first = s.charAt(0);
        if (first < 'A' || first > 'Z') {
            throw Factory.getInvalidValueException("s:" + s);
        }
        int len = s.length();
        int i = 1;
        while (i < len) {
            char c = s.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_')) {
                throw Factory.getInvalidValueException("s:" + s);
            }
            ++i;
        }
    }

    boolean testTable(String tableName) {
        return !this.mAdapter.isSystemTable(tableName);
    }

    static boolean testPattern(String text, String pattern) {
        if (pattern == null) {
            return true;
        }
        if (text == null) {
            text = "";
        }
        return jdbcDatabaseMetaData.testPatternSub(text.toCharArray(), 0, pattern.toCharArray(), 0);
    }

    /*
     * Unable to fully structure code
     */
    static boolean testPatternSub(char[] text, int textIndex, char[] pattern, int patternIndex) {
        textLen = text.length;
        patternLen = pattern.length;
        while (patternIndex < patternLen) {
            block8: {
                p = pattern[patternIndex];
                if (p != '%') break block8;
                if (++patternIndex < patternLen) ** GOTO lbl11
                return true;
lbl-1000:
                // 1 sources

                {
                    if (jdbcDatabaseMetaData.testPatternSub(text, textIndex, pattern, patternIndex)) {
                        return true;
                    }
                    ++textIndex;
lbl11:
                    // 2 sources

                    ** while (textIndex < textLen)
                }
lbl12:
                // 1 sources

                return false;
            }
            if (p == '_') {
                if (textIndex++ >= textLen) {
                    return false;
                }
            } else {
                if (p == '\\') {
                    p = pattern[++patternIndex];
                }
                if (textIndex >= textLen || p != text[textIndex++]) {
                    return false;
                }
            }
            ++patternIndex;
        }
        return textIndex == textLen;
    }

    void checkClosed() throws SQLException {
        if (this.mConn.mClosed) {
            throw Factory.getClosedException();
        }
    }

    String getId() {
        return "dbmeta" + this.mId;
    }

    SQLException convertThrowable(Throwable e) {
        SQLException x = this.mAdapter.convertThrowable(e);
        if (Trace.isEnabled()) {
            Trace.traceException(x);
        }
        return x;
    }

    String getPrimaryKeyName(String catalog, String schema, String table) throws SQLException {
        String pkname = null;
        ResultSet rspkname = this.mMeta.getPrimaryKeys(catalog, schema, table);
        if (rspkname.next()) {
            pkname = rspkname.getString(6).toUpperCase();
        }
        pkname = this.mAdapter.truncateIndexName(pkname);
        return pkname;
    }
}

