/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.ldbc.core.Adapter;
import org.ldbc.core.Factory;
import org.ldbc.core.Trace;
import org.ldbc.jdbc.jdbcConnection;

public class jdbcDriver
implements Driver {
    static final int MAJOR_VERSION = 0;
    static final int MINOR_VERSION = 1;
    static final String START_URL = "jdbc:ldbc:";

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        String user = info.getProperty("user", "");
        String password = info.getProperty("password", "");
        int traceBegin = url.indexOf("[ldbc.trace=");
        if (traceBegin != -1) {
            int traceEnd = url.indexOf(93, traceBegin);
            String trace = url.substring(traceBegin + 1, traceEnd);
            url = url.substring(0, traceBegin) + url.substring(traceEnd + 1);
            trace = trace.substring(trace.indexOf(61) + 1);
            Trace.setOption(trace);
        }
        String vendor_url = "jdbc:" + url.substring(START_URL.length());
        Adapter adapter = Factory.getAdapter(vendor_url);
        String driver = adapter.getDriverClass();
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            throw Factory.getSQLException("IM003", driver);
        }
        Connection conn = DriverManager.getConnection(vendor_url, user, password);
        return new jdbcConnection(url, user, adapter, conn);
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.startsWith(START_URL);
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 1;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        jdbcDriver driver = new jdbcDriver();
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {}
    }
}

