/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import org.ldbc.core.Adapter;
import org.ldbc.core.Command;
import org.ldbc.core.Factory;
import org.ldbc.core.Trace;
import org.ldbc.jdbc.jdbcConnection;
import org.ldbc.jdbc.jdbcResultSet;

public class jdbcPreparedStatement
implements PreparedStatement {
    static int mCounter;
    Command mCommand;
    int mId = mCounter++;
    boolean mClosed;
    Adapter mAdapter;
    jdbcConnection mConn;
    PreparedStatement mPrep;
    jdbcResultSet mLastResultSet;
    boolean mNoResult;
    int mMaxRows;
    int mQueryTimeout;
    Vector mOpenResultSets = new Vector();
    int mUpdateCount;

    public ResultSet executeQuery() throws SQLException {
        try {
            jdbcResultSet rs;
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.closeOld();
            this.checkClosed();
            this.mCommand.checkQuery();
            this.mAdapter.prepareExecute(this.mPrep, this.mCommand);
            this.mLastResultSet = rs = new jdbcResultSet(this.mConn, null, this, this.mPrep.executeQuery());
            if (Trace.isEnabled()) {
                Trace.traceResult(rs.getId());
            }
            return rs;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            int count;
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.closeOld();
            this.checkClosed();
            if (this.mCommand.isPseudo()) {
                this.mConn.executePseudo(this.mCommand.getPseudoCommand());
                count = 0;
            } else {
                this.mCommand.checkUpdate();
                this.mAdapter.prepareExecute(this.mPrep, this.mCommand);
                count = this.mPrep.executeUpdate();
                if (this.mCommand.isCreateOrDrop() || this.mConn.mAutoCommit) {
                    this.mConn.commitInternal();
                }
            }
            this.mUpdateCount = count;
            if (Trace.isEnabled()) {
                Trace.traceResult(count);
            }
            return count;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean execute() throws SQLException {
        try {
            boolean result;
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.closeOld();
            this.checkClosed();
            if (this.mCommand.isPseudo()) {
                this.mConn.executePseudo(this.mCommand.getPseudoCommand());
                this.mUpdateCount = 0;
                result = false;
            } else if (this.mCommand.isUpdate()) {
                this.mAdapter.prepareExecute(this.mPrep, this.mCommand);
                result = this.mPrep.execute();
                if (!result) {
                    this.mUpdateCount = this.mPrep.getUpdateCount();
                }
                if (this.mCommand.isCreateOrDrop()) {
                    this.mUpdateCount = 0;
                }
            } else {
                result = false;
                this.mAdapter.prepareExecute(this.mPrep, this.mCommand);
                this.mLastResultSet = new jdbcResultSet(this.mConn, null, this, this.mPrep.executeQuery());
            }
            if (this.mCommand.isCreateOrDrop() || this.mConn.mAutoCommit && this.mCommand.isUpdate()) {
                this.mConn.commitInternal();
            }
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            jdbcResultSet rs = this.mNoResult ? null : new jdbcResultSet(this.mConn, null, this, this.mPrep.getResultSet());
            this.mLastResultSet = rs;
            if (Trace.isEnabled()) {
                Trace.traceResult(rs.getId());
            }
            return rs;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = this.mNoResult ? -1 : this.mUpdateCount;
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void close() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.closeOld();
            if (!this.mClosed) {
                this.mClosed = true;
                this.mPrep.close();
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + sqlType);
            }
            this.checkClosed();
            this.mAdapter.setNull(this, parameterIndex, sqlType);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setInt(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mAdapter.setString(this, parameterIndex, x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setBigDecimal(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setDate(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setTime(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setTimestamp(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void clearParameters() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            this.mPrep.clearParameters();
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.traceQuote(this.getId(), sql);
        }
        throw Factory.getUnsupportedException();
    }

    public void addBatch(String sql) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public int executeUpdate(String sql) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.traceQuote(this.getId(), sql);
        }
        throw Factory.getUnsupportedException();
    }

    public boolean execute(String sql) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.traceQuote(this.getId(), sql);
        }
        throw Factory.getUnsupportedException();
    }

    public Connection getConnection() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        if (Trace.isEnabled()) {
            Trace.traceResult(this.mConn.getId());
        }
        return this.mConn;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + Trace.quoteObject(x));
            }
            this.checkClosed();
            if (x == null) {
                throw Factory.getInvalidValueException("x:" + x);
            }
            this.mPrep.setObject(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + Trace.quoteObject(x) + "," + targetSqlType);
            }
            this.checkClosed();
            x = this.convertObject(x, targetSqlType);
            if (x == null) {
                this.setNull(parameterIndex, targetSqlType);
            } else {
                this.mPrep.setObject(this.translateParameterIndex(parameterIndex), x, targetSqlType);
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + Trace.quoteObject(x) + "," + targetSqlType + "," + scale);
            }
            this.checkClosed();
            x = this.convertObject(x, targetSqlType);
            if (x == null) {
                this.setNull(parameterIndex, targetSqlType);
            } else {
                this.mPrep.setObject(this.translateParameterIndex(parameterIndex), x, targetSqlType, scale);
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setInt(this.translateParameterIndex(parameterIndex), x ? 1 : 0);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setInt(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setShort(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setLong(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setFloat(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + x);
            }
            this.checkClosed();
            this.mPrep.setDouble(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.closeOld();
            this.mNoResult = true;
            this.mPrep.getMoreResults();
            return false;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), paramIndex + "," + sqlType + "," + typeName);
        }
        this.setNull(paramIndex, sqlType);
    }

    public void setCursorName(String name) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.traceQuote(this.getId(), name);
        }
        this.checkClosed();
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 0;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), max);
            }
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            int result = this.mPrep.getMaxRows();
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setMaxRows(int max) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), max);
            }
            this.mPrep.setMaxRows(max);
            this.mMaxRows = max;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), direction);
        }
        this.checkClosed();
    }

    public int getFetchDirection() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 1000;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 1007;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 1004;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), "" + enable);
            }
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            return null;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void cancel() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.mAdapter.cancel(this.mPrep);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            int result = this.mQueryTimeout;
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), seconds);
            }
            if (seconds < 0) {
                throw Factory.getInvalidValueException("seconds:" + seconds);
            }
            this.mQueryTimeout = seconds;
            this.mPrep.setQueryTimeout(seconds);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), rows);
            }
            this.checkClosed();
            if (rows < 0) {
                throw Factory.getInvalidValueException("rows:" + rows);
            }
            if (rows > 0 && this.mMaxRows > 0 && rows > this.mMaxRows) {
                throw Factory.getInvalidValueException("rows:" + rows + " max:" + this.mMaxRows);
            }
            this.mPrep.setFetchSize(rows);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = this.mPrep.getFetchSize();
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setRef(int i, Ref x) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), Trace.quoteObject(x));
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public void setDate(int parameterIndex, Date x, Calendar calendar) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + Trace.quoteObject(x) + "," + Trace.quoteObject(calendar));
            }
            this.checkClosed();
            if (x != null) {
                calendar = (Calendar)calendar.clone();
                calendar.setTime(x);
                Calendar local = Calendar.getInstance();
                jdbcPreparedStatement.convertTime(calendar, local);
                x = new Date(local.getTime().getTime());
            }
            this.mPrep.setDate(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar calendar) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + Trace.quoteObject(x) + "," + Trace.quoteObject(calendar));
            }
            this.checkClosed();
            if (x != null) {
                calendar = (Calendar)calendar.clone();
                calendar.setTime(x);
                Calendar local = Calendar.getInstance();
                jdbcPreparedStatement.convertTime(calendar, local);
                x = new Time(local.getTime().getTime());
            }
            this.mPrep.setTime(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar calendar) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + Trace.quoteObject(x) + "," + Trace.quoteObject(calendar));
            }
            this.checkClosed();
            if (x != null) {
                calendar = (Calendar)calendar.clone();
                calendar.setTime(x);
                Calendar local = Calendar.getInstance();
                jdbcPreparedStatement.convertTime(calendar, local);
                x = new Timestamp(local.getTime().getTime());
            }
            this.mPrep.setTimestamp(this.translateParameterIndex(parameterIndex), x);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void clearBatch() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public int[] executeBatch() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public void addBatch() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public void setBlob(int i, Blob x) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public void setClob(int i, Clob x) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public void setArray(int i, Array x) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + Trace.quoteObject(x));
            }
            this.checkClosed();
            if (x == null) {
                this.setNull(parameterIndex, -2);
            } else {
                this.mAdapter.setBytes(this, parameterIndex, x);
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + Trace.quoteObject(x) + "," + length);
            }
            this.checkClosed();
            if (x == null) {
                this.setNull(parameterIndex, -2);
            } else {
                this.mAdapter.setBinaryStream(this, parameterIndex, x, length);
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + Trace.quoteObject(x) + "," + length);
            }
            this.checkClosed();
            if (x == null) {
                this.setNull(parameterIndex, 2005);
            } else {
                this.mAdapter.setAsciiStream(this, parameterIndex, x, length);
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), parameterIndex + "," + Trace.quoteObject(x) + "," + length);
            }
            this.checkClosed();
            if (x == null) {
                this.setNull(parameterIndex, 2005);
            } else {
                this.mAdapter.setCharacterStream(this, parameterIndex, x, length);
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getResultSetHoldability() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public PreparedStatement getVendorObject() {
        return this.mPrep;
    }

    public int translateParameterIndex(int parameterIndex) {
        return this.mCommand.translateParameterIndex(parameterIndex);
    }

    public Vector getOpenResultSets() {
        return this.mOpenResultSets;
    }

    jdbcPreparedStatement(Adapter adapter, jdbcConnection conn, String sql) throws SQLException {
        this.mAdapter = adapter;
        this.mConn = conn;
        this.mCommand = conn.translate(sql);
        this.mPrep = conn.mConn.prepareStatement(this.mCommand.getVendorSQL());
    }

    void checkClosed() throws SQLException {
        if (this.mClosed) {
            throw Factory.getClosedException();
        }
        if (this.mConn.mClosed) {
            throw Factory.getClosedException();
        }
    }

    String getId() {
        return "prep" + this.mId;
    }

    Object convertObject(Object x, int targetSqlType) {
        int originalSqlType;
        if (x == null) {
            return null;
        }
        if (x instanceof String) {
            originalSqlType = 12;
        } else if (x instanceof BigDecimal) {
            originalSqlType = 3;
        } else if (x instanceof Boolean) {
            originalSqlType = -7;
        } else if (x instanceof Integer) {
            originalSqlType = 4;
        } else if (x instanceof Long) {
            originalSqlType = -5;
        } else if (x instanceof Float) {
            originalSqlType = 7;
        } else if (x instanceof Double) {
            originalSqlType = 8;
        } else if (x instanceof byte[]) {
            originalSqlType = -2;
        } else if (x instanceof Date) {
            originalSqlType = 91;
        } else if (x instanceof Time) {
            originalSqlType = 92;
        } else if (x instanceof Timestamp) {
            originalSqlType = 93;
        } else {
            return x;
        }
        if (originalSqlType == targetSqlType) {
            return x;
        }
        switch (targetSqlType) {
            case 12: {
                return x.toString();
            }
            case 3: {
                return new BigDecimal(x.toString());
            }
            case -7: {
                return Boolean.valueOf(x.toString());
            }
            case 4: {
                return Integer.valueOf(x.toString());
            }
            case -5: {
                return Long.valueOf(x.toString());
            }
            case 7: {
                return Float.valueOf(x.toString());
            }
            case 8: {
                return Double.valueOf(x.toString());
            }
            case -2: {
                return x;
            }
            case 91: {
                return x;
            }
            case 92: {
                return x;
            }
            case 93: {
                return x;
            }
        }
        return x;
    }

    SQLException convertThrowable(Throwable e) {
        SQLException x = this.mAdapter.convertThrowable(e);
        if (Trace.isEnabled()) {
            Trace.traceException(x);
        }
        return x;
    }

    static void convertTime(Calendar from, Calendar to) {
        to.set(1, from.get(1));
        to.set(2, from.get(2));
        to.set(5, from.get(5));
        to.set(11, from.get(11));
        to.set(12, from.get(12));
        to.set(13, from.get(13));
        to.set(14, from.get(14));
    }

    void closeOld() {
        if (this.mLastResultSet != null) {
            try {
                this.mLastResultSet.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.mLastResultSet = null;
        }
    }
}

