/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;
import org.ldbc.core.Factory;
import org.ldbc.core.MemoryResultSet;
import org.ldbc.core.Trace;
import org.ldbc.jdbc.jdbcConnection;
import org.ldbc.jdbc.jdbcPreparedStatement;
import org.ldbc.jdbc.jdbcResultSetMetaData;
import org.ldbc.jdbc.jdbcStatement;

public class jdbcResultSet
implements ResultSet {
    static int mCounter;
    int mId = mCounter++;
    jdbcConnection mConn;
    jdbcStatement mStat;
    jdbcPreparedStatement mPrep;
    int mColumnCount;
    Adapter mAdapter;
    DataType[] mDataTypes;
    ResultSet mRs;
    ResultSetMetaData mMeta;
    boolean mClosed;
    boolean mBeforeFirst = true;
    boolean mAfterLast = false;
    int mRow;

    public boolean next() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            this.mBeforeFirst = false;
            boolean result = this.mRs.next();
            ++this.mRow;
            if (!result) {
                this.mAfterLast = true;
                this.mRow = 0;
            }
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            jdbcResultSetMetaData meta = new jdbcResultSetMetaData(this, this.mMeta);
            if (Trace.isEnabled()) {
                Trace.traceResult(meta.getId());
            }
            return meta;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean wasNull() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            boolean result = this.mRs.wasNull();
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int findColumn(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            this.checkClosed();
            int result = this.getColumnIndex(columnName);
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getString(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            int datatype = this.mDataTypes[columnIndex - 1].getDataType();
            String result = datatype == 2005 ? this.mAdapter.getClobString(this.mRs, columnIndex) : this.mRs.getString(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResultQuote(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getString(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            String result = this.getString(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResultQuote(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getInt(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            int datatype = this.mDataTypes[columnIndex - 1].getDataType();
            int result = 0;
            switch (datatype) {
                case 4: 
                case 5: 
                case 12: {
                    result = this.mRs.getInt(columnIndex);
                    break;
                }
                case 3: {
                    BigDecimal bd = this.mRs.getBigDecimal(columnIndex);
                    if (bd == null) {
                        result = 0;
                        break;
                    }
                    result = bd.intValue();
                    break;
                }
                default: {
                    throw Factory.getGeneralException("datatype:" + datatype);
                }
            }
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getInt(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            int result = this.getInt(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            BigDecimal result = this.mRs.getBigDecimal(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Date getDate(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            Date result = this.mRs.getDate(columnIndex);
            if (result != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(result);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                result = new Date(cal.getTime().getTime());
            }
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Time getTime(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            Time result = this.mRs.getTime(columnIndex);
            if (result != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(result);
                cal.set(1, 1970);
                cal.set(2, 0);
                cal.set(5, 1);
                result = new Time(cal.getTime().getTime());
            }
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            Timestamp result = this.mRs.getTimestamp(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            BigDecimal result = this.getBigDecimal(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Date getDate(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            Date result = this.getDate(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Time getTime(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            Time result = this.getTime(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            Timestamp result = this.getTimestamp(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void close() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            if (!this.mClosed) {
                this.mClosed = true;
                this.mRs.close();
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Statement getStatement() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            if (this.mStat == null) {
                if (this.mPrep == null && Trace.isDetailed()) {
                    Trace.traceResult(null);
                }
                if (Trace.isDetailed()) {
                    Trace.traceResult(this.mPrep.getId());
                }
                return this.mPrep;
            }
            if (Trace.isDetailed()) {
                Trace.traceResult(this.mStat.getId());
            }
            return this.mStat;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
    }

    public Object getObject(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            int datatype = this.mDataTypes[columnIndex - 1].getDataType();
            Object result = null;
            switch (datatype) {
                case 12: 
                case 2005: {
                    result = this.getString(columnIndex);
                    break;
                }
                case 4: {
                    int i = this.mRs.getInt(columnIndex);
                    if (this.mRs.wasNull()) break;
                    result = new Integer(i);
                    break;
                }
                case 3: {
                    result = this.mRs.getBigDecimal(columnIndex);
                    break;
                }
                case 93: {
                    result = this.mRs.getTimestamp(columnIndex);
                    break;
                }
                case 5: {
                    int i = this.mRs.getInt(columnIndex);
                    if (this.mRs.wasNull()) break;
                    result = new Short((short)i);
                    break;
                }
                case -7: {
                    boolean b;
                    boolean bl = b = this.mRs.getInt(columnIndex) != 0;
                    if (this.mRs.wasNull()) break;
                    result = new Boolean(b);
                    break;
                }
                case 2004: {
                    result = this.getBytes(columnIndex);
                    break;
                }
                default: {
                    throw Factory.getGeneralException("datatype:" + datatype);
                }
            }
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Object getObject(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            Object result = this.getObject(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            boolean result;
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            boolean bl = result = this.mRs.getInt(columnIndex) != 0;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean getBoolean(String columnName) throws SQLException {
        try {
            int columnIndex;
            boolean result;
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            boolean bl = result = this.mRs.getInt(columnIndex = this.getColumnIndex(columnName)) != 0;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public byte getByte(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            byte result = this.mRs.getByte(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public byte getByte(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            byte result = this.mRs.getByte(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public short getShort(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            short result = this.mRs.getShort(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public short getShort(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            short result = this.mRs.getShort(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public long getLong(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            long result = this.mRs.getLong(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult("" + result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public long getLong(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            long result = this.mRs.getLong(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult("" + result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public float getFloat(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            float result = this.mRs.getFloat(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult("" + result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public float getFloat(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            float result = this.mRs.getFloat(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult("" + result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public double getDouble(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            double result = this.mRs.getDouble(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult("" + result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public double getDouble(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            double result = this.mRs.getDouble(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult("" + result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), Trace.quote(columnName) + "," + scale);
        }
        throw Factory.getUnsupportedException();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), columnIndex + "," + scale);
        }
        throw Factory.getUnsupportedException();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), columnIndex);
        }
        throw Factory.getUnsupportedException();
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.traceQuote(this.getId(), columnName);
        }
        throw Factory.getUnsupportedException();
    }

    public String getCursorName() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public int getRow() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = this.mRow;
            if (Trace.isDetailed()) {
                Trace.traceResult("" + result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 1007;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 1000;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            int result;
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            try {
                result = this.mRs.getFetchSize();
            }
            catch (AbstractMethodError e) {
                result = 0;
            }
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), rows);
            }
            this.checkClosed();
            if (rows < 0) {
                throw Factory.getInvalidValueException("rows:" + rows + " min:0");
            }
            if (rows > 0) {
                if (this.mStat != null && this.mStat.mMaxRows > 0 && rows > this.mStat.mMaxRows) {
                    throw Factory.getInvalidValueException("rows:" + rows + " maxrows:" + this.mStat.mMaxRows);
                }
                if (this.mPrep != null && this.mPrep.mMaxRows > 0 && rows > this.mPrep.mMaxRows) {
                    throw Factory.getInvalidValueException("rows:" + rows + " maxrows:" + this.mPrep.mMaxRows);
                }
            }
            try {
                this.mRs.setFetchSize(rows);
            }
            catch (AbstractMethodError e) {
            }
            catch (SQLException e) {}
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), direction);
        }
        throw Factory.getUnsupportedException();
    }

    public int getType() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 1003;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean isAfterLast() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean isFirst() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean isLast() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public void beforeFirst() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public void afterLast() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean first() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean last() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean absolute(int row) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), row);
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean relative(int rows) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), rows);
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean previous() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public void moveToInsertRow() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public void moveToCurrentRow() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean rowUpdated() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean rowInserted() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public boolean rowDeleted() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public void insertRow() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public void updateRow() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public void deleteRow() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public void refreshRow() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public void cancelRowUpdates() throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId());
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), columnIndex + "," + Trace.quoteObject(map));
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), Trace.quote(columnName) + "," + Trace.quoteObject(map));
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public Ref getRef(int columnIndex) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), columnIndex);
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public Ref getRef(String columnName) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.traceQuote(this.getId(), columnName);
        }
        this.checkClosed();
        throw Factory.getUnsupportedException();
    }

    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex + "," + Trace.quoteObject(calendar));
            }
            this.checkColumnIndex(columnIndex);
            Date result = this.mRs.getDate(columnIndex);
            if (result != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(result);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                result = new Date(cal.getTime().getTime());
                calendar = (Calendar)calendar.clone();
                Calendar local = Calendar.getInstance();
                local.setTime(result);
                jdbcPreparedStatement.convertTime(local, calendar);
                result = new Date(calendar.getTime().getTime());
            }
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Date getDate(String columnName, Calendar calendar) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), Trace.quote(columnName) + "," + Trace.quoteObject(calendar));
            }
            int columnIndex = this.getColumnIndex(columnName);
            Date result = this.getDate(columnIndex, calendar);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex + "," + Trace.quoteObject(calendar));
            }
            this.checkColumnIndex(columnIndex);
            Time result = this.mRs.getTime(columnIndex);
            if (result != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(result);
                cal.set(1, 1970);
                cal.set(2, 0);
                cal.set(5, 1);
                result = new Time(cal.getTime().getTime());
                calendar = (Calendar)calendar.clone();
                Calendar local = Calendar.getInstance();
                local.setTime(result);
                jdbcPreparedStatement.convertTime(local, calendar);
                result = new Time(calendar.getTime().getTime());
            }
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), Trace.quote(columnName) + "," + Trace.quoteObject(calendar));
            }
            int columnIndex = this.getColumnIndex(columnName);
            Time result = this.getTime(columnIndex, calendar);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex + "," + Trace.quoteObject(calendar));
            }
            this.checkColumnIndex(columnIndex);
            Timestamp result = this.mRs.getTimestamp(columnIndex);
            if (result != null) {
                calendar = (Calendar)calendar.clone();
                Calendar local = Calendar.getInstance();
                local.setTime(result);
                jdbcPreparedStatement.convertTime(local, calendar);
                result = new Timestamp(calendar.getTime().getTime());
            }
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), Trace.quote(columnName) + "," + Trace.quoteObject(calendar));
            }
            int columnIndex = this.getColumnIndex(columnName);
            Timestamp result = this.getTimestamp(columnIndex, calendar);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), columnIndex);
        }
        throw Factory.getUnsupportedException();
    }

    public Blob getBlob(String columnName) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.traceQuote(this.getId(), columnName);
        }
        throw Factory.getUnsupportedException();
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            byte[] result = this.mAdapter.getBytes(this.mRs, columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public byte[] getBytes(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            byte[] result = this.mAdapter.getBytes(this.mRs, columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            InputStream result = this.mRs.getBinaryStream(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            InputStream result = this.mRs.getBinaryStream(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Clob getClob(int columnIndex) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), columnIndex);
        }
        throw Factory.getUnsupportedException();
    }

    public Clob getClob(String columnName) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.traceQuote(this.getId(), columnName);
        }
        throw Factory.getUnsupportedException();
    }

    public Array getArray(int columnIndex) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.trace(this.getId(), columnIndex);
        }
        throw Factory.getUnsupportedException();
    }

    public Array getArray(String columnName) throws SQLException {
        if (Trace.isDetailed()) {
            Trace.traceQuote(this.getId(), columnName);
        }
        throw Factory.getUnsupportedException();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            InputStream result = this.mRs.getAsciiStream(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            InputStream result = this.mRs.getAsciiStream(columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), columnIndex);
            }
            this.checkColumnIndex(columnIndex);
            Reader result = this.mAdapter.getCharacterStream(this.mRs, columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.traceQuote(this.getId(), columnName);
            }
            int columnIndex = this.getColumnIndex(columnName);
            Reader result = this.mAdapter.getCharacterStream(this.mRs, columnIndex);
            if (Trace.isDetailed()) {
                Trace.traceResult(Trace.quoteObject(result));
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateNull(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public URL getURL(String columnName) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public ResultSet getVendorObject() {
        return this.mRs;
    }

    int getColumnIndex(String columnName) throws SQLException {
        this.checkClosed();
        return this.mRs.findColumn(columnName);
    }

    void checkColumnIndex(int columnIndex) throws SQLException {
        this.checkClosed();
        if (columnIndex < 1 || columnIndex > this.mColumnCount) {
            throw Factory.getInvalidValueException("columnIndex:" + columnIndex + " min:1 max:" + this.mColumnCount);
        }
    }

    jdbcResultSet(jdbcConnection conn, MemoryResultSet rs) throws SQLException {
        this.mConn = conn;
        this.mAdapter = this.mConn.mAdapter;
        this.mRs = rs;
        this.mMeta = rs.getMetaData();
        this.mColumnCount = this.mMeta.getColumnCount();
        this.mDataTypes = new DataType[this.mColumnCount];
        int i = 0;
        while (i < this.mColumnCount) {
            DataType type;
            int datatype = this.mMeta.getColumnType(i + 1);
            String typename = this.mMeta.getColumnTypeName(i + 1);
            int precision = this.mMeta.getPrecision(i + 1);
            int scale = this.mMeta.getScale(i + 1);
            this.mDataTypes[i] = type = new DataType(typename, datatype, precision, scale);
            ++i;
        }
    }

    jdbcResultSet(jdbcConnection conn, jdbcStatement stat, jdbcPreparedStatement prep, ResultSet rs) throws SQLException {
        this.mConn = conn;
        this.mStat = stat;
        this.mPrep = prep;
        this.mAdapter = this.mConn.mAdapter;
        this.mRs = rs;
        this.mMeta = rs.getMetaData();
        this.mColumnCount = this.mMeta.getColumnCount();
        this.mDataTypes = new DataType[this.mColumnCount];
        int i = 0;
        while (i < this.mColumnCount) {
            int precision;
            int datatype = this.mMeta.getColumnType(i + 1);
            String typename = this.mMeta.getColumnTypeName(i + 1);
            try {
                precision = this.mMeta.getPrecision(i + 1);
            }
            catch (NumberFormatException e) {
                precision = Integer.MAX_VALUE;
            }
            int scale = this.mMeta.getScale(i + 1);
            DataType type = new DataType(typename, datatype, precision, scale);
            this.mAdapter.convertDataType(type);
            this.mDataTypes[i] = type;
            ++i;
        }
    }

    void checkClosed() throws SQLException {
        if (this.mClosed) {
            throw Factory.getClosedException();
        }
        if (this.mStat != null && this.mStat.mClosed) {
            throw Factory.getClosedException();
        }
        if (this.mPrep != null && this.mPrep.mClosed) {
            throw Factory.getClosedException();
        }
        if (this.mConn.mClosed) {
            throw Factory.getClosedException();
        }
    }

    String getId() {
        return "rs" + this.mId;
    }

    SQLException convertThrowable(Throwable e) {
        SQLException x = this.mAdapter.convertThrowable(e);
        if (Trace.isEnabled()) {
            Trace.traceException(x);
        }
        return x;
    }
}

