/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.ldbc.core.Adapter;
import org.ldbc.core.DataType;
import org.ldbc.core.Trace;
import org.ldbc.jdbc.jdbcResultSet;

public class jdbcResultSetMetaData
implements ResultSetMetaData {
    static int mCounter;
    int mId = mCounter++;
    jdbcResultSet mRs;
    Adapter mAdapter;
    ResultSetMetaData mMeta;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Boolean;

    public int getColumnCount() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.mRs.checkClosed();
            int count = this.mRs.mColumnCount;
            if (Trace.isEnabled()) {
                Trace.traceResult(count);
            }
            return count;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getColumnLabel(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            String result = this.mMeta.getColumnLabel(column);
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getColumnName(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            String result = this.mMeta.getColumnName(column);
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getColumnType(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            int result = this.mRs.mDataTypes[column - 1].getDataType();
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getColumnTypeName(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            int type = this.getColumnType(column);
            String result = DataType.getDataTypeString(type);
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getSchemaName(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return "";
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getTableName(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return "";
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getCatalogName(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return "";
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return false;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return true;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isSearchable(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return true;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isCurrency(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return false;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int isNullable(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return 2;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isSigned(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return true;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isReadOnly(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return false;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isWritable(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return true;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return false;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public String getColumnClassName(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            int type = this.getColumnType(column);
            String result = "";
            switch (type) {
                case 4: {
                    result = (class$java$lang$Integer == null ? (class$java$lang$Integer = jdbcResultSetMetaData.class$("java.lang.Integer")) : class$java$lang$Integer).getClass().getName();
                }
                case 12: {
                    result = (class$java$lang$String == null ? (class$java$lang$String = jdbcResultSetMetaData.class$("java.lang.String")) : class$java$lang$String).getClass().getName();
                }
                case 3: {
                    result = (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = jdbcResultSetMetaData.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getClass().getName();
                }
                case 93: {
                    result = (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = jdbcResultSetMetaData.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getClass().getName();
                }
                case 5: {
                    result = (class$java$lang$Short == null ? (class$java$lang$Short = jdbcResultSetMetaData.class$("java.lang.Short")) : class$java$lang$Short).getClass().getName();
                }
                case -7: {
                    result = (class$java$lang$Boolean == null ? (class$java$lang$Boolean = jdbcResultSetMetaData.class$("java.lang.Boolean")) : class$java$lang$Boolean).getClass().getName();
                }
            }
            if (Trace.isEnabled()) {
                Trace.traceResultQuote(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getPrecision(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return 0;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getScale(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), column);
            }
            this.mRs.checkColumnIndex(column);
            return 0;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            int type = this.getColumnType(column);
            int result = 10;
            switch (type) {
                case 12: {
                    result = 255;
                }
                case 3: {
                    result = 40;
                }
            }
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSetMetaData getVendorObject() {
        return this.mMeta;
    }

    jdbcResultSetMetaData(jdbcResultSet rs, ResultSetMetaData meta) {
        this.mMeta = meta;
        this.mRs = rs;
        this.mAdapter = rs.mAdapter;
    }

    String getId() {
        return "meta" + this.mId;
    }

    SQLException convertThrowable(Throwable e) {
        SQLException x = this.mAdapter.convertThrowable(e);
        if (Trace.isEnabled()) {
            Trace.traceException(x);
        }
        return x;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

