/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.ldbc.core.Adapter;
import org.ldbc.core.Command;
import org.ldbc.core.Factory;
import org.ldbc.core.Trace;
import org.ldbc.jdbc.jdbcConnection;
import org.ldbc.jdbc.jdbcResultSet;

public class jdbcStatement
implements Statement {
    static int mCounter;
    int mId = mCounter++;
    boolean mClosed;
    Adapter mAdapter;
    jdbcConnection mConn;
    Statement mStat;
    PreparedStatement mPrep;
    jdbcResultSet mLastResultSet;
    boolean mNoResult;
    int mMaxRows;
    boolean mMaxRowsSet;
    boolean mEscapeProcessing = true;
    int mQueryTimeout;
    boolean mQueryTimeoutSet;
    int mFetchSize;
    boolean mFetchSizeSet;
    int mUpdateCount;

    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.traceQuote(this.getId(), sql);
            }
            this.closeOld();
            this.checkClosed();
            if (this.mEscapeProcessing) {
                sql = this.mConn.translateSQL(sql);
            }
            Command command = this.mConn.translate(sql);
            command.checkQuery();
            sql = command.getVendorSQL();
            jdbcResultSet rs = new jdbcResultSet(this.mConn, this, null, this.mStat.executeQuery(sql));
            if (Trace.isEnabled()) {
                Trace.traceResult(rs.getId());
            }
            this.mLastResultSet = rs;
            return rs;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            int count;
            if (Trace.isEnabled()) {
                Trace.traceQuote(this.getId(), sql);
            }
            this.closeOld();
            this.checkClosed();
            if (this.mEscapeProcessing) {
                sql = this.mConn.translateSQL(sql);
            }
            Command command = this.mConn.translate(sql);
            sql = command.getVendorSQL();
            if (command.isPseudo()) {
                this.mConn.executePseudo(command.getPseudoCommand());
                count = 0;
            } else {
                command.checkUpdate();
                if (command.isAutoIncrement()) {
                    this.prepare(command);
                    count = this.mPrep.executeUpdate();
                } else {
                    count = this.mStat.executeUpdate(sql);
                }
                if (command.isCreateOrDrop()) {
                    count = 0;
                }
                if (command.isCreateOrDrop() || this.mConn.mAutoCommit) {
                    this.mConn.commitInternal();
                }
            }
            this.mUpdateCount = count;
            if (Trace.isEnabled()) {
                Trace.traceResult(count);
            }
            return count;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public boolean execute(String sql) throws SQLException {
        try {
            boolean result;
            if (Trace.isEnabled()) {
                Trace.traceQuote(this.getId(), sql);
            }
            this.closeOld();
            this.checkClosed();
            if (this.mEscapeProcessing) {
                sql = this.mConn.translateSQL(sql);
            }
            Command command = this.mConn.translate(sql);
            sql = command.getVendorSQL();
            if (command.isPseudo()) {
                this.mConn.executePseudo(command.getPseudoCommand());
                this.mUpdateCount = 0;
                result = false;
            } else if (command.isUpdate()) {
                if (command.isAutoIncrement()) {
                    this.prepare(command);
                    result = this.mPrep.execute();
                    if (!result) {
                        this.mUpdateCount = this.mPrep.getUpdateCount();
                    }
                } else {
                    result = this.mStat.execute(sql);
                    if (!result) {
                        this.mUpdateCount = this.mStat.getUpdateCount();
                    }
                    if (command.isCreateOrDrop()) {
                        this.mUpdateCount = 0;
                    }
                }
            } else {
                result = true;
                this.mLastResultSet = new jdbcResultSet(this.mConn, this, null, this.mStat.executeQuery(sql));
            }
            if (command.isCreateOrDrop() || this.mConn.mAutoCommit && command.isUpdate()) {
                this.mConn.commitInternal();
            }
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        try {
            jdbcResultSet rs;
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            if (this.mNoResult) {
                rs = null;
            } else {
                ResultSet r = this.mPrep != null ? this.mPrep.getResultSet() : this.mStat.getResultSet();
                rs = new jdbcResultSet(this.mConn, this, null, r);
            }
            this.mLastResultSet = rs;
            if (Trace.isEnabled()) {
                Trace.traceResult(rs.getId());
            }
            return rs;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getUpdateCount() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = this.mNoResult ? -1 : this.mUpdateCount;
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void close() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.closeOld();
            if (!this.mClosed) {
                this.mClosed = true;
                this.mStat.close();
                if (this.mPrep != null) {
                    this.mPrep.close();
                }
            }
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            if (Trace.isEnabled()) {
                Trace.traceResult(this.mConn.getId());
            }
            return this.mConn;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
    }

    public boolean getMoreResults() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.closeOld();
            if (this.mPrep != null) {
                this.mPrep.getMoreResults();
            } else {
                this.mStat.getMoreResults();
            }
            this.mNoResult = true;
            return false;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setCursorName(String name) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.traceQuote(this.getId(), name);
        }
        this.checkClosed();
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId(), direction);
        }
        this.checkClosed();
    }

    public int getFetchDirection() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 1000;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            int result = this.mMaxRows;
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setMaxRows(int max) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), max);
            }
            this.mStat.setMaxRows(max);
            this.mMaxRows = max;
            this.mMaxRowsSet = true;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId(), rows);
            }
            this.checkClosed();
            if (rows < 0) {
                throw Factory.getInvalidValueException("rows:" + rows);
            }
            if (rows > 0 && this.mMaxRows > 0 && rows > this.mMaxRows) {
                throw Factory.getInvalidValueException("rows:" + rows + " max:" + this.mMaxRows);
            }
            this.mFetchSize = rows;
            this.mFetchSizeSet = true;
            this.mStat.setFetchSize(rows);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = this.mFetchSize;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 1007;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 1004;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            if (Trace.isDetailed()) {
                Trace.trace(this.getId());
            }
            this.checkClosed();
            int result = 0;
            if (Trace.isDetailed()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), max);
            }
            this.checkClosed();
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), "" + enable);
            }
            this.checkClosed();
            this.mEscapeProcessing = enable;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void cancel() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            this.mAdapter.cancel(this.mStat);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId());
            }
            int result = this.mQueryTimeout;
            if (Trace.isEnabled()) {
                Trace.traceResult(result);
            }
            return result;
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            if (Trace.isEnabled()) {
                Trace.trace(this.getId(), seconds);
            }
            if (seconds < 0) {
                throw Factory.getInvalidValueException("seconds:" + seconds);
            }
            this.mQueryTimeout = seconds;
            this.mQueryTimeoutSet = true;
            this.mStat.setQueryTimeout(seconds);
        }
        catch (Throwable e) {
            throw this.convertThrowable(e);
        }
    }

    public void addBatch(String sql) throws SQLException {
        if (Trace.isEnabled()) {
            Trace.traceQuote(this.getId(), sql);
        }
        throw Factory.getUnsupportedException();
    }

    public void clearBatch() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public int[] executeBatch() throws SQLException {
        if (Trace.isEnabled()) {
            Trace.trace(this.getId());
        }
        throw Factory.getUnsupportedException();
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public int getResultSetHoldability() throws SQLException {
        throw Factory.getUnsupportedException();
    }

    public Statement getVendorObject() {
        return this.mStat;
    }

    jdbcStatement(Adapter adapter, jdbcConnection conn) throws SQLException {
        this.mAdapter = adapter;
        this.mConn = conn;
        this.mStat = conn.mConn.createStatement();
    }

    void checkClosed() throws SQLException {
        if (this.mClosed) {
            throw Factory.getClosedException();
        }
        if (this.mConn.mClosed) {
            throw Factory.getClosedException();
        }
    }

    String getId() {
        return "stat" + this.mId;
    }

    SQLException convertThrowable(Throwable e) {
        SQLException x = this.mAdapter.convertThrowable(e);
        if (Trace.isEnabled()) {
            Trace.traceException(x);
        }
        return x;
    }

    void closeOld() {
        if (this.mLastResultSet != null) {
            try {
                this.mLastResultSet.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            this.mLastResultSet = null;
        }
    }

    void prepare(Command command) throws SQLException {
        String sql = command.getVendorSQL();
        PreparedStatement prep = this.mConn.getVendorObject().prepareStatement(sql);
        if (this.mQueryTimeoutSet) {
            prep.setQueryTimeout(this.mQueryTimeout);
        }
        if (this.mFetchSizeSet) {
            prep.setFetchSize(this.mFetchSize);
        }
        if (this.mMaxRowsSet) {
            prep.setMaxRows(this.mMaxRows);
        }
        this.mAdapter.prepareExecute(prep, command);
        this.mPrep = prep;
    }
}

