/*
 * Decompiled with CFR 0.152.
 */
package org.ldbc.parser;

import java.io.StringReader;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import org.ldbc.adapter.Base;
import org.ldbc.antlr.DumpASTVisitor;
import org.ldbc.antlr.collections.AST;
import org.ldbc.core.Adapter;
import org.ldbc.core.Column;
import org.ldbc.core.Command;
import org.ldbc.core.DataType;
import org.ldbc.core.Factory;
import org.ldbc.core.Trace;
import org.ldbc.parser.SQLLexer;
import org.ldbc.parser.SQLParser;

public class Translator {
    Adapter mAdapter;
    static String KEYWORDS = "ABS,ADD,ALL,ALTER,AND,AS,ASC,AVG,BEFORE,BETWEEN,BIGINT,BINARY,BIT,BLOB,BOOLEAN,BOTH,BY,CACHED,CASCADE,CASE,CAST,CHAR,CHARACTER,CHARACTER_LENGTH,CHAR_LENGTH,CLOB,COLUMN,COMMIT,CONCAT,CONSTRAINT,COUNT,CREATE,CROSS,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,DATABASE,DATE,DATETIME,DEC,DECIMAL,DEFAULT,DELETE,DESC,DISTINCT,DOUBLE,DROP,EXISTS,EXTRACT,FALSE,FLOAT,FOR,FOREIGN,FROM,GRANT,GROUP,HAVING,IF,IMAGE,IN,INDEX,INFILE,INNER,INSERT,INT,INTEGER,INTO,IS,JOIN,KEY,KILL,LEADING,LEFT,LENGTH,LIKE,LIMIT,LINENO,LOAD,LOB,LOCAL,LOCATE,LOCK,LONG,LONGVARBINARY,LONGVARCHAR,LOWER,MATCH,MAX,MEDIUMINT,MIN,MOD,NATURAL,NOT,NULL,NUMERIC,OBJECT,OCTET_LENGTH,ON,OPTION,OR,ORDER,OTHER,OUTER,OUTFILE,POSITION,PRECISION,PRIMARY,PRIVILEGES,PROCEDURE,READ,REAL,REFERENCES,RENAME,REPLACE,RESTRICT,RETURNS,REVOKE,RIGHT,ROLLBACK,SAVEPOINT,SELECT,SESSION_USER,SET,SMALLINT,SQRT,SUBSTRING,SUM,SYSDATE,TABLE,TEMP,TEXT,TIME,TIMESTAMP,TINYINT,TO,TRAILING,TRIGGER,TRIM,TRUE,UNION,UNIQUE,UNSIGNED,UPDATE,UPPER,USER,USING,VALUES,VARBINARY,VARCHAR,VARCHAR_IGNORECASE,WHEN,WHERE,WITH,WRITE,ZEROFILL";

    public static String getKeywords() {
        return KEYWORDS;
    }

    public static void checkValid(String sql) throws SQLException {
        Translator trans = new Translator(new Base());
        trans.translate(sql);
    }

    public Translator(Adapter adapter) {
        this.mAdapter = adapter;
    }

    public Command translate(String sql) throws SQLException {
        Command command = new Command(this.mAdapter);
        command.setOriginalSQL(sql);
        try {
            StringReader in = new StringReader(sql);
            SQLLexer lexer = new SQLLexer(in);
            SQLParser parser = new SQLParser(lexer);
            parser.statement();
            if (Trace.isDetailed()) {
                DumpASTVisitor visitor2 = new DumpASTVisitor();
                visitor2.visit(parser.getAST());
            }
            this.parseCommand(command, parser.getAST());
            if (Trace.isEnabled()) {
                Trace.println("\t" + command.getVendorSQL());
            }
            return command;
        }
        catch (Throwable e) {
            throw Factory.getSQLException("37000", sql + " " + e.toString(), e);
        }
    }

    void parseCommand(Command command, AST node) throws SQLException {
        switch (node.getType()) {
            case 5: {
                command.setCreateOrDrop();
                this.parseCreateTable(command, node);
                break;
            }
            case 14: {
                command.setCreateOrDrop();
                this.parseDropTable(command, node);
                break;
            }
            case 13: {
                command.setCreateOrDrop();
                this.parseCreateIndex(command, node);
                break;
            }
            case 15: {
                command.setCreateOrDrop();
                this.parseDropIndex(command, node);
                break;
            }
            case 6: {
                this.parseUpdate(command, node);
                break;
            }
            case 7: {
                this.parseInsert(command, node);
                break;
            }
            case 8: {
                command.setSelect();
                this.parseSelect(command, node);
                break;
            }
            case 10: {
                this.parseDelete(command, node);
                break;
            }
            case 50: {
                command.setPseudoCommand(2);
                break;
            }
            case 51: {
                command.setPseudoCommand(3);
                break;
            }
            case 41: {
                command.setPseudoCommand(0);
                break;
            }
            case 42: {
                command.setPseudoCommand(1);
                break;
            }
            default: {
                throw Factory.getSQLException("37000", "?");
            }
        }
    }

    void parseDelete(Command command, AST parent) throws SQLException {
        int type;
        AST child = parent.getFirstChild();
        String tableName = this.identifier(child.getText());
        child = child.getNextSibling();
        String sql = "DELETE FROM " + this.quote(tableName);
        if (child != null && (type = child.getType()) == 18) {
            sql = sql + " WHERE " + this.getCondition(child);
        }
        command.setVendorSQL(sql);
    }

    String getCondition(AST parent) throws SQLException {
        AST child = parent.getFirstChild();
        return this.getExpression(child);
    }

    String getTableWithAlias(AST parent) throws SQLException {
        AST table = parent.getFirstChild();
        String tables = this.quote(this.identifier(table.getText()));
        if ((table = table.getNextSibling()) != null) {
            tables = tables + " " + this.quote(this.identifier(table.getText()));
        }
        return tables;
    }

    void parseSelect(Command command, AST parent) throws SQLException {
        String condition;
        AST child = parent.getFirstChild();
        String sql = "";
        boolean distinct = false;
        if (child.getType() == 131) {
            distinct = true;
            child = child.getNextSibling();
        }
        if (child.getType() == 72) {
            sql = sql + "* ";
            child = child.getNextSibling();
        } else if (child.getType() == 20) {
            while (child.getType() == 20) {
                AST exp = child.getFirstChild();
                if (exp.getType() == 145) {
                    String s = (exp = exp.getNextSibling()).getText();
                    if (!s.equals("*")) {
                        s = this.quote(this.identifier(s));
                    }
                    sql = sql + "COUNT(" + s + ")";
                } else if (exp.getType() == 17) {
                    sql = sql + this.getExpression(exp);
                }
                exp = exp.getNextSibling();
                if (exp != null) {
                    sql = sql + " AS " + this.quote(this.identifier(exp.getText()));
                }
                sql = sql + ",";
                child = child.getNextSibling();
            }
            sql = sql.substring(0, sql.length() - 1);
        }
        String joinConditions = "";
        String tables = this.getTableWithAlias(child);
        child = child.getNextSibling();
        while (child != null) {
            if (child.getType() == 67) {
                child = child.getNextSibling();
                tables = tables + ",";
                tables = tables + this.getTableWithAlias(child);
                child = child.getNextSibling();
                continue;
            }
            if (child.getType() == 139) {
                child = child.getNextSibling();
                if (this.mAdapter.supportsAnsiJoinSyntax()) {
                    tables = tables + " INNER JOIN ";
                    tables = tables + this.getTableWithAlias(child);
                    child = child.getNextSibling();
                    condition = this.getCondition(child);
                    child = child.getNextSibling();
                    tables = tables + " ON " + condition;
                    continue;
                }
                tables = tables + ",";
                tables = tables + this.getTableWithAlias(child);
                child = child.getNextSibling();
                String cond = this.getCondition(child);
                child = child.getNextSibling();
                if (joinConditions.length() > 0) {
                    joinConditions = joinConditions + " AND ";
                }
                joinConditions = joinConditions + "(" + cond + ")";
                continue;
            }
            if (child.getType() == 140) {
                if (!this.mAdapter.supportsAnsiJoinSyntax()) {
                    throw Factory.getSQLException("37000", "The ANSI SQL-92 outer join syntax is not support by this database");
                }
                child = child.getNextSibling();
                tables = tables + " LEFT OUTER JOIN ";
                tables = tables + this.getTableWithAlias(child);
                child = child.getNextSibling();
                condition = this.getCondition(child);
                child = child.getNextSibling();
                tables = tables + " ON " + condition;
                continue;
            }
            if (child.getType() != 142) break;
            if (!this.mAdapter.supportsAnsiJoinSyntax()) {
                throw Factory.getSQLException("37000", "The ANSI SQL-92 outer join syntax is not support by this database");
            }
            child = child.getNextSibling();
            tables = tables + " RIGHT OUTER JOIN ";
            tables = tables + this.getTableWithAlias(child);
            child = child.getNextSibling();
            condition = this.getCondition(child);
            child = child.getNextSibling();
            tables = tables + " ON " + condition;
        }
        condition = null;
        if (child != null && child.getType() == 18) {
            condition = this.getCondition(child);
            child = child.getNextSibling();
        }
        if (joinConditions.length() > 0) {
            condition = condition == null ? joinConditions : joinConditions + " AND (" + condition + ")";
        }
        String group = null;
        if (child != null && child.getType() == 21) {
            group = this.getGroupBy(child);
            child = child.getNextSibling();
        }
        String order = null;
        if (child != null && child.getType() == 22) {
            order = this.getOrderBy(child);
            child = child.getNextSibling();
        }
        String select = "SELECT ";
        if (distinct) {
            select = select + "DISTINCT ";
        }
        select = select + sql + " FROM " + tables;
        if (condition != null) {
            select = select + " WHERE " + condition;
        }
        if (group != null) {
            select = select + " GROUP BY " + group;
        }
        if (order != null) {
            select = select + " ORDER BY " + order;
        }
        command.setVendorSQL(select);
    }

    void parseInsert(Command command, AST parent) throws SQLException {
        boolean add;
        AST child = parent.getFirstChild();
        String tableName = this.identifier(child.getText());
        child = child.getNextSibling();
        String sql = "INSERT INTO " + this.quote(this.identifier(tableName));
        Vector<String> v = new Vector<String>();
        if (child.getType() == 4) {
            AST list = child.getFirstChild();
            do {
                v.addElement(this.identifier(list.getText()));
            } while ((list = list.getNextSibling()) != null);
            child = child.getNextSibling();
        }
        if (add = this.mAdapter.needToAddAutoIncrement(tableName, v)) {
            if (v.size() == 0) {
                this.mAdapter.addAllColumns(tableName, v);
            }
            v.insertElementAt(this.mAdapter.getAutoIncrementColumn(tableName), 0);
        }
        if (v.size() > 0) {
            String columns = "";
            int i = 0;
            while (i < v.size()) {
                columns = columns + this.quote(v.elementAt(i).toString()) + ",";
                ++i;
            }
            columns = columns.substring(0, columns.length() - 1);
            sql = sql + "(" + columns + ")";
        }
        String values = "";
        if (child.getType() == 82) {
            AST val = child.getFirstChild();
            do {
                String s = this.getExpression(val);
                values = values + s + ",";
            } while ((val = val.getNextSibling()) != null);
            if (add) {
                values = "?," + values;
            }
            values = values.substring(0, values.length() - 1);
        }
        sql = sql + " VALUES(" + values + ")";
        command.setVendorSQL(sql);
        if (add) {
            command.setParameterIndexOffset(1);
            command.setAutoIncrement(true, tableName);
        }
    }

    void parseUpdate(Command command, AST parent) throws SQLException {
        int type;
        AST child = parent.getFirstChild();
        String tableName = this.identifier(child.getText());
        String sql = "";
        child = child.getNextSibling();
        while (child != null && child.getType() == 16) {
            AST updateset = child.getFirstChild();
            String columnName = this.identifier(updateset.getText());
            updateset = updateset.getNextSibling();
            String expression = this.getExpression(updateset);
            child = child.getNextSibling();
            sql = sql + this.quote(columnName) + " = " + expression + ",";
        }
        sql = sql.substring(0, sql.length() - 1);
        if (child != null && (type = child.getType()) == 18) {
            sql = sql + " WHERE " + this.getCondition(child);
        }
        command.setVendorSQL("UPDATE " + this.quote(tableName) + " SET " + sql);
    }

    String getOrderBy(AST parent) throws SQLException {
        AST child = parent.getFirstChild();
        String sql = "";
        do {
            AST item = child.getFirstChild();
            sql = sql + this.getExpression(item);
            if ((item = item.getNextSibling()) != null) {
                sql = sql + " " + item.getText();
            }
            sql = sql + ",";
        } while ((child = child.getNextSibling()) != null);
        sql = sql.substring(0, sql.length() - 1);
        return sql;
    }

    String getGroupBy(AST parent) throws SQLException {
        AST child = parent.getFirstChild();
        String sql = "";
        do {
            sql = sql + this.getExpression(child);
            child = child.getNextSibling();
            sql = sql + ",";
        } while (child != null);
        sql = sql.substring(0, sql.length() - 1);
        return sql;
    }

    String parseDate(String s) {
        s = s.substring(1, s.length() - 1);
        Date.valueOf(s);
        return s;
    }

    String parseTimestamp(String s) {
        s = s.substring(1, s.length() - 1);
        Timestamp.valueOf(s);
        return s;
    }

    String parseBinary(String s) {
        s = s.substring(2, s.length() - 1);
        return s;
    }

    void parseDropIndex(Command command, AST parent) {
        AST child = parent.getFirstChild();
        String indexName = this.identifier(child.getText());
        child = child.getNextSibling();
        String tableName = this.identifier(child.getText());
        String sql = this.mAdapter.getDropIndexSQL(tableName, tableName + "_" + indexName);
        command.setVendorSQL(sql);
    }

    void parseCreateIndex(Command command, AST parent) {
        AST child = parent.getFirstChild();
        boolean unique = false;
        if (child.getType() == 85) {
            unique = true;
            child = child.getNextSibling();
        }
        String indexName = this.identifier(child.getText());
        child = child.getNextSibling();
        String tableName = this.identifier(child.getText());
        child = child.getNextSibling();
        child = child.getFirstChild();
        String sql = "";
        do {
            String columnName = this.identifier(child.getText());
            sql = sql + this.quote(columnName) + ",";
        } while ((child = child.getNextSibling()) != null);
        sql = sql.substring(0, sql.length() - 1);
        command.setVendorSQL("CREATE " + (unique ? "UNIQUE " : "") + "INDEX " + this.quote(tableName + "_" + indexName) + " ON " + this.quote(tableName) + "(" + sql + ")");
    }

    void parseDropTable(Command command, AST parent) {
        AST child = parent.getFirstChild();
        String tableName = this.identifier(child.getText());
        command.setVendorSQL("DROP TABLE " + this.quote(tableName));
    }

    void parseCreateTable(Command command, AST parent) throws SQLException {
        AST child = parent.getFirstChild();
        String tableName = this.identifier(child.getText());
        Vector<Column> columns = new Vector<Column>();
        Vector<Integer> pkcolumns = new Vector<Integer>();
        Vector<String> foreignKey = new Vector<String>();
        Column autoincrement = null;
        while ((child = child.getNextSibling()) != null) {
            int type = child.getType();
            if (type == 11) {
                Column col = this.getColumn(child);
                if (col.isPrimaryKey()) {
                    pkcolumns.addElement(new Integer(columns.size()));
                }
                if (col.isAutoincrement()) {
                    if (autoincrement != null) {
                        throw Factory.getSQLException("37000", "Only one autoincrement columns allowed per table");
                    }
                    autoincrement = col;
                }
                columns.addElement(col);
                continue;
            }
            if (type == 12) {
                AST cols = child.getFirstChild();
                do {
                    String pkCol = this.identifier(cols.getText());
                    int i = 0;
                    while (i < columns.size()) {
                        Column col = (Column)columns.elementAt(i);
                        if (col.getName().equals(pkCol)) {
                            col.setNotNull();
                            pkcolumns.addElement(new Integer(i));
                        }
                        ++i;
                    }
                } while ((cols = cols.getNextSibling()) != null);
                continue;
            }
            if (type != 49) continue;
            foreignKey.addElement(this.getForeignKey(child));
        }
        String sql = "";
        int len = columns.size();
        int i = 0;
        while (i < len) {
            Column col = (Column)columns.elementAt(i);
            sql = sql + col.getCreateSQL(this.mAdapter);
            sql = sql + ",";
            ++i;
        }
        sql = sql.substring(0, sql.length() - 1);
        len = pkcolumns.size();
        if (len > 0) {
            sql = sql + ",PRIMARY KEY(";
            int i2 = 0;
            while (i2 < len) {
                int colidx = (Integer)pkcolumns.elementAt(i2);
                Column col = (Column)columns.elementAt(colidx);
                sql = sql + this.quote(col.getName()) + ",";
                ++i2;
            }
            sql = sql.substring(0, sql.length() - 1) + ")";
        }
        int i3 = 0;
        while (i3 < foreignKey.size()) {
            sql = sql + "," + foreignKey.elementAt(i3);
            ++i3;
        }
        sql = this.mAdapter.getCreateTable(tableName, sql);
        String[] cols = new String[columns.size()];
        int i4 = 0;
        while (i4 < cols.length) {
            cols[i4] = ((Column)columns.elementAt(i4)).getName();
            ++i4;
        }
        if (autoincrement != null) {
            this.mAdapter.addAutoIncrementColumn(tableName, cols, autoincrement.getName());
        }
        command.setVendorSQL(sql);
    }

    String getForeignKey(AST parent) throws SQLException {
        AST child = parent.getFirstChild();
        AST columns = child.getFirstChild();
        int i = 0;
        String columnlist = "";
        do {
            String col = this.identifier(columns.getText());
            if (i > 0) {
                columnlist = columnlist + ",";
            }
            columnlist = columnlist + this.quote(col);
            ++i;
        } while ((columns = columns.getNextSibling()) != null);
        String sql = "FOREIGN KEY(" + columnlist + ") REFERENCES ";
        child = child.getNextSibling();
        String table = this.identifier(child.getText());
        sql = sql + this.quote(table) + "(";
        child = child.getNextSibling();
        columns = child.getFirstChild();
        i = 0;
        do {
            String col = this.identifier(columns.getText());
            if (i > 0) {
                sql = sql + ",";
            }
            ++i;
            sql = sql + this.quote(col);
        } while ((columns = columns.getNextSibling()) != null);
        sql = sql + ")";
        if (this.mAdapter.needExplicitIndexOnForeignKey()) {
            sql = "INDEX(" + columnlist + ")," + sql;
        }
        return sql;
    }

    Column getColumn(AST parent) throws SQLException {
        AST child = parent.getFirstChild();
        String columnName = this.identifier(child.getText());
        child = child.getNextSibling();
        DataType type = this.getDataType(child);
        child = child.getNextSibling();
        boolean primarykey = false;
        boolean notNull = false;
        boolean autoincrement = false;
        if (child != null) {
            int mod = child.getType();
            if (mod == 89) {
                autoincrement = true;
                child = child.getNextSibling();
            }
            if (mod == 54) {
                notNull = true;
                child = child.getNextSibling();
            }
            if (mod == 58) {
                child = child.getNextSibling();
            }
            if (child != null && (mod = child.getType()) == 90) {
                child = child.getNextSibling();
                primarykey = true;
            }
        }
        Column col = new Column(columnName, type, notNull);
        if (primarykey) {
            col.setPrimaryKey();
        }
        if (autoincrement) {
            col.setAutoincrement();
        }
        return col;
    }

    DataType getDataType(AST child) throws SQLException {
        child = child.getFirstChild();
        int datatype = child.getType();
        int precision = 0;
        int scale = 0;
        switch (datatype) {
            case 43: {
                datatype = 4;
                break;
            }
            case 44: {
                datatype = 12;
                child = child.getNextSibling();
                precision = Integer.parseInt(child.getText());
                break;
            }
            case 45: {
                datatype = 3;
                child = child.getNextSibling();
                precision = DataType.getDefaultPrecision(3);
                scale = DataType.getDefaultScale(3);
                if (child == null) break;
                precision = Integer.parseInt(child.getText());
                if ((child = child.getNextSibling()) == null) break;
                scale = Integer.parseInt(child.getText());
                break;
            }
            case 46: {
                datatype = 93;
                break;
            }
            case 47: {
                datatype = 2004;
                break;
            }
            case 48: {
                datatype = 2005;
            }
        }
        DataType type = new DataType(null, datatype, precision, scale);
        return type;
    }

    String getExpression(AST child) throws SQLException {
        switch (child.getType()) {
            case 17: {
                return this.getExpression(child.getFirstChild());
            }
            case 33: {
                AST v = child.getFirstChild();
                String s = "";
                do {
                    s = s + v.getText();
                } while ((v = v.getNextSibling()) != null);
                return s;
            }
            case 18: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                return s1;
            }
            case 52: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " OR " + s2;
            }
            case 66: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                return "( " + s1 + " )";
            }
            case 53: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " AND " + s2;
            }
            case 29: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                return s1 + " IS NULL";
            }
            case 30: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                return s1 + " IS NOT NULL";
            }
            case 27: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " LIKE " + s2 + " " + this.mAdapter.getDefaultLikeEscape();
            }
            case 28: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                s1 = "NOT LIKE " + s1 + " ";
                return s1 + " NOT LIKE " + s2 + " " + this.mAdapter.getDefaultLikeEscape();
            }
            case 26: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                AST v3 = v2.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                String s3 = this.getExpression(v3);
                return s1 + " NOT BETWEEN " + s2 + " AND " + s3;
            }
            case 25: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                AST v3 = v2.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                String s3 = this.getExpression(v3);
                return s1 + " BETWEEN " + s2 + " AND " + s3;
            }
            case 24: {
                return "NOT " + this.getExpression(child.getFirstChild());
            }
            case 31: {
                return "-" + this.getExpression(child.getFirstChild());
            }
            case 59: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " = " + s2;
            }
            case 62: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " <> " + s2;
            }
            case 60: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " > " + s2;
            }
            case 61: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " < " + s2;
            }
            case 64: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " <= " + s2;
            }
            case 63: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " >= " + s2;
            }
            case 69: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return this.mAdapter.getStringConcatenation(s1, s2);
            }
            case 72: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " * " + s2;
            }
            case 73: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " / " + s2;
            }
            case 70: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " + " + s2;
            }
            case 71: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return s1 + " - " + s2;
            }
            case 166: {
                String s = child.getText();
                s = this.mAdapter.getStringConstant(s);
                return s;
            }
            case 34: {
                AST v = child.getFirstChild();
                String s = this.getExpression(v);
                s = this.parseDate(s);
                return this.mAdapter.getDateConstant(s);
            }
            case 36: {
                AST v = child.getFirstChild();
                String s = this.getExpression(v);
                s = this.parseTimestamp(s);
                return this.mAdapter.getTimestampConstant(s);
            }
            case 37: {
                AST v = child.getFirstChild();
                String s = this.getExpression(v);
                s = this.parseBinary(s);
                return this.mAdapter.getBinaryConstant(s);
            }
            case 38: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s = this.quote(this.identifier(v1.getText()));
                if (v2 != null) {
                    s = s + "." + this.quote(this.identifier(v2.getText()));
                }
                return s;
            }
            case 65: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                AST v2 = v1.getNextSibling();
                String s2 = this.getExpression(v2);
                while (v2.getNextSibling() != null) {
                    v2 = v2.getNextSibling();
                    s2 = s2 + ", " + this.getExpression(v2);
                }
                return s1 + " IN(" + s2 + ")";
            }
            case 145: {
                AST v1 = child.getFirstChild();
                if (v1.getType() == 72) {
                    return "COUNT(*)";
                }
                String s1 = this.getExpression(v1);
                return "COUNT(" + s1 + ")";
            }
            case 146: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                return "MIN(" + s1 + ")";
            }
            case 147: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                return "MAX(" + s1 + ")";
            }
            case 148: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                return "SUM(" + s1 + ")";
            }
            case 149: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                return "AVG(" + s1 + ")";
            }
            case 150: 
            case 151: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                DataType type = this.getDataType(v2);
                s1 = this.mAdapter.getCast(s1, type);
                return s1;
            }
            case 152: 
            case 153: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                s1 = this.mAdapter.getLength(s1);
                return s1;
            }
            case 154: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return this.mAdapter.getMod(s1, s2);
            }
            case 155: {
                AST v1 = child.getFirstChild();
                AST v2 = v1.getNextSibling();
                String s1 = this.getExpression(v1);
                String s2 = this.getExpression(v2);
                return this.mAdapter.getStringConcatenation(s1, s2);
            }
            case 156: 
            case 157: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                return "LOWER(" + s1 + ")";
            }
            case 158: 
            case 159: {
                AST v1 = child.getFirstChild();
                String s1 = this.getExpression(v1);
                return "UPPER(" + s1 + ")";
            }
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: {
                return this.mAdapter.getNow();
            }
            case 32: {
                return "NULL";
            }
            case 58: {
                return this.mAdapter.getNullConstant();
            }
            case 167: 
            case 168: {
                return child.getText();
            }
            case 172: {
                return this.quote(this.identifier(child.getText()));
            }
        }
        throw Factory.getSQLException("37000", child.getText());
    }

    String identifier(String id) {
        return id.toUpperCase();
    }

    String quote(String identifier) {
        return this.mAdapter.quote(identifier);
    }
}

