/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.log.Logger;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.Module;
import org.jacorb.idl.PositionInfo;
import org.jacorb.idl.fixed_token;
import org.jacorb.idl.parser;
import org.jacorb.idl.runtime.char_token;
import org.jacorb.idl.runtime.float_token;
import org.jacorb.idl.runtime.int_token;
import org.jacorb.idl.runtime.long_token;
import org.jacorb.idl.runtime.token;
import org.jacorb.idl.str_token;

public class lexer {
    private static Logger logger = parser.getLogger();
    protected static int next_char;
    protected static int next_char2;
    protected static final int EOF_CHAR = -1;
    protected static Hashtable keywords;
    protected static Hashtable keywords_lower_case;
    protected static Hashtable java_keywords;
    protected static Hashtable char_symbols;
    protected static Hashtable defines;
    protected static boolean conditionalCompilation;
    private static Stack ifStack;
    private static Stack tokenStack;
    protected static int current_line;
    protected static StringBuffer line;
    protected static int current_position;
    protected static boolean in_string;
    protected static boolean wide;
    static int error_count;
    public static int warning_count;
    public static String currentPragmaPrefix;
    public static String currentFile;

    public static void reset() {
        current_position = 1;
        error_count = 0;
        warning_count = 0;
        currentPragmaPrefix = "";
        line = new StringBuffer();
        ifStack.removeAllElements();
        tokenStack.removeAllElements();
        defines.clear();
    }

    public static void init() throws IOException {
        defines.put("JACORB_IDL_1_4", "");
        keywords.put("abstract", new Integer(2));
        keywords.put("any", new Integer(3));
        keywords.put("attribute", new Integer(4));
        keywords.put("boolean", new Integer(5));
        keywords.put("case", new Integer(6));
        keywords.put("char", new Integer(7));
        keywords.put("const", new Integer(8));
        keywords.put("context", new Integer(9));
        keywords.put("custom", new Integer(10));
        keywords.put("default", new Integer(11));
        keywords.put("double", new Integer(12));
        keywords.put("enum", new Integer(13));
        keywords.put("exception", new Integer(14));
        keywords.put("factory", new Integer(15));
        keywords.put("FALSE", new Integer(16));
        keywords.put("fixed", new Integer(17));
        keywords.put("float", new Integer(18));
        keywords.put("in", new Integer(19));
        keywords.put("inout", new Integer(20));
        keywords.put("interface", new Integer(21));
        keywords.put("local", new Integer(22));
        keywords.put("long", new Integer(23));
        keywords.put("module", new Integer(24));
        keywords.put("native", new Integer(25));
        keywords.put("Object", new Integer(26));
        keywords.put("octet", new Integer(27));
        keywords.put("oneway", new Integer(28));
        keywords.put("out", new Integer(29));
        keywords.put("private", new Integer(30));
        keywords.put("public", new Integer(31));
        keywords.put("pseudo", new Integer(32));
        keywords.put("raises", new Integer(33));
        keywords.put("readonly", new Integer(34));
        keywords.put("sequence", new Integer(35));
        keywords.put("short", new Integer(36));
        keywords.put("string", new Integer(37));
        keywords.put("struct", new Integer(38));
        keywords.put("supports", new Integer(39));
        keywords.put("switch", new Integer(40));
        keywords.put("TRUE", new Integer(41));
        keywords.put("truncatable", new Integer(42));
        keywords.put("typedef", new Integer(43));
        keywords.put("unsigned", new Integer(44));
        keywords.put("union", new Integer(45));
        keywords.put("ValueBase", new Integer(46));
        keywords.put("valuetype", new Integer(47));
        keywords.put("void", new Integer(48));
        keywords.put("wchar", new Integer(49));
        keywords.put("wstring", new Integer(50));
        keywords.put("::", new Integer(76));
        keywords.put("<<", new Integer(78));
        keywords.put(">>", new Integer(77));
        keywords.put("L\"", new Integer(79));
        Enumeration enumeration = keywords.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.toLowerCase();
            keywords_lower_case.put(string2, string);
        }
        char_symbols.put(new Integer(59), new Integer(51));
        char_symbols.put(new Integer(44), new Integer(52));
        char_symbols.put(new Integer(42), new Integer(53));
        char_symbols.put(new Integer(46), new Integer(54));
        char_symbols.put(new Integer(58), new Integer(55));
        char_symbols.put(new Integer(61), new Integer(56));
        char_symbols.put(new Integer(43), new Integer(57));
        char_symbols.put(new Integer(45), new Integer(58));
        char_symbols.put(new Integer(123), new Integer(61));
        char_symbols.put(new Integer(125), new Integer(62));
        char_symbols.put(new Integer(40), new Integer(59));
        char_symbols.put(new Integer(41), new Integer(60));
        char_symbols.put(new Integer(91), new Integer(63));
        char_symbols.put(new Integer(93), new Integer(64));
        char_symbols.put(new Integer(60), new Integer(65));
        char_symbols.put(new Integer(62), new Integer(66));
        char_symbols.put(new Integer(39), new Integer(67));
        char_symbols.put(new Integer(34), new Integer(68));
        char_symbols.put(new Integer(92), new Integer(69));
        char_symbols.put(new Integer(94), new Integer(71));
        char_symbols.put(new Integer(38), new Integer(72));
        char_symbols.put(new Integer(47), new Integer(73));
        char_symbols.put(new Integer(37), new Integer(74));
        char_symbols.put(new Integer(126), new Integer(75));
        char_symbols.put(new Integer(124), new Integer(70));
        char_symbols.put(new Integer(32), new Integer(80));
        java_keywords.put("abstract", "");
        java_keywords.put("boolean", "");
        java_keywords.put("break", "");
        java_keywords.put("byte", "");
        java_keywords.put("case", "");
        java_keywords.put("catch", "");
        java_keywords.put("char", "");
        java_keywords.put("class", "");
        java_keywords.put("const", "");
        java_keywords.put("continue", "");
        java_keywords.put("default", "");
        java_keywords.put("do", "");
        java_keywords.put("double", "");
        java_keywords.put("else", "");
        java_keywords.put("extends", "");
        java_keywords.put("false", "");
        java_keywords.put("final", "");
        java_keywords.put("finally", "");
        java_keywords.put("float", "");
        java_keywords.put("for", "");
        java_keywords.put("goto", "");
        java_keywords.put("if", "");
        java_keywords.put("implements", "");
        java_keywords.put("import", "");
        java_keywords.put("instanceof", "");
        java_keywords.put("int", "");
        java_keywords.put("interface", "");
        java_keywords.put("long", "");
        java_keywords.put("native", "");
        java_keywords.put("new", "");
        java_keywords.put("null", "");
        java_keywords.put("package", "");
        java_keywords.put("private", "");
        java_keywords.put("protected", "");
        java_keywords.put("public", "");
        java_keywords.put("return", "");
        java_keywords.put("short", "");
        java_keywords.put("static", "");
        java_keywords.put("super", "");
        java_keywords.put("switch", "");
        java_keywords.put("synchronized", "");
        java_keywords.put("true", "");
        java_keywords.put("this", "");
        java_keywords.put("throw", "");
        java_keywords.put("throws", "");
        java_keywords.put("transient", "");
        java_keywords.put("try", "");
        java_keywords.put("void", "");
        java_keywords.put("volatile", "");
        java_keywords.put("while", "");
        java_keywords.put("clone", "");
        java_keywords.put("equals", "");
        java_keywords.put("finalize", "");
        java_keywords.put("getClass", "");
        java_keywords.put("hashCode", "");
        java_keywords.put("notify", "");
        java_keywords.put("notifyAll", "");
        java_keywords.put("toString", "");
        java_keywords.put("wait", "");
        ifStack.push(new Boolean(true));
        try {
            next_char = GlobalInputStream.read();
        }
        catch (Exception exception) {
            parser.fatal_error("Cannot read from file " + GlobalInputStream.currentFile().getAbsolutePath() + ", please check file name.", null);
        }
        next_char2 = next_char == -1 ? -1 : GlobalInputStream.read();
    }

    public static void define(String string, String string2) {
        if (logger.isDebugEnabled()) {
            logger.debug("Defining: " + string + " as " + string2);
        }
        defines.put(string, string2);
    }

    public static void undefine(String string) {
        if (logger.isDebugEnabled()) {
            logger.debug("Un-defining: " + string);
        }
        defines.remove(string);
    }

    public static String defined(String string) {
        return (String)defines.get(string);
    }

    public static int currentLine() {
        return current_line;
    }

    public static PositionInfo getPosition() {
        return new PositionInfo(current_line, current_position, currentPragmaPrefix, line.toString(), GlobalInputStream.currentFile());
    }

    public static void restorePosition(PositionInfo positionInfo) {
        current_line = positionInfo.line_no;
        currentPragmaPrefix = positionInfo.pragma_prefix;
        current_position = 0;
    }

    protected static void advance() throws IOException {
        int n = next_char;
        next_char = next_char2;
        next_char2 = GlobalInputStream.read();
        line.append((char)n);
        ++current_position;
        if (n == 10) {
            ++current_line;
            current_position = 1;
            line = new StringBuffer();
        }
    }

    public static void emit_error(String string) {
        if (parser.getLogger().isErrorEnabled()) {
            logger.error(GlobalInputStream.currentFile().getAbsolutePath() + ", line: " + current_line + "(" + current_position + "): " + string + "\n\t" + line.toString());
        }
        ++error_count;
    }

    public static void emit_error(String string, str_token str_token2) {
        if (str_token2 == null) {
            lexer.emit_error(string);
        } else {
            if (parser.getLogger().isErrorEnabled()) {
                logger.error(str_token2.fileName + ", line:" + str_token2.line_no + "(" + str_token2.char_pos + "): " + string + "\n\t" + str_token2.line_val);
            }
            ++error_count;
        }
    }

    public static void emit_warn(String string) {
        if (parser.getLogger().isWarnEnabled()) {
            logger.warn(string + " at " + current_line + "(" + current_position + "): \"" + line.toString() + "\"");
        }
        ++warning_count;
    }

    public static void emit_warn(String string, str_token str_token2) {
        if (str_token2 == null) {
            lexer.emit_warn(string);
        } else {
            if (parser.getLogger().isWarnEnabled()) {
                logger.warn(" at " + str_token2.fileName + ", line:" + str_token2.line_no + "(" + str_token2.char_pos + "): " + string + "\n\t" + str_token2.line_val);
            }
            ++warning_count;
        }
    }

    protected static boolean id_start_char(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95;
    }

    protected static boolean id_char(int n) {
        return lexer.id_start_char(n) || n == 95 || n >= 48 && n <= 57;
    }

    protected static int find_single_char(int n) {
        Integer n2 = (Integer)char_symbols.get(new Integer((char)n));
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    protected static void swallow_comment() throws IOException {
        if (next_char2 == 42) {
            lexer.advance();
            lexer.advance();
            while (true) {
                if (next_char == -1) {
                    lexer.emit_error("Specification file ends inside a comment", null);
                    return;
                }
                if (next_char == 42 && next_char2 == 47) {
                    lexer.advance();
                    lexer.advance();
                    return;
                }
                lexer.advance();
            }
        }
        if (next_char2 == 47) {
            lexer.advance();
            lexer.advance();
            while (next_char != 10 && next_char != 12 && next_char != 13 && next_char != -1) {
                lexer.advance();
            }
            return;
        }
        lexer.emit_error("Malformed comment in specification -- ignored", null);
        lexer.advance();
    }

    /*
     * Unable to fully structure code
     */
    protected static void preprocess() throws IOException {
        block61: {
            block63: {
                block62: {
                    block60: {
                        if (lexer.next_char == -1) {
                            lexer.emit_error("Specification file ends inside a preprocessor directive", null);
                            return;
                        }
                        if (lexer.next_char != 35) {
                            lexer.emit_error("expected #, got " + (char)lexer.next_char + " instead!", null);
                        } else {
                            lexer.advance();
                        }
                        while (32 == lexer.next_char || 9 == lexer.next_char) {
                            lexer.advance();
                        }
                        var0 = lexer.get_string();
                        if (var0.equals("include")) {
                            if (!lexer.conditionalCompilation) {
                                return;
                            }
                            lexer.advance();
                            var1_1 = lexer.next_char == 60;
                            lexer.advance();
                            var2_10 = lexer.get_string();
                            if (var1_1 && lexer.next_char != 62) {
                                lexer.emit_error("Syntax error in #include directive, expecting '>'");
                            } else if (!var1_1 && lexer.next_char != 34) {
                                lexer.emit_error("Syntax error in #include directive, expecting \"");
                            }
                            while (lexer.next_char != 10 && lexer.next_char != 12 && lexer.next_char != 13 && lexer.next_char != -1) {
                                lexer.advance();
                            }
                            GlobalInputStream.include(var2_10, lexer.next_char2, var1_1);
                            lexer.current_line = 0;
                            lexer.advance();
                            lexer.advance();
                            return;
                        }
                        if (!var0.equals("define")) break block60;
                        if (!lexer.conditionalCompilation) {
                            return;
                        }
                        lexer.swallow_whitespace();
                        var1_2 = lexer.get_string();
                        var2_11 = new StringBuffer();
                        if (lexer.next_char == 32) {
                            lexer.advance();
                        }
                        while (lexer.next_char != 10) {
                            if (lexer.next_char == 92) {
                                lexer.advance();
                                lexer.advance();
                            }
                            var2_11.append((char)lexer.next_char);
                            lexer.advance();
                        }
                        lexer.define(var1_2, var2_11.toString());
                        break block61;
                    }
                    if (!var0.equals("error")) break block62;
                    if (!lexer.conditionalCompilation) {
                        return;
                    }
                    lexer.advance();
                    var1_3 = lexer.get_string();
                    lexer.emit_error(var1_3);
                    break block61;
                }
                if (!var0.equals("undef")) break block63;
                if (!lexer.conditionalCompilation) {
                    return;
                }
                lexer.swallow_whitespace();
                var1_4 = lexer.get_string();
                lexer.undefine(var1_4);
                break block61;
            }
            if (!var0.equals("if") && !var0.equals("elif")) ** GOTO lbl103
            if (!var0.equals("elif")) {
                lexer.ifStack.push(new Boolean(lexer.conditionalCompilation));
                if (!lexer.conditionalCompilation) {
                    return;
                }
            }
            lexer.swallow_whitespace();
            var1_5 = true;
            if (33 == lexer.next_char) {
                lexer.advance();
                var1_5 = false;
            }
            if ((var2_11 = lexer.get_string_no_paren()).equals("defined")) {
                lexer.swallow_whitespace();
                v0 = var3_12 = 40 == lexer.next_char;
                if (var3_12) {
                    lexer.advance();
                    lexer.swallow_whitespace();
                }
                var4_14 = lexer.get_string_no_paren();
                if (var3_12) {
                    lexer.swallow_whitespace();
                    if (lexer.logger.isDebugEnabled()) {
                        lexer.logger.debug("next char: " + lexer.next_char);
                    }
                    if (41 != lexer.next_char) {
                        lexer.emit_error("Expected ) terminating #if defined", null);
                        return;
                    }
                    lexer.advance();
                }
                lexer.conditionalCompilation = var1_5 ? lexer.defined(var4_14) != null : lexer.defined(var4_14) == null;
            } else if (var2_11.equals("0")) {
                lexer.conditionalCompilation = false;
            } else if (var2_11.equals("1")) {
                lexer.conditionalCompilation = true;
            } else {
                lexer.emit_error("Expected \"defined\" following #if: " + var0, null);
                return;
lbl103:
                // 1 sources

                if (var0.equals("ifdef")) {
                    lexer.ifStack.push(new Boolean(lexer.conditionalCompilation));
                    if (!lexer.conditionalCompilation) {
                        return;
                    }
                    lexer.swallow_whitespace();
                    var1_6 = lexer.get_string();
                    lexer.conditionalCompilation = lexer.defined(var1_6) != null;
                } else if (var0.equals("ifndef")) {
                    lexer.ifStack.push(new Boolean(lexer.conditionalCompilation));
                    if (!lexer.conditionalCompilation) {
                        return;
                    }
                    lexer.swallow_whitespace();
                    var1_7 = lexer.get_string();
                    lexer.conditionalCompilation = lexer.defined(var1_7) == null;
                } else if (var0.equals("else")) {
                    if (((Boolean)lexer.ifStack.peek()).booleanValue()) {
                        lexer.conditionalCompilation = lexer.conditionalCompilation == false;
                    }
                } else if (var0.equals("endif")) {
                    lexer.conditionalCompilation = var1_8 = ((Boolean)lexer.ifStack.pop()).booleanValue();
                } else if (var0.equals("pragma")) {
                    if (!lexer.conditionalCompilation) {
                        return;
                    }
                    lexer.swallow_whitespace();
                    var1_9 = lexer.get_string();
                    if (var1_9.equals("prefix")) {
                        lexer.advance();
                        lexer.currentPragmaPrefix = lexer.get_string();
                    } else if (var1_9.equals("version")) {
                        lexer.advance();
                        var2_11 = lexer.get_string();
                        lexer.advance();
                        var3_13 = lexer.get_string();
                        var4_14 = (String)parser.currentScopeData().versionMap.get(var2_11);
                        if (var4_14 == null) {
                            parser.currentScopeData().versionMap.put(var2_11, var3_13);
                        } else if (!var4_14.equals(var3_13)) {
                            lexer.emit_error("Version re-declaration with different value: #pragma version " + var3_13, null);
                        }
                        var5_15 = (String)parser.currentScopeData().idMap.get(var2_11);
                        if (var5_15 != null && !var3_13.equals(var5_15.substring(1 + var5_15.lastIndexOf(58)))) {
                            lexer.emit_error("Declaring version with different version to already declared ID for " + var1_9, null);
                        }
                    } else if (var1_9.equals("ID")) {
                        lexer.advance();
                        var2_11 = lexer.get_string();
                        lexer.advance();
                        var3_13 = lexer.get_string();
                        var4_14 = (String)parser.currentScopeData().idMap.get(var2_11);
                        if (var4_14 == null) {
                            parser.currentScopeData().idMap.put(var2_11, var3_13);
                        } else if (!var4_14.equals(var3_13)) {
                            lexer.emit_error("ID re-declaration with different value: #pragma id " + var3_13, null);
                        }
                        if (parser.currentScopeData().versionMap.get(var2_11) != null && !((String)parser.currentScopeData().versionMap.get(var2_11)).equals(var3_13.substring(1 + var3_13.lastIndexOf(58)))) {
                            lexer.emit_error("Declaring ID with different version to already declared version for " + var1_9, null);
                        }
                    } else if (var1_9.equals("inhibit_code_generation")) {
                        parser.setInhibitionState(true);
                    } else {
                        lexer.emit_warn("Unknown pragma, ignoring: #pragma " + var1_9, null);
                    }
                } else {
                    lexer.emit_error("Unrecognized preprocessor directive " + var0, null);
                }
            }
        }
        while (lexer.next_char != 10 && lexer.next_char != 12 && lexer.next_char != 13 && lexer.next_char != -1) {
            lexer.advance();
        }
    }

    private static final String get_string_no_paren() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char c = (char)next_char;
        while (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f' && c != '\uffffffff' && c != '\"' && c != '<' && c != '>' && c != '(' && c != ')') {
            stringBuffer.append(c);
            lexer.advance();
            c = (char)next_char;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static final String get_string() throws IOException {
        block3: {
            var0 = new StringBuffer("");
            if (lexer.next_char != 34) ** GOTO lbl15
            lexer.advance();
            while (lexer.next_char != 34) {
                if (lexer.next_char == -1) {
                    lexer.emit_error("Unexpected EOF in string");
                }
                var0.append((char)lexer.next_char);
                lexer.advance();
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var0.append((char)lexer.next_char);
                lexer.advance();
lbl15:
                // 2 sources

                ** while (lexer.next_char != 32 && lexer.next_char != 9 && lexer.next_char != 13 && lexer.next_char != 10 && lexer.next_char != 12 && lexer.next_char != -1 && lexer.next_char != 34 && lexer.next_char != 60 && lexer.next_char != 62)
            }
        }
        return var0.toString();
    }

    protected static token do_symbol() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        Integer n = null;
        char[] cArray = new char[]{(char)next_char};
        stringBuffer.append(cArray, 0, 1);
        lexer.advance();
        while (lexer.id_char(next_char)) {
            cArray[0] = (char)next_char;
            stringBuffer.append(cArray, 0, 1);
            lexer.advance();
        }
        String string = stringBuffer.toString();
        String string2 = lexer.defined(string);
        if (string2 != null) {
            char[] cArray2 = new char[]{(char)next_char, (char)next_char2};
            GlobalInputStream.insert(string2 + new String(cArray2));
            lexer.advance();
            lexer.advance();
            return null;
        }
        n = (Integer)keywords.get(string);
        if (n != null) {
            if (lexer.isScope(string)) {
                parser.openScope();
            }
            return new token(n);
        }
        if ((string = lexer.checkIdentifier(string)) != null) {
            return new str_token(81, string, lexer.getPosition(), GlobalInputStream.currentFile().getName());
        }
        return null;
    }

    private static final boolean isScope(String string) {
        return string.equals("module") || string.equals("interface") || string.equals("struct") || string.equals("exception") || string.equals("union");
    }

    public static String checkIdentifier(String string) {
        if (logger.isInfoEnabled()) {
            logger.info("checking identifier " + string);
        }
        if (string.charAt(0) == '_') {
            string = string.substring(1);
        } else {
            String string2 = null;
            string2 = parser.strict_names ? (String)keywords_lower_case.get(string.toLowerCase()) : (String)keywords.get(string);
            if (string2 != null) {
                lexer.emit_error("Identifier " + string + " collides with keyword " + string2 + ".");
                return null;
            }
        }
        if (lexer.needsJavaEscape(string)) {
            string = "_" + string;
        }
        return string;
    }

    private static final boolean needsJavaEscape(String string) {
        return java_keywords.containsKey(string);
    }

    public static boolean strictJavaEscapeCheck(String string) {
        return !string.equals("Helper") && string.endsWith("Helper") || !string.equals("Holder") && string.endsWith("Holder") || !string.equals("Operations") && string.endsWith("Operations") || !string.equals("Package") && string.endsWith("Package") || !string.equals("POA") && string.endsWith("POA") || !string.equals("POATie") && string.endsWith("POATie");
    }

    public static boolean needsJavaEscape(Module module) {
        String string = module.pack_name;
        if (logger.isDebugEnabled()) {
            logger.debug("checking module name " + string);
        }
        return lexer.strictJavaEscapeCheck(string);
    }

    public static token next_token() throws IOException {
        parser.set_included(GlobalInputStream.includeState());
        token token2 = lexer.real_next_token();
        return token2;
    }

    private static final void swallow_whitespace() throws IOException {
        while (next_char == 32 || next_char == 9 || next_char == 10 || next_char == 12 || next_char == 13) {
            lexer.advance();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected static token real_next_token() throws IOException {
        if (!lexer.tokenStack.empty()) {
            return (token)lexer.tokenStack.pop();
        }
        while (true) {
            block102: {
                block101: {
                    if (lexer.in_string) break block101;
                    lexer.swallow_whitespace();
                    if ((char)lexer.next_char == '#') {
                        lexer.preprocess();
                        continue;
                    }
                    if (lexer.next_char == 47 && (lexer.next_char2 == 42 || lexer.next_char2 == 47)) {
                        lexer.swallow_comment();
                        continue;
                    }
                    if (!lexer.conditionalCompilation) {
                        lexer.advance();
                        if (lexer.next_char != -1) continue;
                        lexer.emit_error("EOF in conditional compilation!", null);
                        return null;
                    }
                    if (lexer.next_char == 58) {
                        if (lexer.next_char2 == 58) {
                            lexer.advance();
                            lexer.advance();
                            return new token(76);
                        }
                        lexer.advance();
                        return new token(55);
                    }
                    if (lexer.next_char == 76 && (lexer.next_char2 == 34 || lexer.next_char2 == 39)) {
                        lexer.wide = true;
                        lexer.advance();
                        if (lexer.next_char2 == 34) {
                            lexer.advance();
                            lexer.in_string = true;
                            return new token(79);
                        }
                    }
                    if (lexer.next_char == 60) {
                        if (lexer.next_char2 == 60) {
                            lexer.advance();
                            lexer.advance();
                            return new token(78);
                        }
                        lexer.advance();
                        return new token(65);
                    }
                    if (lexer.next_char == 62) {
                        if (lexer.next_char2 == 62) {
                            lexer.advance();
                            lexer.advance();
                            return new token(77);
                        }
                        lexer.advance();
                        return new token(66);
                    }
                    if (lexer.next_char == 48) {
                        var1_2 = 0L;
                        var3_9 = 0L;
                        var5_21 = 8;
                        var6_25 = 0;
                        lexer.advance();
                        if (lexer.next_char == 46) {
                            var7_28 = new StringBuffer("0.");
                            lexer.advance();
                            while (lexer.next_char >= 48 && lexer.next_char <= 57) {
                                var7_28.append((char)lexer.next_char);
                                lexer.advance();
                            }
                            var8_31 = new Float(var7_28.toString()).floatValue();
                            return new float_token(85, var8_31);
                        }
                        if (lexer.next_char == 120 || lexer.next_char == 88) {
                            lexer.advance();
                            var5_21 = 16;
                        }
                        var7_29 = new StringBuffer("0");
                        var6_25 = Character.digit((char)lexer.next_char, var5_21);
                        while (var6_25 != -1) {
                            var7_29.append((char)lexer.next_char);
                            lexer.advance();
                            var6_25 = Character.digit((char)lexer.next_char, var5_21);
                        }
                        var8_32 = var7_29.toString();
                        try {
                            return new int_token(83, Integer.parseInt(var8_32, var5_21));
                        }
                        catch (NumberFormatException var9_34) {
                            try {
                                return new long_token(84, Long.parseLong(var8_32, var5_21));
                            }
                            catch (NumberFormatException var10_35) {
                                lexer.emit_error("Invalid octal/hex value:  " + var8_32);
                                return null;
                            }
                        }
                    }
                    if (lexer.isDigit((char)lexer.next_char) || lexer.next_char == 46 || lexer.next_char == 45 && lexer.isDigit((char)lexer.next_char2)) {
                        var1_1 = new StringBuffer();
                        var2_3 = null;
                        var3_8 = '\u0000';
                        if (lexer.next_char == 45) {
                            var1_1.append((char)lexer.next_char);
                            lexer.advance();
                        }
                        while (lexer.next_char >= 48 && lexer.next_char <= 57) {
                            var1_1.append((char)lexer.next_char);
                            lexer.advance();
                        }
                        if (lexer.next_char == 46) {
                            var2_3 = new StringBuffer();
                            lexer.advance();
                            while (lexer.next_char >= 48 && lexer.next_char <= 57) {
                                var2_3.append((char)lexer.next_char);
                                lexer.advance();
                            }
                        }
                        if (lexer.next_char == 101 || lexer.next_char == 69) {
                            if (var2_3 == null) {
                                var2_3 = new StringBuffer();
                            }
                            var2_3.append('e');
                            lexer.advance();
                            if (lexer.next_char == 45 || lexer.next_char == 43) {
                                var2_3.append((char)lexer.next_char);
                                lexer.advance();
                            }
                            while (lexer.next_char >= 48 && lexer.next_char <= 57) {
                                var2_3.append((char)lexer.next_char);
                                lexer.advance();
                            }
                            if (var2_3.length() == 1) {
                                lexer.emit_error("Empty exponent in float/double.");
                                continue;
                            }
                            return new float_token(85, Float.valueOf(var1_1.toString() + "." + var2_3.toString()).floatValue());
                        }
                        if (lexer.next_char == 100 || lexer.next_char == 68) {
                            lexer.advance();
                            if (var2_3 == null) {
                                var2_3 = new StringBuffer();
                            }
                            var4_14 = new BigDecimal(var1_1.toString() + "." + var2_3.toString());
                            return new fixed_token(86, var4_14);
                        }
                        if (var2_3 == null) {
                            var4_15 /* !! */  = null;
                            var5_22 = var1_1.toString();
                            try {
                                var4_15 /* !! */  = new int_token(83, Integer.parseInt(var5_22));
                            }
                            catch (NumberFormatException var6_26) {
                                try {
                                    var4_15 /* !! */  = new long_token(84, Long.parseLong(var5_22));
                                }
                                catch (NumberFormatException var7_30) {
                                    try {
                                        var4_15 /* !! */  = new fixed_token(86, new BigDecimal(var5_22));
                                    }
                                    catch (NumberFormatException var8_33) {
                                        lexer.emit_error("Invalid long value:  " + var5_22);
                                    }
                                }
                            }
                            return var4_15 /* !! */ ;
                        }
                        try {
                            var4_16 = Float.valueOf(var1_1.toString() + "." + var2_3.toString()).floatValue();
                            return new float_token(85, var4_16);
                        }
                        catch (NumberFormatException var4_13) {
                            lexer.emit_error("Unexpected symbol:  " + var1_1.toString() + "." + var2_3.toString());
                        }
                    }
                    var0 = lexer.find_single_char(lexer.next_char);
                    if ((char)lexer.next_char == '\"') {
                        lexer.in_string = true;
                        lexer.advance();
                        return new token(68);
                    }
                    if ((char)lexer.next_char == '\'') {
                        lexer.advance();
                        var1_1 = null;
                        if (lexer.next_char == 92) {
                            lexer.advance();
                            if (lexer.isDigit((char)lexer.next_char)) {
                                var2_4 = '0';
                                var3_8 = '0';
                                var4_17 = (char)lexer.next_char;
                                if (lexer.isDigit((char)lexer.next_char2)) {
                                    lexer.advance();
                                    var3_8 = var4_17;
                                    var4_17 = (char)lexer.next_char;
                                    if (lexer.isDigit((char)lexer.next_char2)) {
                                        lexer.advance();
                                        var2_4 = var3_8;
                                        var3_8 = var4_17;
                                        var4_17 = (char)lexer.next_char;
                                    }
                                }
                                var1_1 = new char_token(82, (char)Integer.parseInt(new String(new char[]{var2_4, var3_8, var4_17}), 8));
                            } else if ((char)lexer.next_char == 'x') {
                                lexer.advance();
                                var2_5 = '0';
                                var3_8 = (char)lexer.next_char;
                                if (lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                    lexer.advance();
                                    var2_5 = var3_8;
                                    var3_8 = (char)lexer.next_char;
                                } else if ((char)lexer.next_char2 != '\'') {
                                    lexer.emit_error("Illegal hex character");
                                    return null;
                                }
                                var1_1 = new char_token(82, (char)Integer.parseInt(new String(new char[]{var2_5, var3_8}), 16));
                            } else if ((char)lexer.next_char == 'u') {
                                if (!lexer.wide) {
                                    lexer.emit_error("Unicode characters are only legal with wide character");
                                    return null;
                                }
                                lexer.advance();
                                var2_6 = '0';
                                var3_8 = '0';
                                var4_18 = '0';
                                var5_23 = (char)lexer.next_char;
                                if (lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                    lexer.advance();
                                    var4_18 = var5_23;
                                    var5_23 = (char)lexer.next_char;
                                    if (lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                        lexer.advance();
                                        var3_8 = var4_18;
                                        var4_18 = var5_23;
                                        var5_23 = (char)lexer.next_char;
                                        if (lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                            lexer.advance();
                                            var2_6 = var3_8;
                                            var3_8 = var4_18;
                                            var4_18 = var5_23;
                                            var5_23 = (char)lexer.next_char;
                                        } else if ((char)lexer.next_char2 != '\'') {
                                            lexer.emit_error("Illegal unicode character");
                                            return null;
                                        }
                                    } else if ((char)lexer.next_char2 != '\'') {
                                        lexer.emit_error("Illegal unicode character");
                                        return null;
                                    }
                                } else if ((char)lexer.next_char2 != '\'') {
                                    lexer.emit_error("Illegal unicode character");
                                    return null;
                                }
                                var1_1 = new char_token(82, (char)Integer.parseInt(new String(new char[]{var2_6, var3_8, var4_18, var5_23}), 16));
                            } else {
                                switch (lexer.next_char) {
                                    case 110: {
                                        var1_1 = new char_token(82, '\n');
                                        break;
                                    }
                                    case 116: {
                                        var1_1 = new char_token(82, '\t');
                                        break;
                                    }
                                    case 118: {
                                        var1_1 = new char_token(82, '\u000b');
                                        break;
                                    }
                                    case 98: {
                                        var1_1 = new char_token(82, '\b');
                                        break;
                                    }
                                    case 114: {
                                        var1_1 = new char_token(82, '\r');
                                        break;
                                    }
                                    case 102: {
                                        var1_1 = new char_token(82, '\f');
                                        break;
                                    }
                                    case 97: {
                                        var1_1 = new char_token(82, '\u0007');
                                        break;
                                    }
                                    case 92: {
                                        var1_1 = new char_token(82, '\\');
                                        break;
                                    }
                                    case 63: {
                                        var1_1 = new char_token(82, '?');
                                        break;
                                    }
                                    case 48: {
                                        var1_1 = new char_token(82, '\u0000');
                                        break;
                                    }
                                    case 39: {
                                        var1_1 = new char_token(82, '\'');
                                        break;
                                    }
                                    case 34: {
                                        var1_1 = new char_token(82, '\"');
                                        break;
                                    }
                                    default: {
                                        lexer.emit_error("Invalid escape symbol '");
                                        return null;
                                    }
                                }
                            }
                        } else {
                            var1_1 = new char_token(82, (char)lexer.next_char);
                        }
                        lexer.advance();
                        if ((char)lexer.next_char != '\'') {
                            lexer.emit_error("Expecting closing '");
                            return null;
                        }
                        lexer.tokenStack.push(new token(67));
                        lexer.tokenStack.push(var1_1);
                        lexer.advance();
                        lexer.wide = false;
                        return new token(67);
                    }
                    if (var0 != -1) {
                        lexer.advance();
                        return new token(var0);
                    }
                    if (lexer.id_start_char(lexer.next_char)) {
                        var1_1 = lexer.do_symbol();
                        if (var1_1 == null) continue;
                        return var1_1;
                    }
                    if (lexer.next_char == -1) {
                        return new token(0);
                    }
                    break block102;
                }
                if ((char)lexer.next_char == '\"') {
                    lexer.in_string = false;
                    lexer.advance();
                    return new token(68);
                }
                var1_1 = new StringBuffer();
                var2_7 = ' ';
                do {
                    block104: {
                        block103: {
                            if (lexer.next_char != 92) break block103;
                            switch (lexer.next_char2) {
                                case 97: {
                                    var1_1.append("\\007");
                                    var2_7 = 'a';
                                    lexer.advance();
                                    break;
                                }
                                case 118: {
                                    var1_1.append("\\013");
                                    var2_7 = 'v';
                                    lexer.advance();
                                    break;
                                }
                                case 63: {
                                    var1_1.append("?");
                                    var2_7 = '?';
                                    lexer.advance();
                                    break;
                                }
                                case 120: {
                                    lexer.advance();
                                    lexer.advance();
                                    var3_10 = Integer.toOctalString(Integer.parseInt(new String(new char[]{(char)lexer.next_char, (char)lexer.next_char2}), 16));
                                    if (var3_10.length() != 3) {
                                        if (var3_10.length() == 1) {
                                            var3_10 = "0" + var3_10;
                                        }
                                        var3_10 = "0" + var3_10;
                                    }
                                    var1_1.append("\\" + var3_10);
                                    var2_7 = (char)lexer.next_char2;
                                    lexer.advance();
                                    break;
                                }
                                case 117: {
                                    if (!lexer.wide) {
                                        lexer.emit_error("Unicode characters are only legal with wide strings");
                                        return null;
                                    }
                                    var1_1.append((char)lexer.next_char);
                                    var1_1.append((char)lexer.next_char2);
                                    lexer.advance();
                                    lexer.advance();
                                    var3_11 = (char)lexer.next_char;
                                    var4_20 = '0';
                                    var5_24 = '0';
                                    var6_27 = '0';
                                    if (!lexer.isHexLetterOrDigit((char)lexer.next_char2)) ** GOTO lbl356
                                    lexer.advance();
                                    var4_20 = (char)lexer.next_char;
                                    if (lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                        lexer.advance();
                                        var5_24 = (char)lexer.next_char;
                                        if (!lexer.isHexLetterOrDigit((char)lexer.next_char2)) {
                                            lexer.emit_error("Illegal unicode character");
                                            return null;
                                        }
                                    } else {
                                        lexer.emit_error("Illegal unicode character");
                                        return null;
lbl356:
                                        // 1 sources

                                        lexer.emit_error("Illegal unicode character");
                                        return null;
                                    }
                                    lexer.advance();
                                    var6_27 = (char)lexer.next_char;
                                    var2_7 = var6_27;
                                    var1_1.append(var3_11);
                                    var1_1.append(var4_20);
                                    var1_1.append(var5_24);
                                    var1_1.append(var6_27);
                                    break;
                                }
                                default: {
                                    var2_7 = (char)lexer.next_char;
                                    var1_1.append((char)lexer.next_char);
                                    break;
                                }
                            }
                            break block104;
                        }
                        var2_7 = (char)lexer.next_char;
                        var1_1.append((char)lexer.next_char);
                    }
                    lexer.advance();
                } while ((char)lexer.next_char != '\"' || var2_7 == 92);
                lexer.wide = false;
                var3_12 = var1_1.toString();
                return new str_token(81, var3_12, lexer.getPosition(), GlobalInputStream.currentFile().getName());
            }
            lexer.emit_warn("Unrecognized character '" + new Character((char)lexer.next_char) + "'(" + lexer.next_char + ") -- ignored");
            lexer.advance();
        }
    }

    static boolean isDigit(char c) {
        boolean bl = false;
        if (c >= '0' && c <= '9') {
            bl = true;
        }
        return bl;
    }

    private static final boolean isHexLetterOrDigit(char c) {
        boolean bl = false;
        if (c >= '0') {
            if (c <= '9') {
                bl = true;
            } else if (c >= 'A') {
                if (c <= 'F') {
                    bl = true;
                }
                if (c >= 'a' && c <= 'f') {
                    bl = true;
                }
            }
        }
        return bl;
    }

    static {
        keywords = new Hashtable();
        keywords_lower_case = new Hashtable();
        java_keywords = new Hashtable();
        char_symbols = new Hashtable(25);
        defines = new Hashtable();
        conditionalCompilation = true;
        ifStack = new Stack();
        tokenStack = new Stack();
        current_line = 1;
        line = new StringBuffer();
        current_position = 1;
        in_string = false;
        wide = false;
        error_count = 0;
        warning_count = 0;
        currentPragmaPrefix = "";
        currentFile = "";
    }
}

