/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Buffer;
import com.mysql.jdbc.CharsetMapping;
import com.mysql.jdbc.DatabaseMetaData;
import com.mysql.jdbc.Driver;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.TimeUtil;
import com.mysql.jdbc.Util;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Connection
implements java.sql.Connection {
    private static final String PING_COMMAND = "SELECT 1";
    private static Map mapTransIsolationName2Value;
    private static Map charsetMap;
    private static Map multibyteCharsetsMap;
    private static final String DEFAULT_SOCKET_FACTORY;
    private DatabaseMetaData dbmd = null;
    private List hostList = null;
    private Map statementsUsingMaxRows;
    private MysqlIO io = null;
    private final Object mutex = new Object();
    private Driver myDriver;
    private Map serverVariables = new HashMap();
    private Properties props = null;
    private String database = null;
    private String encoding = null;
    private String host = null;
    private String myURL = null;
    private String password = null;
    private String socketFactoryClassName = null;
    private String user = null;
    private TimeZone serverTimezone = null;
    private boolean allowLoadLocalInfile = true;
    private boolean autoCommit = true;
    private boolean capitalizeDBMDTypes = false;
    private boolean continueBatchOnError = true;
    private boolean doUnicode = false;
    private boolean failedOver = false;
    private boolean hasIsolationLevels = false;
    private boolean hasQuotedIdentifiers = false;
    private boolean highAvailability = false;
    private boolean isClosed = true;
    private boolean isInteractiveClient = false;
    private boolean lowerCaseTableNames = false;
    private boolean maxRowsChanged = false;
    private boolean paranoid = false;
    private boolean pedantic = false;
    private boolean readOnly = false;
    private boolean relaxAutoCommit = false;
    private boolean strictFloatingPoint = false;
    private boolean strictUpdates = true;
    private boolean transactionsSupported = false;
    private boolean useAnsiQuotes = false;
    private boolean useCompression = false;
    private boolean useFastPing = false;
    private boolean useHostsInPrivileges = true;
    private boolean useSSL = false;
    private boolean useStreamLengthsInPrepStmts = true;
    private boolean useTimezone = false;
    private boolean useUltraDevWorkAround = false;
    private double initialTimeout = 2.0;
    private int hostListSize = 0;
    private int isolationLevel = 2;
    private int maxAllowedPacket = 65536;
    private int maxReconnects = 3;
    private int maxRows = -1;
    private int netBufferLength = 16384;
    private int port = 3306;
    private int queriesBeforeRetryMaster = 50;
    private int socketTimeout = 0;
    private long lastQueryFinishedTime = 0L;
    private long masterFailTimeMillis = 0L;
    private long queriesIssuedFailedOver = 0L;
    private long secondsBeforeRetryMaster = 30L;
    private Map typeMap;
    private boolean ignoreNonTxTables = false;
    static /* synthetic */ Class class$com$mysql$jdbc$StandardSocketFactory;

    Connection(String host, int port, Properties info, String database, String url, Driver d) throws SQLException {
        this.hostList = new ArrayList();
        if (host == null) {
            this.host = "localhost";
            this.hostList.add(this.host);
        } else if (host.indexOf(",") != -1) {
            StringTokenizer hostTokenizer = new StringTokenizer(host, ",", false);
            while (hostTokenizer.hasMoreTokens()) {
                this.hostList.add(hostTokenizer.nextToken().trim());
            }
        } else {
            this.host = host;
            this.hostList.add(this.host);
        }
        this.hostListSize = this.hostList.size();
        this.port = port;
        if (database == null) {
            throw new SQLException("Malformed URL '" + url + "'.", "S1000");
        }
        this.database = database;
        this.myURL = url;
        this.myDriver = d;
        this.user = info.getProperty("user");
        this.password = info.getProperty("password");
        if (this.user == null || this.user.equals("")) {
            this.user = "nobody";
        }
        if (this.password == null) {
            this.password = "";
        }
        this.props = info;
        this.initializeDriverProperties(info);
        try {
            this.createNewIO(false);
            this.dbmd = new DatabaseMetaData(this, this.database);
        }
        catch (SQLException ex) {
            this.cleanup();
            throw ex;
        }
        catch (Exception ex) {
            this.cleanup();
            StringBuffer mesg = new StringBuffer();
            if (!this.useParanoidErrorMessages()) {
                mesg.append("Cannot connect to MySQL server on ");
                mesg.append(this.host);
                mesg.append(":");
                mesg.append(this.port);
                mesg.append(".\n\n");
                mesg.append("Make sure that there is a MySQL server ");
                mesg.append("running on the machine/port you are trying ");
                mesg.append("to connect to and that the machine this software is running on ");
                mesg.append("is able to connect to this host/port (i.e. not firewalled). ");
                mesg.append("Also make sure that the server has not been started with the --skip-networking ");
                mesg.append("flag.\n\n");
            } else {
                mesg.append("Unable to connect to database.");
            }
            mesg.append("Underlying exception: \n\n");
            mesg.append(ex.getClass().getName());
            throw new SQLException(mesg.toString(), "08S01");
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.transactionsSupported) {
            this.autoCommit = autoCommit;
            String sql = "SET autocommit=" + (autoCommit ? "1" : "0");
            this.execSQL(sql, -1, this.database);
        } else {
            if (!autoCommit && !this.relaxAutoCommit) {
                throw new SQLException("MySQL Versions Older than 3.23.15 do not support transactions", "08003");
            }
            this.autoCommit = autoCommit;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        String quotedId = this.dbmd.getIdentifierQuoteString();
        if (quotedId == null || quotedId.equals(" ")) {
            quotedId = "";
        }
        StringBuffer query = new StringBuffer("USE ");
        query.append(quotedId);
        query.append(catalog);
        query.append(quotedId);
        this.execSQL(query.toString(), -1, catalog);
        this.database = catalog;
    }

    public String getCatalog() throws SQLException {
        return this.database;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setHoldability(int arg0) throws SQLException {
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public long getIdleFor() {
        if (this.lastQueryFinishedTime == 0L) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long idleTime = now - this.lastQueryFinishedTime;
        return idleTime;
    }

    public boolean isInteractiveClient() {
        return this.isInteractiveClient;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new DatabaseMetaData(this, this.database);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new NotImplemented();
    }

    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new NotImplemented();
    }

    public TimeZone getServerTimezone() {
        return this.serverTimezone;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        StringBuffer sql;
        this.checkClosed();
        if (this.hasIsolationLevels) {
            sql = new StringBuffer("SET SESSION TRANSACTION ISOLATION LEVEL ");
            switch (level) {
                case 0: {
                    throw new SQLException("Transaction isolation level NONE not supported by MySQL");
                }
                case 2: {
                    sql.append("READ COMMITTED");
                    break;
                }
                case 1: {
                    sql.append("READ UNCOMMITTED");
                    break;
                }
                case 4: {
                    sql.append("REPEATABLE READ");
                    break;
                }
                case 8: {
                    sql.append("SERIALIZABLE");
                    break;
                }
                default: {
                    throw new SQLException("Unsupported transaction isolation level '" + level + "'", "S1C00");
                }
            }
        } else {
            throw new SQLException("Transaction Isolation Levels are not supported on MySQL versions older than 3.23.36.", "S1C00");
        }
        this.execSQL(sql.toString(), -1, this.database);
        this.isolationLevel = level;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTransactionIsolation() throws SQLException {
        String s;
        block10: {
            Exception ex22;
            int n;
            java.sql.Statement stmt;
            block11: {
                if (!this.hasIsolationLevels) return this.isolationLevel;
                stmt = null;
                java.sql.ResultSet rs = null;
                try {
                    Integer intTI;
                    stmt = this.createStatement();
                    String query = null;
                    query = this.io.versionMeetsMinimum(4, 0, 3) ? "SHOW VARIABLES LIKE 'tx_isolation'" : "SHOW VARIABLES LIKE 'transaction_isolation'";
                    rs = stmt.executeQuery(query);
                    if (!rs.next()) throw new SQLException("Could not retrieve transaction isolation level from server", "S1000");
                    s = rs.getString(2);
                    if (s == null || (intTI = (Integer)mapTransIsolationName2Value.get(s)) == null) break block10;
                    n = intTI;
                    Object var8_7 = null;
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    Exception ex22;
                    Object var8_8 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception ex22) {
                            // empty catch block
                        }
                        rs = null;
                    }
                    if (stmt == null) throw throwable;
                    try {
                        stmt.close();
                    }
                    catch (Exception ex22) {
                        // empty catch block
                    }
                    stmt = null;
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (Exception ex22) {
                    // empty catch block
                }
                rs = null;
            }
            if (stmt == null) return n;
            try {
                stmt.close();
            }
            catch (Exception ex22) {
                // empty catch block
            }
            stmt = null;
            return n;
        }
        throw new SQLException("Could not map transaction isolation '" + s + " to a valid JDBC level.", "S1000");
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public synchronized Map getTypeMap() throws SQLException {
        if (this.typeMap == null) {
            this.typeMap = new HashMap();
        }
        return this.typeMap;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean allowLoadLocalInfile() {
        return this.allowLoadLocalInfile;
    }

    public boolean capitalizeDBMDTypes() {
        return this.capitalizeDBMDTypes;
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
        SQLException sqlEx = null;
        if (!this.isClosed() && !this.getAutoCommit()) {
            try {
                this.rollback();
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
        }
        if (this.io != null) {
            try {
                this.io.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.io = null;
        }
        this.isClosed = true;
        if (sqlEx != null) {
            throw sqlEx;
        }
    }

    public void commit() throws SQLException {
        this.checkClosed();
        if (this.autoCommit && !this.relaxAutoCommit) {
            throw new SQLException("Can't call commit when autocommit=true");
        }
        if (this.transactionsSupported) {
            this.execSQL("commit", -1, this.database);
        }
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        Statement stmt = new Statement(this, this.database);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    public java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1004, 1007);
    }

    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.pedantic && resultSetHoldability != 1) {
            throw new SQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    public void finalize() throws Throwable {
        this.cleanup();
    }

    public boolean lowerCaseTableNames() {
        return this.lowerCaseTableNames;
    }

    public String nativeSQL(String sql) throws SQLException {
        EscapeProcessor escaper = new EscapeProcessor();
        return escaper.escapeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.getUseUltraDevWorkAround()) {
            return new UltraDevWorkAround(this.prepareStatement(sql));
        }
        throw new SQLException("Callable statments not supported.", "S1C00");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.pedantic && resultSetHoldability != 1) {
            throw new SQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        throw new NotImplemented();
    }

    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1004, 1007);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        PreparedStatement pStmt = new PreparedStatement(this, sql, this.database);
        pStmt.setResultSetType(resultSetType);
        pStmt.setResultSetConcurrency(resultSetConcurrency);
        return pStmt;
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.pedantic && resultSetHoldability != 1) {
            throw new SQLException("HOLD_CUSRORS_OVER_COMMIT is only supported holdability level", "S1009");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        return this.prepareStatement(sql);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    public java.sql.PreparedStatement prepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new NotImplemented();
    }

    public void rollback() throws SQLException {
        block4: {
            this.checkClosed();
            if (this.autoCommit && !this.relaxAutoCommit) {
                throw new SQLException("Can't call rollback when autocommit=true", "08003");
            }
            if (this.transactionsSupported) {
                try {
                    this.rollbackNoChecks();
                }
                catch (SQLException sqlEx) {
                    if (!this.ignoreNonTxTables || sqlEx.getErrorCode() == 1196) break block4;
                    throw sqlEx;
                }
            }
        }
    }

    private void rollbackNoChecks() throws SQLException {
        this.execSQL("rollback", -1, null);
    }

    public void rollback(Savepoint arg0) throws SQLException {
        throw new NotImplemented();
    }

    public void shutdownServer() throws SQLException {
        try {
            this.io.sendCommand(8, null, null);
        }
        catch (Exception ex) {
            throw new SQLException("Unhandled exception '" + ex.toString() + "'", "S1000");
        }
    }

    public boolean supportsIsolationLevel() {
        return this.hasIsolationLevels;
    }

    public boolean supportsQuotedIdentifiers() {
        return this.hasQuotedIdentifiers;
    }

    public boolean supportsTransactions() {
        return this.transactionsSupported;
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    public boolean useParanoidErrorMessages() {
        return this.paranoid;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public boolean useStrictFloatingPoint() {
        return this.strictFloatingPoint;
    }

    public boolean useStrictUpdates() {
        return this.strictUpdates;
    }

    public boolean useTimezone() {
        return this.useTimezone;
    }

    public boolean useUnicode() {
        return this.doUnicode;
    }

    protected MysqlIO getIO() {
        return this.io;
    }

    protected MysqlIO createNewIO(boolean isForReconnect) throws SQLException {
        MysqlIO newIo = null;
        if (!this.highAvailability && !this.failedOver) {
            int hostIndex = 0;
            while (hostIndex < this.hostListSize) {
                block27: {
                    try {
                        this.io = new MysqlIO(this.hostList.get(hostIndex).toString(), this.port, this.socketFactoryClassName, this.props, this, this.socketTimeout);
                        this.io.doHandshake(this.user, this.password);
                        this.isClosed = false;
                        if (this.database.length() != 0) {
                            this.io.sendCommand(2, this.database, null);
                        }
                        boolean autoCommit = this.getAutoCommit();
                        int oldIsolationLevel = this.getTransactionIsolation();
                        this.initializePropsFromServer(this.props);
                        if (isForReconnect) {
                            this.setAutoCommit(autoCommit);
                            this.setTransactionIsolation(oldIsolationLevel);
                        }
                        if (hostIndex != 0) {
                            this.setFailedOverState();
                        } else {
                            this.failedOver = false;
                            this.setReadOnly(false);
                        }
                        break;
                    }
                    catch (SQLException sqlEx) {
                        String sqlState;
                        if (this.io != null) {
                            this.io.forceClose();
                        }
                        if ((sqlState = sqlEx.getSQLState()) == null || !sqlState.equals("08S01")) {
                            throw sqlEx;
                        }
                        if (this.hostListSize - 1 == hostIndex) {
                            throw sqlEx;
                        }
                    }
                    catch (Exception unknownException) {
                        if (this.io != null) {
                            this.io.forceClose();
                        }
                        if (this.hostListSize - 1 != hostIndex) break block27;
                        throw new SQLException("Unable to connect to any hosts due to exception: " + unknownException.toString(), "08S01");
                    }
                }
                ++hostIndex;
            }
        } else {
            double timeout = this.initialTimeout;
            boolean connectionGood = false;
            int hostIndex = 0;
            while (hostIndex < this.hostListSize) {
                int attemptCount = 0;
                while (attemptCount < this.maxReconnects) {
                    try {
                        if (this.io != null) {
                            this.io.forceClose();
                        }
                        this.io = new MysqlIO(this.hostList.get(hostIndex).toString(), this.port, this.socketFactoryClassName, this.props, this, this.socketTimeout);
                        this.io.doHandshake(this.user, this.password);
                        if (this.database.length() != 0) {
                            this.io.sendCommand(2, this.database, null);
                        }
                        this.ping();
                        this.isClosed = false;
                        boolean autoCommit = this.getAutoCommit();
                        int oldIsolationLevel = this.getTransactionIsolation();
                        this.initializePropsFromServer(this.props);
                        if (isForReconnect) {
                            this.setAutoCommit(autoCommit);
                            this.setTransactionIsolation(oldIsolationLevel);
                        }
                        connectionGood = true;
                        if (hostIndex != 0) {
                            this.setFailedOverState();
                            break;
                        }
                        this.failedOver = false;
                        this.setReadOnly(false);
                        break;
                    }
                    catch (Exception EEE) {
                        connectionGood = false;
                        if (connectionGood) break;
                        try {
                            Thread.sleep((long)timeout * 1000L);
                            timeout *= timeout;
                        }
                        catch (InterruptedException IE) {
                            // empty catch block
                        }
                        ++attemptCount;
                    }
                }
                if (!connectionGood) {
                    throw new SQLException("Server connection failure during transaction. \nAttemtped reconnect " + this.maxReconnects + " times. Giving up.", "08001");
                }
                ++hostIndex;
            }
        }
        if (this.paranoid && !this.highAvailability && this.hostListSize <= 1) {
            this.password = null;
            this.user = null;
        }
        return newIo;
    }

    int getMaxAllowedPacket() {
        return this.maxAllowedPacket;
    }

    Object getMutex() throws SQLException {
        if (this.io == null) {
            throw new SQLException("Connection.close() has already been called. Invalid operation in this state.", "08003");
        }
        return this.mutex;
    }

    int getNetBufferLength() {
        return this.netBufferLength;
    }

    boolean isPedantic() {
        return this.pedantic;
    }

    int getServerMajorVersion() {
        return this.io.getServerMajorVersion();
    }

    int getServerMinorVersion() {
        return this.io.getServerMinorVersion();
    }

    int getServerSubMinorVersion() {
        return this.io.getServerSubMinorVersion();
    }

    String getServerVersion() {
        return this.io.getServerVersion();
    }

    String getURL() {
        return this.myURL;
    }

    void setUseSSL(boolean flag) {
        this.useSSL = flag;
    }

    String getUser() {
        return this.user;
    }

    boolean continueBatchOnError() {
        return this.continueBatchOnError;
    }

    ResultSet execSQL(String sql, int maxRowsToRetreive, String catalog) throws SQLException {
        return this.execSQL(sql, maxRowsToRetreive, null, 1007, catalog);
    }

    ResultSet execSQL(String sql, int maxRows, int resultSetType, boolean streamResults, boolean queryIsSelectOnly, String catalog) throws SQLException {
        return this.execSQL(sql, maxRows, null, resultSetType, streamResults, queryIsSelectOnly, catalog);
    }

    ResultSet execSQL(String sql, int maxRows, Buffer packet, String catalog) throws SQLException {
        return this.execSQL(sql, maxRows, packet, 1007, catalog);
    }

    ResultSet execSQL(String sql, int maxRows, Buffer packet, int resultSetType, String catalog) throws SQLException {
        return this.execSQL(sql, maxRows, packet, resultSetType, true, false, catalog);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResultSet execSQL(String sql, int maxRows, Buffer packet, int resultSetType, boolean streamResults, boolean queryIsSelectOnly, String catalog) throws SQLException {
        Object object = this.mutex;
        synchronized (object) {
            ResultSet encoding2;
            block17: {
                ResultSet resultSet;
                block16: {
                    this.lastQueryFinishedTime = 0L;
                    if (this.failedOver && this.autoCommit) {
                        ++this.queriesIssuedFailedOver;
                        if (this.shouldFallBack()) {
                            this.createNewIO(true);
                            String connectedHost = this.io.getHost();
                            if (connectedHost != null && this.hostList.get(0).equals(connectedHost)) {
                                this.failedOver = false;
                                this.queriesIssuedFailedOver = 0L;
                                this.setReadOnly(false);
                            }
                        }
                    }
                    if ((this.highAvailability || this.failedOver) && this.autoCommit) {
                        try {
                            this.ping();
                        }
                        catch (Exception Ex) {
                            this.createNewIO(true);
                        }
                    }
                    try {
                        int realMaxRows;
                        int n = realMaxRows = maxRows == -1 ? 50000000 : maxRows;
                        if (packet == null) {
                            String encoding2 = null;
                            if (this.useUnicode()) {
                                encoding2 = this.getEncoding();
                            }
                            resultSet = this.io.sqlQuery(sql, realMaxRows, encoding2, this, resultSetType, streamResults, catalog);
                            Object var14_18 = null;
                            break block16;
                        }
                        encoding2 = this.io.sqlQueryDirect(packet, realMaxRows, this, resultSetType, streamResults, catalog);
                        break block17;
                    }
                    catch (SQLException sqlE) {
                        try {
                            throw sqlE;
                            catch (Exception ex) {
                                String exceptionType = ex.getClass().getName();
                                String exceptionMessage = ex.getMessage();
                                if (this.useParanoidErrorMessages()) throw new SQLException("Error during query: Unexpected Exception: " + exceptionType + " message given: " + exceptionMessage, "S1000");
                                exceptionMessage = exceptionMessage + "\n\nNested Stack Trace:\n";
                                exceptionMessage = exceptionMessage + Util.stackTraceToString(ex);
                                throw new SQLException("Error during query: Unexpected Exception: " + exceptionType + " message given: " + exceptionMessage, "S1000");
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_20 = null;
                            this.lastQueryFinishedTime = System.currentTimeMillis();
                            throw throwable;
                        }
                    }
                }
                this.lastQueryFinishedTime = System.currentTimeMillis();
                return resultSet;
            }
            Object var14_19 = null;
            this.lastQueryFinishedTime = System.currentTimeMillis();
            return encoding2;
        }
    }

    synchronized void maxRowsChanged(Statement stmt) {
        if (this.statementsUsingMaxRows == null) {
            this.statementsUsingMaxRows = new HashMap();
        }
        this.statementsUsingMaxRows.put(stmt, stmt);
        this.maxRowsChanged = true;
    }

    synchronized void unsetMaxRows(Statement stmt) throws SQLException {
        Object found;
        if (this.statementsUsingMaxRows != null && (found = this.statementsUsingMaxRows.remove(stmt)) != null && this.statementsUsingMaxRows.size() == 0) {
            this.execSQL("SET OPTION SQL_SELECT_LIMIT=DEFAULT", -1, this.database);
            this.maxRowsChanged = false;
        }
    }

    boolean useAnsiQuotedIdentifiers() {
        return this.useAnsiQuotes;
    }

    boolean useHostsInPrivileges() {
        return this.useHostsInPrivileges;
    }

    synchronized boolean useMaxRows() {
        return this.maxRowsChanged;
    }

    boolean useStreamLengthsInPrepStmts() {
        return this.useStreamLengthsInPrepStmts;
    }

    private void setFailedOverState() throws SQLException {
        this.setReadOnly(true);
        this.queriesIssuedFailedOver = 0L;
        this.failedOver = true;
        this.masterFailTimeMillis = System.currentTimeMillis();
    }

    private void checkServerEncoding() throws SQLException {
        if (this.doUnicode && this.encoding != null) {
            return;
        }
        String serverEncoding = (String)this.serverVariables.get("character_set");
        String mappedServerEncoding = null;
        if (serverEncoding != null) {
            mappedServerEncoding = (String)charsetMap.get(serverEncoding.toUpperCase());
        }
        if (!this.useUnicode() && mappedServerEncoding != null) {
            try {
                SingleByteCharsetConverter converter = SingleByteCharsetConverter.getInstance(mappedServerEncoding);
                if (converter != null) {
                    this.doUnicode = true;
                    this.encoding = mappedServerEncoding;
                    return;
                }
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        if (this.useUnicode() && this.getEncoding() == null) {
            if (serverEncoding != null) {
                this.encoding = mappedServerEncoding;
                if (this.encoding == null && Character.isLowerCase(serverEncoding.charAt(0))) {
                    char[] ach = serverEncoding.toCharArray();
                    ach[0] = Character.toUpperCase(serverEncoding.charAt(0));
                    this.encoding = new String(ach);
                }
            }
            try {
                String testString = "abc";
                testString.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException UE) {
                throw new SQLException("The driver can not map the character encoding '" + this.encoding + "' that your server is using " + "to a character encoding your JVM understands. You " + "can specify this mapping manually by adding \"useUnicode=true\" " + "as well as \"characterEncoding=[an_encoding_your_jvm_understands]\" " + "to your JDBC URL.", "0S100");
            }
        }
    }

    private void checkTransactionIsolationLevel() throws SQLException {
        Integer intTI;
        String txIsolationName = null;
        txIsolationName = this.io.versionMeetsMinimum(4, 0, 3) ? "tx_isolation" : "transaction_isolation";
        String s = (String)this.serverVariables.get(txIsolationName);
        if (s != null && (intTI = (Integer)mapTransIsolationName2Value.get(s)) != null) {
            this.isolationLevel = intTI;
        }
    }

    private void cleanup() {
        try {
            if (this.io != null && !this.isClosed()) {
                this.close();
            } else if (this.io != null) {
                this.io.forceClose();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.isClosed = true;
    }

    private void initializeDriverProperties(Properties info) throws SQLException {
        this.socketFactoryClassName = info.getProperty("socketFactory", DEFAULT_SOCKET_FACTORY);
        if (info.getProperty("strictUpdates") != null) {
            this.strictUpdates = info.getProperty("strictUpdates").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("ignoreNonTxTables") != null) {
            this.ignoreNonTxTables = info.getProperty("ignoreNonTxTables").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("secondsBeforeRetryMaster") != null) {
            String secondsBeforeRetryStr = info.getProperty("secondsBeforeRetryMaster");
            try {
                int seconds = Integer.parseInt(secondsBeforeRetryStr);
                if (seconds < 1) {
                    throw new SQLException("Illegal (< 1)  value '" + secondsBeforeRetryStr + "' for 'secondsBeforeRetryMaster'", "S1009");
                }
                this.secondsBeforeRetryMaster = seconds;
            }
            catch (NumberFormatException nfe) {
                throw new SQLException("Illegal non-numeric value '" + secondsBeforeRetryStr + "' for 'secondsBeforeRetryMaster'", "S1009");
            }
        }
        if (info.getProperty("queriesBeforeRetryMaster") != null) {
            String queriesBeforeRetryStr = info.getProperty("queriesBeforeRetryMaster");
            try {
                this.queriesBeforeRetryMaster = Integer.parseInt(queriesBeforeRetryStr);
            }
            catch (NumberFormatException nfe) {
                throw new SQLException("Illegal non-numeric value '" + queriesBeforeRetryStr + "' for 'queriesBeforeRetryMaster'", "S1009");
            }
        }
        if (info.getProperty("allowLoadLocalInfile") != null) {
            this.allowLoadLocalInfile = info.getProperty("allowLoadLocalInfile").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("continueBatchOnError") != null) {
            this.continueBatchOnError = info.getProperty("continueBatchOnError").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("pedantic") != null) {
            this.pedantic = info.getProperty("pedantic").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("useStreamLengthsInPrepStmts") != null) {
            this.useStreamLengthsInPrepStmts = info.getProperty("useStreamLengthsInPrepStmts").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("useTimezone") != null) {
            this.useTimezone = info.getProperty("useTimezone").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("relaxAutoCommit") != null) {
            this.relaxAutoCommit = info.getProperty("relaxAutoCommit").equalsIgnoreCase("TRUE");
        } else if (info.getProperty("relaxAutocommit") != null) {
            this.relaxAutoCommit = info.getProperty("relaxAutocommit").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("paranoid") != null) {
            this.paranoid = info.getProperty("paranoid").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("autoReconnect") != null) {
            this.highAvailability = info.getProperty("autoReconnect").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("capitalizeTypeNames") != null) {
            this.capitalizeDBMDTypes = info.getProperty("capitalizeTypeNames").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("ultraDevHack") != null) {
            this.useUltraDevWorkAround = info.getProperty("ultraDevHack").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("strictFloatingPoint") != null) {
            this.strictFloatingPoint = info.getProperty("strictFloatingPoint").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("useSSL") != null) {
            this.useSSL = info.getProperty("useSSL").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("useCompression") != null) {
            this.useSSL = info.getProperty("useCompression").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("socketTimeout") != null) {
            try {
                int n = Integer.parseInt(info.getProperty("socketTimeout"));
                if (n < 0) {
                    throw new SQLException("socketTimeout can not be < 0", "0S100");
                }
                this.socketTimeout = n;
            }
            catch (NumberFormatException NFE) {
                throw new SQLException("Illegal parameter '" + info.getProperty("socketTimeout") + "' for socketTimeout", "0S100");
            }
        }
        if (this.highAvailability) {
            if (info.getProperty("maxReconnects") != null) {
                try {
                    int n;
                    this.maxReconnects = n = Integer.parseInt(info.getProperty("maxReconnects"));
                }
                catch (NumberFormatException NFE) {
                    throw new SQLException("Illegal parameter '" + info.getProperty("maxReconnects") + "' for maxReconnects", "0S100");
                }
            }
            if (info.getProperty("initialTimeout") != null) {
                try {
                    double n;
                    this.initialTimeout = n = (double)Integer.parseInt(info.getProperty("initialTimeout"));
                }
                catch (NumberFormatException NFE) {
                    throw new SQLException("Illegal parameter '" + info.getProperty("initialTimeout") + "' for initialTimeout", "0S100");
                }
            }
        }
        if (info.getProperty("maxRows") != null) {
            try {
                int n = Integer.parseInt(info.getProperty("maxRows"));
                if (n == 0) {
                    n = -1;
                }
                this.maxRows = n;
                this.maxRowsChanged = true;
            }
            catch (NumberFormatException NFE) {
                throw new SQLException("Illegal parameter '" + info.getProperty("maxRows") + "' for maxRows", "0S100");
            }
        }
        if (info.getProperty("useHostsInPrivileges") != null) {
            this.useHostsInPrivileges = info.getProperty("useHostsInPrivileges").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("interactiveClient") != null) {
            this.isInteractiveClient = info.getProperty("interactiveClient").equalsIgnoreCase("TRUE");
        }
        if (info.getProperty("useUnicode") != null) {
            this.doUnicode = info.getProperty("useUnicode").equalsIgnoreCase("TRUE");
        }
        if (this.doUnicode && info.getProperty("characterEncoding") != null) {
            this.encoding = info.getProperty("characterEncoding");
            try {
                String testString = "abc";
                testString.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException UE) {
                throw new SQLException("Unsupported character encoding '" + this.encoding + "'.", "0S100");
            }
        }
    }

    /*
     * Loose catch block
     */
    private void initializePropsFromServer(Properties info) throws SQLException {
        block32: {
            String lowerCaseTables;
            block33: {
                SQLException sqlE22;
                ResultSet results;
                Statement stmt;
                block31: {
                    if (this.io.versionMeetsMinimum(3, 22, 1)) {
                        this.useFastPing = true;
                    }
                    this.serverVariables.clear();
                    if (!this.io.versionMeetsMinimum(3, 21, 22)) break block32;
                    stmt = null;
                    results = null;
                    stmt = (Statement)this.createStatement();
                    results = (ResultSet)stmt.executeQuery("SHOW VARIABLES");
                    while (results.next()) {
                        this.serverVariables.put(results.getString(1), results.getString(2));
                    }
                    Object var6_5 = null;
                    if (results == null) break block31;
                    try {
                        results.close();
                    }
                    catch (SQLException sqlE22) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlE22) {}
                }
                break block33;
                {
                    catch (SQLException e) {
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    SQLException sqlE22;
                    Object var6_6 = null;
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (SQLException sqlE22) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqlE22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            if ((lowerCaseTables = (String)this.serverVariables.get("lower_case_table_names")) != null) {
                this.lowerCaseTableNames = lowerCaseTables.trim().equalsIgnoreCase("on");
            }
            if (this.useTimezone && this.serverVariables.containsKey("timezone")) {
                String canoncicalTimezone = this.props.getProperty("serverTimezone");
                if (canoncicalTimezone == null || canoncicalTimezone.length() == 0) {
                    String serverTimezoneStr = (String)this.serverVariables.get("timezone");
                    try {
                        canoncicalTimezone = TimeUtil.getCanoncialTimezone(serverTimezoneStr);
                        if (canoncicalTimezone == null) {
                            throw new SQLException("Can't map timezone '" + serverTimezoneStr + "' to " + " canonical timezone.", "S1009");
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        throw new SQLException(iae.getMessage(), "S1000");
                    }
                }
                this.serverTimezone = TimeZone.getTimeZone(canoncicalTimezone);
                if (!canoncicalTimezone.equalsIgnoreCase("GMT") && this.serverTimezone.getID().equals("GMT")) {
                    throw new SQLException("No timezone mapping entry for '" + canoncicalTimezone + "'", "S1009");
                }
            }
            if (this.serverVariables.containsKey("max_allowed_packet")) {
                this.maxAllowedPacket = Integer.parseInt((String)this.serverVariables.get("max_allowed_packet"));
            }
            if (this.serverVariables.containsKey("net_buffer_length")) {
                this.netBufferLength = Integer.parseInt((String)this.serverVariables.get("net_buffer_length"));
            }
            this.checkTransactionIsolationLevel();
            this.checkServerEncoding();
        }
        if (this.io.versionMeetsMinimum(3, 23, 15)) {
            this.transactionsSupported = true;
            this.setAutoCommit(true);
        } else {
            this.transactionsSupported = false;
        }
        this.hasIsolationLevels = this.io.versionMeetsMinimum(3, 23, 36);
        String profileSql = info.getProperty("profileSql");
        if (profileSql != null && profileSql.trim().equalsIgnoreCase("true")) {
            this.io.setProfileSql(true);
        } else {
            this.io.setProfileSql(false);
        }
        this.hasQuotedIdentifiers = this.io.versionMeetsMinimum(3, 23, 6);
        if (this.serverVariables.containsKey("sql_mode")) {
            int sqlMode = 0;
            try {
                sqlMode = Integer.parseInt((String)this.serverVariables.get("sql_mode"));
            }
            catch (NumberFormatException nfe) {
                sqlMode = 0;
            }
            this.useAnsiQuotes = (sqlMode & 4) > 0;
        }
        this.io.resetMaxBuf();
    }

    private static void loadCharacterSetMapping() {
        multibyteCharsetsMap = new HashMap();
        Iterator multibyteCharsets = CharsetMapping.MULTIBYTE_CHARSETS.keySet().iterator();
        while (multibyteCharsets.hasNext()) {
            String charset = ((String)multibyteCharsets.next()).toUpperCase();
            multibyteCharsetsMap.put(charset, charset);
        }
        Iterator keys = CharsetMapping.CHARSETMAP.keySet().iterator();
        charsetMap = new HashMap();
        while (keys.hasNext()) {
            String mysqlCharsetName = ((String)keys.next()).trim();
            String javaCharsetName = CharsetMapping.CHARSETMAP.get(mysqlCharsetName).toString().trim();
            charsetMap.put(mysqlCharsetName.toUpperCase(), javaCharsetName);
            charsetMap.put(mysqlCharsetName, javaCharsetName);
        }
    }

    private boolean getUseUltraDevWorkAround() {
        return this.useUltraDevWorkAround;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("No operations allowed after connection closed", "08003");
        }
    }

    private void ping() throws Exception {
        if (this.useFastPing) {
            this.io.sendCommand(14, null, null);
        } else {
            this.io.sqlQuery(PING_COMMAND, 50000000, this.encoding, this, 1007, false, this.database);
        }
    }

    private boolean shouldFallBack() {
        long secondsSinceFailedOver = (System.currentTimeMillis() - this.masterFailTimeMillis) / 1000L;
        return secondsSinceFailedOver >= this.secondsBeforeRetryMaster || this.queriesIssuedFailedOver % (long)this.queriesBeforeRetryMaster == 0L;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PING_COMMAND = PING_COMMAND;
        mapTransIsolationName2Value = null;
        DEFAULT_SOCKET_FACTORY = (class$com$mysql$jdbc$StandardSocketFactory == null ? (class$com$mysql$jdbc$StandardSocketFactory = Connection.class$("com.mysql.jdbc.StandardSocketFactory")) : class$com$mysql$jdbc$StandardSocketFactory).getName();
        Connection.loadCharacterSetMapping();
        mapTransIsolationName2Value = new HashMap(8);
        mapTransIsolationName2Value.put("READ-UNCOMMITED", new Integer(1));
        mapTransIsolationName2Value.put("READ-UNCOMMITTED", new Integer(1));
        mapTransIsolationName2Value.put("READ-COMMITTED", new Integer(2));
        mapTransIsolationName2Value.put("REPEATABLE-READ", new Integer(4));
        mapTransIsolationName2Value.put("SERIALIZABLE", new Integer(8));
    }

    class UltraDevWorkAround
    implements CallableStatement {
        private java.sql.PreparedStatement delegate = null;

        UltraDevWorkAround(java.sql.PreparedStatement pstmt) {
            this.delegate = pstmt;
        }

        public void setArray(int p1, Array p2) throws SQLException {
            this.delegate.setArray(p1, p2);
        }

        public Array getArray(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Array getArray(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setAsciiStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setAsciiStream(p1, p2, p3);
        }

        public void setAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setBigDecimal(int p1, BigDecimal p2) throws SQLException {
            this.delegate.setBigDecimal(p1, p2);
        }

        public void setBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
            throw new NotImplemented();
        }

        public BigDecimal getBigDecimal(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public BigDecimal getBigDecimal(int p1, int p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public BigDecimal getBigDecimal(String arg0) throws SQLException {
            return null;
        }

        public void setBinaryStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setBinaryStream(p1, p2, p3);
        }

        public void setBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setBlob(int p1, Blob p2) throws SQLException {
            this.delegate.setBlob(p1, p2);
        }

        public Blob getBlob(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Blob getBlob(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setBoolean(int p1, boolean p2) throws SQLException {
            this.delegate.setBoolean(p1, p2);
        }

        public void setBoolean(String arg0, boolean arg1) throws SQLException {
            throw new NotImplemented();
        }

        public boolean getBoolean(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public boolean getBoolean(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setByte(int p1, byte p2) throws SQLException {
            this.delegate.setByte(p1, p2);
        }

        public void setByte(String arg0, byte arg1) throws SQLException {
            throw new NotImplemented();
        }

        public byte getByte(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public byte getByte(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setBytes(int p1, byte[] p2) throws SQLException {
            this.delegate.setBytes(p1, p2);
        }

        public void setBytes(String arg0, byte[] arg1) throws SQLException {
            throw new NotImplemented();
        }

        public byte[] getBytes(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public byte[] getBytes(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setCharacterStream(int p1, Reader p2, int p3) throws SQLException {
            this.delegate.setCharacterStream(p1, p2, p3);
        }

        public void setCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setClob(int p1, Clob p2) throws SQLException {
            this.delegate.setClob(p1, p2);
        }

        public Clob getClob(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Clob getClob(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.Connection getConnection() throws SQLException {
            return this.delegate.getConnection();
        }

        public void setCursorName(String p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void setDate(int p1, Date p2) throws SQLException {
            this.delegate.setDate(p1, p2);
        }

        public void setDate(int p1, Date p2, Calendar p3) throws SQLException {
            this.delegate.setDate(p1, p2, p3);
        }

        public void setDate(String arg0, Date arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setDate(String arg0, Date arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Date getDate(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Date getDate(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Date getDate(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Date getDate(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setDouble(int p1, double p2) throws SQLException {
            this.delegate.setDouble(p1, p2);
        }

        public void setDouble(String arg0, double arg1) throws SQLException {
            throw new NotImplemented();
        }

        public double getDouble(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public double getDouble(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setEscapeProcessing(boolean p1) throws SQLException {
            this.delegate.setEscapeProcessing(p1);
        }

        public void setFetchDirection(int p1) throws SQLException {
            this.delegate.setFetchDirection(p1);
        }

        public int getFetchDirection() throws SQLException {
            return this.delegate.getFetchDirection();
        }

        public void setFetchSize(int p1) throws SQLException {
            this.delegate.setFetchSize(p1);
        }

        public int getFetchSize() throws SQLException {
            return this.delegate.getFetchSize();
        }

        public void setFloat(int p1, float p2) throws SQLException {
            this.delegate.setFloat(p1, p2);
        }

        public void setFloat(String arg0, float arg1) throws SQLException {
            throw new NotImplemented();
        }

        public float getFloat(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public float getFloat(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.ResultSet getGeneratedKeys() throws SQLException {
            return this.delegate.getGeneratedKeys();
        }

        public void setInt(int p1, int p2) throws SQLException {
            this.delegate.setInt(p1, p2);
        }

        public void setInt(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public int getInt(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getInt(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setLong(int p1, long p2) throws SQLException {
            this.delegate.setLong(p1, p2);
        }

        public void setLong(String arg0, long arg1) throws SQLException {
            throw new NotImplemented();
        }

        public long getLong(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public long getLong(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setMaxFieldSize(int p1) throws SQLException {
            this.delegate.setMaxFieldSize(p1);
        }

        public int getMaxFieldSize() throws SQLException {
            return this.delegate.getMaxFieldSize();
        }

        public void setMaxRows(int p1) throws SQLException {
            this.delegate.setMaxRows(p1);
        }

        public int getMaxRows() throws SQLException {
            return this.delegate.getMaxRows();
        }

        public ResultSetMetaData getMetaData() throws SQLException {
            throw new SQLException("Not supported");
        }

        public boolean getMoreResults() throws SQLException {
            return this.delegate.getMoreResults();
        }

        public boolean getMoreResults(int arg0) throws SQLException {
            return this.delegate.getMoreResults();
        }

        public void setNull(int p1, int p2) throws SQLException {
            this.delegate.setNull(p1, p2);
        }

        public void setNull(int p1, int p2, String p3) throws SQLException {
            this.delegate.setNull(p1, p2, p3);
        }

        public void setNull(String arg0, int arg1, String arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setNull(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(int p1, Object p2) throws SQLException {
            this.delegate.setObject(p1, p2);
        }

        public void setObject(int p1, Object p2, int p3) throws SQLException {
            this.delegate.setObject(p1, p2, p3);
        }

        public void setObject(int p1, Object p2, int p3, int p4) throws SQLException {
            this.delegate.setObject(p1, p2, p3, p4);
        }

        public void setObject(String arg0, Object arg1, int arg2, int arg3) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(String arg0, Object arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setObject(String arg0, Object arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Object getObject(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Object getObject(int p1, Map p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Object getObject(String arg0, Map arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Object getObject(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public ParameterMetaData getParameterMetaData() throws SQLException {
            return this.delegate.getParameterMetaData();
        }

        public void setQueryTimeout(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public int getQueryTimeout() throws SQLException {
            return this.delegate.getQueryTimeout();
        }

        public void setRef(int p1, Ref p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Ref getRef(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Ref getRef(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public java.sql.ResultSet getResultSet() throws SQLException {
            return this.delegate.getResultSet();
        }

        public int getResultSetConcurrency() throws SQLException {
            return this.delegate.getResultSetConcurrency();
        }

        public int getResultSetHoldability() throws SQLException {
            return this.delegate.getResultSetHoldability();
        }

        public int getResultSetType() throws SQLException {
            return this.delegate.getResultSetType();
        }

        public void setShort(int p1, short p2) throws SQLException {
            this.delegate.setShort(p1, p2);
        }

        public void setShort(String arg0, short arg1) throws SQLException {
            throw new NotImplemented();
        }

        public short getShort(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public short getShort(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setString(int p1, String p2) throws SQLException {
            this.delegate.setString(p1, p2);
        }

        public void setString(String arg0, String arg1) throws SQLException {
            throw new NotImplemented();
        }

        public String getString(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public String getString(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setTime(int p1, Time p2) throws SQLException {
            this.delegate.setTime(p1, p2);
        }

        public void setTime(int p1, Time p2, Calendar p3) throws SQLException {
            this.delegate.setTime(p1, p2, p3);
        }

        public void setTime(String arg0, Time arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setTime(String arg0, Time arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Time getTime(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Time getTime(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Time getTime(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Time getTime(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setTimestamp(int p1, Timestamp p2) throws SQLException {
            this.delegate.setTimestamp(p1, p2);
        }

        public void setTimestamp(int p1, Timestamp p2, Calendar p3) throws SQLException {
            this.delegate.setTimestamp(p1, p2, p3);
        }

        public void setTimestamp(String arg0, Timestamp arg1, Calendar arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void setTimestamp(String arg0, Timestamp arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Timestamp getTimestamp(int p1) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Timestamp getTimestamp(int p1, Calendar p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
            throw new NotImplemented();
        }

        public Timestamp getTimestamp(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setURL(String arg0, URL arg1) throws SQLException {
            throw new NotImplemented();
        }

        public void setURL(int arg0, URL arg1) throws SQLException {
            this.delegate.setURL(arg0, arg1);
        }

        public URL getURL(int arg0) throws SQLException {
            throw new NotImplemented();
        }

        public URL getURL(String arg0) throws SQLException {
            throw new NotImplemented();
        }

        public void setUnicodeStream(int p1, InputStream p2, int p3) throws SQLException {
            this.delegate.setUnicodeStream(p1, p2, p3);
        }

        public int getUpdateCount() throws SQLException {
            return this.delegate.getUpdateCount();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        public void addBatch() throws SQLException {
            this.delegate.addBatch();
        }

        public void addBatch(String p1) throws SQLException {
            this.delegate.addBatch(p1);
        }

        public void cancel() throws SQLException {
            this.delegate.cancel();
        }

        public void clearBatch() throws SQLException {
            this.delegate.clearBatch();
        }

        public void clearParameters() throws SQLException {
            this.delegate.clearParameters();
        }

        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        public void close() throws SQLException {
            this.delegate.close();
        }

        public boolean execute() throws SQLException {
            return this.delegate.execute();
        }

        public boolean execute(String p1) throws SQLException {
            return this.delegate.execute(p1);
        }

        public boolean execute(String arg0, int arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public boolean execute(String arg0, int[] arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public boolean execute(String arg0, String[] arg1) throws SQLException {
            return this.delegate.execute(arg0, arg1);
        }

        public int[] executeBatch() throws SQLException {
            return this.delegate.executeBatch();
        }

        public java.sql.ResultSet executeQuery() throws SQLException {
            return this.delegate.executeQuery();
        }

        public java.sql.ResultSet executeQuery(String p1) throws SQLException {
            return this.delegate.executeQuery(p1);
        }

        public int executeUpdate() throws SQLException {
            return this.delegate.executeUpdate();
        }

        public int executeUpdate(String p1) throws SQLException {
            return this.delegate.executeUpdate(p1);
        }

        public int executeUpdate(String arg0, int arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public int executeUpdate(String arg0, int[] arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public int executeUpdate(String arg0, String[] arg1) throws SQLException {
            return this.delegate.executeUpdate(arg0, arg1);
        }

        public void registerOutParameter(int p1, int p2) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(int p1, int p2, int p3) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(int p1, int p2, String p3) throws SQLException {
            throw new SQLException("Not supported");
        }

        public void registerOutParameter(String arg0, int arg1, int arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void registerOutParameter(String arg0, int arg1, String arg2) throws SQLException {
            throw new NotImplemented();
        }

        public void registerOutParameter(String arg0, int arg1) throws SQLException {
            throw new NotImplemented();
        }

        public boolean wasNull() throws SQLException {
            throw new SQLException("Not supported");
        }
    }
}

